/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.ampcustom.scte35;

import com.akamai.amp.exoplayer2.ampcustom.scte35.Pair;
import com.akamai.amp.exoplayer2.ampcustom.scte35.Scte35Data;
import com.akamai.amp.exoplayer2.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Scte35Manager {
    private static final String TAG = Scte35Manager.class.getName();
    private static boolean PARSER_LOG_ENABLED = false;
    public static final String TAG_OATCLS_SCTE35 = "#EXT-OATCLS-SCTE35";
    public static final String TAG_CUE_OUT = "#EXT-X-CUE-OUT";
    public static final String TAG_CUE_OUT_CONT = "#EXT-X-CUE-OUT-CONT";
    public static final String TAG_CUE_IN = "#EXT-X-CUE-IN";
    public static Map<String, List<Scte35Data>> cache = new ConcurrentHashMap<String, List<Scte35Data>>();

    public static String parseOatclsScte35(String line) {
        assert (line.startsWith(TAG_OATCLS_SCTE35));
        String base64 = Scte35Manager.getRightSide(line, ':');
        Scte35Manager.log("#EXT-OATCLS-SCTE35 -> " + base64);
        return base64;
    }

    public static float parseCueOut(String line) {
        assert (line.startsWith(TAG_CUE_OUT));
        String durationStr = Scte35Manager.getRightSide(line, ':');
        float duration = Scte35Manager.parseFloat(durationStr);
        Scte35Manager.log("#EXT-X-CUE-OUT -> Duration: " + duration);
        return duration;
    }

    public static Pair<Float, Float> parseCueOutCont(String line) {
        assert (line.startsWith(TAG_CUE_OUT_CONT));
        String remainder = line.substring(line.indexOf(58) + 1);
        String[] parts = remainder.split(",");
        assert (parts.length == 3);
        String elapsedTimeStr = Scte35Manager.getRightSide(parts[0], '=');
        float elapsedTime = Scte35Manager.parseFloat(elapsedTimeStr);
        String durationStr = Scte35Manager.getRightSide(parts[1], '=');
        float duration = Scte35Manager.parseFloat(durationStr);
        Pair<Float, Float> result = Pair.create(Float.valueOf(elapsedTime), Float.valueOf(duration));
        Scte35Manager.log("#EXT-X-CUE-OUT-CONT -> ElapsedTime: " + result.first + " -> Duration: " + result.second);
        return result;
    }

    public static boolean parseCueIn(String line) {
        boolean result = line.startsWith(TAG_CUE_IN);
        assert (result);
        Scte35Manager.log("#EXT-X-CUE-IN -> " + result);
        return result;
    }

    static String getRightSide(String original, char separator) {
        int i = original.indexOf(separator);
        String result = original.substring(i + 1);
        return result;
    }

    static float parseFloat(String param) {
        if (!param.contains(".")) {
            param = param + ".0";
        }
        float result = Float.parseFloat(param);
        return result;
    }

    private static void log(String logLine) {
        if (PARSER_LOG_ENABLED) {
            Log.d(TAG, logLine);
        }
    }

    public static void putAll(String url, List<Scte35Data> newData) {
        if (cache.containsKey(url)) {
            List<Scte35Data> scte35Data = cache.get(url);
            scte35Data.addAll(newData);
            cache.put(url, new ArrayList<Scte35Data>(scte35Data));
        } else {
            cache.put(url, new ArrayList<Scte35Data>(newData));
        }
    }

    public static void put(String url, Scte35Data data) {
        ArrayList<Scte35Data> list = new ArrayList<Scte35Data>();
        list.add(data);
        Scte35Manager.putAll(url, list);
    }
}

