/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.yospace.exo;

import android.app.Activity;
import com.akamai.amp.ads.yospace.exo.ExoAdapter;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.id3.BinaryFrame;
import com.akamai.amp.id3.ID3TagData;
import com.akamai.amp.id3.ID3TagEventListener;
import com.akamai.amp.media.VideoPlayerView;
import com.yospace.android.hls.analytic.Session;
import com.yospace.android.hls.analytic.SessionLive;
import com.yospace.hls.TimedMetadata;
import com.yospace.util.event.EventSourceImpl;

public class ExoAdapterLive
extends ExoAdapter
implements ID3TagEventListener {
    private EventSourceImpl<TimedMetadata> mMetadataSource = new EventSourceImpl();

    public ExoAdapterLive(Activity activity) {
        super(activity);
    }

    private void initID3Handler() {
        if (this.mVideoPlayerView == null) {
            return;
        }
        this.mVideoPlayerView.addId3TagsEventListener((ID3TagEventListener)this);
    }

    public boolean onFoundID3TagData(ID3TagData data) {
        String ymid = null;
        String yseq = null;
        String ytyp = null;
        String ydur = null;
        String yprg = null;
        for (int i = 0; i < data.getId3Frames().length(); ++i) {
            Metadata.Entry entry = data.getId3Frames().get(i);
            if (!(entry instanceof BinaryFrame)) continue;
            BinaryFrame binFrame = (BinaryFrame)entry;
            if ("YMID".equals(binFrame.id)) {
                ymid = new String(binFrame.data);
            } else if ("YSEQ".equals(binFrame.id)) {
                yseq = new String(binFrame.data);
            } else if ("YTYP".equals(binFrame.id)) {
                ytyp = new String(binFrame.data);
            } else if ("YDUR".equals(binFrame.id)) {
                ydur = new String(binFrame.data);
            } else if ("YPRG".equals(binFrame.id)) {
                yprg = new String(binFrame.data);
            }
            TimedMetadata metadata = null;
            if (ymid != null && yseq != null && ytyp != null && ydur != null) {
                metadata = TimedMetadata.createFromId3Tags((String)ymid, (String)yseq, (String)ytyp, (String)ydur);
                ymid = null;
                yseq = null;
                ytyp = null;
                ydur = null;
            } else if (yprg != null) {
                metadata = TimedMetadata.createFromId3Tags(yprg, (float)0.0f);
                yprg = null;
            }
            if (metadata == null) continue;
            this.mMetadataSource.notify((Object)metadata);
        }
        return true;
    }

    public void setSession(SessionLive session) {
        super.setSession((Session)session);
        session.setTimedMetadataSource(this.mMetadataSource);
    }

    @Override
    public void setVideoPlayerView(VideoPlayerView videoPlayerView) {
        super.setVideoPlayerView(videoPlayerView);
        this.initID3Handler();
    }
}

