/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.config;

import com.akamai.amp.config.data.GenericData;
import com.akamai.amp.config.data.NielsenAdData;
import com.akamai.amp.config.data.NielsenAppData;
import com.akamai.amp.config.data.NielsenContentData;
import com.akamai.amp.config.data.NielsenData;
import com.akamai.amp.parser.utils.UtilsParser;
import com.akamai.amp.utils.LogManager;
import java.util.HashMap;
import org.json.JSONObject;

public class NielsenParser {
    public static final String NIELSEN_OBJ_TAG = "nielsendcr";
    public static final String DATA_TAG = "data";
    public static final String EVENT_TAG = "events";
    public static final String VIDEO_TAG = "video";
    public static final String AD_TAG = "ad";

    public NielsenData buildNielsenData(JSONObject root) {
        JSONObject nielsenObject = UtilsParser.getObj(NIELSEN_OBJ_TAG, root);
        NielsenAppData appData = this.parseNielsenAppData(nielsenObject);
        NielsenContentData contentData = this.parseNielsenContentData(nielsenObject);
        NielsenAdData adData = this.parseNielsenAdData(nielsenObject);
        NielsenData nielsenData = new NielsenData(appData, contentData, adData);
        return nielsenData;
    }

    private NielsenAppData parseNielsenAppData(JSONObject nielsen) {
        JSONObject data;
        NielsenAppData result = new NielsenAppData(new HashMap<String, String>());
        if (nielsen != null && (data = UtilsParser.getObj(DATA_TAG, nielsen)) != null) {
            this.setValues(result, data, "APP");
        }
        return result;
    }

    private NielsenContentData parseNielsenContentData(JSONObject nielsen) {
        JSONObject video;
        JSONObject events;
        NielsenContentData result = new NielsenContentData(new HashMap<String, String>());
        if (nielsen != null && (events = UtilsParser.getObj(EVENT_TAG, nielsen)) != null && (video = UtilsParser.getObj(VIDEO_TAG, events)) != null) {
            this.setValues(result, video, "CONTENT");
        }
        return result;
    }

    private NielsenAdData parseNielsenAdData(JSONObject nielsen) {
        JSONObject ad;
        JSONObject events;
        NielsenAdData result = new NielsenAdData(new HashMap<String, String>());
        if (nielsen != null && (events = UtilsParser.getObj(EVENT_TAG, nielsen)) != null && (ad = UtilsParser.getObj(AD_TAG, events)) != null) {
            this.setValues(result, ad, "AD");
        }
        return result;
    }

    private void setValues(GenericData data, JSONObject jsonObject, String id) {
        for (String key : data.getAllMetadata()) {
            String value = UtilsParser.getValue(key, jsonObject);
            if (value == null) continue;
            LogManager.log("NielsenParser", "Nielsen " + id + " Data: " + key + " (" + value + ")");
            data.putValue(key, value);
        }
    }
}

