/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.decoder;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.decoder.OutputBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SimpleOutputBuffer
extends OutputBuffer {
    private final OutputBuffer.Owner<SimpleOutputBuffer> owner;
    @Nullable
    public ByteBuffer data;

    public SimpleOutputBuffer(OutputBuffer.Owner<SimpleOutputBuffer> owner) {
        this.owner = owner;
    }

    public ByteBuffer init(long timeUs, int size) {
        this.timeUs = timeUs;
        if (this.data == null || this.data.capacity() < size) {
            this.data = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        }
        this.data.position(0);
        this.data.limit(size);
        return this.data;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.data != null) {
            this.data.clear();
        }
    }

    @Override
    public void release() {
        this.owner.releaseOutputBuffer(this);
    }
}

