/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.firebase;

import android.content.Context;
import android.os.Bundle;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.analytics.AnalyticsTracker;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.firebase.AmpFirebaseAnalyticsTracker;
import com.akamai.amp.analytics.firebase.AmpFirebaseCustomParams;
import com.akamai.amp.analytics.firebase.AmpFirebaseEvent;
import com.akamai.amp.analytics.firebase.FirebaseTrackerData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.Utils;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.util.UUID;

public class FirebaseEventsHandler
extends AnalyticsTracker<FirebaseTrackerData>
implements AmpFirebaseAnalyticsTracker {
    private static final String LOG_TAG = "FirebaseEventsHandler";
    public static final String VERSION = "9.10.6";
    private FirebaseAnalytics mFirebaseAnalytics;
    private AmpFirebaseCustomParams customParams;
    private UUID sessionId;

    public FirebaseEventsHandler(FirebaseTrackerData data) {
        super((AnalyticsTrackerData)data, LOG_TAG, VERSION);
        this.initCustomParams();
    }

    public FirebaseEventsHandler(VideoPlayerView videoPlayerView, FirebaseTrackerData data) {
        super(videoPlayerView, (AnalyticsTrackerData)data, LOG_TAG, VERSION);
        this.initCustomParams();
    }

    private void initCustomParams() {
        this.customParams = ((FirebaseTrackerData)this.getData()).getCustomParams();
        if (this.customParams == null) {
            this.customParams = new AmpFirebaseCustomParams();
        }
    }

    public void init() {
        this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)this.getOwner());
        this.isSessionInitialized = true;
        this.sessionId = Utils.generateSessionId();
        this.setUserProperty("ampPlatform", "Amp Android SDK player");
        this.setUserProperty("ampVersion", VERSION);
    }

    public void cleanup() {
        this.mFirebaseAnalytics = null;
        this.sessionId = null;
    }

    public String getExternalLibVersion() {
        return "17.2.0";
    }

    public void trackPlayRequestedEvent() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.PLAY)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampPlayRequest", this.customParams.getPlayRequestCustomParams());
        }
    }

    public void trackStopPlaying() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.STOP)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampStop", this.customParams.getStopCustomParams());
        }
    }

    public void trackPlayEvent() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.START)) {
            Bundle params = this.customParams.getStartCustomParams();
            params.putString("ampDeliveryType", this.mVideoPlayerView.isLive() ? "live" : "vod");
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampPlaybackStart", params);
        }
    }

    public void trackResumeEvent() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.RESUME)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampResume", this.customParams.getResumeCustomParams());
        }
    }

    public void trackPauseEvent() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.PAUSE)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampPause", this.customParams.getPauseCustomParams());
        }
    }

    public void trackStartRebuffering() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.BUFFER_START)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampBufferingStart", this.customParams.getBufferStartCustomParams());
        }
    }

    public void trackStopRebuffering() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.BUFFER_END)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampBufferingEnd", this.customParams.getBufferEndCustomParams());
        }
    }

    public void trackSeekStarted() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.SEEK_START)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampSeekStarted", this.customParams.getSeekStartCustomParams());
        }
    }

    public void trackSeekComplete() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.SEEK_END)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampSeekEnded", this.customParams.getSeekEndCustomParams());
        }
    }

    public void trackError(String errorMessage) {
        if (this.isBeaconAvailable(AmpFirebaseEvent.ERROR)) {
            super.trackError(errorMessage);
            Bundle params = this.customParams.getErrorCustomParams();
            params.putString("ampErrorMessage", errorMessage);
            this.logCustomEvent("ampError", params);
        }
    }

    public void trackSendToBackground() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.ON_BACKGROUND)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampOnBackground", this.customParams.getOnBackgroundCustomParams());
        }
    }

    public void trackSendToForeground() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.ON_FOREGROUND)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampOnForeground", this.customParams.getOnForegroundCustomParams());
        }
    }

    public void trackABR() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.BITRATE_SWITCH)) {
            Bundle params = this.customParams.getBitrateSwitchCustomParams();
            if (this.mVideoPlayerView != null) {
                long currentBitrate = this.mVideoPlayerView.getCurrentBitrate();
                params.putLong("ampBitrate", currentBitrate);
            }
            this.logCustomEvent("ampBitrateSwitch", params);
        }
    }

    public void trackFinish() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.END)) {
            this.logCustomEvent(AmpFirebaseEvent.PLAYBACK, "ampPlaybackEnd", this.customParams.getEndCustomParams());
        }
    }

    public void trackAdsLoaded(AdsCount adsCount) {
        if (this.isBeaconAvailable(AmpFirebaseEvent.AD_LOAD)) {
            this.logCustomEvent(AmpFirebaseEvent.ADS, "ampAdLoaded", this.customParams.getAdsLoadCustomParams());
        }
    }

    public void trackAdBreakStart() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.ADBREAK_START)) {
            this.logCustomEvent(AmpFirebaseEvent.ADS, "ampAdBreakStart", this.customParams.getAdBreakStartCustomParams());
        }
    }

    public void trackAdsStarted(AdsInfo adsInfo) {
        if (this.isBeaconAvailable(AmpFirebaseEvent.AD_START)) {
            this.logCustomEvent(AmpFirebaseEvent.ADS, "ampAdStart", this.customParams.getAdStartCustomParams());
        }
    }

    public void trackAdsPaused() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.AD_PAUSE)) {
            this.logCustomEvent(AmpFirebaseEvent.ADS, "ampAdPaused", this.customParams.getAdPauseCustomParams());
        }
    }

    public void trackAdsResumed() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.AD_RESUME)) {
            this.logCustomEvent(AmpFirebaseEvent.ADS, "ampAdResume", this.customParams.getAdResumeCustomParams());
        }
    }

    public void trackAdsEnded() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.AD_END)) {
            this.logCustomEvent(AmpFirebaseEvent.ADS, "ampAdEnd", this.customParams.getAdEndCustomParams());
        }
    }

    public void trackAdBreakEnd() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.ADBREAK_END)) {
            this.logCustomEvent(AmpFirebaseEvent.ADS, "ampAdBreakEnd", this.customParams.getAdBreakEndCustomParams());
        }
    }

    public void trackAdsError(String reason) {
        if (this.isBeaconAvailable(AmpFirebaseEvent.AD_ERROR)) {
            super.trackAdsError(reason);
            Bundle params = new Bundle();
            params.putString("ampErrorMessage", reason);
            this.logCustomEvent("ampAdError", params);
        }
    }

    public void trackSubtitlesDisabled() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.CAPTIONS_DISABLE)) {
            this.logCustomEvent(AmpFirebaseEvent.CAPTIONS, "ampCaptionsDisabled", this.customParams.getCaptionsDisableCustomParams());
        }
    }

    public void trackSubtitlesEnabled() {
        if (this.isBeaconAvailable(AmpFirebaseEvent.CAPTIONS_ENABLE)) {
            this.logCustomEvent(AmpFirebaseEvent.CAPTIONS, "ampCaptionsEnabled", this.customParams.getCaptionsEnableCustomParams());
        }
    }

    @Override
    public void setUserProperty(String key, String value) {
        if (this.mFirebaseAnalytics != null) {
            this.mFirebaseAnalytics.setUserProperty(key, value);
        }
    }

    @Override
    public void logCustomEvent(String key, Bundle params) {
        Bundle defaultParams = this.getDefaultLogBundle(null);
        this.appendParams(defaultParams, params);
        this.doLogCustomEvent(key, defaultParams);
    }

    @Override
    public void logCustomEvent(AmpFirebaseEvent parentType, String key, Bundle params) {
        Bundle defaultParams = this.getDefaultLogBundle(parentType);
        this.appendParams(defaultParams, params);
        this.doLogCustomEvent(key, defaultParams);
    }

    private Bundle appendMultiParams(AmpFirebaseEvent parentType) {
        Bundle params = new Bundle();
        if (this.customParams != null) {
            this.appendParams(params, this.customParams.getGlobalCustomParams());
            if (parentType != null) {
                if (parentType.ordinal() == AmpFirebaseEvent.PLAYBACK.ordinal()) {
                    this.appendParams(params, this.customParams.getPlaybackCustomParams());
                } else if (parentType.ordinal() == AmpFirebaseEvent.ADS.ordinal()) {
                    this.appendParams(params, this.customParams.getAdsCustomParams());
                } else if (parentType.ordinal() == AmpFirebaseEvent.CAPTIONS.ordinal()) {
                    this.appendParams(params, this.customParams.getCaptionsCustomParams());
                }
            }
        }
        return params;
    }

    private void appendParams(Bundle defaultBundle, Bundle extraBundle) {
        if (extraBundle != null && !extraBundle.isEmpty()) {
            defaultBundle.putAll(extraBundle);
        }
    }

    private void doLogCustomEvent(String key, Bundle params) {
        if (this.mFirebaseAnalytics != null) {
            this.mFirebaseAnalytics.logEvent(key, params);
        }
    }

    private Bundle getDefaultLogBundle(AmpFirebaseEvent parentType) {
        Bundle params = new Bundle();
        params.putString("ampSessionId", this.sessionId.toString());
        params.putLong("ampTimestamp", System.currentTimeMillis());
        params.putAll(this.appendMultiParams(parentType));
        return params;
    }

    private boolean isBeaconAvailable(AmpFirebaseEvent selectedEvent) {
        AmpFirebaseEvent[] events = ((FirebaseTrackerData)this.getData()).getTrackEvents();
        if (events == null || events.length == 0) {
            return false;
        }
        for (AmpFirebaseEvent event : events) {
            if (selectedEvent.ordinal() != event.ordinal() && selectedEvent.parentType.ordinal() != event.ordinal()) continue;
            return true;
        }
        return false;
    }
}

