/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.source.ClippingMediaPeriod;
import com.akamai.amp.exoplayer2.source.CompositeMediaSource;
import com.akamai.amp.exoplayer2.source.ForwardingTimeline;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public final class ClippingMediaSource
extends CompositeMediaSource<Void> {
    private final MediaSource mediaSource;
    private final long startUs;
    private final long endUs;
    private final boolean enableInitialDiscontinuity;
    private final boolean allowDynamicClippingUpdates;
    private final boolean relativeToDefaultPosition;
    private final ArrayList<ClippingMediaPeriod> mediaPeriods;
    private final Timeline.Window window;
    @Nullable
    private ClippingTimeline clippingTimeline;
    @Nullable
    private IllegalClippingException clippingError;
    private long periodStartUs;
    private long periodEndUs;

    @Override
    public boolean isLive() {
        if (this.mediaSource == null) {
            return false;
        }
        return this.mediaSource.isLive();
    }

    public ClippingMediaSource(MediaSource mediaSource, long startPositionUs, long endPositionUs) {
        this(mediaSource, startPositionUs, endPositionUs, true, false, false);
    }

    public ClippingMediaSource(MediaSource mediaSource, long durationUs) {
        this(mediaSource, 0L, durationUs, true, false, true);
    }

    public ClippingMediaSource(MediaSource mediaSource, long startPositionUs, long endPositionUs, boolean enableInitialDiscontinuity, boolean allowDynamicClippingUpdates, boolean relativeToDefaultPosition) {
        Assertions.checkArgument(startPositionUs >= 0L);
        this.mediaSource = Assertions.checkNotNull(mediaSource);
        this.startUs = startPositionUs;
        this.endUs = endPositionUs;
        this.enableInitialDiscontinuity = enableInitialDiscontinuity;
        this.allowDynamicClippingUpdates = allowDynamicClippingUpdates;
        this.relativeToDefaultPosition = relativeToDefaultPosition;
        this.mediaPeriods = new ArrayList();
        this.window = new Timeline.Window();
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.mediaSource.getTag();
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaSource.getMediaItem();
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        this.prepareChildSource(null, this.mediaSource);
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        if (this.clippingError != null) {
            throw this.clippingError;
        }
        super.maybeThrowSourceInfoRefreshError();
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        ClippingMediaPeriod mediaPeriod = new ClippingMediaPeriod(this.mediaSource.createPeriod(id, allocator, startPositionUs), this.enableInitialDiscontinuity, this.periodStartUs, this.periodEndUs);
        this.mediaPeriods.add(mediaPeriod);
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        Assertions.checkState(this.mediaPeriods.remove(mediaPeriod));
        this.mediaSource.releasePeriod(((ClippingMediaPeriod)mediaPeriod).mediaPeriod);
        if (this.mediaPeriods.isEmpty() && !this.allowDynamicClippingUpdates) {
            this.refreshClippedTimeline(Assertions.checkNotNull(this.clippingTimeline).timeline);
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        this.clippingError = null;
        this.clippingTimeline = null;
    }

    @Override
    protected void onChildSourceInfoRefreshed(Void id, MediaSource mediaSource, Timeline timeline) {
        if (this.clippingError != null) {
            return;
        }
        this.refreshClippedTimeline(timeline);
    }

    private void refreshClippedTimeline(Timeline timeline) {
        long windowEndUs;
        long windowStartUs;
        timeline.getWindow(0, this.window);
        long windowPositionInPeriodUs = this.window.getPositionInFirstPeriodUs();
        if (this.clippingTimeline == null || this.mediaPeriods.isEmpty() || this.allowDynamicClippingUpdates) {
            windowStartUs = this.startUs;
            windowEndUs = this.endUs;
            if (this.relativeToDefaultPosition) {
                long windowDefaultPositionUs = this.window.getDefaultPositionUs();
                windowStartUs += windowDefaultPositionUs;
                windowEndUs += windowDefaultPositionUs;
            }
            this.periodStartUs = windowPositionInPeriodUs + windowStartUs;
            this.periodEndUs = this.endUs == Long.MIN_VALUE ? Long.MIN_VALUE : windowPositionInPeriodUs + windowEndUs;
            int count = this.mediaPeriods.size();
            for (int i = 0; i < count; ++i) {
                this.mediaPeriods.get(i).updateClipping(this.periodStartUs, this.periodEndUs);
            }
        } else {
            windowStartUs = this.periodStartUs - windowPositionInPeriodUs;
            windowEndUs = this.endUs == Long.MIN_VALUE ? Long.MIN_VALUE : this.periodEndUs - windowPositionInPeriodUs;
        }
        try {
            this.clippingTimeline = new ClippingTimeline(timeline, windowStartUs, windowEndUs);
        }
        catch (IllegalClippingException e) {
            this.clippingError = e;
            return;
        }
        this.refreshSourceInfo(this.clippingTimeline);
    }

    @Override
    protected long getMediaTimeForChildMediaTime(Void id, long mediaTimeMs) {
        if (mediaTimeMs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        long startMs = C.usToMs(this.startUs);
        long clippedTimeMs = Math.max(0L, mediaTimeMs - startMs);
        if (this.endUs != Long.MIN_VALUE) {
            clippedTimeMs = Math.min(C.usToMs(this.endUs) - startMs, clippedTimeMs);
        }
        return clippedTimeMs;
    }

    public static final class IllegalClippingException
    extends IOException {
        public static final int REASON_INVALID_PERIOD_COUNT = 0;
        public static final int REASON_NOT_SEEKABLE_TO_START = 1;
        public static final int REASON_START_EXCEEDS_END = 2;
        public final int reason;

        public IllegalClippingException(int reason) {
            super("Illegal clipping: " + IllegalClippingException.getReasonDescription(reason));
            this.reason = reason;
        }

        private static String getReasonDescription(int reason) {
            switch (reason) {
                case 0: {
                    return "invalid period count";
                }
                case 1: {
                    return "not seekable to start";
                }
                case 2: {
                    return "start exceeds end";
                }
            }
            return "unknown";
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }

    private static final class ClippingTimeline
    extends ForwardingTimeline {
        private final long startUs;
        private final long endUs;
        private final long durationUs;
        private final boolean isDynamic;

        public ClippingTimeline(Timeline timeline, long startUs, long endUs) throws IllegalClippingException {
            super(timeline);
            long resolvedEndUs;
            if (timeline.getPeriodCount() != 1) {
                throw new IllegalClippingException(0);
            }
            Timeline.Window window = timeline.getWindow(0, new Timeline.Window());
            startUs = Math.max(0L, startUs);
            if (!window.isPlaceholder && startUs != 0L && !window.isSeekable) {
                throw new IllegalClippingException(1);
            }
            long l = resolvedEndUs = endUs == Long.MIN_VALUE ? window.durationUs : Math.max(0L, endUs);
            if (window.durationUs != -9223372036854775807L) {
                if (resolvedEndUs > window.durationUs) {
                    resolvedEndUs = window.durationUs;
                }
                if (startUs > resolvedEndUs) {
                    throw new IllegalClippingException(2);
                }
            }
            this.startUs = startUs;
            this.endUs = resolvedEndUs;
            this.durationUs = resolvedEndUs == -9223372036854775807L ? -9223372036854775807L : resolvedEndUs - startUs;
            this.isDynamic = window.isDynamic && (resolvedEndUs == -9223372036854775807L || window.durationUs != -9223372036854775807L && resolvedEndUs == window.durationUs);
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            this.timeline.getWindow(0, window, 0L);
            window.positionInFirstPeriodUs += this.startUs;
            window.durationUs = this.durationUs;
            window.isDynamic = this.isDynamic;
            if (window.defaultPositionUs != -9223372036854775807L) {
                window.defaultPositionUs = Math.max(window.defaultPositionUs, this.startUs);
                window.defaultPositionUs = this.endUs == -9223372036854775807L ? window.defaultPositionUs : Math.min(window.defaultPositionUs, this.endUs);
                window.defaultPositionUs -= this.startUs;
            }
            long startMs = C.usToMs(this.startUs);
            if (window.presentationStartTimeMs != -9223372036854775807L) {
                window.presentationStartTimeMs += startMs;
            }
            if (window.windowStartTimeMs != -9223372036854775807L) {
                window.windowStartTimeMs += startMs;
            }
            return window;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            this.timeline.getPeriod(0, period, setIds);
            long positionInClippedWindowUs = period.getPositionInWindowUs() - this.startUs;
            long periodDurationUs = this.durationUs == -9223372036854775807L ? -9223372036854775807L : this.durationUs - positionInClippedWindowUs;
            return period.set(period.id, period.uid, 0, periodDurationUs, positionInClippedWindowUs);
        }
    }
}

