/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.audio;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.FormatHolder;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Renderer;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.audio.AudioCapabilities;
import com.akamai.amp.exoplayer2.audio.AudioProcessor;
import com.akamai.amp.exoplayer2.audio.AudioRendererEventListener;
import com.akamai.amp.exoplayer2.audio.AudioSink;
import com.akamai.amp.exoplayer2.audio.AuxEffectInfo;
import com.akamai.amp.exoplayer2.audio.DefaultAudioSink;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecAdapter;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecInfo;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecRenderer;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecSelector;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecUtil;
import com.akamai.amp.exoplayer2.mediacodec.MediaFormatUtil;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.MediaClock;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MediaCodecAudioRenderer
extends MediaCodecRenderer
implements MediaClock {
    private static final String TAG = "MediaCodecAudioRenderer";
    private static final String VIVO_BITS_PER_SAMPLE_KEY = "v-bits-per-sample";
    private final Context context;
    private final AudioRendererEventListener.EventDispatcher eventDispatcher;
    private final AudioSink audioSink;
    private int codecMaxInputSize;
    private boolean codecNeedsDiscardChannelsWorkaround;
    private boolean codecNeedsEosBufferTimestampWorkaround;
    @Nullable
    private Format decryptOnlyCodecFormat;
    private long currentPositionUs;
    private boolean allowFirstBufferPositionDiscontinuity;
    private boolean allowPositionDiscontinuity;
    private boolean audioSinkNeedsReset;
    private boolean experimentalKeepAudioTrackOnSeek;
    @Nullable
    private Renderer.WakeupListener wakeupListener;

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector) {
        this(context, mediaCodecSelector, null, null);
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener) {
        this(context, mediaCodecSelector, eventHandler, eventListener, (AudioCapabilities)null, new AudioProcessor[0]);
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, @Nullable AudioCapabilities audioCapabilities, AudioProcessor ... audioProcessors) {
        this(context, mediaCodecSelector, eventHandler, eventListener, new DefaultAudioSink(audioCapabilities, audioProcessors));
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, AudioSink audioSink) {
        this(context, mediaCodecSelector, false, eventHandler, eventListener, audioSink);
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, AudioSink audioSink) {
        super(1, mediaCodecSelector, enableDecoderFallback, 44100.0f);
        this.context = context.getApplicationContext();
        this.audioSink = audioSink;
        this.eventDispatcher = new AudioRendererEventListener.EventDispatcher(eventHandler, eventListener);
        audioSink.setListener(new AudioSinkListener());
    }

    @Override
    public String getName() {
        return TAG;
    }

    public void experimentalSetEnableKeepAudioTrackOnSeek(boolean enableKeepAudioTrackOnSeek) {
        this.experimentalKeepAudioTrackOnSeek = enableKeepAudioTrackOnSeek;
    }

    @Override
    protected int supportsFormat(MediaCodecSelector mediaCodecSelector, Format format) throws MediaCodecUtil.DecoderQueryException {
        if (!MimeTypes.isAudio(format.sampleMimeType)) {
            return RendererCapabilities.create(0);
        }
        int tunnelingSupport = Util.SDK_INT >= 21 ? 32 : 0;
        boolean formatHasDrm = format.exoMediaCryptoType != null;
        boolean supportsFormatDrm = MediaCodecAudioRenderer.supportsFormatDrm(format);
        if (supportsFormatDrm && this.audioSink.supportsFormat(format) && (!formatHasDrm || MediaCodecUtil.getDecryptOnlyDecoderInfo() != null)) {
            return RendererCapabilities.create(4, 8, tunnelingSupport);
        }
        if ("audio/raw".equals(format.sampleMimeType) && !this.audioSink.supportsFormat(format)) {
            return RendererCapabilities.create(1);
        }
        if (!this.audioSink.supportsFormat(Util.getPcmFormat(2, format.channelCount, format.sampleRate))) {
            return RendererCapabilities.create(1);
        }
        List<MediaCodecInfo> decoderInfos = this.getDecoderInfos(mediaCodecSelector, format, false);
        if (decoderInfos.isEmpty()) {
            return RendererCapabilities.create(1);
        }
        if (!supportsFormatDrm) {
            return RendererCapabilities.create(2);
        }
        MediaCodecInfo decoderInfo = decoderInfos.get(0);
        boolean isFormatSupported = decoderInfo.isFormatSupported(format);
        int adaptiveSupport = isFormatSupported && decoderInfo.isSeamlessAdaptationSupported(format) ? 16 : 8;
        int formatSupport = isFormatSupported ? 4 : 3;
        return RendererCapabilities.create(formatSupport, adaptiveSupport, tunnelingSupport);
    }

    @Override
    protected List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        MediaCodecInfo codecInfo;
        String mimeType = format.sampleMimeType;
        if (mimeType == null) {
            return Collections.emptyList();
        }
        if (this.audioSink.supportsFormat(format) && (codecInfo = MediaCodecUtil.getDecryptOnlyDecoderInfo()) != null) {
            return Collections.singletonList(codecInfo);
        }
        List<MediaCodecInfo> decoderInfos = mediaCodecSelector.getDecoderInfos(mimeType, requiresSecureDecoder, false);
        decoderInfos = MediaCodecUtil.getDecoderInfosSortedByFormatSupport(decoderInfos, format);
        if ("audio/eac3-joc".equals(mimeType)) {
            ArrayList<MediaCodecInfo> decoderInfosWithEac3 = new ArrayList<MediaCodecInfo>(decoderInfos);
            decoderInfosWithEac3.addAll(mediaCodecSelector.getDecoderInfos("audio/eac3", requiresSecureDecoder, false));
            decoderInfos = decoderInfosWithEac3;
        }
        return Collections.unmodifiableList(decoderInfos);
    }

    @Override
    protected boolean shouldUseBypass(Format format) {
        return this.audioSink.supportsFormat(format);
    }

    @Override
    protected void configureCodec(MediaCodecInfo codecInfo, MediaCodecAdapter codecAdapter, Format format, @Nullable MediaCrypto crypto, float codecOperatingRate) {
        this.codecMaxInputSize = this.getCodecMaxInputSize(codecInfo, format, this.getStreamFormats());
        this.codecNeedsDiscardChannelsWorkaround = MediaCodecAudioRenderer.codecNeedsDiscardChannelsWorkaround(codecInfo.name);
        this.codecNeedsEosBufferTimestampWorkaround = MediaCodecAudioRenderer.codecNeedsEosBufferTimestampWorkaround(codecInfo.name);
        MediaFormat mediaFormat = this.getMediaFormat(format, codecInfo.codecMimeType, this.codecMaxInputSize, codecOperatingRate);
        codecAdapter.configure(mediaFormat, null, crypto, 0);
        boolean decryptOnlyCodecEnabled = "audio/raw".equals(codecInfo.mimeType) && !"audio/raw".equals(format.sampleMimeType);
        this.decryptOnlyCodecFormat = decryptOnlyCodecEnabled ? format : null;
    }

    @Override
    protected int canKeepCodec(MediaCodec codec, MediaCodecInfo codecInfo, Format oldFormat, Format newFormat) {
        if (this.getCodecMaxInputSize(codecInfo, newFormat) > this.codecMaxInputSize) {
            return 0;
        }
        if (codecInfo.isSeamlessAdaptationSupported(oldFormat, newFormat, true)) {
            return 3;
        }
        if (this.canKeepCodecWithFlush(oldFormat, newFormat)) {
            return 1;
        }
        return 0;
    }

    protected boolean canKeepCodecWithFlush(Format oldFormat, Format newFormat) {
        return Util.areEqual(oldFormat.sampleMimeType, newFormat.sampleMimeType) && oldFormat.channelCount == newFormat.channelCount && oldFormat.sampleRate == newFormat.sampleRate && oldFormat.pcmEncoding == newFormat.pcmEncoding && oldFormat.initializationDataEquals(newFormat) && !"audio/opus".equals(oldFormat.sampleMimeType);
    }

    @Override
    @Nullable
    public MediaClock getMediaClock() {
        return this;
    }

    @Override
    protected float getCodecOperatingRateV23(float operatingRate, Format format, Format[] streamFormats) {
        int maxSampleRate = -1;
        for (Format streamFormat : streamFormats) {
            int streamSampleRate = streamFormat.sampleRate;
            if (streamSampleRate == -1) continue;
            maxSampleRate = Math.max(maxSampleRate, streamSampleRate);
        }
        return maxSampleRate == -1 ? -1.0f : (float)maxSampleRate * operatingRate;
    }

    @Override
    protected void onCodecInitialized(String name, long initializedTimestampMs, long initializationDurationMs) {
        this.eventDispatcher.decoderInitialized(name, initializedTimestampMs, initializationDurationMs);
    }

    @Override
    protected void onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        super.onInputFormatChanged(formatHolder);
        this.eventDispatcher.inputFormatChanged(formatHolder.format);
    }

    @Override
    protected void onOutputFormatChanged(Format format, @Nullable MediaFormat mediaFormat) throws ExoPlaybackException {
        Format audioSinkInputFormat;
        int[] channelMap = null;
        if (this.decryptOnlyCodecFormat != null) {
            audioSinkInputFormat = this.decryptOnlyCodecFormat;
        } else if (this.getCodec() == null) {
            audioSinkInputFormat = format;
        } else {
            int pcmEncoding = "audio/raw".equals(format.sampleMimeType) ? format.pcmEncoding : (Util.SDK_INT >= 24 && mediaFormat.containsKey("pcm-encoding") ? mediaFormat.getInteger("pcm-encoding") : (mediaFormat.containsKey(VIVO_BITS_PER_SAMPLE_KEY) ? Util.getPcmEncoding(mediaFormat.getInteger(VIVO_BITS_PER_SAMPLE_KEY)) : ("audio/raw".equals(format.sampleMimeType) ? format.pcmEncoding : 2)));
            audioSinkInputFormat = new Format.Builder().setSampleMimeType("audio/raw").setPcmEncoding(pcmEncoding).setEncoderDelay(format.encoderDelay).setEncoderPadding(format.encoderPadding).setChannelCount(mediaFormat.getInteger("channel-count")).setSampleRate(mediaFormat.getInteger("sample-rate")).build();
            if (this.codecNeedsDiscardChannelsWorkaround && audioSinkInputFormat.channelCount == 6 && format.channelCount < 6) {
                channelMap = new int[format.channelCount];
                for (int i = 0; i < format.channelCount; ++i) {
                    channelMap[i] = i;
                }
            }
        }
        try {
            this.audioSink.configure(audioSinkInputFormat, 0, channelMap);
        }
        catch (AudioSink.ConfigurationException e) {
            throw this.createRendererException(e, format);
        }
    }

    protected void onAudioSessionId(int audioSessionId) {
    }

    @CallSuper
    protected void onPositionDiscontinuity() {
        this.allowPositionDiscontinuity = true;
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        super.onEnabled(joining, mayRenderStartOfStream);
        this.eventDispatcher.enabled(this.decoderCounters);
        int tunnelingAudioSessionId = this.getConfiguration().tunnelingAudioSessionId;
        if (tunnelingAudioSessionId != 0) {
            this.audioSink.enableTunnelingV21(tunnelingAudioSessionId);
        } else {
            this.audioSink.disableTunneling();
        }
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        super.onPositionReset(positionUs, joining);
        if (this.experimentalKeepAudioTrackOnSeek) {
            this.audioSink.experimentalFlushWithoutAudioTrackRelease();
        } else {
            this.audioSink.flush();
        }
        this.currentPositionUs = positionUs;
        this.allowFirstBufferPositionDiscontinuity = true;
        this.allowPositionDiscontinuity = true;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.audioSink.play();
    }

    @Override
    protected void onStopped() {
        this.updateCurrentPosition();
        this.audioSink.pause();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.audioSinkNeedsReset = true;
        try {
            this.audioSink.flush();
        }
        finally {
            try {
                super.onDisabled();
            }
            finally {
                this.eventDispatcher.disabled(this.decoderCounters);
            }
        }
    }

    @Override
    protected void onReset() {
        try {
            super.onReset();
        }
        finally {
            if (this.audioSinkNeedsReset) {
                this.audioSinkNeedsReset = false;
                this.audioSink.reset();
            }
        }
    }

    @Override
    public boolean isEnded() {
        return super.isEnded() && this.audioSink.isEnded();
    }

    @Override
    public boolean isReady() {
        return this.audioSink.hasPendingData() || super.isReady();
    }

    @Override
    public long getPositionUs() {
        if (this.getState() == 2) {
            this.updateCurrentPosition();
        }
        return this.currentPositionUs;
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.audioSink.setPlaybackParameters(playbackParameters);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.audioSink.getPlaybackParameters();
    }

    @Override
    protected void onQueueInputBuffer(DecoderInputBuffer buffer) {
        if (this.allowFirstBufferPositionDiscontinuity && !buffer.isDecodeOnly()) {
            if (Math.abs(buffer.timeUs - this.currentPositionUs) > 500000L) {
                this.currentPositionUs = buffer.timeUs;
            }
            this.allowFirstBufferPositionDiscontinuity = false;
        }
    }

    @Override
    protected void onProcessedStreamChange() {
        super.onProcessedStreamChange();
        this.audioSink.handleDiscontinuity();
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, @Nullable MediaCodec codec, @Nullable ByteBuffer buffer, int bufferIndex, int bufferFlags, int sampleCount, long bufferPresentationTimeUs, boolean isDecodeOnlyBuffer, boolean isLastBuffer, Format format) throws ExoPlaybackException {
        boolean fullyConsumed;
        Assertions.checkNotNull(buffer);
        if (codec != null && this.codecNeedsEosBufferTimestampWorkaround && bufferPresentationTimeUs == 0L && (bufferFlags & 4) != 0 && this.getLargestQueuedPresentationTimeUs() != -9223372036854775807L) {
            bufferPresentationTimeUs = this.getLargestQueuedPresentationTimeUs();
        }
        if (this.decryptOnlyCodecFormat != null && (bufferFlags & 2) != 0) {
            Assertions.checkNotNull(codec).releaseOutputBuffer(bufferIndex, false);
            return true;
        }
        if (isDecodeOnlyBuffer) {
            if (codec != null) {
                codec.releaseOutputBuffer(bufferIndex, false);
            }
            this.decoderCounters.skippedOutputBufferCount += sampleCount;
            this.audioSink.handleDiscontinuity();
            return true;
        }
        try {
            fullyConsumed = this.audioSink.handleBuffer(buffer, bufferPresentationTimeUs, sampleCount);
        }
        catch (AudioSink.InitializationException | AudioSink.WriteException e) {
            throw this.createRendererException(e, format);
        }
        if (fullyConsumed) {
            if (codec != null) {
                codec.releaseOutputBuffer(bufferIndex, false);
            }
            this.decoderCounters.renderedOutputBufferCount += sampleCount;
            return true;
        }
        return false;
    }

    @Override
    protected void renderToEndOfStream() throws ExoPlaybackException {
        try {
            this.audioSink.playToEndOfStream();
        }
        catch (AudioSink.WriteException e) {
            Format outputFormat = this.getOutputFormat();
            throw this.createRendererException(e, outputFormat != null ? outputFormat : this.getInputFormat());
        }
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 2: {
                this.audioSink.setVolume(((Float)message).floatValue());
                break;
            }
            case 3: {
                AudioAttributes audioAttributes = (AudioAttributes)message;
                this.audioSink.setAudioAttributes(audioAttributes);
                break;
            }
            case 5: {
                AuxEffectInfo auxEffectInfo = (AuxEffectInfo)message;
                this.audioSink.setAuxEffectInfo(auxEffectInfo);
                break;
            }
            case 101: {
                this.audioSink.setSkipSilenceEnabled((Boolean)message);
                break;
            }
            case 102: {
                this.audioSink.setAudioSessionId((Integer)message);
                break;
            }
            case 103: {
                this.wakeupListener = (Renderer.WakeupListener)message;
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }

    protected int getCodecMaxInputSize(MediaCodecInfo codecInfo, Format format, Format[] streamFormats) {
        int maxInputSize = this.getCodecMaxInputSize(codecInfo, format);
        if (streamFormats.length == 1) {
            return maxInputSize;
        }
        for (Format streamFormat : streamFormats) {
            if (!codecInfo.isSeamlessAdaptationSupported(format, streamFormat, false)) continue;
            maxInputSize = Math.max(maxInputSize, this.getCodecMaxInputSize(codecInfo, streamFormat));
        }
        return maxInputSize;
    }

    private int getCodecMaxInputSize(MediaCodecInfo codecInfo, Format format) {
        if ("OMX.google.raw.decoder".equals(codecInfo.name) && Util.SDK_INT < 24 && (Util.SDK_INT != 23 || !Util.isTv(this.context))) {
            return -1;
        }
        return format.maxInputSize;
    }

    @SuppressLint(value={"InlinedApi"})
    protected MediaFormat getMediaFormat(Format format, String codecMimeType, int codecMaxInputSize, float codecOperatingRate) {
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", codecMimeType);
        mediaFormat.setInteger("channel-count", format.channelCount);
        mediaFormat.setInteger("sample-rate", format.sampleRate);
        MediaFormatUtil.setCsdBuffers(mediaFormat, format.initializationData);
        MediaFormatUtil.maybeSetInteger(mediaFormat, "max-input-size", codecMaxInputSize);
        if (Util.SDK_INT >= 23) {
            mediaFormat.setInteger("priority", 0);
            if (codecOperatingRate != -1.0f && !MediaCodecAudioRenderer.deviceDoesntSupportOperatingRate()) {
                mediaFormat.setFloat("operating-rate", codecOperatingRate);
            }
        }
        if (Util.SDK_INT <= 28 && "audio/ac4".equals(format.sampleMimeType)) {
            mediaFormat.setInteger("ac4-is-sync", 1);
        }
        if (Util.SDK_INT >= 24 && this.audioSink.getFormatSupport(Util.getPcmFormat(4, format.channelCount, format.sampleRate)) == 2) {
            mediaFormat.setInteger("pcm-encoding", 4);
        }
        return mediaFormat;
    }

    private void updateCurrentPosition() {
        long newCurrentPositionUs = this.audioSink.getCurrentPositionUs(this.isEnded());
        if (newCurrentPositionUs != Long.MIN_VALUE) {
            this.currentPositionUs = this.allowPositionDiscontinuity ? newCurrentPositionUs : Math.max(this.currentPositionUs, newCurrentPositionUs);
            this.allowPositionDiscontinuity = false;
        }
    }

    private static boolean deviceDoesntSupportOperatingRate() {
        return Util.SDK_INT == 23 && ("ZTE B2017G".equals(Util.MODEL) || "AXON 7 mini".equals(Util.MODEL));
    }

    private static boolean codecNeedsDiscardChannelsWorkaround(String codecName) {
        return Util.SDK_INT < 24 && "OMX.SEC.aac.dec".equals(codecName) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("zeroflte") || Util.DEVICE.startsWith("herolte") || Util.DEVICE.startsWith("heroqlte"));
    }

    private static boolean codecNeedsEosBufferTimestampWorkaround(String codecName) {
        return Util.SDK_INT < 21 && "OMX.SEC.mp3.dec".equals(codecName) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("baffin") || Util.DEVICE.startsWith("grand") || Util.DEVICE.startsWith("fortuna") || Util.DEVICE.startsWith("gprimelte") || Util.DEVICE.startsWith("j2y18lte") || Util.DEVICE.startsWith("ms01"));
    }

    private final class AudioSinkListener
    implements AudioSink.Listener {
        private AudioSinkListener() {
        }

        @Override
        public void onAudioSessionId(int audioSessionId) {
            MediaCodecAudioRenderer.this.eventDispatcher.audioSessionId(audioSessionId);
            MediaCodecAudioRenderer.this.onAudioSessionId(audioSessionId);
        }

        @Override
        public void onPositionDiscontinuity() {
            MediaCodecAudioRenderer.this.onPositionDiscontinuity();
        }

        @Override
        public void onPositionAdvancing(long playoutStartSystemTimeMs) {
            MediaCodecAudioRenderer.this.eventDispatcher.positionAdvancing(playoutStartSystemTimeMs);
        }

        @Override
        public void onUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            MediaCodecAudioRenderer.this.eventDispatcher.underrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }

        @Override
        public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
            MediaCodecAudioRenderer.this.eventDispatcher.skipSilenceEnabledChanged(skipSilenceEnabled);
        }

        @Override
        public void onOffloadBufferEmptying() {
            if (MediaCodecAudioRenderer.this.wakeupListener != null) {
                MediaCodecAudioRenderer.this.wakeupListener.onWakeup();
            }
        }

        @Override
        public void onOffloadBufferFull(long bufferEmptyingDeadlineMs) {
            if (MediaCodecAudioRenderer.this.wakeupListener != null) {
                MediaCodecAudioRenderer.this.wakeupListener.onSleep(bufferEmptyingDeadlineMs);
            }
        }
    }
}

