/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.audio;

import com.akamai.amp.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface AudioProcessor {
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());

    public AudioFormat configure(AudioFormat var1) throws UnhandledAudioFormatException;

    public boolean isActive();

    public void queueInput(ByteBuffer var1);

    public void queueEndOfStream();

    public ByteBuffer getOutput();

    public boolean isEnded();

    public void flush();

    public void reset();

    public static final class UnhandledAudioFormatException
    extends Exception {
        public UnhandledAudioFormatException(AudioFormat inputAudioFormat) {
            super("Unhandled format: " + inputAudioFormat);
        }
    }

    public static final class AudioFormat {
        public static final AudioFormat NOT_SET = new AudioFormat(-1, -1, -1);
        public final int sampleRate;
        public final int channelCount;
        public final int encoding;
        public final int bytesPerFrame;

        public AudioFormat(int sampleRate, int channelCount, int encoding) {
            this.sampleRate = sampleRate;
            this.channelCount = channelCount;
            this.encoding = encoding;
            this.bytesPerFrame = Util.isEncodingLinearPcm(encoding) ? Util.getPcmFrameSize(encoding, channelCount) : -1;
        }

        public String toString() {
            return "AudioFormat[sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + ", encoding=" + this.encoding + ']';
        }
    }
}

