/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.service.clock;

import com.adobe.primetime.va.service.clock.TimerManager;
import java.util.Date;

final class TimerDescriptor {
    private String _name;
    private double _interval;
    private int _repeatCount;
    private int _tick;
    private boolean _isActive;
    private long _createdTimeStamp;
    private long _nextTickTimeStamp;

    TimerDescriptor(String name, double interval, int repeatCount) {
        this._interval = interval;
        this._name = name;
        this._isActive = false;
        this._repeatCount = repeatCount;
        this.reset();
    }

    public int getRepeatCount() {
        return this._repeatCount;
    }

    public void setRepeatCount(int value) {
        this._repeatCount = value;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void isActive(boolean value) {
        this._isActive = value;
    }

    public double getInterval() {
        return this._interval;
    }

    public String getName() {
        return this._name;
    }

    public int getTick() {
        return this._tick;
    }

    public void reset() {
        this._tick = 0;
        this._createdTimeStamp = new Date().getTime();
        this._updateNextTickTimeStamp();
    }

    public boolean shouldTick() {
        long now = new Date().getTime();
        if ((double)now > (double)this._nextTickTimeStamp - TimerManager.TIMER_BASE_INTERVAL / 2.0) {
            ++this._tick;
            this._updateNextTickTimeStamp();
            return true;
        }
        return false;
    }

    private void _updateNextTickTimeStamp() {
        long now = new Date().getTime();
        this._nextTickTimeStamp = now + (long)(this._interval * 1000.0) - 1L;
    }
}

