/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.model.serialization;

import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.Dao;
import com.adobe.primetime.va.plugins.ah.engine.model.report.Report;
import com.adobe.primetime.va.plugins.ah.engine.model.serialization.ISerializable;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseSerializer
implements ISerializable {
    protected ILogger _logger;
    protected String _logTag;

    BaseSerializer(ILogger logger) {
        if (logger == null) {
            throw new Error("Reference to logger object cannot be NULL.");
        }
        this._logger = logger;
        this._logTag = BaseSerializer.class.getSimpleName();
    }

    ArrayList<String> _processDao(Dao dao) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Dao.DaoField> entry : dao.getData().entrySet()) {
            String key = entry.getKey();
            Dao.DaoField field = entry.getValue();
            Object value = field.value;
            Object hint = field.hint;
            String realm = dao.getRealm();
            String serializedValue = null;
            if (value == null) continue;
            if (value instanceof Long) {
                serializedValue = (String)this.serializeLong(key, (Long)value, realm, hint);
            } else if (value instanceof Integer) {
                serializedValue = (String)this.serializeInteger(key, (Integer)value, realm, hint);
            } else if (value instanceof Double) {
                serializedValue = (String)this.serializeDouble(key, (Double)value, realm, hint);
            } else if (value instanceof Boolean) {
                serializedValue = (String)this.serializeBooleanToLong(key, (Boolean)value, realm, hint);
            } else if (value instanceof String) {
                serializedValue = (String)this.serializeString(key, (String)value, realm, hint);
            } else if (value instanceof Dao) {
                serializedValue = (String)this.serializeDao((Dao)value);
            } else {
                this._logger.warn(this._logTag, "_processDao() - Unable to serialize DAO. Field: " + key + ". Value: " + value + ".");
            }
            if (serializedValue == null) continue;
            result.add(serializedValue);
        }
        return result;
    }

    @Override
    public Map<String, Object> serializeReport(Report report) {
        this._logger.error(this._logTag, "#serializeReport() - Pure virtual method. Must override.");
        return null;
    }

    abstract Object serializeDao(Dao var1);

    abstract Object serializeMap(Map<String, Object> var1);

    abstract Object serializeDouble(String var1, Double var2, String var3, Object var4);

    abstract Object serializeLong(String var1, Long var2, String var3, Object var4);

    abstract Object serializeInteger(String var1, Integer var2, String var3, Object var4);

    abstract Object serializeBooleanToLong(String var1, Boolean var2, String var3, Object var4);

    abstract Object serializeString(String var1, String var2, String var3, Object var4);
}

