/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.context;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.utils.MD5;
import com.adobe.primetime.va.ErrorInfo;
import com.adobe.primetime.va.plugins.ah.engine.context.InputDataValidator;
import com.adobe.primetime.va.plugins.ah.engine.context.ReportFactory;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.AAMDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.AdDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.AdobeAnalyticsDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.AssetDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.CUserDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.ChapterDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.EventDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.QoSDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.ServiceProviderDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.SessionDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.StreamDao;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.UserDao;
import com.adobe.primetime.va.plugins.ah.engine.model.report.Report;
import com.adobe.primetime.va.plugins.ah.engine.model.report.TrackItem;
import java.lang.constant.Constable;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private static final String ERROR_SOURCE_PLAYER = "sourceErrorSDK";
    private static final String CMD_ENABLE_REPORTING_TIMER = "clock:reporting.resume";
    private static final String CMD_DISABLE_REPORTING_TIMER = "clock:reporting.pause";
    private static final String REQ_REPORTING_INTERVAL = "reporting_interval";
    private static final String REQ_SESSION_ID = "session_id";
    private static final String RESET_SESSION_ID = "reset_session_id";
    private static final String KEY_CALLBACK = "callback";
    private static final String KEY_FILTER_REPORT = "filter_report";
    private static final String KEY_REPORT = "report";
    private static final String KEY_RESET = "reset";
    private static final String KEY_DO_NOT_OVERRIDE_INTERVAL = "do_not_override_interval";
    private static final String KEY_TRACK_EXTERNAL_ERRORS = "track_external_errors";
    private static final String KEY_REPORTING_INTERVAL = "reporting_interval";
    private static final String EVENT_API_AA_START = "api:aa_start";
    private static final String EVENT_API_AA_AD_START = "api:aa_ad_start";
    private static final String EVENT_API_VIDEO_LOAD = "api:video_load";
    private static final String EVENT_API_VIDEO_UNLOAD = "api:video_unload";
    private static final String EVENT_API_VIDEO_START = "api:video_start";
    private static final String EVENT_API_VIDEO_COMPLETE = "api:video_complete";
    private static final String EVENT_API_VIDEO_SKIP = "api:video_skip";
    private static final String EVENT_API_VIDEO_RESUME = "api:video_resume";
    private static final String EVENT_API_VIDEO_SESSION_END = "api:video_session_end";
    private static final String EVENT_API_AD_START = "api:ad_start";
    private static final String EVENT_API_AD_COMPLETE = "api:ad_complete";
    private static final String EVENT_API_AD_SKIP = "api:ad_skip";
    private static final String EVENT_API_ADBREAK_START = "api:adbreak_start";
    private static final String EVENT_API_ADBREAK_COMPLETE = "api:adbreak_complete";
    private static final String EVENT_API_PLAY = "api:play";
    private static final String EVENT_API_PAUSE = "api:pause";
    private static final String EVENT_API_BUFFER_START = "api:buffer_start";
    private static final String EVENT_API_CHAPTER_START = "api:chapter_start";
    private static final String EVENT_API_CHAPTER_COMPLETE = "api:chapter_complete";
    private static final String EVENT_API_CHAPTER_SKIP = "api:chapter_skip";
    private static final String EVENT_API_TRACK_ERROR = "api:track_error";
    private static final String EVENT_API_TRACK_INTERNAL_ERROR = "api:track_internal_error";
    private static final String EVENT_API_BITRATE_CHANGE = "api:bitrate_change";
    private static final String EVENT_API_QUANTUM_END = "api:quantum_end";
    private static final String EVENT_CONTEXT_REPORT_AVAILABLE = "context:report_available";
    private static final String EVENT_UPDATE_REPORTING_INTERVAL = "update_reporting_interval";
    private static final String EVENT_NET_CHECK_STATUS_COMPLETE = "net:check_status_complete";
    private static final double DEFAULT_REPORTING_INTERVAL = 10.0;
    private static final double TS_DELTA_LIMIT_FACTOR = 1.5;
    private static final double MAX_ACCEPTED_EVENT_DURATION = 600000.0;
    private static final double MAX_ACCEPTED_PLAY_DURATION_ERROR = 2000.0;
    private ILogger _logger;
    private String _logTag;
    private InputDataValidator _inputDataValidator;
    private TrackItem _lastInBandItem;
    private TrackItem _stashedlastInBandItem;
    private Object _stashedMainMetadata;
    private long _autoComputedStartupTime;
    private double _reportingInterval;
    private boolean _doNotOverrideEventDuration;
    private boolean _isDestroyed;
    private boolean _isTrackingSessionActive;
    private boolean _isVideoComplete;
    private boolean _isAnalyticsStarted;
    private ReportFactory _reportFactory;
    private boolean _trackExternalErrors;
    public Channel _channel;
    public AssetDao _assetData;
    public SessionDao _sessionData;
    public StreamDao _streamData;
    public QoSDao _qosData;
    public AdobeAnalyticsDao _adobeAnalyticsData;
    public AAMDao _aamData;
    public UserDao _userData;
    public CUserDao _cuserData;
    public ServiceProviderDao _serviceProviderData;
    private Context _context;
    private final ICallback _onApiAnalyticsStart = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiAnalyticsStart");
                if (!Context.this._checkCall("_onApiAnalyticsStart")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._userData.setVisitorId((String)info.get("vid"));
                Context.this._userData.setAnalyticsVisitorId((String)info.get("aid"));
                Context.this._userData.setMarketingCloudVisitorId((String)info.get("mid"));
                Context.this._aamData.setAudienceManagerBlob(info.get("blob") != null ? (String)info.get("blob") : "");
                Context.this._aamData.setAudienceManagerLocationHint(info.get("loc_hint") != null ? Long.valueOf(Long.parseLong((String)info.get("loc_hint"))) : null);
                Context.this._cuserData = new CUserDao();
                Context.this._cuserData.setDpid((String)info.get("dpid"));
                Context.this._cuserData.setDpuuid((String)info.get("dpuuid"));
                Context.this._updateQoSInfo(info);
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem aaStartItem = new TrackItem(Context.this._context, "aa_start", (Double)info.get("playhead"), null, callback);
                aaStartItem.getAssetDao().setAdData(null);
                aaStartItem.getAssetDao().setType("main");
                if (!Context.this._isAnalyticsStarted && aaStartItem.getAssetDao() != null) {
                    aaStartItem.getAssetDao().setChapterData(null);
                }
                Context.this._cuserData = null;
                Context.this._sendHit(aaStartItem);
                return null;
            }
        }
    };
    private final ICallback _onApiAnalyticsAdStart = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiAnalyticsAdStart");
                if (!Context.this._checkCall("_onApiAnalyticsAdStart")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._updateQoSInfo(info);
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem aaAdStartItem = new TrackItem(Context.this._context, "aa_ad_start", (Double)info.get("playhead"), null, callback);
                Context.this._sendHit(aaAdStartItem);
                return null;
            }
        }
    };
    private final ICallback _onApiVideoLoad = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Context.this._logger.debug(Context.this._logTag, "#_onApiVideoLoad()");
                Context.this._resetInternalState();
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                String[] keys = new String[]{"rsid", "trackingServer"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._sessionData.setSessionId(Context._generateSessionId());
                Context.this._isTrackingSessionActive = true;
                return null;
            }
        }
    };
    private final ICallback _onApiVideoUnload = new ICallback(){

        public Object call(Object param) {
            Context.this._logger.debug(Context.this._logTag, "#_onApiVideoUnload()");
            if (!Context.this._isTrackingSessionActive) {
                Context.this._logger.debug(Context.this._logTag, "#_onApiVideoUnload() > No active tracking session.");
                return null;
            }
            Context.this._isTrackingSessionActive = false;
            return null;
        }
    };
    private final ICallback _onApiVideoSessionEnd = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Context.this._logger.debug(Context.this._logTag, "#_onApiVideoSessionEnd");
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                if (!Context.this._checkCall("_onApiVideoSessionEnd")) {
                    return null;
                }
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem sessionEndItem = new TrackItem(Context.this._context, "end", (Double)info.get("playhead"), null, callback);
                AssetDao assetData = sessionEndItem.getAssetDao();
                assetData.setAdData(null);
                assetData.setType("main");
                Context.this._sendHit(sessionEndItem);
                return null;
            }
        }
    };
    private final ICallback _onApiVideoStart = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiVideoStart(id=" + info.get("videoId") + ", name=" + info.get("videoName") + ", length=" + info.get("videoLength") + ", type=" + info.get("streamType") + ", playerName=" + info.get("playerName") + ")");
                if (!Context.this._checkCall("_onApiVideoStart")) {
                    return null;
                }
                String[] keys = new String[]{"videoId", "streamType", "videoLength", "playhead", "playerName"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._lastInBandItem = null;
                Context.this._stashedlastInBandItem = null;
                Context.this._adobeAnalyticsData.setReportSuiteId((String)info.get("rsid"));
                Context.this._adobeAnalyticsData.setTrackingServer((String)info.get("trackingServer"));
                Context.this._adobeAnalyticsData.setSsl((Boolean)info.get("useSsl"));
                Context.this._serviceProviderData.setOvp((String)info.get("ovp"));
                Context.this._serviceProviderData.setSdk((String)info.get("sdk"));
                Context.this._serviceProviderData.setChannel((String)info.get("channel"));
                Context.this._serviceProviderData.setLibVersion((String)info.get("version"));
                Context.this._serviceProviderData.setApiLevel(((Integer)info.get("apiLvl")).longValue());
                Context.this._assetData.setAdData(null);
                Context.this._assetData.setChapterData(null);
                Context.this._serviceProviderData.setPlayerName((String)info.get("playerName"));
                Context.this._assetData.setVideoId((String)info.get("videoId"));
                Context.this._assetData.setDuration((Double)info.get("videoLength"));
                Context.this._assetData.setType("main");
                Context.this._assetData.setPublisher((String)info.get("publisher"));
                Context.this._assetData.setName((String)info.get("videoName"));
                Context.this._streamData.setType((String)info.get("streamType"));
                Context.this._updateQoSInfo(info);
                HashMap metadata = null;
                if (info.get("metaVideo") != null) {
                    HashMap metaVideoMap = (HashMap)info.get("metaVideo");
                    metadata = new HashMap(metaVideoMap);
                }
                if (info.get("metaNielsen") != null) {
                    HashMap metaNielsen = (HashMap)info.get("metaNielsen");
                    if (metadata != null) {
                        metadata.putAll(metaNielsen);
                    } else {
                        metadata = (HashMap)metaNielsen.clone();
                    }
                }
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem startItem = new TrackItem(Context.this._context, "start", (Double)info.get("playhead"), metadata, callback);
                Context.this._sendHit(startItem);
                return null;
            }
        }
    };
    private final ICallback _onApiVideoResume = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiVideoResume(id=" + info.get("videoId") + ", name=" + info.get("videoName") + ", length=" + info.get("videoLength") + ", type=" + info.get("streamType") + ", playerName=" + info.get("playerName") + ")");
                if (!Context.this._checkCall("_onApiVideoResume")) {
                    return null;
                }
                String[] keys = new String[]{"videoId", "streamType", "videoLength", "playhead", "playerName"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._assetData.setVideoId((String)info.get("videoId"));
                Context.this._assetData.setDuration((Double)info.get("videoLength"));
                Context.this._assetData.setType("main");
                Context.this._assetData.setName((String)info.get("videoName"));
                Context.this._streamData.setType((String)info.get("streamType"));
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem resumeItem = new TrackItem(Context.this._context, "resume", (Double)info.get("playhead"), null, callback);
                Context.this._sendHit(resumeItem);
                return null;
            }
        }
    };
    private final ICallback _onApiVideoComplete = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiVideoComplete()");
                if (!Context.this._checkCall("_onApiVideoComplete")) {
                    return null;
                }
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                double playhead = Context.this._assetData.getDuration();
                if (info.get("playhead") != null && (Double)info.get("playhead") > 0.0 && (Double)info.get("playhead") != playhead) {
                    Context.this._logger.debug(Context.this._logTag, "last playhead value " + (Double)info.get("playhead") + " and asset data length value " + playhead + " do not match. Setting the playhead value to " + (Double)info.get("playhead"));
                    playhead = (Double)info.get("playhead");
                }
                TrackItem completeItem = new TrackItem(Context.this._context, "complete", playhead, null, callback);
                Context.this._sendHit(completeItem);
                Context.this._isVideoComplete = true;
                return null;
            }
        }
    };
    private final ICallback _onApiVideoSkip = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiVideoSkip()");
                if (!Context.this._checkCall("_onApiVideoSkip")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem skipItem = new TrackItem(Context.this._context, "skip", (Double)info.get("playhead"), null, callback);
                Context.this._sendHit(skipItem);
                Context.this._isVideoComplete = true;
                return null;
            }
        }
    };
    private final ICallback _onApiPlay = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiPlay()");
                if (!Context.this._checkCall("_onApiPlay")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._updateQoSInfo(info);
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem playItem = new TrackItem(Context.this._context, "play", (Double)info.get("playhead"), null, callback);
                Context.this._sendHit(playItem);
                return null;
            }
        }
    };
    private final ICallback _onApiPause = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiPause()");
                if (!Context.this._checkCall("_onApiPause")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._updateQoSInfo(info);
                Boolean filterReport = null;
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                    filterReport = (Boolean)_eventData.get(Context.KEY_FILTER_REPORT);
                }
                String pauseType = info.containsKey("playheadStalled") && (Boolean)info.get("playheadStalled") != false ? "stall" : "pause";
                TrackItem pauseItem = new TrackItem(Context.this._context, pauseType, (Double)info.get("playhead"), null, callback);
                pauseItem.setFilterReport(filterReport);
                Context.this._sendHit(pauseItem);
                return null;
            }
        }
    };
    private final ICallback _onApiBufferStart = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiBufferStart()");
                if (!Context.this._checkCall("_onApiBufferStart")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._updateQoSInfo(info);
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem bufferStartItem = new TrackItem(Context.this._context, "buffer", (Double)info.get("playhead"), null, callback);
                Context.this._sendHit(bufferStartItem);
                return null;
            }
        }
    };
    private final ICallback _onApiAdBreakStart = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiAdBreakStart()");
                if (!Context.this._checkCall("_onApiAdBreakStart")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._flushLastInbandItem(info);
                Context.this._updateLastInbandItemToBuffering();
                return null;
            }
        }
    };
    private final ICallback _onApiAdBreakComplete = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Context.this._logger.debug(Context.this._logTag, "#__onApiAdBreakComplete()");
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                if (!Context.this._checkCall("_onApiAdBreakComplete")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._flushLastInbandItem(info);
                Context.this._restoreLastInbandItem();
            }
            return null;
        }
    };
    private final ICallback _onApiAdStart = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                boolean adGranularTracking;
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiAdStart(id=" + info.get("adId") + ", player_name=" + info.get("podPlayerName") + ", parent_name=" + Context.this._assetData.getVideoId() + ", pod_pos=" + info.get("adPosition") + ")");
                if (!Context.this._checkCall("_onApiAdStart")) {
                    return null;
                }
                String[] keys = new String[]{"playhead", "podPosition", "podPlayerName", "adId", "adPosition"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                AdDao adData = new AdDao();
                adData.setAdId((String)info.get("adId"));
                adData.setAdName((String)info.get("adName"));
                adData.setAdLength(((Double)info.get("adLength")).longValue());
                adData.setResolver((String)info.get("podPlayerName"));
                adData.setPodId(MD5.hash(Context.this._assetData.getVideoId()) + "_" + info.get("podPosition"));
                adData.setPodPosition(info.get("adPosition").toString());
                adData.setPodName(info.get("podName").toString());
                adData.setPodOffset(((Double)info.get("podSecond")).longValue());
                adData.setSid(Context._generateSessionId());
                Context.this._assetData.setAdData(adData);
                Context.this._assetData.setType("ad");
                Context.this._updateQoSInfo(info);
                HashMap metadata = null;
                if (info.get("metaVideo") != null) {
                    HashMap metaVideoMap = (HashMap)info.get("metaVideo");
                    metadata = new HashMap(metaVideoMap);
                }
                if (info.get("metaAd") != null) {
                    HashMap metaAdMap = (HashMap)info.get("metaAd");
                    if (metadata != null) {
                        metadata.putAll(metaAdMap);
                    } else {
                        metadata = new HashMap(metaAdMap);
                    }
                }
                if (info.get("metaNielsen") != null) {
                    HashMap metaNielsen = (HashMap)info.get("metaNielsen");
                    if (metadata != null) {
                        metadata.putAll(metaNielsen);
                    } else {
                        metadata = (HashMap)metaNielsen.clone();
                    }
                }
                if (info.get("adMetaNielsen") != null) {
                    HashMap adMetaNielsen = (HashMap)info.get("adMetaNielsen");
                    if (metadata != null) {
                        metadata.putAll(adMetaNielsen);
                    } else {
                        metadata = (HashMap)adMetaNielsen.clone();
                    }
                }
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem startItem = new TrackItem(Context.this._context, "start", (Double)info.get("playhead"), metadata, callback);
                Context.this._sendHit(startItem);
                Context.this._restoreLastInbandItem();
                boolean bl = adGranularTracking = info.get("adGranularTracking") != null ? (Boolean)info.get("adGranularTracking") : false;
                if (adGranularTracking) {
                    double adReportingInterval = info.get("adTrackingInterval") != null ? (double)((Double)info.get("adTrackingInterval")).longValue() : 10.0;
                    Context.this._updateReportingInterval(adReportingInterval, true);
                }
                return null;
            }
        }
    };
    private final ICallback _onApiAdComplete = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Context.this._logger.debug(Context.this._logTag, "#_onApiAdComplete()");
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                if (!Context.this._checkCall("_onApiAdComplete")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                if (Context.this._assetData.getType() != "ad") {
                    Context.this._logger.warn(Context.this._logTag, "#_onApiAdComplete() > Ignoring the ad complete event, because we are no longer in an ad.");
                    return null;
                }
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem completeItem = new TrackItem(Context.this._context, "complete", (Double)info.get("playhead"), null, callback);
                Context.this._sendHit(completeItem);
                Context.this._updateLastInbandItemToBuffering();
                Context.this._assetData.setAdData(null);
                Context.this._assetData.setType("main");
                Context.this._updateReportingInterval(Context.this._reportingInterval, false);
                return null;
            }
        }
    };
    private final ICallback _onApiAdSkip = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Context.this._logger.debug(Context.this._logTag, "#_onApiAdSkip()");
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                if (!Context.this._checkCall("_onApiAdSkip")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                if (Context.this._assetData.getType() != "ad") {
                    Context.this._logger.warn(Context.this._logTag, "#_onApiAdSkip() > Ignoring the ad skip event, because we are no longer in an ad.");
                    return null;
                }
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem skipItem = new TrackItem(Context.this._context, "skip", (Double)info.get("playhead"), null, callback);
                Context.this._sendHit(skipItem);
                Context.this._updateLastInbandItemToBuffering();
                Context.this._assetData.setAdData(null);
                Context.this._assetData.setType("main");
                Context.this._updateReportingInterval(Context.this._reportingInterval, false);
                return null;
            }
        }
    };
    private final ICallback _onApiChapterStart = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiChapterStart(name=" + info.get("chapterName") + ", length=" + info.get("chapterLength") + ", position=" + info.get("chapterPosition") + ", chapter_offset=" + info.get("chapterOffset") + ")");
                if (!Context.this._checkCall("_onApiChapterStart")) {
                    return null;
                }
                String[] keys = new String[]{"playhead", "chapterPosition", "chapterOffset", "chapterLength"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                ChapterDao chapterData = new ChapterDao();
                chapterData.setId(MD5.hash(Context.this._assetData.getVideoId()) + "_" + info.get("chapterPosition"));
                chapterData.setName((String)info.get("chapterName"));
                chapterData.setLength((Double)info.get("chapterLength"));
                chapterData.setPosition((Long)info.get("chapterPosition"));
                chapterData.setOffset((Double)info.get("chapterOffset"));
                chapterData.setSid(Context._generateSessionId());
                Context.this._assetData.setChapterData(chapterData);
                Context.this._updateQoSInfo(info);
                HashMap metadata = null;
                if (info.get("metaVideo") != null) {
                    HashMap metaVideoMap = (HashMap)info.get("metaVideo");
                    metadata = new HashMap(metaVideoMap);
                }
                if (info.get("metaChapter") != null) {
                    HashMap metaChapterMap = (HashMap)info.get("metaChapter");
                    if (metadata != null) {
                        metadata.putAll(metaChapterMap);
                    } else {
                        metadata = new HashMap(metaChapterMap);
                    }
                }
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem startChapterItem = new TrackItem(Context.this._context, "chapter_start", (Double)info.get("playhead"), metadata, callback);
                startChapterItem.getAssetDao().setAdData(null);
                startChapterItem.getAssetDao().setType("main");
                Context.this._sendHit(startChapterItem);
                return null;
            }
        }
    };
    private final ICallback _onApiChapterComplete = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiChapterComplete()");
                if (!Context.this._checkCall("_onApiChapterComplete")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                if (Context.this._assetData.getChapterData() == null) {
                    Context.this._logger.warn(Context.this._logTag, "#_onApiChapterComplete() > Ignoring the chapter complete event, because we are no longer in a chapter.");
                    return null;
                }
                Context.this._updateQoSInfo(info);
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem completeChapterItem = new TrackItem(Context.this._context, "chapter_complete", (Double)info.get("playhead"), null, callback);
                completeChapterItem.getAssetDao().setAdData(null);
                completeChapterItem.getAssetDao().setType("main");
                Context.this._sendHit(completeChapterItem);
                Context.this._assetData.setChapterData(null);
                return null;
            }
        }
    };
    private final ICallback _onApiChapterSkip = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiChapterSkip()");
                if (!Context.this._checkCall("_onApiChapterSkip")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                if (Context.this._assetData.getChapterData() == null) {
                    Context.this._logger.warn(Context.this._logTag, "#_onApiChapterSkip() > Ignoring the chapter skip event, because we are no longer in a chapter.");
                    return null;
                }
                Context.this._updateQoSInfo(info);
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem skipChapterItem = new TrackItem(Context.this._context, "chapter_skip", (Double)info.get("playhead"), null, callback);
                skipChapterItem.getAssetDao().setAdData(null);
                skipChapterItem.getAssetDao().setType("main");
                Context.this._sendHit(skipChapterItem);
                Context.this._assetData.setChapterData(null);
                return null;
            }
        }
    };
    private final ICallback _onApiBitrateChange = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiBitrateChange()");
                if (!Context.this._checkCall("_onApiBitrateChange")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                Context.this._updateQoSInfo(info);
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap _eventData = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                TrackItem bitrateChangeItem = new TrackItem(Context.this._context, "bitrate_change", (Double)info.get("playhead"), null, callback);
                Context.this._sendHit(bitrateChangeItem);
                return null;
            }
        }
    };
    private final ICallback _onApiTrackError = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                HashMap _eventData = null;
                ICallback callback = null;
                if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                    HashMap eventDataMap;
                    _eventData = eventDataMap = (HashMap)info.get("_eventData");
                    callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                }
                if (_eventData != null) {
                    Context.this._logger.debug(Context.this._logTag, "#_onApiTrackError(source=" + _eventData.get("source") + ", err_id=" + _eventData.get("error_id") + ")");
                }
                if (!Context.this._isTrackingSessionActive) {
                    Context.this._logger.warn(Context.this._logTag, "#_onApiTrackError() > No active tracking session.");
                    return null;
                }
                if (!Context.this._trackExternalErrors && !_eventData.get("source").equals(Context.ERROR_SOURCE_PLAYER)) {
                    return null;
                }
                Context.this._updateQoSInfo(info);
                TrackItem errorItem = new TrackItem(Context.this._context, "error", 0.0, null, callback);
                errorItem.getEventDao().setId((String)_eventData.get("error_id"));
                errorItem.getEventDao().setSource((String)_eventData.get("source"));
                Context.this._sendHit(errorItem);
                return null;
            }
        }
    };
    private final ICallback _onApiTrackInternalError = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiTrackInternalError(source=" + info.get("source") + ", err_id=" + info.get("error_id") + ")");
                Context.this._updateQoSInfo(info);
                TrackItem errorItem = new TrackItem(Context.this._context, "error", 0.0, null, null);
                errorItem.getEventDao().setId((String)info.get("error_id"));
                errorItem.getEventDao().setSource((String)info.get("source"));
                Context.this._sendHit(errorItem);
                return null;
            }
        }
    };
    private final ICallback _onApiQuantumEnd = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._logger.debug(Context.this._logTag, "#_onApiQuantumEnd(interval=" + Context.this._channel.request("reporting_interval") + ")");
                if (!Context.this._checkCall("_onApiQuantumEnd")) {
                    return null;
                }
                String[] keys = new String[]{"playhead"};
                if (!Context.this._inputDataValidator.validateFields(info, keys)) {
                    return null;
                }
                TrackItem lastInBandItem = Context.this._lastInBandItem;
                if (lastInBandItem != null) {
                    Context.this._updateQoSInfo(info);
                    ICallback callback = null;
                    if (info.get("_eventData") != null && info.get("_eventData") instanceof HashMap) {
                        HashMap _eventData = (HashMap)info.get("_eventData");
                        callback = (ICallback)_eventData.get(Context.KEY_CALLBACK);
                    }
                    TrackItem item = new TrackItem(Context.this._context, lastInBandItem.getEventDao().getType(), (Double)info.get("playhead"), lastInBandItem.getMeta(), callback);
                    Context.this._sendHit(item, true);
                }
                return null;
            }
        }
    };
    private final ICallback _onNetworkCheckStatusComplete = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Event e = (Event)param;
                HashMap info = (HashMap)e.getData();
                Context.this._trackExternalErrors = (Boolean)info.get(Context.KEY_TRACK_EXTERNAL_ERRORS);
                Context.this._logger.debug(Context.this._logTag, "#_onNetworkCheckStatusComplete(track_ext_err=" + Context.this._trackExternalErrors + ")");
                return null;
            }
        }
    };
    private final ICallback _onResetSessionId = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Context context = Context.this._context;
            synchronized (context) {
                Context.this._sessionData = new SessionDao();
                Context.this._sessionData.setSessionId(Context._generateSessionId());
                return null;
            }
        }
    };

    public Context(Channel channel, ILogger logger) {
        if (channel == null) {
            throw new Error("Reference to the channel object cannot be NULL.");
        }
        this._channel = channel;
        if (logger == null) {
            throw new Error("Reference to the logger object cannot be NULL.");
        }
        this._logTag = Context.class.getSimpleName();
        this._logger = logger;
        this._lastInBandItem = null;
        this._stashedlastInBandItem = null;
        this._stashedMainMetadata = null;
        this._autoComputedStartupTime = 0L;
        this._reportingInterval = 10.0;
        this._assetData = null;
        this._streamData = null;
        this._qosData = null;
        this._sessionData = null;
        this._cuserData = null;
        this._adobeAnalyticsData = new AdobeAnalyticsDao();
        this._serviceProviderData = new ServiceProviderDao();
        this._userData = new UserDao();
        this._aamData = new AAMDao();
        this._doNotOverrideEventDuration = false;
        this._isDestroyed = false;
        this._isTrackingSessionActive = false;
        this._isVideoComplete = false;
        this._isAnalyticsStarted = false;
        this._reportFactory = new ReportFactory(this, this._logger);
        this._inputDataValidator = new InputDataValidator(new ICallback(){

            public Object call(Object param) {
                ErrorInfo errorInfo = (ErrorInfo)param;
                Context.this._logger.error(Context.this._logTag, errorInfo.getMessage() + " | " + errorInfo.getDetails());
                Context.this._channel.trigger(new Event("error", errorInfo));
                return null;
            }
        });
        this._trackExternalErrors = true;
        this._context = this;
        this._installEventListeners();
    }

    public void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._isDestroyed = true;
        this._logger.debug(this._logTag, "#destroy()");
        this._uninstallEventListeners();
    }

    private void _installEventListeners() {
        this._channel.on(EVENT_API_AA_START, this._onApiAnalyticsStart, this);
        this._channel.on(EVENT_API_AA_AD_START, this._onApiAnalyticsAdStart, this);
        this._channel.on(EVENT_API_VIDEO_LOAD, this._onApiVideoLoad, this);
        this._channel.on(EVENT_API_VIDEO_UNLOAD, this._onApiVideoUnload, this);
        this._channel.on(EVENT_API_VIDEO_START, this._onApiVideoStart, this);
        this._channel.on(EVENT_API_VIDEO_COMPLETE, this._onApiVideoComplete, this);
        this._channel.on(EVENT_API_VIDEO_SKIP, this._onApiVideoSkip, this);
        this._channel.on(EVENT_API_VIDEO_RESUME, this._onApiVideoResume, this);
        this._channel.on(EVENT_API_VIDEO_SESSION_END, this._onApiVideoSessionEnd, this);
        this._channel.on(EVENT_API_AD_START, this._onApiAdStart, this);
        this._channel.on(EVENT_API_AD_COMPLETE, this._onApiAdComplete, this);
        this._channel.on(EVENT_API_AD_SKIP, this._onApiAdSkip, this);
        this._channel.on(EVENT_API_ADBREAK_START, this._onApiAdBreakStart, this);
        this._channel.on(EVENT_API_ADBREAK_COMPLETE, this._onApiAdBreakComplete, this);
        this._channel.on(EVENT_API_PLAY, this._onApiPlay, this);
        this._channel.on(EVENT_API_PAUSE, this._onApiPause, this);
        this._channel.on(EVENT_API_BUFFER_START, this._onApiBufferStart, this);
        this._channel.on(EVENT_API_CHAPTER_START, this._onApiChapterStart, this);
        this._channel.on(EVENT_API_CHAPTER_COMPLETE, this._onApiChapterComplete, this);
        this._channel.on(EVENT_API_CHAPTER_SKIP, this._onApiChapterSkip, this);
        this._channel.on(EVENT_API_BITRATE_CHANGE, this._onApiBitrateChange, this);
        this._channel.on(EVENT_API_TRACK_ERROR, this._onApiTrackError, this);
        this._channel.on(EVENT_API_TRACK_INTERNAL_ERROR, this._onApiTrackInternalError, this);
        this._channel.on(EVENT_API_QUANTUM_END, this._onApiQuantumEnd, this);
        this._channel.on(EVENT_NET_CHECK_STATUS_COMPLETE, this._onNetworkCheckStatusComplete, this);
        this._channel.reply(REQ_SESSION_ID, new ICallback(){

            public Object call(Object param) {
                return Context.this._sessionData != null && Context.this._sessionData.getSessionId() != null ? Context.this._sessionData.getSessionId() : null;
            }
        });
        this._channel.on(RESET_SESSION_ID, this._onResetSessionId, this);
    }

    private void _uninstallEventListeners() {
        this._channel.off(null, null, this);
    }

    private void _resetInternalState() {
        this._logger.debug(this._logTag, "#_resetInternalState()");
        this._isTrackingSessionActive = false;
        this._isVideoComplete = false;
        this._autoComputedStartupTime = 0L;
        this._reportingInterval = 10.0;
        this._lastInBandItem = null;
        this._streamData = new StreamDao();
        this._qosData = new QoSDao();
        this._sessionData = new SessionDao();
        this._assetData = new AssetDao();
        this._cuserData = null;
    }

    private static String _generateSessionId() {
        SecureRandom r = new SecureRandom();
        return "" + new Date().getTime() + r.nextInt(1000000000);
    }

    private void _updateQoSInfo(Map<String, Object> info) {
        this._qosData.setBitrate((Long)(info.get("bitrate") != null ? info.get("bitrate") : Long.valueOf(0L)));
        this._qosData.setFps((Double)(info.get("fps") != null ? info.get("fps") : Double.valueOf(0.0)));
        this._qosData.setDroppedFrames((Long)(info.get("droppedFrames") != null ? info.get("droppedFrames") : Long.valueOf(0L)));
        if (info.get("startupTime") != null) {
            this._qosData.setStartupTime(((Double)info.get("startupTime")).longValue());
            this._qosData.isStartupTimeOverridden = true;
        } else {
            this._qosData.setStartupTime(this._autoComputedStartupTime);
            this._qosData.isStartupTimeOverridden = false;
        }
    }

    private boolean _checkCall(String methodName) {
        if (!this._isTrackingSessionActive) {
            this._logger.warn(this._logTag, "#" + methodName + "() > No active tracking session.");
            return false;
        }
        if (this._isVideoComplete && methodName != "_onApiVideoSessionEnd") {
            this._logger.warn(this._logTag, "#" + methodName + "() > The video content already completed.");
            return false;
        }
        return true;
    }

    private void _updateReportingInterval(double newInterval, boolean doNotOverride) {
        HashMap<String, Constable> data = new HashMap<String, Constable>();
        data.put("reporting_interval", Double.valueOf(newInterval));
        data.put(KEY_DO_NOT_OVERRIDE_INTERVAL, Boolean.valueOf(doNotOverride));
        this._channel.trigger(new Event(EVENT_UPDATE_REPORTING_INTERVAL, data));
    }

    private void _updateLastInBandItem(TrackItem currentInBandItem) {
        TrackItem lastInBandItem = this._lastInBandItem;
        long now = new Date().getTime();
        boolean inAd = lastInBandItem.getAssetDao().getType() == "ad" || currentInBandItem.getAssetDao().getType() == "ad";
        double playheadDelta = Math.abs(currentInBandItem.getEventDao().getPlayhead() - lastInBandItem.getEventDao().getPlayhead()) * 1000.0;
        long tsDelta = Math.abs(now - lastInBandItem.getEventDao().getTs());
        long errorDelta = Math.abs((long)playheadDelta - tsDelta);
        long eventDuration = tsDelta;
        if ((double)eventDuration > 600000.0) {
            this._logger.warn(this._logTag, " Resetting duration in lastInBandItem[" + lastInBandItem.getAssetDao().getType() + ":" + lastInBandItem.getEventDao().getType() + "] call to 0 as calculated duration (" + eventDuration + ")exceeds maximum accepted duration");
            eventDuration = 0L;
        } else if (lastInBandItem.getEventDao().getType() == "play" && !inAd && !this._doNotOverrideEventDuration && (double)errorDelta > 2000.0) {
            this._logger.warn(this._logTag, "Difference between Playhead delta and computed TS delta in lastInBandItem[" + lastInBandItem.getAssetDao().getType() + ":" + currentInBandItem.getEventDao().getType() + "] is " + errorDelta + "ms and differs by more than" + 2000.0 + "ms duration");
            eventDuration = Math.min((long)playheadDelta, tsDelta);
        }
        this._doNotOverrideEventDuration = false;
        lastInBandItem.getEventDao().setDuration(eventDuration);
        lastInBandItem.getEventDao().setTs(now);
        lastInBandItem.getEventDao().setPlayhead(currentInBandItem.getEventDao().getPlayhead());
        lastInBandItem.getQoSDao().setStartupTime(currentInBandItem.getQoSDao().getStartupTime());
        lastInBandItem.getQoSDao().isStartupTimeOverridden = currentInBandItem.getQoSDao().isStartupTimeOverridden;
    }

    private void _updateLastInbandItemToBuffering() {
        this._stashedlastInBandItem = this._lastInBandItem;
        double playhead = 0.0;
        ICallback callback = null;
        if (this._lastInBandItem != null) {
            if (this._lastInBandItem.getAssetDao().getType() == "main" && this._lastInBandItem.getEventDao().getType() == "start") {
                this._stashedMainMetadata = this._lastInBandItem.getMeta();
            }
            playhead = this._lastInBandItem.getEventDao().getPlayhead();
            callback = this._lastInBandItem.getCallback();
        }
        TrackItem item = new TrackItem(this._context, "buffer", playhead, null, callback);
        item.getAssetDao().setAdData(null);
        item.getAssetDao().setType("main");
        this._lastInBandItem = item;
    }

    private void _restoreLastInbandItem() {
        if (this._stashedlastInBandItem != null) {
            TrackItem item;
            Object meta = null;
            if (this._stashedlastInBandItem.getEventDao().getType() == "start") {
                if (this._lastInBandItem.getAssetDao().getType() == "ad") {
                    meta = this._lastInBandItem.getMeta();
                } else {
                    meta = this._stashedMainMetadata;
                    this._stashedMainMetadata = null;
                }
            }
            this._lastInBandItem = item = new TrackItem(this._context, this._stashedlastInBandItem.getEventDao().getType(), this._stashedlastInBandItem.getEventDao().getPlayhead(), meta, this._stashedlastInBandItem.getCallback());
            this._stashedlastInBandItem = null;
        }
    }

    private void _flushLastInbandItem(Map<String, Object> info) {
        if (this._lastInBandItem != null) {
            this._updateQoSInfo(info);
            TrackItem item = new TrackItem(this._context, this._lastInBandItem.getEventDao().getType(), (Double)info.get("playhead"), this._lastInBandItem.getMeta(), this._lastInBandItem.getCallback());
            this._sendHit(item, true);
        }
    }

    private void _sendHit(TrackItem item) {
        this._sendHit(item, false);
    }

    private void _sendHit(TrackItem item, boolean quantumEnd) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        EventDao.TYPE type = EventDao.TYPE.valueOf(item.getEventDao().getType());
        switch (type) {
            case start: 
            case play: 
            case pause: 
            case stall: 
            case buffer: {
                if (this._lastInBandItem != null) {
                    this._updateLastInBandItem(item);
                    if (this._lastInBandItem.getEventDao().getType() == "start" && this._lastInBandItem.getAssetDao().getType() == "main") {
                        this._autoComputedStartupTime += this._lastInBandItem.getEventDao().getDuration();
                    }
                    this._createAndSendReport(this._lastInBandItem);
                    if (!quantumEnd || this._lastInBandItem.getEventDao().getType() != item.getEventDao().getType()) {
                        this._createAndSendReport(item);
                    }
                } else {
                    this._createAndSendReport(item);
                }
                this._lastInBandItem = item;
                break;
            }
            case complete: 
            case skip: {
                if (this._lastInBandItem != null) {
                    this._updateLastInBandItem(item);
                    this._createAndSendReport(this._lastInBandItem);
                }
                if (type != EventDao.TYPE.skip) {
                    this._createAndSendReport(item);
                }
                if (item.getAssetDao().getType() == "main") {
                    this._lastInBandItem = null;
                    this._stashedlastInBandItem = null;
                    params.clear();
                    params.put(KEY_RESET, true);
                    this._channel.command(CMD_DISABLE_REPORTING_TIMER, params);
                    break;
                }
                if (item.getAssetDao().getType() != "ad") break;
                this._lastInBandItem.getAssetDao().setAdData(null);
                this._lastInBandItem.getAssetDao().setType("main");
                this._doNotOverrideEventDuration = true;
                break;
            }
            case chapter_start: 
            case chapter_complete: 
            case chapter_skip: {
                if (this._lastInBandItem != null) {
                    this._updateLastInBandItem(item);
                    this._createAndSendReport(this._lastInBandItem);
                }
                if (type != EventDao.TYPE.chapter_skip) {
                    this._createAndSendReport(item);
                }
                if (this._lastInBandItem == null) break;
                this._lastInBandItem.getAssetDao().setChapterData(item.getEventDao().getType() == "chapter_start" ? new ChapterDao(item.getAssetDao().getChapterData()) : null);
                this._lastInBandItem.getEventDao().setDuration(0L);
                this._createAndSendReport(this._lastInBandItem);
                break;
            }
            default: {
                this._createAndSendReport(item);
            }
        }
    }

    private void _createAndSendReport(TrackItem item) {
        Report report = this._reportFactory.createReportForItem(item);
        if (!report.getQosData().isStartupTimeOverridden) {
            report.getQosData().setStartupTime(this._autoComputedStartupTime);
        }
        HashMap<String, Report> eventData = new HashMap<String, Report>();
        eventData.put(KEY_REPORT, report);
        this._channel.trigger(new Event(EVENT_CONTEXT_REPORT_AVAILABLE, eventData));
        if (report.getEventData().getType() == "start" || report.getEventData().getType() == "play" || report.getEventData().getType() == "pause" || report.getEventData().getType() == "stall" || report.getEventData().getType() == "buffer") {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put(KEY_RESET, true);
            this._channel.command(CMD_ENABLE_REPORTING_TIMER, params);
        }
        if (item.getEventDao().getType().equalsIgnoreCase(EVENT_API_AA_START)) {
            this._isAnalyticsStarted = true;
        }
    }
}

