/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.aa;

import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.va.ErrorInfo;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputDataValidator {
    private ICallback _onFail;

    public InputDataValidator(ICallback onFail) {
        this._onFail = onFail;
    }

    public boolean validateFields(HashMap<String, Object> data, String[] params) {
        if (data == null) {
            return this._fail("Data cannot be null");
        }
        block12: for (String param : params) {
            Params paramTypes = Params.valueOf(param);
            switch (paramTypes) {
                case videoId: {
                    if (!data.containsKey("videoId")) {
                        return this._fail("The ID for the main video must be specified.");
                    }
                    if (data.get("videoId") == null || !(data.get("videoId") instanceof String)) {
                        return this._fail("The ID for the main video must be a String.");
                    }
                    if (!((String)data.get("videoId")).equals("")) continue block12;
                    return this._fail("The ID for the main video cannot be an empty string.");
                }
                case playerName: {
                    if (!data.containsKey("playerName")) {
                        return this._fail("The player name for the main video must be specified.");
                    }
                    if (data.get("playerName") == null || !(data.get("playerName") instanceof String)) {
                        return this._fail("The player name for the main video must be a String.");
                    }
                    if (!((String)data.get("playerName")).equals("")) continue block12;
                    return this._fail("The player name for the main video cannot be an empty string.");
                }
                case videoLength: {
                    if (!data.containsKey("videoLength")) {
                        return this._fail("The length of the main video must be specified.");
                    }
                    if (data.get("videoLength") != null && data.get("videoLength") instanceof Number) continue block12;
                    return this._fail("The length of the main video must be a Number.");
                }
                case streamType: {
                    if (!data.containsKey("streamType")) {
                        return this._fail("The stream type for the main video must be specified.");
                    }
                    if (data.get("streamType") == null || !(data.get("streamType") instanceof String)) {
                        return this._fail("The stream type for the main video must be a String.");
                    }
                    if (!((String)data.get("streamType")).equals("")) continue block12;
                    return this._fail("The stream type for the main video cannot be an empty string.");
                }
                case podPlayerName: {
                    if (!data.containsKey("podPlayerName")) {
                        return this._fail("The player name for the ad-break must be specified.");
                    }
                    if (data.get("podPlayerName") == null || !(data.get("podPlayerName") instanceof String)) {
                        return this._fail("The player name for the ad-break must be a String.");
                    }
                    if (!((String)data.get("podPlayerName")).equals("")) continue block12;
                    return this._fail("The player name for the ad-break cannot be an empty string.");
                }
                case podPosition: {
                    if (!data.containsKey("podPosition")) {
                        return this._fail("Position (index) of the ad-break must be specified.");
                    }
                    if (data.get("podPosition") != null && data.get("podPosition") instanceof Number) continue block12;
                    return this._fail("Position (index) of the ad-break must be a Number.");
                }
                case adId: {
                    if (!data.containsKey("adId")) {
                        return this._fail("The ad ID must be specified.");
                    }
                    if (data.get("adId") == null || !(data.get("adId") instanceof String)) {
                        return this._fail("The ad ID must be a String.");
                    }
                    if (!((String)data.get("adId")).equals("")) continue block12;
                    return this._fail("The ad ID cannot be an empty string.");
                }
                case adLength: {
                    if (!data.containsKey("adLength")) {
                        return this._fail("The length of the ad must be specified.");
                    }
                    if (data.get("adLength") != null && data.get("adLength") instanceof Number) continue block12;
                    return this._fail("The length of the ad must be a Number.");
                }
                case adPosition: {
                    if (!data.containsKey("adPosition")) {
                        return this._fail("Position (index) of the ad must be specified.");
                    }
                    if (data.get("adPosition") != null && data.get("adPosition") instanceof Number) continue block12;
                    return this._fail("Position (index) of the ad must be a Number.");
                }
                case mediaType: {
                    if (!data.containsKey("mediaType")) {
                        return this._fail("Media type must be specified.");
                    }
                    if (data.get("mediaType") == null || !(data.get("mediaType") instanceof String)) {
                        return this._fail("Media type must be a String.");
                    }
                    if (!((String)data.get("mediaType")).equals("")) continue block12;
                    return this._fail("Media type cannot be an empty string.");
                }
                default: {
                    return this._fail("Unable to validate unknown parameter: " + param);
                }
            }
        }
        return true;
    }

    private boolean _fail(String errorString) {
        ErrorInfo errorInfo = new ErrorInfo("Invalid input data", errorString);
        if (this._onFail != null) {
            this._onFail.call(errorInfo);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Params {
        videoId,
        playerName,
        videoLength,
        streamType,
        podPlayerName,
        podPosition,
        adId,
        adLength,
        adPosition,
        mediaType;

    }
}

