/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va;

import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.Logger;
import com.adobe.primetime.core.plugin.IPlugin;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.va.HeartbeatConfig;
import com.adobe.primetime.va.HeartbeatDelegate;
import com.adobe.primetime.va.service.clock.ClockService;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Heartbeat {
    private static final String ADOBE_HEARTBEAT_PLUGIN = "adobe-heartbeat";
    private static final String ADOBE_ANALYTICS_PLUGIN = "adobe-analytics";
    private static final String PLAYER_PLUGIN = "player";
    private String _logTag = Heartbeat.class.getSimpleName();
    private ILogger _logger = new Logger();
    private PluginManager _pluginManager = new PluginManager(this._logger);
    private boolean _isDestroyed;

    public Heartbeat(HeartbeatDelegate delegate) {
        this(delegate, null);
    }

    public Heartbeat(HeartbeatDelegate delegate, List<IPlugin> plugins) {
        this._pluginManager.addPlugin(new ClockService(this._logger));
        if (plugins != null) {
            Collections.sort(plugins, new Comparator<IPlugin>(){

                @Override
                public int compare(IPlugin lhs, IPlugin rhs) {
                    if (lhs.getName().equals(Heartbeat.ADOBE_HEARTBEAT_PLUGIN) && rhs.getName().equals(Heartbeat.ADOBE_ANALYTICS_PLUGIN)) {
                        return -1;
                    }
                    if (lhs.getName().equals(Heartbeat.ADOBE_HEARTBEAT_PLUGIN) && rhs.getName().equals(Heartbeat.PLAYER_PLUGIN)) {
                        return -1;
                    }
                    if (lhs.getName().equals(Heartbeat.ADOBE_ANALYTICS_PLUGIN) && rhs.getName().equals(Heartbeat.ADOBE_HEARTBEAT_PLUGIN)) {
                        return 1;
                    }
                    if (lhs.getName().equals(Heartbeat.ADOBE_ANALYTICS_PLUGIN) && rhs.getName().equals(Heartbeat.PLAYER_PLUGIN)) {
                        return -1;
                    }
                    if (lhs.getName().equals(Heartbeat.PLAYER_PLUGIN) && rhs.getName().equals(Heartbeat.ADOBE_HEARTBEAT_PLUGIN)) {
                        return 1;
                    }
                    if (lhs.getName().equals(Heartbeat.PLAYER_PLUGIN) && rhs.getName().equals(Heartbeat.ADOBE_ANALYTICS_PLUGIN)) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (IPlugin plugin : plugins) {
                this._pluginManager.addPlugin(plugin);
            }
        }
        this._pluginManager.setupPlugins();
        this._isDestroyed = false;
    }

    public synchronized void configure(HeartbeatConfig configData) {
        if (configData == null) {
            throw new Error("Configuration object cannot be NULL.");
        }
        if (configData.debugLogging) {
            this._logger.enable();
        } else {
            this._logger.disable();
        }
        if (this._isDestroyed) {
            this._logger.error(this._logTag, "Instance is destroyed.");
        }
    }

    public synchronized void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._pluginManager.destroy();
        this._isDestroyed = true;
    }
}

