/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.elements;

import com.akamai.amp.media.elements.DRMKey;
import com.akamai.amp.media.exowrapper2.drm.DrmScheme;
import com.akamai.amp.utils.LogManager;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class MediaResource {
    public static final String VIDEO_CONTENT_VOD = "VOD";
    public static final String VIDEO_CONTENT_LIVE = "LIVE";
    private String url;
    private String redirectedUrl;
    private String mimeType;
    private String description;
    private int duration = -1;
    private String guid;
    private int height;
    private int width;
    private String videoContentType;
    private String poster;
    private String title;
    private String temporalType;
    private String category;
    private JSONObject metadata;
    private boolean multipleTracksAvailable;
    private List<DRMKey> drmKeys;
    private DrmScheme selectedScheme;
    private String rating;
    private List<String> genres;
    private String channel;
    private List<String> categories;
    private String extension;

    public MediaResource() {
    }

    public MediaResource(String url, String mimeType) {
        this.url = url;
        this.mimeType = mimeType;
        LogManager.log("MediaResource", "MediaResource [ URL: " + url + " MimeType: " + mimeType + "]");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getVideoContentType() {
        return this.videoContentType;
    }

    public void setVideoContentType(String videoContentType) {
        this.videoContentType = videoContentType;
    }

    public String getPoster() {
        return this.poster;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JSONObject getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JSONObject metadata) {
        this.metadata = metadata;
    }

    public String getTemporalType() {
        return this.temporalType;
    }

    public void setTemporalType(String temporalType) {
        this.temporalType = temporalType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public void setRedirectedUrl(String redirectedUrl) {
        this.redirectedUrl = redirectedUrl;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getUrlWithoutQueryString() {
        String resUrl = this.getResourceUrl();
        int iPos = resUrl.indexOf("?");
        if (iPos > 0) {
            return resUrl.substring(0, iPos);
        }
        return resUrl;
    }

    public String getResourceUrl() {
        if (this.redirectedUrl != null && this.redirectedUrl.length() > 0) {
            return this.redirectedUrl;
        }
        return this.url;
    }

    public void setResourceURL(String url) {
        this.url = url;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            return "";
        }
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setDRMKey(DRMKey drmKey) {
        if (this.drmKeys == null) {
            this.drmKeys = new ArrayList<DRMKey>();
        }
        this.drmKeys.add(drmKey);
    }

    public DRMKey getDRMKey(DrmScheme selectedScheme) {
        if (this.drmKeys != null && this.drmKeys.size() != 0) {
            for (DRMKey drmKey : this.drmKeys) {
                if (drmKey.getDRMScheme() != selectedScheme) continue;
                return drmKey;
            }
        }
        return null;
    }

    public void setDRMKeys(List<DRMKey> drmKeys) {
        this.drmKeys = new ArrayList<DRMKey>(drmKeys);
    }

    public DrmScheme getSelectedScheme() {
        return this.selectedScheme;
    }

    public void setSelectedScheme(DrmScheme selectedScheme) {
        this.selectedScheme = selectedScheme;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public void setGenres(List<String> genres) {
        this.genres = genres;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public String getRating() {
        return this.rating;
    }

    public List<String> getGenres() {
        return this.genres;
    }

    public String getChannel() {
        return this.channel;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public boolean isDurationSet() {
        return this.duration != -1;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isMultipleTracksAvailable() {
        return this.multipleTracksAvailable;
    }

    public void setMultipleTracksAvailable(boolean multipleTracksAvailable) {
        this.multipleTracksAvailable = multipleTracksAvailable;
    }
}

