/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.config.data;

import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.util.Helper;
import com.akamai.amp.utils.util.Predicate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class GenericData {
    private static final String LOG_TAG = GenericData.class.getSimpleName();
    protected static final boolean MANDATORY = true;
    protected static final boolean OPTIONAL = false;
    protected Map<String, Boolean> METADATA = this.initMetadata();
    protected final Set<String> MANDATORY_METADATA = Helper.filter(this.getAllMetadata(), this.isMandatory());
    protected Map<String, String> values = new LinkedHashMap<String, String>();

    public abstract Map<String, Boolean> initMetadata();

    public Predicate<String> isMandatory() {
        return new Predicate<String>(){

            @Override
            public boolean apply(String key) {
                if (GenericData.this.METADATA.containsKey(key)) {
                    return GenericData.this.METADATA.get(key);
                }
                return false;
            }
        };
    }

    public Set<String> getAllMetadata() {
        return this.METADATA.keySet();
    }

    public Set<String> getMandatoryMetadata() {
        return this.MANDATORY_METADATA;
    }

    public void put(String key, String value) {
        this.putValue(key, value);
    }

    public void addValue(String tag, String value) {
        this.put(tag, value);
    }

    public void putValue(String key, String value) {
        boolean officialKey = this.getAllMetadata().contains(key);
        if (!officialKey) {
            LogManager.error(LOG_TAG, "Non-official key used for Analytics Metadata: " + key + ", with value: " + value);
        }
        this.values.put(key, value);
    }

    public void addValues(Map<String, String> param) {
        for (String key : param.keySet()) {
            this.putValue(key, param.get(key));
        }
    }

    public String getValue(String key) {
        return this.values.get(key);
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public String toString() {
        return LOG_TAG + " " + this.values;
    }
}

