/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.bidder.aps;

import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApsContentInfo {
    private static final String TAG = ApsContentInfo.class.getSimpleName();
    private final String id;
    private final String rating;
    private final List<String> genres;
    private final String channel;
    private final long lengthInSeconds;
    private final String toStringCache;

    public ApsContentInfo(String id, String rating, List<String> genres, String channel, long lengthInSeconds) {
        this.id = id;
        this.rating = (String)Utils.requireNonNull((Object)rating);
        this.genres = (List)Utils.requireNonEmpty(genres);
        this.channel = channel;
        this.lengthInSeconds = lengthInSeconds;
        this.toStringCache = this.toJson();
        LogManager.log((String)TAG, (String)this.toStringCache);
    }

    private String toJson() {
        try {
            JSONObject internal = this.buildInternalJsonObject();
            JSONObject content = new JSONObject();
            content.put("content", (Object)internal);
            String result = content.toString();
            return result;
        }
        catch (JSONException e) {
            LogManager.error((String)TAG, (String)("toJson() Exception: " + (Object)((Object)e)));
            return "";
        }
    }

    private JSONObject buildInternalJsonObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)this.id);
        jsonObject.put("rating", (Object)this.rating);
        this.maybeAddGenre(jsonObject);
        jsonObject.put("channel", (Object)this.channel);
        jsonObject.put("length", (Object)this.getLength());
        return jsonObject;
    }

    private String getLength() {
        if (this.lengthInSeconds > 0L) {
            String length = String.valueOf(this.lengthInSeconds);
            return length;
        }
        return "";
    }

    private void maybeAddGenre(JSONObject jsonObject) throws JSONException {
        if (this.genres == null || this.genres.isEmpty()) {
            return;
        }
        JSONArray genresJsonArray = new JSONArray(this.genres);
        jsonObject.put("genre", (Object)genresJsonArray);
    }

    public String toString() {
        return this.toStringCache;
    }
}

