/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.truex;

import android.content.Context;
import android.util.Log;
import android.view.ViewGroup;
import com.akamai.amp.ads.truex.PlaybackHandler;
import com.akamai.amp.ads.truex.TruexEventListener;
import com.truex.adrenderer.TruexAdEvent;
import com.truex.adrenderer.TruexAdOptions;
import com.truex.adrenderer.TruexAdRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TruexAdManager {
    private static final String CLASSTAG = TruexAdManager.class.getSimpleName();
    private PlaybackHandler playbackHandler;
    private boolean didReceiveCredit;
    private TruexAdRenderer truexAdRenderer;
    private ViewGroup viewGroup;
    private static final boolean showAdImmediately = true;
    private static final boolean showAdAfterLoad = false;
    private final List<TruexEventListener> listeners;

    public TruexAdManager(Context context, PlaybackHandler playbackHandler, List<TruexEventListener> listeners) {
        this.playbackHandler = playbackHandler;
        this.didReceiveCredit = false;
        this.truexAdRenderer = new TruexAdRenderer(context);
        this.truexAdRenderer.addEventListener(TruexAdEvent.AD_FETCH_COMPLETED, this::adFetchCompleted);
        this.truexAdRenderer.addEventListener(TruexAdEvent.AD_STARTED, this::adStarted);
        this.truexAdRenderer.addEventListener(TruexAdEvent.AD_DISPLAYED, this::adDisplayed);
        this.truexAdRenderer.addEventListener(TruexAdEvent.AD_COMPLETED, this::adCompleted);
        this.truexAdRenderer.addEventListener(TruexAdEvent.AD_ERROR, this::adError);
        this.truexAdRenderer.addEventListener(TruexAdEvent.NO_ADS_AVAILABLE, this::noAds);
        this.truexAdRenderer.addEventListener(TruexAdEvent.AD_FREE_POD, this::adFree);
        this.truexAdRenderer.addEventListener(TruexAdEvent.USER_CANCEL, this::userCancel);
        this.truexAdRenderer.addEventListener(TruexAdEvent.OPT_IN, this::optIn);
        this.truexAdRenderer.addEventListener(TruexAdEvent.OPT_OUT, this::optOut);
        this.truexAdRenderer.addEventListener(TruexAdEvent.SKIP_CARD_SHOWN, this::skipCardShown);
        this.truexAdRenderer.addEventListener(TruexAdEvent.POPUP_WEBSITE, this::popUp);
        this.listeners = new ArrayList<TruexEventListener>(listeners);
    }

    public void startAd(ViewGroup viewGroup, String vastUrl) {
        this.viewGroup = viewGroup;
        TruexAdOptions options = new TruexAdOptions();
        this.truexAdRenderer.init(vastUrl, options);
        this.truexAdRenderer.start(viewGroup);
    }

    public void onResume() {
        Log.d((String)CLASSTAG, (String)"onResume");
        this.truexAdRenderer.resume();
    }

    public void onPause() {
        Log.d((String)CLASSTAG, (String)"onPause");
        this.truexAdRenderer.pause();
    }

    public void onStop() {
        Log.d((String)CLASSTAG, (String)"onStop");
    }

    public void onDestroy() {
        Log.d((String)CLASSTAG, (String)"onDestroy");
        this.truexAdRenderer.stop();
    }

    private void onCompletion() {
        if (this.didReceiveCredit) {
            this.playbackHandler.resumeStream();
        } else {
            this.playbackHandler.displayLinearAds();
        }
    }

    private void adFetchCompleted(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"adFetchCompleted");
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onAdFetchCompleted(data);
        }
    }

    private void adStarted(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"adStarted");
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onAdStarted(data);
        }
    }

    private void adDisplayed(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"adDisplayed");
    }

    private void adCompleted(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"adCompleted");
        this.onCompletion();
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onAdCompleted(data);
        }
    }

    private void adError(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"adError");
        this.onCompletion();
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onAdError(data);
        }
    }

    private void noAds(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"noAds");
        this.onCompletion();
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onNoAds(data);
        }
    }

    private void adFree(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"adFree");
        this.didReceiveCredit = true;
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onAdFree(data);
        }
    }

    private void userCancel(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"userCancel");
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onUserCancel(data);
        }
    }

    private void optIn(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"optIn");
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onOptIn(data);
        }
    }

    private void optOut(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"optOut");
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onOptOut(data);
        }
    }

    private void skipCardShown(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"skipCardShown");
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onSkipCardShown(data);
        }
    }

    private void popUp(TruexAdEvent event, Map<String, ?> data) {
        Log.d((String)CLASSTAG, (String)"popUp");
        String url = (String)data.get("url");
        this.playbackHandler.handlePopup(url);
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onPopUp(data);
        }
    }

    private /* synthetic */ void lambda$adDisplayed$0(Map data) {
        this.truexAdRenderer.start(this.viewGroup);
        for (TruexEventListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onAdDisplayed(data);
        }
    }
}

