/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.truex;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import android.view.ViewGroup;
import com.akamai.amp.ads.truex.AdBreak;
import com.akamai.amp.ads.truex.DisplayMode;
import com.akamai.amp.ads.truex.PlaybackHandler;
import com.akamai.amp.ads.truex.PlaybackStateListener;
import com.akamai.amp.ads.truex.PlayerEventListener;
import com.akamai.amp.ads.truex.TruexAdManager;
import com.akamai.amp.ads.truex.TruexEventListener;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.source.ConcatenatingMediaSource;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.ProgressiveMediaSource;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.VideoPlayerViewExo;
import com.akamai.amp.media.exowrapper2.ExoWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class AmpTruexManager
implements PlaybackHandler,
PlaybackStateListener {
    private static final String CLASSTAG = AmpTruexManager.class.getSimpleName();
    private Context context;
    private VideoPlayerContainer playerView;
    private Boolean isPaused;
    private TruexAdManager truexAdManager;
    private DisplayMode displayMode;
    private List<AdBreak> adBreaks;
    private AdBreak currentAdBreak;
    private final List<TruexEventListener> listeners;
    private Handler progressHandler = new Handler();
    private Runnable checkForAds = null;
    private long resumePosition = 0L;
    private PlayerEventListener l;
    private ViewGroup viewGroup;
    private final IPlayerEventsListener ampListener = new IPlayerEventsListener(){

        public boolean onPlayerEvent(int eventID) {
            switch (eventID) {
                case 18: {
                    AmpTruexManager.this.onResume();
                    break;
                }
                case 17: {
                    AmpTruexManager.this.onPause();
                    break;
                }
                case 23: {
                    AmpTruexManager.this.onDestroy();
                }
            }
            return false;
        }

        public boolean onPlayerExtendedEvent(int i, int i1, int i2) {
            return false;
        }
    };

    public AmpTruexManager(Context context, VideoPlayerContainer playerView, List<AdBreak> adBreaks, List<TruexEventListener> listeners) {
        this.context = context;
        this.playerView = playerView;
        this.adBreaks = this.cleanList(adBreaks);
        this.listeners = this.cleanList(listeners);
        this.truexAdManager = new TruexAdManager(this.context, this, this.listeners);
        this.l = new PlayerEventListener(this, this);
        this.setVideoPlayerView(this.playerView.getVideoPlayer());
    }

    private <T> List<T> cleanList(List<T> list) {
        return list == null ? new ArrayList() : new ArrayList<T>(list);
    }

    public void setVideoPlayerView(VideoPlayerView amp) {
        if (amp == null) {
            return;
        }
        amp.addEventsListener((IPlayerEventsListener)this.l);
        amp.addEventsListener(this.ampListener);
    }

    public void onResume() {
        Log.d((String)CLASSTAG, (String)"onResume");
        this.isPaused = false;
        if (this.truexAdManager != null) {
            this.truexAdManager.onResume();
        }
        if (this.playerView.getVideoPlayer() != null && this.displayMode != DisplayMode.INTERACTIVE_AD) {
            this.playerView.getVideoPlayer().resume();
        }
    }

    public void onPause() {
        this.isPaused = true;
        if (this.truexAdManager != null) {
            this.truexAdManager.onPause();
        }
        if (this.playerView.getVideoPlayer() != null && this.displayMode != DisplayMode.INTERACTIVE_AD) {
            this.playerView.getVideoPlayer().pause();
        }
    }

    public void onDestroy() {
        if (this.truexAdManager != null) {
            this.truexAdManager.onDestroy();
        }
        this.cleanupProgressMonitor();
        this.closeStream();
    }

    @Override
    public void onPlayerDidStart() {
        this.playCurrentAds();
        this.startProgressMonitor();
    }

    @Override
    public void onPlayerDidResume() {
        Log.d((String)CLASSTAG, (String)"onPlayerDidResume");
    }

    @Override
    public void onPlayerDidPause() {
        Log.d((String)CLASSTAG, (String)"onPlayerDidPause");
    }

    @Override
    public void onPlayerDidComplete() {
        if (this.displayMode == DisplayMode.LINEAR_ADS) {
            this.displayContentStream();
            this.clearCurrentAdBreak();
        }
    }

    private void clearCurrentAdBreak() {
        if (this.currentAdBreak != null) {
            this.currentAdBreak.viewed = true;
            this.currentAdBreak = null;
        }
    }

    @Override
    public void resumeStream() {
        VideoPlayerView videoPlayer;
        Log.d((String)CLASSTAG, (String)"resumeStream");
        this.playerView.setVisibility(0);
        this.displayMode = DisplayMode.CONTENT_STREAM;
        this.clearCurrentAdBreak();
        if (!this.isPaused.booleanValue() && (videoPlayer = this.playerView.getVideoPlayer()) != null) {
            videoPlayer.resume();
        }
    }

    public void pauseStream() {
        Log.d((String)CLASSTAG, (String)"pauseStream");
        VideoPlayerView videoPlayer = this.playerView.getVideoPlayer();
        if (videoPlayer != null) {
            videoPlayer.pause();
        }
        this.playerView.setVisibility(8);
    }

    @Override
    public void displayLinearAds() {
        Log.d((String)CLASSTAG, (String)"displayLinearAds");
        this.displayMode = DisplayMode.LINEAR_ADS;
        MediaSource adPod = this.buildAdPod();
        VideoPlayerViewExo exo = (VideoPlayerViewExo)this.getPlayer();
        if (exo != null) {
            ExoWrapper wrapper = this.getExoWrapper(exo);
            this.setMediaSource(wrapper, adPod);
            this.setPlayWhenReady(wrapper, true);
        }
        this.playerView.setVisibility(0);
    }

    private void setPlayWhenReady(ExoWrapper wrapper, boolean b) {
        if (wrapper == null) {
            return;
        }
        wrapper.setPlayWhenReady(b);
    }

    private void setMediaSource(ExoWrapper wrapper, MediaSource adPod) {
        if (wrapper == null) {
            return;
        }
        if (adPod == null) {
            return;
        }
        try {
            Field f1 = wrapper.getClass().getDeclaredField("mediaSource");
            f1.setAccessible(true);
            f1.set(wrapper, adPod);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private ExoWrapper getExoWrapper(VideoPlayerViewExo exo) {
        if (exo == null) {
            return null;
        }
        try {
            Field privateField = VideoPlayerViewExo.class.getDeclaredField("exo");
            privateField.setAccessible(true);
            ExoWrapper wrapper = (ExoWrapper)privateField.get(exo);
            return wrapper;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    private MediaSource buildAdPod() {
        ArrayList<ProgressiveMediaSource> ads = new ArrayList<ProgressiveMediaSource>();
        for (String url : this.currentAdBreak.adUrls) {
            if (this.isTruexAdUrl(url).booleanValue()) continue;
            Uri uri = Uri.parse((String)url);
            ProgressiveMediaSource source = new ProgressiveMediaSource.Factory(this.getDataSourceFactory()).createMediaSource(MediaItem.fromUri((Uri)uri));
            ads.add(source);
        }
        ConcatenatingMediaSource adPod = new ConcatenatingMediaSource(ads.toArray(new MediaSource[0]));
        return adPod;
    }

    private DataSource.Factory getDataSourceFactory() {
        VideoPlayerViewExo player = (VideoPlayerViewExo)this.getPlayer();
        ExoWrapper exo = this.getExoWrapper(player);
        if (exo == null) {
            return null;
        }
        try {
            Field privateField = ExoWrapper.class.getDeclaredField("mediaDataSourceFactory");
            privateField.setAccessible(true);
            DataSource.Factory factory = (DataSource.Factory)privateField.get(exo);
            return factory;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void handlePopup(String url) {
        Log.i((String)CLASSTAG, (String)("handlePopup: " + url));
    }

    private void playCurrentAds() {
        if (this.adBreaks == null || this.adBreaks.size() == 0) {
            return;
        }
        long position = this.getContentPosition();
        for (int i = 0; i < this.adBreaks.size(); ++i) {
            AdBreak adBreak = this.adBreaks.get(i);
            if (position < (long)adBreak.timeOffsetMs || adBreak.viewed) continue;
            this.currentAdBreak = adBreak;
            String firstAd = adBreak.getFirstAd();
            if (this.isTruexAdUrl(firstAd).booleanValue()) {
                this.displayInteractiveAd(firstAd);
            } else {
                this.displayLinearAds();
            }
            return;
        }
    }

    private void displayInteractiveAd(String vastUrl) {
        Log.d((String)CLASSTAG, (String)"displayInteractiveAds");
        this.pauseStream();
        Long position = this.getContentPosition();
        if (position > 0L) {
            this.resumePosition = position;
        }
        this.displayMode = DisplayMode.INTERACTIVE_AD;
        ViewGroup viewGroup = this.getViewGroup();
        this.truexAdManager = new TruexAdManager(this.context, this, this.listeners);
        this.truexAdManager.startAd(viewGroup, vastUrl);
    }

    public void setViewGroup(ViewGroup viewGroup) {
        this.viewGroup = viewGroup;
    }

    private ViewGroup getViewGroup() {
        if (this.viewGroup == null) {
            return (ViewGroup)this.playerView.getParent();
        }
        return this.viewGroup;
    }

    private void displayContentStream() {
        Log.d((String)CLASSTAG, (String)"displayContentStream");
        this.displayMode = DisplayMode.CONTENT_STREAM;
    }

    @Override
    public void closeStream() {
        Log.d((String)CLASSTAG, (String)"closeStream");
        VideoPlayerView videoPlayer = this.playerView.getVideoPlayer();
        if (videoPlayer != null) {
            videoPlayer.onDestroy();
        }
        this.playerView.onDestroy();
    }

    private void startProgressMonitor() {
        if (this.checkForAds == null) {
            this.checkForAds = new Runnable(){

                @Override
                public void run() {
                    if (AmpTruexManager.this.currentAdBreak == null && AmpTruexManager.this.getContentPosition() > 0L) {
                        AmpTruexManager.this.playCurrentAds();
                    }
                    if (AmpTruexManager.this.progressHandler != null) {
                        AmpTruexManager.this.progressHandler.postDelayed(AmpTruexManager.this.checkForAds, 1000L);
                    }
                }
            };
        }
        this.checkForAds.run();
    }

    private void cleanupProgressMonitor() {
        if (this.progressHandler != null) {
            if (this.checkForAds != null) {
                this.progressHandler.removeCallbacks(this.checkForAds);
            }
            this.progressHandler = null;
        }
    }

    private VideoPlayerView getPlayer() {
        return this.playerView != null ? this.playerView.getVideoPlayer() : null;
    }

    private long getContentPosition() {
        VideoPlayerView player = this.getPlayer();
        return player != null ? (long)player.getCurrentStreamPosition() : 0L;
    }

    private Boolean isTruexAdUrl(String url) {
        return url.contains("get.truex.com");
    }
}

