/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.hls.playlist;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.ParserException;
import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.hls.HlsDataSourceFactory;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.Loader;
import com.akamai.amp.exoplayer2.upstream.ParsingLoadable;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class DefaultHlsPlaylistTracker
implements HlsPlaylistTracker,
Loader.Callback<ParsingLoadable<HlsPlaylist>> {
    public static final HlsPlaylistTracker.Factory FACTORY = DefaultHlsPlaylistTracker::new;
    public static final double DEFAULT_PLAYLIST_STUCK_TARGET_DURATION_COEFFICIENT = 3.5;
    private final HlsDataSourceFactory dataSourceFactory;
    private final HlsPlaylistParserFactory playlistParserFactory;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final HashMap<Uri, MediaPlaylistBundle> playlistBundles;
    private final List<HlsPlaylistTracker.PlaylistEventListener> listeners;
    private final double playlistStuckTargetDurationCoefficient;
    @Nullable
    private ParsingLoadable.Parser<HlsPlaylist> mediaPlaylistParser;
    @Nullable
    private MediaSourceEventListener.EventDispatcher eventDispatcher;
    @Nullable
    private Loader initialPlaylistLoader;
    @Nullable
    private Handler playlistRefreshHandler;
    @Nullable
    private HlsPlaylistTracker.PrimaryPlaylistListener primaryPlaylistListener;
    @Nullable
    private HlsMasterPlaylist masterPlaylist;
    @Nullable
    private Uri primaryMediaPlaylistUrl;
    @Nullable
    private HlsMediaPlaylist primaryMediaPlaylistSnapshot;
    private boolean isLive;
    private long initialStartTimeUs;
    private long refLoadMs;
    private long refSegmentNum = -1L;
    private static final int DEFAULT_REFRESH_DELAY_US = 100000;
    private long refreshDelayUs = 0L;

    public DefaultHlsPlaylistTracker(HlsDataSourceFactory dataSourceFactory, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistParserFactory playlistParserFactory) {
        this(dataSourceFactory, loadErrorHandlingPolicy, playlistParserFactory, 3.5);
    }

    public DefaultHlsPlaylistTracker(HlsDataSourceFactory dataSourceFactory, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistParserFactory playlistParserFactory, double playlistStuckTargetDurationCoefficient) {
        this.dataSourceFactory = dataSourceFactory;
        this.playlistParserFactory = playlistParserFactory;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.playlistStuckTargetDurationCoefficient = playlistStuckTargetDurationCoefficient;
        this.listeners = new ArrayList<HlsPlaylistTracker.PlaylistEventListener>();
        this.playlistBundles = new HashMap();
        this.initialStartTimeUs = -9223372036854775807L;
    }

    @Override
    public void start(Uri initialPlaylistUri, MediaSourceEventListener.EventDispatcher eventDispatcher, HlsPlaylistTracker.PrimaryPlaylistListener primaryPlaylistListener) {
        this.playlistRefreshHandler = Util.createHandlerForCurrentLooper();
        this.eventDispatcher = eventDispatcher;
        this.primaryPlaylistListener = primaryPlaylistListener;
        ParsingLoadable<HlsPlaylist> masterPlaylistLoadable = new ParsingLoadable<HlsPlaylist>(this.dataSourceFactory.createDataSource(4), initialPlaylistUri, 4, this.playlistParserFactory.createPlaylistParser());
        Assertions.checkState(this.initialPlaylistLoader == null);
        this.initialPlaylistLoader = new Loader("DefaultHlsPlaylistTracker:MasterPlaylist");
        long elapsedRealtime = this.initialPlaylistLoader.startLoading(masterPlaylistLoadable, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(masterPlaylistLoadable.type));
        eventDispatcher.loadStarted(new LoadEventInfo(masterPlaylistLoadable.loadTaskId, masterPlaylistLoadable.dataSpec, elapsedRealtime), masterPlaylistLoadable.type);
    }

    @Override
    public void stop() {
        this.primaryMediaPlaylistUrl = null;
        this.primaryMediaPlaylistSnapshot = null;
        this.masterPlaylist = null;
        this.initialStartTimeUs = -9223372036854775807L;
        this.initialPlaylistLoader.release();
        this.initialPlaylistLoader = null;
        for (MediaPlaylistBundle bundle : this.playlistBundles.values()) {
            bundle.release();
        }
        this.playlistRefreshHandler.removeCallbacksAndMessages(null);
        this.playlistRefreshHandler = null;
        this.playlistBundles.clear();
    }

    @Override
    public void addListener(HlsPlaylistTracker.PlaylistEventListener listener) {
        Assertions.checkNotNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(HlsPlaylistTracker.PlaylistEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    @Nullable
    public HlsMasterPlaylist getMasterPlaylist() {
        return this.masterPlaylist;
    }

    @Override
    @Nullable
    public HlsMediaPlaylist getPlaylistSnapshot(Uri url, boolean isForPlayback) {
        HlsMediaPlaylist snapshot = this.playlistBundles.get(url).getPlaylistSnapshot();
        if (snapshot != null && isForPlayback) {
            this.maybeSetPrimaryUrl(url);
        }
        return snapshot;
    }

    @Override
    public long getInitialStartTimeUs() {
        return this.initialStartTimeUs;
    }

    @Override
    public boolean isSnapshotValid(Uri url) {
        return this.playlistBundles.get(url).isSnapshotValid();
    }

    @Override
    public void maybeThrowPrimaryPlaylistRefreshError() throws IOException {
        if (this.initialPlaylistLoader != null) {
            this.initialPlaylistLoader.maybeThrowError();
        }
        if (this.primaryMediaPlaylistUrl != null) {
            this.maybeThrowPlaylistRefreshError(this.primaryMediaPlaylistUrl);
        }
    }

    @Override
    public void maybeThrowPlaylistRefreshError(Uri url) throws IOException {
        this.playlistBundles.get(url).maybeThrowPlaylistRefreshError();
    }

    @Override
    public void refreshPlaylist(Uri url) {
        this.playlistBundles.get(url).loadPlaylist();
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public void onLoadCompleted(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        HlsPlaylist result = loadable.getResult();
        boolean isMediaPlaylist = result instanceof HlsMediaPlaylist;
        HlsMasterPlaylist masterPlaylist = isMediaPlaylist ? HlsMasterPlaylist.createSingleVariantMasterPlaylist(result.baseUri) : (HlsMasterPlaylist)result;
        this.masterPlaylist = masterPlaylist;
        this.mediaPlaylistParser = this.playlistParserFactory.createPlaylistParser(masterPlaylist);
        this.primaryMediaPlaylistUrl = masterPlaylist.variants.get((int)0).url;
        this.createBundles(masterPlaylist.mediaPlaylistUrls);
        MediaPlaylistBundle primaryBundle = this.playlistBundles.get(this.primaryMediaPlaylistUrl);
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (isMediaPlaylist) {
            primaryBundle.processLoadedPlaylist((HlsMediaPlaylist)result, loadEventInfo);
        } else {
            primaryBundle.loadPlaylist();
        }
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.eventDispatcher.loadCompleted(loadEventInfo, 4);
    }

    @Override
    public void onLoadCanceled(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.eventDispatcher.loadCanceled(loadEventInfo, 4);
    }

    @Override
    public Loader.LoadErrorAction onLoadError(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        MediaLoadData mediaLoadData;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(loadable.type), error, errorCount));
        boolean isFatal = retryDelayMs == -9223372036854775807L;
        this.eventDispatcher.loadError(loadEventInfo, loadable.type, error, isFatal);
        if (isFatal) {
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }
        return isFatal ? Loader.DONT_RETRY_FATAL : Loader.createRetryAction(false, retryDelayMs);
    }

    private boolean maybeSelectNewPrimaryUrl() {
        List<HlsMasterPlaylist.Variant> variants = this.masterPlaylist.variants;
        int variantsSize = variants.size();
        long currentTimeMs = SystemClock.elapsedRealtime();
        for (int i = 0; i < variantsSize; ++i) {
            MediaPlaylistBundle bundle = this.playlistBundles.get(variants.get((int)i).url);
            if (currentTimeMs <= bundle.excludeUntilMs) continue;
            this.primaryMediaPlaylistUrl = bundle.playlistUrl;
            bundle.loadPlaylist();
            return true;
        }
        return false;
    }

    private void maybeSetPrimaryUrl(Uri url) {
        if (url.equals((Object)this.primaryMediaPlaylistUrl) || !this.isVariantUrl(url) || this.primaryMediaPlaylistSnapshot != null && this.primaryMediaPlaylistSnapshot.hasEndTag) {
            return;
        }
        this.primaryMediaPlaylistUrl = url;
        this.playlistBundles.get(this.primaryMediaPlaylistUrl).loadPlaylist();
    }

    private boolean isVariantUrl(Uri playlistUrl) {
        List<HlsMasterPlaylist.Variant> variants = this.masterPlaylist.variants;
        for (int i = 0; i < variants.size(); ++i) {
            if (!playlistUrl.equals((Object)variants.get((int)i).url)) continue;
            return true;
        }
        return false;
    }

    private void createBundles(List<Uri> urls) {
        int listSize = urls.size();
        for (int i = 0; i < listSize; ++i) {
            Uri url = urls.get(i);
            MediaPlaylistBundle bundle = new MediaPlaylistBundle(url);
            this.playlistBundles.put(url, bundle);
        }
    }

    private void onPlaylistUpdated(Uri url, HlsMediaPlaylist newSnapshot) {
        if (url.equals((Object)this.primaryMediaPlaylistUrl)) {
            if (this.primaryMediaPlaylistSnapshot == null) {
                this.isLive = !newSnapshot.hasEndTag;
                this.initialStartTimeUs = newSnapshot.startTimeUs;
            }
            this.primaryMediaPlaylistSnapshot = newSnapshot;
            this.primaryPlaylistListener.onPrimaryPlaylistRefreshed(newSnapshot);
        }
        int listenersSize = this.listeners.size();
        for (int i = 0; i < listenersSize; ++i) {
            this.listeners.get(i).onPlaylistChanged();
        }
    }

    private boolean notifyPlaylistError(Uri playlistUrl, long exclusionDurationMs) {
        int listenersSize = this.listeners.size();
        boolean anyExclusionFailed = false;
        for (int i = 0; i < listenersSize; ++i) {
            anyExclusionFailed |= !this.listeners.get(i).onPlaylistError(playlistUrl, exclusionDurationMs);
        }
        return anyExclusionFailed;
    }

    private HlsMediaPlaylist getLatestPlaylistSnapshot(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        if (!loadedPlaylist.isNewerThan(oldPlaylist)) {
            if (loadedPlaylist.hasEndTag) {
                return oldPlaylist.copyWithEndTag();
            }
            return oldPlaylist;
        }
        long startTimeUs = this.getLoadedPlaylistStartTimeUs(oldPlaylist, loadedPlaylist);
        int discontinuitySequence = this.getLoadedPlaylistDiscontinuitySequence(oldPlaylist, loadedPlaylist);
        return loadedPlaylist.copyWith(startTimeUs, discontinuitySequence);
    }

    private long getLoadedPlaylistStartTimeUs(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        long primarySnapshotStartTimeUs;
        if (loadedPlaylist.hasProgramDateTime) {
            return loadedPlaylist.startTimeUs;
        }
        long l = primarySnapshotStartTimeUs = this.primaryMediaPlaylistSnapshot != null ? this.primaryMediaPlaylistSnapshot.startTimeUs : 0L;
        if (oldPlaylist == null) {
            return primarySnapshotStartTimeUs;
        }
        int oldPlaylistSize = oldPlaylist.segments.size();
        HlsMediaPlaylist.Segment firstOldOverlappingSegment = DefaultHlsPlaylistTracker.getFirstOldOverlappingSegment(oldPlaylist, loadedPlaylist);
        if (firstOldOverlappingSegment != null) {
            return oldPlaylist.startTimeUs + firstOldOverlappingSegment.relativeStartTimeUs;
        }
        if ((long)oldPlaylistSize == loadedPlaylist.mediaSequence - oldPlaylist.mediaSequence) {
            return oldPlaylist.getEndTimeUs();
        }
        return primarySnapshotStartTimeUs;
    }

    private int getLoadedPlaylistDiscontinuitySequence(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        int primaryUrlDiscontinuitySequence;
        if (loadedPlaylist.hasDiscontinuitySequence) {
            return loadedPlaylist.discontinuitySequence;
        }
        int n = primaryUrlDiscontinuitySequence = this.primaryMediaPlaylistSnapshot != null ? this.primaryMediaPlaylistSnapshot.discontinuitySequence : 0;
        if (oldPlaylist == null) {
            return primaryUrlDiscontinuitySequence;
        }
        HlsMediaPlaylist.Segment firstOldOverlappingSegment = DefaultHlsPlaylistTracker.getFirstOldOverlappingSegment(oldPlaylist, loadedPlaylist);
        if (firstOldOverlappingSegment != null) {
            return oldPlaylist.discontinuitySequence + firstOldOverlappingSegment.relativeDiscontinuitySequence - loadedPlaylist.segments.get((int)0).relativeDiscontinuitySequence;
        }
        return primaryUrlDiscontinuitySequence;
    }

    private static HlsMediaPlaylist.Segment getFirstOldOverlappingSegment(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        int mediaSequenceOffset = (int)(loadedPlaylist.mediaSequence - oldPlaylist.mediaSequence);
        List<HlsMediaPlaylist.Segment> oldSegments = oldPlaylist.segments;
        return mediaSequenceOffset < oldSegments.size() ? oldSegments.get(mediaSequenceOffset) : null;
    }

    private final class MediaPlaylistBundle
    implements Loader.Callback<ParsingLoadable<HlsPlaylist>>,
    Runnable {
        private final Uri playlistUrl;
        private final Loader mediaPlaylistLoader;
        private final ParsingLoadable<HlsPlaylist> mediaPlaylistLoadable;
        @Nullable
        private HlsMediaPlaylist playlistSnapshot;
        private long lastSnapshotLoadMs;
        private long lastSnapshotChangeMs;
        private long earliestNextLoadTimeMs;
        private long excludeUntilMs;
        private boolean loadPending;
        private IOException playlistError;

        public MediaPlaylistBundle(Uri playlistUrl) {
            this.playlistUrl = playlistUrl;
            this.mediaPlaylistLoader = new Loader("DefaultHlsPlaylistTracker:MediaPlaylist");
            this.mediaPlaylistLoadable = new ParsingLoadable<HlsPlaylist>(DefaultHlsPlaylistTracker.this.dataSourceFactory.createDataSource(4), playlistUrl, 4, DefaultHlsPlaylistTracker.this.mediaPlaylistParser);
        }

        @Nullable
        public HlsMediaPlaylist getPlaylistSnapshot() {
            return this.playlistSnapshot;
        }

        public boolean isSnapshotValid() {
            if (this.playlistSnapshot == null) {
                return false;
            }
            long currentTimeMs = SystemClock.elapsedRealtime();
            long snapshotValidityDurationMs = Math.max(30000L, C.usToMs(this.playlistSnapshot.durationUs));
            return this.playlistSnapshot.hasEndTag || this.playlistSnapshot.playlistType == 2 || this.playlistSnapshot.playlistType == 1 || this.lastSnapshotLoadMs + snapshotValidityDurationMs > currentTimeMs;
        }

        public void release() {
            this.mediaPlaylistLoader.release();
        }

        public void loadPlaylist() {
            this.excludeUntilMs = 0L;
            if (this.loadPending || this.mediaPlaylistLoader.isLoading() || this.mediaPlaylistLoader.hasFatalError()) {
                return;
            }
            long currentTimeMs = SystemClock.elapsedRealtime();
            if (currentTimeMs < this.earliestNextLoadTimeMs) {
                this.loadPending = true;
                DefaultHlsPlaylistTracker.this.playlistRefreshHandler.postDelayed((Runnable)this, this.earliestNextLoadTimeMs - currentTimeMs);
            } else {
                this.loadPlaylistImmediately();
            }
        }

        public void maybeThrowPlaylistRefreshError() throws IOException {
            this.mediaPlaylistLoader.maybeThrowError();
            if (this.playlistError != null) {
                throw this.playlistError;
            }
        }

        @Override
        public void onLoadCompleted(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            HlsPlaylist result = loadable.getResult();
            LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
            if (result instanceof HlsMediaPlaylist) {
                this.processLoadedPlaylist((HlsMediaPlaylist)result, loadEventInfo);
                DefaultHlsPlaylistTracker.this.eventDispatcher.loadCompleted(loadEventInfo, 4);
            } else {
                this.playlistError = new ParserException("Loaded playlist has unexpected type.");
                DefaultHlsPlaylistTracker.this.eventDispatcher.loadError(loadEventInfo, 4, this.playlistError, true);
            }
            DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }

        @Override
        public void onLoadCanceled(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
            DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadCanceled(loadEventInfo, 4);
        }

        @Override
        public Loader.LoadErrorAction onLoadError(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
            long retryDelay;
            boolean exclusionFailed;
            MediaLoadData mediaLoadData;
            LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
            LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo = new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(loadable.type), error, errorCount);
            long exclusionDurationMs = DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.getBlacklistDurationMsFor(loadErrorInfo);
            boolean shouldExclude = exclusionDurationMs != -9223372036854775807L;
            boolean bl = exclusionFailed = DefaultHlsPlaylistTracker.this.notifyPlaylistError(this.playlistUrl, exclusionDurationMs) || !shouldExclude;
            if (shouldExclude) {
                exclusionFailed |= this.excludePlaylist(exclusionDurationMs);
            }
            Loader.LoadErrorAction loadErrorAction = exclusionFailed ? ((retryDelay = DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.getRetryDelayMsFor(loadErrorInfo)) != -9223372036854775807L ? Loader.createRetryAction(false, retryDelay) : Loader.DONT_RETRY_FATAL) : Loader.DONT_RETRY;
            boolean wasCanceled = !loadErrorAction.isRetry();
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadError(loadEventInfo, loadable.type, error, wasCanceled);
            if (wasCanceled) {
                DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
            }
            return loadErrorAction;
        }

        @Override
        public void run() {
            this.loadPending = false;
            this.loadPlaylistImmediately();
        }

        private void loadPlaylistImmediately() {
            long elapsedRealtime = this.mediaPlaylistLoader.startLoading(this.mediaPlaylistLoadable, this, DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(this.mediaPlaylistLoadable.type));
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadStarted(new LoadEventInfo(this.mediaPlaylistLoadable.loadTaskId, this.mediaPlaylistLoadable.dataSpec, elapsedRealtime), this.mediaPlaylistLoadable.type);
        }

        private void processLoadedPlaylist(HlsMediaPlaylist loadedPlaylist, LoadEventInfo loadEventInfo) {
            long currentTimeMs;
            HlsMediaPlaylist oldPlaylist = this.playlistSnapshot;
            this.lastSnapshotLoadMs = currentTimeMs = SystemClock.elapsedRealtime();
            this.playlistSnapshot = DefaultHlsPlaylistTracker.this.getLatestPlaylistSnapshot(oldPlaylist, loadedPlaylist);
            if (this.playlistSnapshot != null && oldPlaylist != null && (DefaultHlsPlaylistTracker.this.refSegmentNum == -1L || DefaultHlsPlaylistTracker.this.refreshDelayUs == 100000L || this.playlistSnapshot.mediaSequence > oldPlaylist.mediaSequence + 1L)) {
                DefaultHlsPlaylistTracker.this.refSegmentNum = this.playlistSnapshot.mediaSequence + (long)this.playlistSnapshot.segments.size() - 1L;
                DefaultHlsPlaylistTracker.this.refLoadMs = this.lastSnapshotLoadMs;
            }
            if (this.playlistSnapshot != oldPlaylist) {
                long currentSegmentNum = this.playlistSnapshot.mediaSequence + (long)this.playlistSnapshot.segments.size() - 1L;
                this.playlistError = null;
                this.lastSnapshotChangeMs = currentTimeMs;
                DefaultHlsPlaylistTracker.this.onPlaylistUpdated(this.playlistUrl, this.playlistSnapshot);
                long diffUs = this.playlistSnapshot.targetDurationUs - 100000L;
                if ((currentSegmentNum != DefaultHlsPlaylistTracker.this.refSegmentNum || DefaultHlsPlaylistTracker.this.refreshDelayUs == 100000L) && DefaultHlsPlaylistTracker.this.refSegmentNum > 0L) {
                    diffUs = (currentTimeMs - DefaultHlsPlaylistTracker.this.refLoadMs) * 1000L - (currentSegmentNum - DefaultHlsPlaylistTracker.this.refSegmentNum) * this.playlistSnapshot.targetDurationUs;
                }
                DefaultHlsPlaylistTracker.this.refreshDelayUs = Math.max(0L, this.playlistSnapshot.targetDurationUs - diffUs);
            } else {
                DefaultHlsPlaylistTracker.this.refreshDelayUs = 100000L;
            }
            if (!this.playlistSnapshot.hasEndTag) {
                if (loadedPlaylist.mediaSequence + (long)loadedPlaylist.segments.size() < this.playlistSnapshot.mediaSequence) {
                    this.playlistError = new HlsPlaylistTracker.PlaylistResetException(this.playlistUrl);
                    DefaultHlsPlaylistTracker.this.notifyPlaylistError(this.playlistUrl, -9223372036854775807L);
                } else if ((double)(currentTimeMs - this.lastSnapshotChangeMs) > (double)C.usToMs(this.playlistSnapshot.targetDurationUs) * DefaultHlsPlaylistTracker.this.playlistStuckTargetDurationCoefficient) {
                    this.playlistError = new HlsPlaylistTracker.PlaylistStuckException(this.playlistUrl);
                    LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo = new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, new MediaLoadData(4), this.playlistError, 1);
                    long exclusionDurationMs = DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.getBlacklistDurationMsFor(loadErrorInfo);
                    DefaultHlsPlaylistTracker.this.notifyPlaylistError(this.playlistUrl, exclusionDurationMs);
                    if (exclusionDurationMs != -9223372036854775807L) {
                        this.excludePlaylist(exclusionDurationMs);
                    }
                }
            }
            this.earliestNextLoadTimeMs = AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().isLowLatencyTurnedOn() && DefaultHlsPlaylistTracker.this.refreshDelayUs < this.playlistSnapshot.targetDurationUs ? currentTimeMs + C.usToMs(DefaultHlsPlaylistTracker.this.refreshDelayUs) : currentTimeMs + C.usToMs(this.playlistSnapshot != oldPlaylist ? this.playlistSnapshot.targetDurationUs : this.playlistSnapshot.targetDurationUs / 2L);
            if (this.playlistUrl.equals((Object)DefaultHlsPlaylistTracker.this.primaryMediaPlaylistUrl) && !this.playlistSnapshot.hasEndTag) {
                this.loadPlaylist();
            }
        }

        private boolean excludePlaylist(long exclusionDurationMs) {
            this.excludeUntilMs = SystemClock.elapsedRealtime() + exclusionDurationMs;
            return this.playlistUrl.equals((Object)DefaultHlsPlaylistTracker.this.primaryMediaPlaylistUrl) && !DefaultHlsPlaylistTracker.this.maybeSelectNewPrimaryUrl();
        }
    }
}

