package com.akamai.mdt.id3tag;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;

public class MainActivity extends Activity {

    private final static String LOG_TAG = "ID3TagsAMP";
    private final static String LICENSE = "Xun_biQDGlqwOlKxgRiWVK283OnTccVwJNUb2YlYmlbHzgVP5S-3l_bB95rvVLjp_8ZhHd0WA7eE35YilStPFg==";
    private final static String VIDEO_URL = "http://sblanco.mediadev.edgesuite.net/id3/master.m3u8";
 
    private VideoPlayerContainer mVideoContainer;
    private VideoPlayerView mVideoView;
    private ProgressBar mProgressBar;
    private TextView tagsTextView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // This prevents the device to go sleep
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        mProgressBar = findViewById(R.id.progressBar);
        mVideoContainer = findViewById(R.id.playerViewCtrl);
        tagsTextView = findViewById(R.id.tagsTextView);
        mVideoContainer.addVideoPlayerContainerCallback(new VideoPlayerContainer.VideoPlayerContainerCallback() {
            @Override
            public void onVideoPlayerCreated() {
                mVideoView = mVideoContainer.getVideoPlayer();
                mVideoView.setProgressBarControl(mProgressBar);
                mVideoView.setLicense(LICENSE);
                mVideoView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO_FILL_SCREEN);
                mVideoView.setLogEnabled(true);

                initID3Handler();
              }

            @Override
            public void onResourceReady(MediaResource mediaResource) {
                mVideoView.play(mediaResource);
            }

            @Override
            public void onResourceError(ErrorType errorType, Exception exception) {
                Log.e(LOG_TAG, "onResourceError()");
            }
        });

        //mVideoContainer.setApiKey("demo");
        mVideoContainer.prepareResource(VIDEO_URL);
    }

    private void initID3Handler() {
        mVideoView.addId3TagsEventListener(data -> {
            String id3Tag = data.getText();
            Log.i(LOG_TAG, id3Tag);
            tagsTextView.setText(id3Tag);
            return true;
        });
    }

    @Override
    protected void onResume() {
        Log.d("PlayerView", "OnResume");
        if ((mVideoView != null)){
            mVideoView.onResume();
        }
        super.onResume();
    }

    @Override
    protected void onPause() {
        Log.d("PlayerView", "OnPause");

        if ((mVideoView != null)){
           mVideoView.onPause();
        }
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        Log.d("PlayerView", "OnDestroy");
        mVideoView.stop();
        mVideoView.onDestroy();
        super.onDestroy();
    }
}
