package fragment;

import android.os.Bundle;
import android.util.Log;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.akamai.amp.cc.AmpSubtitleView;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.captioning.ampcaptioningsample.R;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.media.exowrapper2.SideloadedCaptionsData;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class WebVTTFragment extends Fragment {

    private final static String TAG = "AMP-CC-WEBVTT";
    private final static String VIDEO_URL = "http://media-demo-host.akamaized.net/test/video/kluge/hls/all.m3u8";

    private static final String VTT_CAPTIONS = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/sample.vtt";

    private static final String TTML_CAPTIONS = "http://projects.mediadev.edgesuite.net/jchavarr/assets/ttl-w3-sample1.ttml";

    private static final String HLS_WITH_VTTS = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/vtt-sideload-playlist-min.m3u8";

    private static final String WEBVTTS_A = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/a.vtt";
    private static final String WEBVTTS_B = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/b.vtt";
    private static final String WEBVTTS_C = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/c.vtt";
    private static final String WEBVTTS_D = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/d.vtt";

    private static final String WEBVTTS_LIST_A = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/vtt-sideload-playlista.m3u8";
    private static final String WEBVTTS_LIST_B = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/vtt-sideload-playlistb.m3u8";
    private static final String WEBVTTS_LIST_C = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/vtt-sideload-playlistc.m3u8";
    private static final String WEBVTTS_LIST_D = "http://projects.mediadev.edgesuite.net/customers/akamai/android/doc/vtt-sideload-playlistd.m3u8";


    private VideoPlayerContainer mVideoContainer;
    private VideoPlayerView mVideoPlayerView;
    private ProgressBar mProgressBar;
    private AmpSubtitleView ampSubtitleView;
    private int nextCaptions = 0;

    public static WebVTTFragment newInstance() {
        return new WebVTTFragment();
    }

    public WebVTTFragment() {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.fragment_main, container, false);
        mProgressBar = rootView.findViewById(R.id.progressBar);
        ampSubtitleView = rootView.findViewById(R.id.captionView);
        mVideoContainer = rootView.findViewById(R.id.playerViewCtrl);
        mVideoContainer.addVideoPlayerContainerCallback(new VideoPlayerContainer.VideoPlayerContainerCallback() {
            @Override
            public void onVideoPlayerCreated() {
                Log.i(TAG, "onVideoPlayerCreated()");
            }

            @Override
            public void onResourceReady(MediaResource mediaResource) {
                mVideoPlayerView = mVideoContainer.getVideoPlayer();
                mVideoPlayerView.setProgressBarControl(mProgressBar);
                mVideoPlayerView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO_FIT_SCREEN);
                mVideoPlayerView.setLogEnabled(true);
                initCaptions();
                mVideoPlayerView.setKeepScreenOn(true);

                mVideoPlayerView.play(mediaResource);
            }

            @Override
            public void onResourceError(ErrorType errorType, Exception exception) {

                Log.e(TAG, "onResourceError()");
            }
        });

        Button showCaptionsButton = rootView.findViewById(R.id.showCaptionsButton);
        showCaptionsButton.setOnClickListener(view -> {
            ampSubtitleView.show();
            Toast.makeText(getContext(), "Showing captions", Toast.LENGTH_SHORT).show();
        });
        showCaptionsButton.setVisibility(View.VISIBLE);

        Button hideCaptionsButton = rootView.findViewById(R.id.hideCaptionsButton);
        hideCaptionsButton.setOnClickListener(view -> {
            ampSubtitleView.hide();
            Toast.makeText(getContext(), "Hiding captions", Toast.LENGTH_SHORT).show();
        });
        hideCaptionsButton.setVisibility(View.VISIBLE);

        Button nextCaptionsButton = rootView.findViewById(R.id.nextCaptionsButton);
        nextCaptionsButton.setOnClickListener(view -> {
            int captionsID = loadNextCaptions();
            Toast.makeText(getContext(), "Loading captions #" + captionsID, Toast.LENGTH_SHORT).show();
        });
        nextCaptionsButton.setVisibility(View.VISIBLE);
        mVideoContainer.prepareResource(VIDEO_URL);
        return rootView;
    }

    private void initCaptions(){
        ampSubtitleView.setVideoPlayerView(mVideoPlayerView);

        //SideloadedCaptionsData cc0 = new SideloadedCaptionsData(MimeTypes.TEXT_VTT, VTT_CAPTIONS);
        //SideloadedCaptionsData cc1 = new SideloadedCaptionsData(MimeTypes.APPLICATION_TTML, TTML_CAPTIONS);
        SideloadedCaptionsData cc2 = new SideloadedCaptionsData(MimeTypes.TEXT_VTT, WEBVTTS_A, "cc-id-0", "english");
        SideloadedCaptionsData cc3 = new SideloadedCaptionsData(MimeTypes.TEXT_VTT, WEBVTTS_B, "cc-id-1", "japanese");
        SideloadedCaptionsData cc4 = new SideloadedCaptionsData(MimeTypes.TEXT_VTT, WEBVTTS_C, "cc-id-2", "french");
        SideloadedCaptionsData cc5 = new SideloadedCaptionsData(MimeTypes.TEXT_VTT, WEBVTTS_D, "cc-id-3", "klingon");

        //List<SideloadedCaptionsData> captions = Arrays.asList(cc0, cc1, cc2, cc3, cc4, cc5);
        List<SideloadedCaptionsData> captions = Arrays.asList(cc2, cc3, cc4, cc5);

        ampSubtitleView.sideload(captions);
    }

    private int loadNextCaptions(){
        nextCaptions++;
        Map<Pair<Integer, Integer>, String> dataTracks = ampSubtitleView.getDataTracks();
        int size = dataTracks.size();
        if (nextCaptions >= size) {
            nextCaptions = 0;
        }
        ampSubtitleView.setIndexes(nextCaptions, 0);

        return nextCaptions + 1;
    }

    @Override
    public void onResume() {
        Log.d(TAG, "OnResume");
        if (mVideoPlayerView != null) {
            mVideoPlayerView.resume();
        }
        super.onResume();
    }

    @Override
    public void onPause() {
        Log.d(TAG, "OnPause");
        if(mVideoPlayerView != null){
            mVideoPlayerView.pause();
        }
        super.onPause();
    }

    @Override
    public void onDestroy() {
        Log.d(TAG, "OnDestroy");
        if (mVideoPlayerView!=null) {
            mVideoPlayerView.stop();
            mVideoPlayerView.onDestroy();
        }
        super.onDestroy();
    }
}