package fragment;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;

import androidx.fragment.app.Fragment;

import com.akamai.amp.cc.AmpSubtitleView;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.captioning.ampcaptioningsample.R;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;

import java.util.List;

public class EIAFragment extends Fragment {

    private final static String TAG = "AMP-CC-CEA608";
    private final static String VIDEO_URL = "http://sblanco.mediadev.edgesuite.net/worldnow/608/master.m3u8";

    private VideoPlayerContainer mVideoContainer;
    private VideoPlayerView videoPlayerView;
    private ProgressBar mProgressBar;
    private AmpSubtitleView ampSubtitleView;


    public static EIAFragment newInstance() {
        return new EIAFragment();
    }

    public EIAFragment() {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_main, container, false);
        mProgressBar = rootView.findViewById(R.id.progressBar);
        ampSubtitleView = rootView.findViewById(R.id.captionView);
        mVideoContainer = rootView.findViewById(R.id.playerViewCtrl);
        mVideoContainer.addVideoPlayerContainerCallback(new VideoPlayerContainer.VideoPlayerContainerCallback() {
            @Override
            public void onVideoPlayerCreated() {
                Log.i(TAG, "onVideoPlayerCreated()");
            }

            @Override
            public void onResourceReady(MediaResource mediaResource) {
                videoPlayerView = mVideoContainer.getVideoPlayer();
                videoPlayerView.setProgressBarControl(mProgressBar);
                videoPlayerView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO_FIT_SCREEN);
                videoPlayerView.setLogEnabled(true);
                ampSubtitleView.setVideoPlayerView(videoPlayerView);
                videoPlayerView.addEventsListener(new IPlayerEventsListener() {
                    @Override
                    public boolean onPlayerEvent(int eventID) {
                        if (eventID == IPlayerEventsListener.PLAYER_EVENT_TYPE_START_PLAYING) {
                            ampSubtitleView.setIndexes(0, 0);
                            List<Format> dataFormats = ampSubtitleView.getDataFormats();
                            int count = 1;
                            for (Format format : dataFormats) {
                                Log.i(TAG, count + ") Data Format found: " + format);
                                count++;
                            }
                        }

                        return true;
                    }

                    @Override
                    public boolean onPlayerExtendedEvent(int eventID, int arg1, int arg2) {
                        return true;
                    }
                });
                videoPlayerView.setKeepScreenOn(true);
                videoPlayerView.play(mediaResource);
            }

            @Override
            public void onResourceError(ErrorType errorType, Exception exception) {
                Log.e(TAG, "onResourceError()");
            }
        });

        mVideoContainer.prepareResource(VIDEO_URL);

        return rootView;
    }

    @Override
    public void onResume() {
        Log.d(TAG, "OnResume");
        if (videoPlayerView != null) {
            videoPlayerView.onResume();
        }
        super.onResume();
    }

    @Override
    public void onPause() {
        Log.d(TAG, "OnPause");
        if(videoPlayerView != null){
            videoPlayerView.onPause();
        }
        super.onPause();
    }

    @Override
    public void onDestroy() {
        Log.d(TAG, "OnDestroy");
        if (videoPlayerView!=null) {
            videoPlayerView.onDestroy();
        }
        super.onDestroy();
    }
}
