package com.akamai.ampdemo;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;
import android.widget.ProgressBar;

import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;

import java.util.HashMap;

public class MainActivity extends Activity
        implements VideoPlayerContainer.VideoPlayerContainerCallback {

    private final static String LOG_TAG = "AMPv6";
    private final static String VIDEO_URL = "https://welcomevideo.akamaized.net/delivery/1f/07/1f0756a1-f54b-4e22-adbc-8c68680532ea/tom-intro-for-new-customers-v26b238090-d41d-336d-4347-3dac7fc07f0e.m3u8";

    private final static String AMP_LICENSE = "BtvXWK8rlDMO8uWHJcnKB84uPUOQYCI8UKi9jGUgG5aGrKCdiKOsFVA00spK8fs7WDdZ9qNk5ztdMn1yWiam1g==";
    private VideoPlayerContainer videoPlayerContainer;
    private VideoPlayerView videoPlayerView;
    private ProgressBar progressBar;
    private String videoProtocol;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        progressBar = (ProgressBar) findViewById(R.id.progressBar);
        videoPlayerContainer = (VideoPlayerContainer) findViewById(R.id.playerViewCtrl);
        videoPlayerContainer.addVideoPlayerContainerCallback(this);

      /*  Api keys are a new way to handle AMP licenses, if the Akamai team have given you the
        proper induction to this new approach and you already have your own api key,
        you can use the following method, otherwise, keep using the previous license code.*/

        // videoPlayerContainer.setApiKey("demo");

        //HashMap headers = new HashMap();
        //headers.put("CustomHeader","CustomValue");
        //videoPlayerContainer.setRequestHeaders(headers);

        videoPlayerContainer.prepareResource(VIDEO_URL);

    }

    @Override
    public void onResourceReady(MediaResource mediaResource) {
        videoPlayerView = videoPlayerContainer.getVideoPlayer();
        videoPlayerView.setProgressBarControl(progressBar);
        videoPlayerView.setLogEnabled(true);
        videoPlayerView.setLicense(AMP_LICENSE);
        videoPlayerView.setFullScreenMode(VideoPlayerView.FULLSCREEN_MODE_KEEP_ASPECT_RATIO_FIT_SCREEN);

        videoPlayerView.play(mediaResource);
        //videoPlayerView.setPlaybackRate(1f,1f);
        //videoPlayerContainer.enableAutoRecovery();
        //videoProtocol = videoPlayerView.getProtocol();

    }

    @Override
    public void onVideoPlayerCreated() {
        Log.i(LOG_TAG, "onVideoPlayerCreated()");
    }

    @Override
    public void onResourceError(ErrorType errorType, Exception exception) {
        Log.e(LOG_TAG, "onResourceError()");
    }

    @Override
    protected void onResume() {
        Log.d(LOG_TAG, "onResume");
        if (videoPlayerView != null) {
            videoPlayerView.onResume();
        }
        super.onResume();
    }

    @Override
    protected void onPause() {
        Log.d(LOG_TAG, "onPause");
        if (videoPlayerView != null) {
            videoPlayerView.onPause();
        }
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        Log.d(LOG_TAG, "onDestroy");
        if (videoPlayerView != null) {
            videoPlayerView.onDestroy();
        }
        super.onDestroy();
    }

}
