/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.cast.utils;

import android.app.Activity;
import android.content.Context;
import com.akamai.amp.utils.LogManager;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;

public class CastSettings {
    public String TAG = this.getClass().getSimpleName();
    private String defaultAppId;
    private CastSession mCastSession;
    private String targetActivity;
    private final int PRELOAD_TIME_S = 20;
    private static CastSettings castSettings;

    public static CastSettings get() {
        if (castSettings == null) {
            castSettings = new CastSettings();
        }
        return castSettings;
    }

    public void setTargetActivity(Class<? extends Activity> activity) {
        this.targetActivity = activity.getName();
    }

    public int getPreloadTimeS() {
        return 20;
    }

    public void setAppId(String appId) {
        this.defaultAppId = appId;
    }

    public String getAppId() {
        return this.defaultAppId;
    }

    public String getTargetActivity() {
        return this.targetActivity;
    }

    public void overrideCastSession(CastSession castSession) {
        this.mCastSession = castSession;
    }

    public CastSession getCastSession() {
        return this.mCastSession;
    }

    public void updateCastSession(Context context) {
        this.mCastSession = this.getCastContext(context).getSessionManager().getCurrentCastSession();
    }

    public CastContext getCastContext(Context context) {
        return CastContext.getSharedInstance((Context)context);
    }

    public boolean isConnected(Context context) {
        this.updateCastSession(context);
        if (this.mCastSession == null) {
            LogManager.log((String)this.TAG, (String)"Cast Session is null, it can't be used");
            return false;
        }
        return this.mCastSession.isConnected();
    }

    public boolean isConnecting(Context context) {
        this.updateCastSession(context);
        if (this.mCastSession == null) {
            LogManager.log((String)this.TAG, (String)"Cast Session is null, it can't be used");
            return false;
        }
        return this.mCastSession.isConnecting();
    }

    public RemoteMediaClient getRemoteMediaClient(Context context) {
        if (!this.isConnected(context)) {
            LogManager.error((String)this.TAG, (String)"Trying to get a RemoteMediaClient when no CastSession is started");
            return null;
        }
        return this.getCastSession().getRemoteMediaClient();
    }
}

