/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.cast;

import android.content.Context;
import androidx.annotation.NonNull;
import com.akamai.amp.cast.utils.CastSettings;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.common.images.WebImage;
import java.util.Arrays;
import java.util.List;

public class CastOptionsProvider
implements OptionsProvider {
    public CastOptions getCastOptions(Context context) {
        String appId = CastSettings.get().getAppId();
        String targetActivity = CastSettings.get().getTargetActivity();
        NotificationOptions notificationOptions = this.buildNotificationOptions(targetActivity);
        CastMediaOptions mediaOptions = this.buildCastMediaOptions(targetActivity, notificationOptions);
        CastOptions castOptions = this.buildCastOptions(appId, mediaOptions);
        return castOptions;
    }

    @NonNull
    private CastOptions buildCastOptions(String appId, CastMediaOptions mediaOptions) {
        return new CastOptions.Builder().setReceiverApplicationId(appId).setCastMediaOptions(mediaOptions).build();
    }

    @NonNull
    private CastMediaOptions buildCastMediaOptions(String targetActivity, NotificationOptions notificationOptions) {
        return new CastMediaOptions.Builder().setImagePicker((ImagePicker)new ImagePickerImpl()).setNotificationOptions(notificationOptions).setExpandedControllerActivityClassName(targetActivity).build();
    }

    @NonNull
    private NotificationOptions buildNotificationOptions(String targetActivity) {
        return new NotificationOptions.Builder().setActions(Arrays.asList("com.google.android.gms.cast.framework.action.SKIP_NEXT", "com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK", "com.google.android.gms.cast.framework.action.STOP_CASTING"), new int[]{1, 2}).setTargetActivityClassName(targetActivity).build();
    }

    public List<SessionProvider> getAdditionalSessionProviders(Context appContext) {
        return null;
    }

    private static class ImagePickerImpl
    extends ImagePicker {
        private ImagePickerImpl() {
        }

        public WebImage onPickImage(MediaMetadata mediaMetadata, int type) {
            if (mediaMetadata == null || !mediaMetadata.hasImages()) {
                return null;
            }
            List images = mediaMetadata.getImages();
            if (images.size() == 1) {
                return (WebImage)images.get(0);
            }
            if (type == 0) {
                return (WebImage)images.get(0);
            }
            return (WebImage)images.get(1);
        }
    }
}

