/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.cast;

import android.app.Activity;
import android.content.Context;
import com.akamai.amp.cast.AmpCastManager;
import com.akamai.amp.cast.CastHandler;
import com.akamai.amp.cast.OTTDeviceEventsListener;
import com.akamai.amp.cast.queue.AmpQueueManager;
import com.akamai.amp.cast.queue.QueueProvider;
import com.akamai.amp.cast.utils.CastSettings;
import com.akamai.amp.media.VideoPlayerContainer;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;

public class AmpCAF {

    public static class Builder {
        AmpCastManager ampCastManager;
        AmpQueueManager ampQueueManager;
        Context context;

        public Builder(Context context) {
            this.context = context;
            this.ampCastManager = new CastHandler(context);
        }

        public Builder withSessionManagerListener(SessionManagerListener sessionManagerListener) {
            this.ampCastManager.setSessionManagerListener(sessionManagerListener);
            return this;
        }

        public Builder withRemoteMediaClientCallback(RemoteMediaClient.Callback remoteMediaClientCallback) {
            this.ampCastManager.setRemoteMediaClientCallback(remoteMediaClientCallback);
            return this;
        }

        public Builder withCastStateListener(CastStateListener castStateListener) {
            this.ampCastManager.setCastStateListener(castStateListener);
            return this;
        }

        public Builder withAppId(String appId) {
            CastSettings.get().setAppId(appId);
            return this;
        }

        public Builder withVideoPlayerContainer(VideoPlayerContainer videoPlayerContainer) {
            this.ampCastManager.setVideoplayerContainer(videoPlayerContainer);
            return this;
        }

        public Builder withOTTDeviceEventsListener(OTTDeviceEventsListener ottDeviceEventsListener) {
            this.ampCastManager.setOTTDeviceEventsListener(ottDeviceEventsListener);
            return this;
        }

        public Builder withTargetActivity(Class<? extends Activity> activity) {
            CastSettings.get().setTargetActivity(activity);
            return this;
        }

        public Builder withQueue(boolean enableQueue) {
            if (this.context != null && enableQueue) {
                this.ampQueueManager = QueueProvider.getInstance(this.context);
                this.ampCastManager.setQueueManager(this.ampQueueManager);
            }
            return this;
        }

        public AmpCastManager build() {
            return this.ampCastManager;
        }
    }
}

