/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.mae;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.akamai.amp.utils.LogManager;
import com.akamai.lmsclientsdk.proxy.LMSProxyAPI;
import com.akamai.lmsclientsdk.proxy.LMSProxyPlayer;
import java.io.IOException;
import java.net.BindException;
import org.json.JSONException;
import org.json.JSONObject;

public class LmsManager {
    private LMSProxyAPI lmsProxyApi;
    private boolean multicastEnabled;
    private LMSProxyPlayer lmsProxyPlayer;
    public static LmsManager instance;
    public String configJsonString;

    public static LmsManager getManager() {
        if (instance == null) {
            instance = new LmsManager();
        }
        return instance;
    }

    public void createLmsProxy(Context context, boolean debug) {
        try {
            this.lmsProxyApi = new LMSProxyAPI(context, debug);
        }
        catch (BindException e) {
            LogManager.log(LmsManager.class.getName(), "An error occurred while trying to instantiate the LMS Proxy SDK: " + e);
        }
    }

    public String startMulticast(String resourceURL) {
        if (this.lmsProxyPlayer == null) {
            return resourceURL;
        }
        try {
            Uri streamUri = Uri.parse((String)resourceURL);
            Uri localUri = this.lmsProxyPlayer.play(streamUri, this.getConfigObject());
            return localUri.toString();
        }
        catch (IOException e) {
            Log.d((String)LmsManager.class.getName(), (String)("An error occurred while trying to play through the LMS Proxy SDK: " + e));
            return resourceURL;
        }
    }

    private JSONObject getConfigObject() {
        JSONObject configResult = null;
        try {
            if (this.configJsonString != null) {
                configResult = new JSONObject(this.configJsonString);
            }
        }
        catch (JSONException e) {
            Log.d((String)LmsManager.class.getName(), (String)"No valid LMS configuration was found");
        }
        return configResult;
    }

    public boolean isMulticastEnabled() {
        return this.multicastEnabled;
    }

    public void setMulticast(boolean enabled) {
        this.multicastEnabled = enabled;
    }

    public void setLmsProxyPlayer() {
        if (this.lmsProxyApi != null) {
            this.lmsProxyPlayer = this.lmsProxyApi.createPlayer();
        }
    }

    public void enableMulticast(Context context, boolean debug, String config) {
        this.configJsonString = config;
        this.setMulticast(true);
        this.createLmsProxy(context, debug);
        this.setLmsProxyPlayer();
    }

    public void disableMulticast() {
        this.setMulticast(false);
    }

    public void stopMulticast() {
        if (this.lmsProxyPlayer != null) {
            this.lmsProxyPlayer.stop();
        }
    }

    public void releaseMulticast() {
        if (this.lmsProxyApi != null) {
            this.lmsProxyApi.release();
        }
    }

    public JSONObject getStats() {
        if (this.lmsProxyPlayer != null) {
            return this.lmsProxyPlayer.getStats();
        }
        return null;
    }
}

