/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.id3;

import android.util.Log;
import androidx.annotation.NonNull;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.metadata.id3.Id3Frame;
import com.akamai.amp.id3.ID3TagData;
import com.akamai.amp.id3.ID3TagEventListener;
import com.akamai.amp.media.VideoPlayerViewExo;
import java.util.ArrayList;
import java.util.List;

public class ID3TagsSessionHandler {
    private static final String LOG_TAG = ID3TagsSessionHandler.class.getSimpleName();
    public static final String VERSION = "9.10.7";
    private final List<ID3TagEventListener> mListeners = new ArrayList<ID3TagEventListener>();
    private VideoPlayerViewExo mVideoPlayerView;
    private final MetadataOutput metadataOutput = metadata -> {
        ID3TagData id3Data = this.convert(metadata);
        this.notifyListeners(id3Data);
    };

    public void addEventListener(ID3TagEventListener listener) {
        if (listener == null) {
            return;
        }
        this.mListeners.add(listener);
    }

    public void removeEventListener(ID3TagEventListener listener) {
        this.mListeners.remove(listener);
    }

    public void removeAllEventListeners() {
        this.mListeners.clear();
    }

    public void setVideoPlayerView(VideoPlayerViewExo videoPlayerView) {
        this.mVideoPlayerView = videoPlayerView;
        this.mVideoPlayerView.setID3MetadataListener(this.getMetadataOutput());
    }

    private MetadataOutput getMetadataOutput() {
        return this.metadataOutput;
    }

    @NonNull
    private ID3TagData convert(Metadata metadata) {
        return new ID3TagData(this.getTxxxText(metadata), this.mVideoPlayerView.getCurrentStreamPositionMS(), metadata);
    }

    private String getTxxxText(Metadata metadata) {
        if (metadata != null) {
            for (int i = 0; i < metadata.length(); ++i) {
                Metadata.Entry entry = metadata.get(i);
                if (entry == null) {
                    Log.e((String)LOG_TAG, (String)"NULL Metadata.Entry found");
                    continue;
                }
                if (!(entry instanceof Id3Frame)) continue;
                Id3Frame frame = (Id3Frame)entry;
                return frame.getValue();
            }
        }
        return "";
    }

    private void notifyListeners(ID3TagData dataForPosition) {
        for (ID3TagEventListener listener : this.mListeners) {
            if (listener == null) continue;
            listener.onFoundID3TagData(dataForPosition);
        }
    }
}

