/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.os.Looper;
import android.widget.TextView;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.SimpleExoPlayer;
import com.akamai.amp.exoplayer2.decoder.DecoderCounters;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.util.Locale;

public class DebugTextViewHelper
implements Player.EventListener,
Runnable {
    private static final int REFRESH_INTERVAL_MS = 1000;
    private final SimpleExoPlayer player;
    private final TextView textView;
    private boolean started;

    public DebugTextViewHelper(SimpleExoPlayer player, TextView textView) {
        Assertions.checkArgument(player.getApplicationLooper() == Looper.getMainLooper());
        this.player = player;
        this.textView = textView;
    }

    public final void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.player.addListener(this);
        this.updateAndPost();
    }

    public final void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.player.removeListener(this);
        this.textView.removeCallbacks((Runnable)this);
    }

    @Override
    public final void onPlaybackStateChanged(int playbackState) {
        this.updateAndPost();
    }

    @Override
    public final void onPlayWhenReadyChanged(boolean playWhenReady, int playbackState) {
        this.updateAndPost();
    }

    @Override
    public final void onPositionDiscontinuity(int reason) {
        this.updateAndPost();
    }

    @Override
    public final void run() {
        this.updateAndPost();
    }

    @SuppressLint(value={"SetTextI18n"})
    protected final void updateAndPost() {
        this.textView.setText((CharSequence)this.getDebugString());
        this.textView.removeCallbacks((Runnable)this);
        this.textView.postDelayed((Runnable)this, 1000L);
    }

    protected String getDebugString() {
        return this.getPlayerStateString() + this.getVideoString() + this.getAudioString();
    }

    protected String getPlayerStateString() {
        return String.format("playWhenReady:%s playbackState:%s window:%s", this.player.getPlayWhenReady(), switch (this.player.getPlaybackState()) {
            case 2 -> "buffering";
            case 4 -> "ended";
            case 1 -> "idle";
            case 3 -> "ready";
            default -> "unknown";
        }, this.player.getCurrentWindowIndex());
    }

    protected String getVideoString() {
        Format format = this.player.getVideoFormat();
        DecoderCounters decoderCounters = this.player.getVideoDecoderCounters();
        if (format == null || decoderCounters == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " r:" + format.width + "x" + format.height + DebugTextViewHelper.getPixelAspectRatioString(format.pixelWidthHeightRatio) + DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters) + " vfpo: " + DebugTextViewHelper.getVideoFrameProcessingOffsetAverageString(decoderCounters.totalVideoFrameProcessingOffsetUs, decoderCounters.videoFrameProcessingOffsetCount) + ")";
    }

    protected String getAudioString() {
        Format format = this.player.getAudioFormat();
        DecoderCounters decoderCounters = this.player.getAudioDecoderCounters();
        if (format == null || decoderCounters == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " hz:" + format.sampleRate + " ch:" + format.channelCount + DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters) + ")";
    }

    private static String getDecoderCountersBufferCountString(DecoderCounters counters) {
        if (counters == null) {
            return "";
        }
        counters.ensureUpdated();
        return " sib:" + counters.skippedInputBufferCount + " sb:" + counters.skippedOutputBufferCount + " rb:" + counters.renderedOutputBufferCount + " db:" + counters.droppedBufferCount + " mcdb:" + counters.maxConsecutiveDroppedBufferCount + " dk:" + counters.droppedToKeyframeCount;
    }

    private static String getPixelAspectRatioString(float pixelAspectRatio) {
        return pixelAspectRatio == -1.0f || pixelAspectRatio == 1.0f ? "" : " par:" + String.format(Locale.US, "%.02f", Float.valueOf(pixelAspectRatio));
    }

    private static String getVideoFrameProcessingOffsetAverageString(long totalOffsetUs, int frameCount) {
        if (frameCount == 0) {
            return "N/A";
        }
        long averageUs = (long)((double)totalOffsetUs / (double)frameCount);
        return String.valueOf(averageUs);
    }
}

