/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.decoder.OutputBuffer;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.Subtitle;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.util.List;

public abstract class SubtitleOutputBuffer
extends OutputBuffer
implements Subtitle {
    @Nullable
    private Subtitle subtitle;
    private long subsampleOffsetUs;

    public void setContent(long timeUs, Subtitle subtitle, long subsampleOffsetUs) {
        this.timeUs = timeUs;
        this.subtitle = subtitle;
        this.subsampleOffsetUs = subsampleOffsetUs == Long.MAX_VALUE ? this.timeUs : subsampleOffsetUs;
    }

    @Override
    public int getEventTimeCount() {
        return Assertions.checkNotNull(this.subtitle).getEventTimeCount();
    }

    @Override
    public long getEventTime(int index) {
        return Assertions.checkNotNull(this.subtitle).getEventTime(index) + this.subsampleOffsetUs;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        return Assertions.checkNotNull(this.subtitle).getNextEventTimeIndex(timeUs - this.subsampleOffsetUs);
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        return Assertions.checkNotNull(this.subtitle).getCues(timeUs - this.subsampleOffsetUs);
    }

    @Override
    public void clear() {
        super.clear();
        this.subtitle = null;
    }
}

