/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.hls;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HlsTrackMetadataEntry
implements Metadata.Entry {
    @Nullable
    public final String groupId;
    @Nullable
    public final String name;
    public final List<VariantInfo> variantInfos;
    public static final Parcelable.Creator<HlsTrackMetadataEntry> CREATOR = new Parcelable.Creator<HlsTrackMetadataEntry>(){

        public HlsTrackMetadataEntry createFromParcel(Parcel in) {
            return new HlsTrackMetadataEntry(in);
        }

        public HlsTrackMetadataEntry[] newArray(int size) {
            return new HlsTrackMetadataEntry[size];
        }
    };

    public HlsTrackMetadataEntry(@Nullable String groupId, @Nullable String name, List<VariantInfo> variantInfos) {
        this.groupId = groupId;
        this.name = name;
        this.variantInfos = Collections.unmodifiableList(new ArrayList<VariantInfo>(variantInfos));
    }

    HlsTrackMetadataEntry(Parcel in) {
        this.groupId = in.readString();
        this.name = in.readString();
        int variantInfoSize = in.readInt();
        ArrayList<VariantInfo> variantInfos = new ArrayList<VariantInfo>(variantInfoSize);
        for (int i = 0; i < variantInfoSize; ++i) {
            variantInfos.add((VariantInfo)in.readParcelable(VariantInfo.class.getClassLoader()));
        }
        this.variantInfos = Collections.unmodifiableList(variantInfos);
    }

    public String toString() {
        return "HlsTrackMetadataEntry" + (this.groupId != null ? " [" + this.groupId + ", " + this.name + "]" : "");
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HlsTrackMetadataEntry that = (HlsTrackMetadataEntry)other;
        return TextUtils.equals((CharSequence)this.groupId, (CharSequence)that.groupId) && TextUtils.equals((CharSequence)this.name, (CharSequence)that.name) && this.variantInfos.equals(that.variantInfos);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.variantInfos.hashCode();
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.groupId);
        dest.writeString(this.name);
        int variantInfosSize = this.variantInfos.size();
        dest.writeInt(variantInfosSize);
        for (int i = 0; i < variantInfosSize; ++i) {
            dest.writeParcelable((Parcelable)this.variantInfos.get(i), 0);
        }
    }

    public static final class VariantInfo
    implements Parcelable {
        public final int averageBitrate;
        public final int peakBitrate;
        @Nullable
        public final String videoGroupId;
        @Nullable
        public final String audioGroupId;
        @Nullable
        public final String subtitleGroupId;
        @Nullable
        public final String captionGroupId;
        public static final Parcelable.Creator<VariantInfo> CREATOR = new Parcelable.Creator<VariantInfo>(){

            public VariantInfo createFromParcel(Parcel in) {
                return new VariantInfo(in);
            }

            public VariantInfo[] newArray(int size) {
                return new VariantInfo[size];
            }
        };

        public VariantInfo(int averageBitrate, int peakBitrate, @Nullable String videoGroupId, @Nullable String audioGroupId, @Nullable String subtitleGroupId, @Nullable String captionGroupId) {
            this.averageBitrate = averageBitrate;
            this.peakBitrate = peakBitrate;
            this.videoGroupId = videoGroupId;
            this.audioGroupId = audioGroupId;
            this.subtitleGroupId = subtitleGroupId;
            this.captionGroupId = captionGroupId;
        }

        VariantInfo(Parcel in) {
            this.averageBitrate = in.readInt();
            this.peakBitrate = in.readInt();
            this.videoGroupId = in.readString();
            this.audioGroupId = in.readString();
            this.subtitleGroupId = in.readString();
            this.captionGroupId = in.readString();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            VariantInfo that = (VariantInfo)other;
            return this.averageBitrate == that.averageBitrate && this.peakBitrate == that.peakBitrate && TextUtils.equals((CharSequence)this.videoGroupId, (CharSequence)that.videoGroupId) && TextUtils.equals((CharSequence)this.audioGroupId, (CharSequence)that.audioGroupId) && TextUtils.equals((CharSequence)this.subtitleGroupId, (CharSequence)that.subtitleGroupId) && TextUtils.equals((CharSequence)this.captionGroupId, (CharSequence)that.captionGroupId);
        }

        public int hashCode() {
            int result = this.averageBitrate;
            result = 31 * result + this.peakBitrate;
            result = 31 * result + (this.videoGroupId != null ? this.videoGroupId.hashCode() : 0);
            result = 31 * result + (this.audioGroupId != null ? this.audioGroupId.hashCode() : 0);
            result = 31 * result + (this.subtitleGroupId != null ? this.subtitleGroupId.hashCode() : 0);
            result = 31 * result + (this.captionGroupId != null ? this.captionGroupId.hashCode() : 0);
            return result;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.averageBitrate);
            dest.writeInt(this.peakBitrate);
            dest.writeString(this.videoGroupId);
            dest.writeString(this.audioGroupId);
            dest.writeString(this.subtitleGroupId);
            dest.writeString(this.captionGroupId);
        }
    }
}

