/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.hls;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.extractor.Extractor;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.extractor.mp3.Mp3Extractor;
import com.akamai.amp.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.akamai.amp.exoplayer2.extractor.ts.Ac3Extractor;
import com.akamai.amp.exoplayer2.extractor.ts.Ac4Extractor;
import com.akamai.amp.exoplayer2.extractor.ts.AdtsExtractor;
import com.akamai.amp.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.akamai.amp.exoplayer2.extractor.ts.TsExtractor;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.source.hls.BundledHlsMediaChunkExtractor;
import com.akamai.amp.exoplayer2.source.hls.HlsExtractorFactory;
import com.akamai.amp.exoplayer2.source.hls.HlsTrackMetadataEntry;
import com.akamai.amp.exoplayer2.source.hls.WebvttExtractor;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.FileTypes;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.TimestampAdjuster;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DefaultHlsExtractorFactory
implements HlsExtractorFactory {
    private static final int[] DEFAULT_EXTRACTOR_ORDER = new int[]{8, 13, 11, 2, 0, 1, 7};
    private final int payloadReaderFactoryFlags;
    private final boolean exposeCea608WhenMissingDeclarations;

    public DefaultHlsExtractorFactory() {
        this(0, true);
    }

    public DefaultHlsExtractorFactory(int payloadReaderFactoryFlags, boolean exposeCea608WhenMissingDeclarations) {
        this.payloadReaderFactoryFlags = payloadReaderFactoryFlags;
        this.exposeCea608WhenMissingDeclarations = exposeCea608WhenMissingDeclarations;
    }

    @Override
    public BundledHlsMediaChunkExtractor createExtractor(Uri uri, Format format, @Nullable List<Format> muxedCaptionFormats, TimestampAdjuster timestampAdjuster, Map<String, List<String>> responseHeaders, ExtractorInput extractorInput) throws IOException {
        int formatInferredFileType = FileTypes.inferFileTypeFromMimeType(format.sampleMimeType);
        int responseHeadersInferredFileType = FileTypes.inferFileTypeFromResponseHeaders(responseHeaders);
        int uriInferredFileType = FileTypes.inferFileTypeFromUri(uri);
        ArrayList<Integer> fileTypeOrder = new ArrayList<Integer>(DEFAULT_EXTRACTOR_ORDER.length);
        DefaultHlsExtractorFactory.addFileTypeIfNotPresent(formatInferredFileType, fileTypeOrder);
        DefaultHlsExtractorFactory.addFileTypeIfNotPresent(responseHeadersInferredFileType, fileTypeOrder);
        DefaultHlsExtractorFactory.addFileTypeIfNotPresent(uriInferredFileType, fileTypeOrder);
        for (int fileType : DEFAULT_EXTRACTOR_ORDER) {
            DefaultHlsExtractorFactory.addFileTypeIfNotPresent(fileType, fileTypeOrder);
        }
        Extractor fallBackExtractor = null;
        extractorInput.resetPeekPosition();
        for (int i = 0; i < fileTypeOrder.size(); ++i) {
            int fileType = (Integer)fileTypeOrder.get(i);
            Extractor extractor = Assertions.checkNotNull(this.createExtractorByFileType(fileType, format, muxedCaptionFormats, timestampAdjuster));
            if (DefaultHlsExtractorFactory.sniffQuietly(extractor, extractorInput)) {
                return new BundledHlsMediaChunkExtractor(extractor, format, timestampAdjuster);
            }
            if (fileType != 11) continue;
            fallBackExtractor = extractor;
        }
        return new BundledHlsMediaChunkExtractor(Assertions.checkNotNull(fallBackExtractor), format, timestampAdjuster);
    }

    private static void addFileTypeIfNotPresent(int fileType, List<Integer> fileTypes) {
        if (fileType == -1 || fileTypes.contains(fileType)) {
            return;
        }
        fileTypes.add(fileType);
    }

    @Nullable
    private Extractor createExtractorByFileType(int fileType, Format format, @Nullable List<Format> muxedCaptionFormats, TimestampAdjuster timestampAdjuster) {
        switch (fileType) {
            case 13: {
                return new WebvttExtractor(format.language, timestampAdjuster);
            }
            case 2: {
                return new AdtsExtractor();
            }
            case 0: {
                return new Ac3Extractor();
            }
            case 1: {
                return new Ac4Extractor();
            }
            case 7: {
                return new Mp3Extractor(0, 0L);
            }
            case 8: {
                return DefaultHlsExtractorFactory.createFragmentedMp4Extractor(timestampAdjuster, format, muxedCaptionFormats);
            }
            case 11: {
                return DefaultHlsExtractorFactory.createTsExtractor(this.payloadReaderFactoryFlags, this.exposeCea608WhenMissingDeclarations, format, muxedCaptionFormats, timestampAdjuster);
            }
        }
        return null;
    }

    private static TsExtractor createTsExtractor(int userProvidedPayloadReaderFactoryFlags, boolean exposeCea608WhenMissingDeclarations, Format format, @Nullable List<Format> muxedCaptionFormats, TimestampAdjuster timestampAdjuster) {
        int payloadReaderFactoryFlags = 0x10 | userProvidedPayloadReaderFactoryFlags;
        if (muxedCaptionFormats != null) {
            payloadReaderFactoryFlags |= 0x20;
        } else {
            muxedCaptionFormats = exposeCea608WhenMissingDeclarations ? Collections.singletonList(new Format.Builder().setSampleMimeType("application/cea-608").build()) : Collections.emptyList();
        }
        String codecs = format.codecs;
        if (!TextUtils.isEmpty((CharSequence)codecs)) {
            if (!MimeTypes.containsCodecsCorrespondingToMimeType(codecs, "audio/mp4a-latm")) {
                payloadReaderFactoryFlags |= 2;
            }
            if (!MimeTypes.containsCodecsCorrespondingToMimeType(codecs, "video/avc")) {
                payloadReaderFactoryFlags |= 4;
            }
        }
        return new TsExtractor(2, timestampAdjuster, new DefaultTsPayloadReaderFactory(payloadReaderFactoryFlags, muxedCaptionFormats));
    }

    private static FragmentedMp4Extractor createFragmentedMp4Extractor(TimestampAdjuster timestampAdjuster, Format format, @Nullable List<Format> muxedCaptionFormats) {
        return new FragmentedMp4Extractor(DefaultHlsExtractorFactory.isFmp4Variant(format) ? 4 : 0, timestampAdjuster, null, muxedCaptionFormats != null ? muxedCaptionFormats : Collections.emptyList());
    }

    private static boolean isFmp4Variant(Format format) {
        Metadata metadata = format.metadata;
        if (metadata == null) {
            return false;
        }
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (!(entry instanceof HlsTrackMetadataEntry)) continue;
            return !((HlsTrackMetadataEntry)entry).variantInfos.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sniffQuietly(Extractor extractor, ExtractorInput input) throws IOException {
        boolean result = false;
        try {
            result = extractor.sniff(input);
        }
        catch (EOFException eOFException) {
        }
        finally {
            input.resetPeekPosition();
        }
        return result;
    }
}

