/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.SampleStream;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class MaskingMediaPeriod
implements MediaPeriod,
MediaPeriod.Callback {
    public final MediaSource.MediaPeriodId id;
    private final long preparePositionUs;
    private final Allocator allocator;
    private @MonotonicNonNull MediaSource mediaSource;
    private @MonotonicNonNull MediaPeriod mediaPeriod;
    @Nullable
    private MediaPeriod.Callback callback;
    @Nullable
    private PrepareListener listener;
    private boolean notifiedPrepareError;
    private long preparePositionOverrideUs;

    public MaskingMediaPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long preparePositionUs) {
        this.id = id;
        this.allocator = allocator;
        this.preparePositionUs = preparePositionUs;
        this.preparePositionOverrideUs = -9223372036854775807L;
    }

    public void setPrepareListener(PrepareListener listener) {
        this.listener = listener;
    }

    public long getPreparePositionUs() {
        return this.preparePositionUs;
    }

    public void overridePreparePositionUs(long preparePositionUs) {
        this.preparePositionOverrideUs = preparePositionUs;
    }

    public long getPreparePositionOverrideUs() {
        return this.preparePositionOverrideUs;
    }

    public void setMediaSource(MediaSource mediaSource) {
        Assertions.checkState(this.mediaSource == null);
        this.mediaSource = mediaSource;
    }

    public void createPeriod(MediaSource.MediaPeriodId id) {
        long preparePositionUs = this.getPreparePositionWithOverride(this.preparePositionUs);
        this.mediaPeriod = Assertions.checkNotNull(this.mediaSource).createPeriod(id, this.allocator, preparePositionUs);
        if (this.callback != null) {
            this.mediaPeriod.prepare(this, preparePositionUs);
        }
    }

    public void releasePeriod() {
        if (this.mediaPeriod != null) {
            Assertions.checkNotNull(this.mediaSource).releasePeriod(this.mediaPeriod);
        }
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long preparePositionUs) {
        this.callback = callback;
        if (this.mediaPeriod != null) {
            this.mediaPeriod.prepare(this, this.getPreparePositionWithOverride(this.preparePositionUs));
        }
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        block6: {
            try {
                if (this.mediaPeriod != null) {
                    this.mediaPeriod.maybeThrowPrepareError();
                } else if (this.mediaSource != null) {
                    this.mediaSource.maybeThrowSourceInfoRefreshError();
                }
            }
            catch (IOException e) {
                if (this.listener == null) {
                    throw e;
                }
                if (this.notifiedPrepareError) break block6;
                this.notifiedPrepareError = true;
                this.listener.onPrepareError(this.id, e);
            }
        }
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return Util.castNonNull(this.mediaPeriod).getTrackGroups();
    }

    @Override
    public long selectTracks(@NullableType TrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        if (this.preparePositionOverrideUs != -9223372036854775807L && positionUs == this.preparePositionUs) {
            positionUs = this.preparePositionOverrideUs;
            this.preparePositionOverrideUs = -9223372036854775807L;
        }
        return Util.castNonNull(this.mediaPeriod).selectTracks(selections, mayRetainStreamFlags, streams, streamResetFlags, positionUs);
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        Util.castNonNull(this.mediaPeriod).discardBuffer(positionUs, toKeyframe);
    }

    @Override
    public long readDiscontinuity() {
        return Util.castNonNull(this.mediaPeriod).readDiscontinuity();
    }

    @Override
    public long getBufferedPositionUs() {
        return Util.castNonNull(this.mediaPeriod).getBufferedPositionUs();
    }

    @Override
    public long seekToUs(long positionUs) {
        return Util.castNonNull(this.mediaPeriod).seekToUs(positionUs);
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return Util.castNonNull(this.mediaPeriod).getAdjustedSeekPositionUs(positionUs, seekParameters);
    }

    @Override
    public long getNextLoadPositionUs() {
        return Util.castNonNull(this.mediaPeriod).getNextLoadPositionUs();
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        Util.castNonNull(this.mediaPeriod).reevaluateBuffer(positionUs);
    }

    @Override
    public boolean continueLoading(long positionUs) {
        return this.mediaPeriod != null && this.mediaPeriod.continueLoading(positionUs);
    }

    @Override
    public boolean isLoading() {
        return this.mediaPeriod != null && this.mediaPeriod.isLoading();
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod source) {
        Util.castNonNull(this.callback).onContinueLoadingRequested(this);
    }

    @Override
    public void onPrepared(MediaPeriod mediaPeriod) {
        Util.castNonNull(this.callback).onPrepared(this);
        if (this.listener != null) {
            this.listener.onPrepareComplete(this.id);
        }
    }

    private long getPreparePositionWithOverride(long preparePositionUs) {
        return this.preparePositionOverrideUs != -9223372036854775807L ? this.preparePositionOverrideUs : preparePositionUs;
    }

    public static interface PrepareListener {
        public void onPrepareComplete(MediaSource.MediaPeriodId var1);

        public void onPrepareError(MediaSource.MediaPeriodId var1, IOException var2);
    }
}

