/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.mediacodec;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.decoder.CryptoInfo;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecInputBufferEnqueuer;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.ConditionVariable;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@RequiresApi(value=23)
class AsynchronousMediaCodecBufferEnqueuer
implements MediaCodecInputBufferEnqueuer {
    private static final int MSG_QUEUE_INPUT_BUFFER = 0;
    private static final int MSG_QUEUE_SECURE_INPUT_BUFFER = 1;
    private static final int MSG_FLUSH = 2;
    @GuardedBy(value="MESSAGE_PARAMS_INSTANCE_POOL")
    private static final ArrayDeque<MessageParams> MESSAGE_PARAMS_INSTANCE_POOL = new ArrayDeque();
    private static final Object QUEUE_SECURE_LOCK = new Object();
    private final MediaCodec codec;
    private final HandlerThread handlerThread;
    private @MonotonicNonNull Handler handler;
    private final AtomicReference<@NullableType RuntimeException> pendingRuntimeException;
    private final ConditionVariable conditionVariable;
    private final boolean needsSynchronizationWorkaround;
    private boolean started;

    public AsynchronousMediaCodecBufferEnqueuer(MediaCodec codec, int trackType) {
        this(codec, new HandlerThread(AsynchronousMediaCodecBufferEnqueuer.createThreadLabel(trackType)), new ConditionVariable());
    }

    @VisibleForTesting
    AsynchronousMediaCodecBufferEnqueuer(MediaCodec codec, HandlerThread handlerThread, ConditionVariable conditionVariable) {
        this.codec = codec;
        this.handlerThread = handlerThread;
        this.conditionVariable = conditionVariable;
        this.pendingRuntimeException = new AtomicReference();
        this.needsSynchronizationWorkaround = AsynchronousMediaCodecBufferEnqueuer.needsSynchronizationWorkaround();
    }

    @Override
    public void start() {
        if (!this.started) {
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper()){

                public void handleMessage(Message msg) {
                    AsynchronousMediaCodecBufferEnqueuer.this.doHandleMessage(msg);
                }
            };
            this.started = true;
        }
    }

    @Override
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        this.maybeThrowException();
        MessageParams messageParams = AsynchronousMediaCodecBufferEnqueuer.getMessageParams();
        messageParams.setQueueParams(index, offset, size, presentationTimeUs, flags);
        Message message = Util.castNonNull(this.handler).obtainMessage(0, (Object)messageParams);
        message.sendToTarget();
    }

    @Override
    public void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) {
        this.maybeThrowException();
        MessageParams messageParams = AsynchronousMediaCodecBufferEnqueuer.getMessageParams();
        messageParams.setQueueParams(index, offset, 0, presentationTimeUs, flags);
        AsynchronousMediaCodecBufferEnqueuer.copy(info, messageParams.cryptoInfo);
        Message message = Util.castNonNull(this.handler).obtainMessage(1, (Object)messageParams);
        message.sendToTarget();
    }

    @Override
    public void flush() {
        if (this.started) {
            try {
                this.flushHandlerThread();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.started) {
            this.flush();
            this.handlerThread.quit();
        }
        this.started = false;
    }

    private void doHandleMessage(Message msg) {
        MessageParams params = null;
        switch (msg.what) {
            case 0: {
                params = (MessageParams)msg.obj;
                this.doQueueInputBuffer(params.index, params.offset, params.size, params.presentationTimeUs, params.flags);
                break;
            }
            case 1: {
                params = (MessageParams)msg.obj;
                this.doQueueSecureInputBuffer(params.index, params.offset, params.cryptoInfo, params.presentationTimeUs, params.flags);
                break;
            }
            case 2: {
                this.conditionVariable.open();
                break;
            }
            default: {
                this.setPendingRuntimeException(new IllegalStateException(String.valueOf(msg.what)));
            }
        }
        if (params != null) {
            AsynchronousMediaCodecBufferEnqueuer.recycleMessageParams(params);
        }
    }

    private void maybeThrowException() {
        RuntimeException exception = this.pendingRuntimeException.getAndSet(null);
        if (exception != null) {
            throw exception;
        }
    }

    private void flushHandlerThread() throws InterruptedException {
        Handler handler = Util.castNonNull(this.handler);
        handler.removeCallbacksAndMessages(null);
        this.conditionVariable.close();
        handler.obtainMessage(2).sendToTarget();
        this.conditionVariable.block();
        this.maybeThrowException();
    }

    @VisibleForTesting
    void setPendingRuntimeException(RuntimeException exception) {
        this.pendingRuntimeException.set(exception);
    }

    private void doQueueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flag) {
        try {
            this.codec.queueInputBuffer(index, offset, size, presentationTimeUs, flag);
        }
        catch (RuntimeException e) {
            this.setPendingRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueueSecureInputBuffer(int index, int offset, MediaCodec.CryptoInfo info, long presentationTimeUs, int flags) {
        block6: {
            try {
                if (this.needsSynchronizationWorkaround) {
                    Object object = QUEUE_SECURE_LOCK;
                    synchronized (object) {
                        this.codec.queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
                        break block6;
                    }
                }
                this.codec.queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
            }
            catch (RuntimeException e) {
                this.setPendingRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static int getInstancePoolSize() {
        ArrayDeque<MessageParams> arrayDeque = MESSAGE_PARAMS_INSTANCE_POOL;
        synchronized (arrayDeque) {
            return MESSAGE_PARAMS_INSTANCE_POOL.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MessageParams getMessageParams() {
        ArrayDeque<MessageParams> arrayDeque = MESSAGE_PARAMS_INSTANCE_POOL;
        synchronized (arrayDeque) {
            if (MESSAGE_PARAMS_INSTANCE_POOL.isEmpty()) {
                return new MessageParams();
            }
            return MESSAGE_PARAMS_INSTANCE_POOL.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleMessageParams(MessageParams params) {
        ArrayDeque<MessageParams> arrayDeque = MESSAGE_PARAMS_INSTANCE_POOL;
        synchronized (arrayDeque) {
            MESSAGE_PARAMS_INSTANCE_POOL.add(params);
        }
    }

    private static boolean needsSynchronizationWorkaround() {
        String manufacturer = Util.toLowerInvariant(Util.MANUFACTURER);
        return manufacturer.contains("samsung") || manufacturer.contains("motorola");
    }

    private static String createThreadLabel(int trackType) {
        StringBuilder labelBuilder = new StringBuilder("ExoPlayer:MediaCodecBufferEnqueuer:");
        if (trackType == 1) {
            labelBuilder.append("Audio");
        } else if (trackType == 2) {
            labelBuilder.append("Video");
        } else {
            labelBuilder.append("Unknown(").append(trackType).append(")");
        }
        return labelBuilder.toString();
    }

    private static void copy(CryptoInfo cryptoInfo, MediaCodec.CryptoInfo frameworkCryptoInfo) {
        frameworkCryptoInfo.numSubSamples = cryptoInfo.numSubSamples;
        frameworkCryptoInfo.numBytesOfClearData = AsynchronousMediaCodecBufferEnqueuer.copy(cryptoInfo.numBytesOfClearData, frameworkCryptoInfo.numBytesOfClearData);
        frameworkCryptoInfo.numBytesOfEncryptedData = AsynchronousMediaCodecBufferEnqueuer.copy(cryptoInfo.numBytesOfEncryptedData, frameworkCryptoInfo.numBytesOfEncryptedData);
        frameworkCryptoInfo.key = Assertions.checkNotNull(AsynchronousMediaCodecBufferEnqueuer.copy(cryptoInfo.key, frameworkCryptoInfo.key));
        frameworkCryptoInfo.iv = Assertions.checkNotNull(AsynchronousMediaCodecBufferEnqueuer.copy(cryptoInfo.iv, frameworkCryptoInfo.iv));
        frameworkCryptoInfo.mode = cryptoInfo.mode;
        if (Util.SDK_INT >= 24) {
            MediaCodec.CryptoInfo.Pattern pattern = new MediaCodec.CryptoInfo.Pattern(cryptoInfo.encryptedBlocks, cryptoInfo.clearBlocks);
            frameworkCryptoInfo.setPattern(pattern);
        }
    }

    @Nullable
    private static int[] copy(@Nullable int[] src, @Nullable int[] dst) {
        if (src == null) {
            return dst;
        }
        if (dst == null || dst.length < src.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Nullable
    private static byte[] copy(@Nullable byte[] src, @Nullable byte[] dst) {
        if (src == null) {
            return dst;
        }
        if (dst == null || dst.length < src.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private static class MessageParams {
        public int index;
        public int offset;
        public int size;
        public final MediaCodec.CryptoInfo cryptoInfo = new MediaCodec.CryptoInfo();
        public long presentationTimeUs;
        public int flags;

        MessageParams() {
        }

        public void setQueueParams(int index, int offset, int size, long presentationTimeUs, int flags) {
            this.index = index;
            this.offset = offset;
            this.size = size;
            this.presentationTimeUs = presentationTimeUs;
            this.flags = flags;
        }
    }
}

