/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.ampcustom;

import com.akamai.amp.exoplayer2.ampcustom.SntpClient;

public class LowLatencySettings {
    public static final int DEFAULT_TARGET_BUFFER_MS = 3000;
    public static final int DEFAULT_MAX_BUFFER_MS = 10000;
    private int targetLowLatencyBuffer;
    private int maxLowLatencyBuffer;
    private boolean allowLowLatency;
    private boolean allowSeekJumps;
    private SntpClient sntpClient;

    public void flush() {
        this.allowLowLatency = false;
        this.allowSeekJumps = false;
        this.sntpClient = null;
        this.maxLowLatencyBuffer = 0;
        this.targetLowLatencyBuffer = 0;
    }

    public boolean isLowLatencyTurnedOn() {
        return this.allowLowLatency;
    }

    public void turnOnLowLatency(boolean allowSeekJumps) {
        this.allowLowLatency = true;
        this.allowSeekJumps = allowSeekJumps;
    }

    public boolean allowSeekJumps() {
        return this.allowSeekJumps;
    }

    public int getTargetLowLatencyBuffer() {
        return this.targetLowLatencyBuffer;
    }

    public void setTargetLowLatencyBuffer(int targetLowLatencyBuffer) {
        this.targetLowLatencyBuffer = targetLowLatencyBuffer;
    }

    public int getMaxLowLatencyBuffer() {
        return this.maxLowLatencyBuffer;
    }

    public void setMaxLowLatencyBuffer(int maxLowLatencyBuffer) {
        this.maxLowLatencyBuffer = maxLowLatencyBuffer;
    }

    public void startSntpClient() {
        this.sntpClient = new SntpClient();
        Thread ntpInitializer = new Thread(){

            @Override
            public void run() {
                LowLatencySettings.this.sntpClient.initialize("pool.ntp.org", 5000);
            }
        };
        ntpInitializer.start();
    }

    public SntpClient getSntpClient() {
        if (this.sntpClient == null) {
            this.startSntpClient();
        }
        return this.sntpClient;
    }
}

