/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.networking;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import com.akamai.amp.media.networking.IConnectionSwitchCallback;
import com.akamai.amp.utils.LogManager;

public class NetworkSwitchingBroadcastReceiver
extends BroadcastReceiver {
    public static final String TAG = NetworkSwitchingBroadcastReceiver.class.getSimpleName();
    private static boolean latestIsConnected = true;
    private IConnectionSwitchCallback callback;

    public NetworkSwitchingBroadcastReceiver(IConnectionSwitchCallback param) {
        this.setCallback(param);
    }

    public void setCallback(IConnectionSwitchCallback param) {
        this.callback = param;
        LogManager.log(TAG, (Object)((Object)this) + " setCallback: " + param);
    }

    public void onReceive(Context context, Intent intent) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        if (connMgr == null) {
            return;
        }
        boolean isConnected = this.getIsConnected(connMgr);
        if (isConnected != latestIsConnected) {
            latestIsConnected = isConnected;
            this.onNetworkChange();
        }
    }

    private boolean getIsConnected(ConnectivityManager connMgr) {
        if (connMgr == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Network[] allNetworks = connMgr.getAllNetworks();
            LogManager.log(TAG, allNetworks.length + " network(s) found");
            for (Network network : allNetworks) {
                if (network != null) {
                    NetworkInfo networkInfo = connMgr.getNetworkInfo(network);
                    boolean isConnected = this.getIsConnected(networkInfo);
                    LogManager.log(TAG, (isConnected ? "Connected" : "Disconnected") + " -> " + networkInfo);
                    if (!isConnected) continue;
                    return true;
                }
                LogManager.log(TAG, "A NULL Network was found");
            }
        }
        NetworkInfo netInfo = connMgr.getActiveNetworkInfo();
        boolean isConnected = this.getIsConnected(netInfo);
        return isConnected;
    }

    private boolean getIsConnected(NetworkInfo netInfo) {
        if (netInfo == null) {
            return false;
        }
        boolean connectedOrConnecting = netInfo.isConnectedOrConnecting();
        return connectedOrConnecting;
    }

    private void onNetworkChange() {
        if (latestIsConnected) {
            this.onConnect();
        } else {
            this.onDisconnect();
        }
    }

    private void onDisconnect() {
        LogManager.error(TAG, "Internet disconnected, callback " + this.callback);
        if (this.callback == null) {
            return;
        }
        this.callback.onDisconnect();
    }

    private void onConnect() {
        LogManager.error(TAG, "Internet connected, callback " + this.callback);
        if (this.callback == null) {
            return;
        }
        this.callback.onConnect();
    }
}

