/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.FormatHolder;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.drm.DrmInitData;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecAdapter;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecDecoderException;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecInfo;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecRenderer;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecSelector;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecUtil;
import com.akamai.amp.exoplayer2.mediacodec.MediaFormatUtil;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.TraceUtil;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.exoplayer2.video.DummySurface;
import com.akamai.amp.exoplayer2.video.MediaCodecVideoDecoderException;
import com.akamai.amp.exoplayer2.video.VideoFrameMetadataListener;
import com.akamai.amp.exoplayer2.video.VideoFrameReleaseTimeHelper;
import com.akamai.amp.exoplayer2.video.VideoRendererEventListener;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class MediaCodecVideoRenderer
extends MediaCodecRenderer {
    private static final String TAG = "MediaCodecVideoRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    private static final int[] STANDARD_LONG_EDGE_VIDEO_PX = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private static final float INITIAL_FORMAT_MAX_INPUT_SIZE_SCALE_FACTOR = 1.5f;
    private static final long TUNNELING_EOS_PRESENTATION_TIME_US = Long.MAX_VALUE;
    @Nullable
    private static final Method surfaceSetFrameRateMethod;
    private static final int SURFACE_FRAME_RATE_COMPATIBILITY_DEFAULT = 0;
    private static final int SURFACE_FRAME_RATE_COMPATIBILITY_FIXED_SOURCE = 1;
    private static boolean evaluatedDeviceNeedsSetOutputSurfaceWorkaround;
    private static boolean deviceNeedsSetOutputSurfaceWorkaround;
    private final Context context;
    private final VideoFrameReleaseTimeHelper frameReleaseTimeHelper;
    private final VideoRendererEventListener.EventDispatcher eventDispatcher;
    private final long allowedJoiningTimeMs;
    private final int maxDroppedFramesToNotify;
    private final boolean deviceNeedsNoPostProcessWorkaround;
    private CodecMaxValues codecMaxValues;
    private boolean codecNeedsSetOutputSurfaceWorkaround;
    private boolean codecHandlesHdr10PlusOutOfBandMetadata;
    private Surface surface;
    private float surfaceFrameRate;
    private Surface dummySurface;
    private boolean haveReportedFirstFrameRenderedForCurrentSurface;
    private int scalingMode;
    private boolean renderedFirstFrameAfterReset;
    private boolean mayRenderFirstFrameAfterEnableIfNotStarted;
    private boolean renderedFirstFrameAfterEnable;
    private long initialPositionUs;
    private long joiningDeadlineMs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrames;
    private int consecutiveDroppedFrameCount;
    private int buffersInCodecCount;
    private long lastRenderTimeUs;
    private long totalVideoFrameProcessingOffsetUs;
    private int videoFrameProcessingOffsetCount;
    private int currentWidth;
    private int currentHeight;
    private int currentUnappliedRotationDegrees;
    private float currentPixelWidthHeightRatio;
    private float currentFrameRate;
    private int reportedWidth;
    private int reportedHeight;
    private int reportedUnappliedRotationDegrees;
    private float reportedPixelWidthHeightRatio;
    private boolean tunneling;
    private int tunnelingAudioSessionId;
    @Nullable
    OnFrameRenderedListenerV23 tunnelingOnFrameRenderedListener;
    @Nullable
    private VideoFrameMetadataListener frameMetadataListener;

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector) {
        this(context, mediaCodecSelector, 0L);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs) {
        this(context, mediaCodecSelector, allowedJoiningTimeMs, null, null, -1);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        this(context, mediaCodecSelector, allowedJoiningTimeMs, false, eventHandler, eventListener, maxDroppedFramesToNotify);
    }

    public MediaCodecVideoRenderer(Context context, MediaCodecSelector mediaCodecSelector, long allowedJoiningTimeMs, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        super(2, mediaCodecSelector, enableDecoderFallback, 30.0f);
        this.allowedJoiningTimeMs = allowedJoiningTimeMs;
        this.maxDroppedFramesToNotify = maxDroppedFramesToNotify;
        this.context = context.getApplicationContext();
        this.frameReleaseTimeHelper = new VideoFrameReleaseTimeHelper(this.context);
        this.eventDispatcher = new VideoRendererEventListener.EventDispatcher(eventHandler, eventListener);
        this.deviceNeedsNoPostProcessWorkaround = MediaCodecVideoRenderer.deviceNeedsNoPostProcessWorkaround();
        this.joiningDeadlineMs = -9223372036854775807L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.currentPixelWidthHeightRatio = -1.0f;
        this.scalingMode = 1;
        this.clearReportedVideoSize();
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    protected int supportsFormat(MediaCodecSelector mediaCodecSelector, Format format) throws MediaCodecUtil.DecoderQueryException {
        MediaCodecInfo tunnelingDecoderInfo;
        List<MediaCodecInfo> tunnelingDecoderInfos;
        String mimeType = format.sampleMimeType;
        if (!MimeTypes.isVideo(mimeType)) {
            return RendererCapabilities.create(0);
        }
        DrmInitData drmInitData = format.drmInitData;
        boolean requiresSecureDecryption = drmInitData != null;
        List<MediaCodecInfo> decoderInfos = MediaCodecVideoRenderer.getDecoderInfos(mediaCodecSelector, format, requiresSecureDecryption, false);
        if (requiresSecureDecryption && decoderInfos.isEmpty()) {
            decoderInfos = MediaCodecVideoRenderer.getDecoderInfos(mediaCodecSelector, format, false, false);
        }
        if (decoderInfos.isEmpty()) {
            return RendererCapabilities.create(1);
        }
        if (!MediaCodecVideoRenderer.supportsFormatDrm(format)) {
            return RendererCapabilities.create(2);
        }
        MediaCodecInfo decoderInfo = decoderInfos.get(0);
        boolean isFormatSupported = decoderInfo.isFormatSupported(format);
        int adaptiveSupport = decoderInfo.isSeamlessAdaptationSupported(format) ? 16 : 8;
        int tunnelingSupport = 0;
        if (isFormatSupported && !(tunnelingDecoderInfos = MediaCodecVideoRenderer.getDecoderInfos(mediaCodecSelector, format, requiresSecureDecryption, true)).isEmpty() && (tunnelingDecoderInfo = tunnelingDecoderInfos.get(0)).isFormatSupported(format) && tunnelingDecoderInfo.isSeamlessAdaptationSupported(format)) {
            tunnelingSupport = 32;
        }
        int formatSupport = isFormatSupported ? 4 : 3;
        return RendererCapabilities.create(formatSupport, adaptiveSupport, tunnelingSupport);
    }

    @Override
    protected List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        return MediaCodecVideoRenderer.getDecoderInfos(mediaCodecSelector, format, requiresSecureDecoder, this.tunneling);
    }

    private static List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder, boolean requiresTunnelingDecoder) throws MediaCodecUtil.DecoderQueryException {
        Pair<Integer, Integer> codecProfileAndLevel;
        String mimeType = format.sampleMimeType;
        if (mimeType == null) {
            return Collections.emptyList();
        }
        List<MediaCodecInfo> decoderInfos = mediaCodecSelector.getDecoderInfos(mimeType, requiresSecureDecoder, requiresTunnelingDecoder);
        decoderInfos = MediaCodecUtil.getDecoderInfosSortedByFormatSupport(decoderInfos, format);
        if ("video/dolby-vision".equals(mimeType) && (codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(format)) != null) {
            int profile = (Integer)codecProfileAndLevel.first;
            if (profile == 16 || profile == 256) {
                decoderInfos.addAll(mediaCodecSelector.getDecoderInfos("video/hevc", requiresSecureDecoder, requiresTunnelingDecoder));
            } else if (profile == 512) {
                decoderInfos.addAll(mediaCodecSelector.getDecoderInfos("video/avc", requiresSecureDecoder, requiresTunnelingDecoder));
            }
        }
        return Collections.unmodifiableList(decoderInfos);
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        super.onEnabled(joining, mayRenderStartOfStream);
        int oldTunnelingAudioSessionId = this.tunnelingAudioSessionId;
        this.tunnelingAudioSessionId = this.getConfiguration().tunnelingAudioSessionId;
        boolean bl = this.tunneling = this.tunnelingAudioSessionId != 0;
        if (this.tunnelingAudioSessionId != oldTunnelingAudioSessionId) {
            this.releaseCodec();
        }
        this.eventDispatcher.enabled(this.decoderCounters);
        this.frameReleaseTimeHelper.enable();
        this.mayRenderFirstFrameAfterEnableIfNotStarted = mayRenderStartOfStream;
        this.renderedFirstFrameAfterEnable = false;
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        super.onPositionReset(positionUs, joining);
        this.clearRenderedFirstFrame();
        this.initialPositionUs = -9223372036854775807L;
        this.consecutiveDroppedFrameCount = 0;
        if (joining) {
            this.setJoiningDeadlineMs();
        } else {
            this.joiningDeadlineMs = -9223372036854775807L;
        }
    }

    @Override
    public boolean isReady() {
        if (super.isReady() && (this.renderedFirstFrameAfterReset || this.dummySurface != null && this.surface == this.dummySurface || this.getCodec() == null || this.tunneling)) {
            this.joiningDeadlineMs = -9223372036854775807L;
            return true;
        }
        if (this.joiningDeadlineMs == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.joiningDeadlineMs) {
            return true;
        }
        this.joiningDeadlineMs = -9223372036854775807L;
        return false;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.droppedFrames = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        this.totalVideoFrameProcessingOffsetUs = 0L;
        this.videoFrameProcessingOffsetCount = 0;
        this.updateSurfaceFrameRate(false);
    }

    @Override
    protected void onStopped() {
        this.joiningDeadlineMs = -9223372036854775807L;
        this.maybeNotifyDroppedFrames();
        this.maybeNotifyVideoFrameProcessingOffset();
        this.clearSurfaceFrameRate();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.clearReportedVideoSize();
        this.clearRenderedFirstFrame();
        this.haveReportedFirstFrameRenderedForCurrentSurface = false;
        this.frameReleaseTimeHelper.disable();
        this.tunnelingOnFrameRenderedListener = null;
        try {
            super.onDisabled();
        }
        finally {
            this.eventDispatcher.disabled(this.decoderCounters);
        }
    }

    @Override
    protected void onReset() {
        try {
            super.onReset();
        }
        finally {
            if (this.dummySurface != null) {
                if (this.surface == this.dummySurface) {
                    this.surface = null;
                }
                this.dummySurface.release();
                this.dummySurface = null;
            }
        }
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        if (messageType == 1) {
            this.setSurface((Surface)message);
        } else if (messageType == 4) {
            this.scalingMode = (Integer)message;
            MediaCodec codec = this.getCodec();
            if (codec != null) {
                codec.setVideoScalingMode(this.scalingMode);
            }
        } else if (messageType == 6) {
            this.frameMetadataListener = (VideoFrameMetadataListener)message;
        } else {
            super.handleMessage(messageType, message);
        }
    }

    private void setSurface(Surface surface) throws ExoPlaybackException {
        if (surface == null) {
            if (this.dummySurface != null) {
                surface = this.dummySurface;
            } else {
                MediaCodecInfo codecInfo = this.getCodecInfo();
                if (codecInfo != null && this.shouldUseDummySurface(codecInfo)) {
                    surface = this.dummySurface = DummySurface.newInstanceV17(this.context, codecInfo.secure);
                }
            }
        }
        if (this.surface != surface) {
            this.clearSurfaceFrameRate();
            this.surface = surface;
            this.haveReportedFirstFrameRenderedForCurrentSurface = false;
            this.updateSurfaceFrameRate(true);
            int state = this.getState();
            MediaCodec codec = this.getCodec();
            if (codec != null) {
                if (Util.SDK_INT >= 23 && surface != null && !this.codecNeedsSetOutputSurfaceWorkaround) {
                    this.setOutputSurfaceV23(codec, surface);
                } else {
                    this.releaseCodec();
                    this.maybeInitCodecOrBypass();
                }
            }
            if (surface != null && surface != this.dummySurface) {
                this.maybeRenotifyVideoSizeChanged();
                this.clearRenderedFirstFrame();
                if (state == 2) {
                    this.setJoiningDeadlineMs();
                }
            } else {
                this.clearReportedVideoSize();
                this.clearRenderedFirstFrame();
            }
        } else if (surface != null && surface != this.dummySurface) {
            this.maybeRenotifyVideoSizeChanged();
            this.maybeRenotifyRenderedFirstFrame();
        }
    }

    @Override
    protected boolean shouldInitCodec(MediaCodecInfo codecInfo) {
        return this.surface != null || this.shouldUseDummySurface(codecInfo);
    }

    @Override
    protected boolean getCodecNeedsEosPropagation() {
        return this.tunneling && Util.SDK_INT < 23;
    }

    @Override
    protected void configureCodec(MediaCodecInfo codecInfo, MediaCodecAdapter codecAdapter, Format format, @Nullable MediaCrypto crypto, float codecOperatingRate) {
        String codecMimeType = codecInfo.codecMimeType;
        this.codecMaxValues = this.getCodecMaxValues(codecInfo, format, this.getStreamFormats());
        MediaFormat mediaFormat = this.getMediaFormat(format, codecMimeType, this.codecMaxValues, codecOperatingRate, this.deviceNeedsNoPostProcessWorkaround, this.tunnelingAudioSessionId);
        if (this.surface == null) {
            if (!this.shouldUseDummySurface(codecInfo)) {
                throw new IllegalStateException();
            }
            if (this.dummySurface == null) {
                this.dummySurface = DummySurface.newInstanceV17(this.context, codecInfo.secure);
            }
            this.surface = this.dummySurface;
        }
        codecAdapter.configure(mediaFormat, this.surface, crypto, 0);
        if (Util.SDK_INT >= 23 && this.tunneling) {
            this.tunnelingOnFrameRenderedListener = new OnFrameRenderedListenerV23(codecAdapter.getCodec());
        }
    }

    @Override
    protected int canKeepCodec(MediaCodec codec, MediaCodecInfo codecInfo, Format oldFormat, Format newFormat) {
        if (codecInfo.isSeamlessAdaptationSupported(oldFormat, newFormat, true) && newFormat.width <= this.codecMaxValues.width && newFormat.height <= this.codecMaxValues.height && MediaCodecVideoRenderer.getMaxInputSize(codecInfo, newFormat) <= this.codecMaxValues.inputSize) {
            return oldFormat.initializationDataEquals(newFormat) ? 3 : 2;
        }
        return 0;
    }

    @Override
    @CallSuper
    protected void resetCodecStateForFlush() {
        super.resetCodecStateForFlush();
        this.buffersInCodecCount = 0;
    }

    @Override
    public void setOperatingRate(float operatingRate) throws ExoPlaybackException {
        super.setOperatingRate(operatingRate);
        this.updateSurfaceFrameRate(false);
    }

    @Override
    protected float getCodecOperatingRateV23(float operatingRate, Format format, Format[] streamFormats) {
        float maxFrameRate = -1.0f;
        for (Format streamFormat : streamFormats) {
            float streamFrameRate = streamFormat.frameRate;
            if (streamFrameRate == -1.0f) continue;
            maxFrameRate = Math.max(maxFrameRate, streamFrameRate);
        }
        return maxFrameRate == -1.0f ? -1.0f : maxFrameRate * operatingRate;
    }

    @Override
    protected void onCodecInitialized(String name, long initializedTimestampMs, long initializationDurationMs) {
        this.eventDispatcher.decoderInitialized(name, initializedTimestampMs, initializationDurationMs);
        this.codecNeedsSetOutputSurfaceWorkaround = this.codecNeedsSetOutputSurfaceWorkaround(name);
        this.codecHandlesHdr10PlusOutOfBandMetadata = Assertions.checkNotNull(this.getCodecInfo()).isHdr10PlusOutOfBandMetadataSupported();
    }

    @Override
    protected void onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        super.onInputFormatChanged(formatHolder);
        this.eventDispatcher.inputFormatChanged(formatHolder.format);
    }

    @Override
    @CallSuper
    protected void onQueueInputBuffer(DecoderInputBuffer buffer) throws ExoPlaybackException {
        if (!this.tunneling) {
            ++this.buffersInCodecCount;
        }
        if (Util.SDK_INT < 23 && this.tunneling) {
            this.onProcessedTunneledBuffer(buffer.timeUs);
        }
    }

    @Override
    protected void onOutputFormatChanged(Format format, @Nullable MediaFormat mediaFormat) {
        MediaCodec codec = this.getCodec();
        if (codec != null) {
            codec.setVideoScalingMode(this.scalingMode);
        }
        if (this.tunneling) {
            this.currentWidth = format.width;
            this.currentHeight = format.height;
        } else {
            Assertions.checkNotNull(mediaFormat);
            boolean hasCrop = mediaFormat.containsKey(KEY_CROP_RIGHT) && mediaFormat.containsKey(KEY_CROP_LEFT) && mediaFormat.containsKey(KEY_CROP_BOTTOM) && mediaFormat.containsKey(KEY_CROP_TOP);
            this.currentWidth = hasCrop ? mediaFormat.getInteger(KEY_CROP_RIGHT) - mediaFormat.getInteger(KEY_CROP_LEFT) + 1 : mediaFormat.getInteger("width");
            this.currentHeight = hasCrop ? mediaFormat.getInteger(KEY_CROP_BOTTOM) - mediaFormat.getInteger(KEY_CROP_TOP) + 1 : mediaFormat.getInteger("height");
        }
        this.currentPixelWidthHeightRatio = format.pixelWidthHeightRatio;
        if (Util.SDK_INT >= 21) {
            if (format.rotationDegrees == 90 || format.rotationDegrees == 270) {
                int rotatedHeight = this.currentWidth;
                this.currentWidth = this.currentHeight;
                this.currentHeight = rotatedHeight;
                this.currentPixelWidthHeightRatio = 1.0f / this.currentPixelWidthHeightRatio;
            }
        } else {
            this.currentUnappliedRotationDegrees = format.rotationDegrees;
        }
        this.currentFrameRate = format.frameRate;
        this.updateSurfaceFrameRate(false);
    }

    @Override
    @TargetApi(value=29)
    protected void handleInputBufferSupplementalData(DecoderInputBuffer buffer) throws ExoPlaybackException {
        if (!this.codecHandlesHdr10PlusOutOfBandMetadata) {
            return;
        }
        ByteBuffer data = Assertions.checkNotNull(buffer.supplementalData);
        if (data.remaining() >= 7) {
            byte ituTT35CountryCode = data.get();
            short ituTT35TerminalProviderCode = data.getShort();
            short ituTT35TerminalProviderOrientedCode = data.getShort();
            byte applicationIdentifier = data.get();
            byte applicationVersion = data.get();
            data.position(0);
            if (ituTT35CountryCode == -75 && ituTT35TerminalProviderCode == 60 && ituTT35TerminalProviderOrientedCode == 1 && applicationIdentifier == 4 && applicationVersion == 0) {
                byte[] hdr10PlusInfo = new byte[data.remaining()];
                data.get(hdr10PlusInfo);
                data.position(0);
                MediaCodecVideoRenderer.setHdr10PlusInfoV29(this.getCodec(), hdr10PlusInfo);
            }
        }
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, @Nullable MediaCodec codec, @Nullable ByteBuffer buffer, int bufferIndex, int bufferFlags, int sampleCount, long bufferPresentationTimeUs, boolean isDecodeOnlyBuffer, boolean isLastBuffer, Format format) throws ExoPlaybackException {
        boolean treatDroppedBuffersAsSkipped;
        boolean forceRenderOutputBuffer;
        boolean isStarted;
        Assertions.checkNotNull(codec);
        if (this.initialPositionUs == -9223372036854775807L) {
            this.initialPositionUs = positionUs;
        }
        long outputStreamOffsetUs = this.getOutputStreamOffsetUs();
        long presentationTimeUs = bufferPresentationTimeUs - outputStreamOffsetUs;
        if (isDecodeOnlyBuffer && !isLastBuffer) {
            this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
            return true;
        }
        long earlyUs = bufferPresentationTimeUs - positionUs;
        if (this.surface == this.dummySurface) {
            if (MediaCodecVideoRenderer.isBufferLate(earlyUs)) {
                this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
                this.updateVideoFrameProcessingOffsetCounters(earlyUs);
                return true;
            }
            return false;
        }
        long elapsedRealtimeNowUs = SystemClock.elapsedRealtime() * 1000L;
        long elapsedSinceLastRenderUs = elapsedRealtimeNowUs - this.lastRenderTimeUs;
        boolean bl = isStarted = this.getState() == 2;
        boolean shouldRenderFirstFrame = !this.renderedFirstFrameAfterEnable ? isStarted || this.mayRenderFirstFrameAfterEnableIfNotStarted : !this.renderedFirstFrameAfterReset;
        boolean bl2 = forceRenderOutputBuffer = this.joiningDeadlineMs == -9223372036854775807L && positionUs >= outputStreamOffsetUs && (shouldRenderFirstFrame || isStarted && this.shouldForceRenderOutputBuffer(earlyUs, elapsedSinceLastRenderUs));
        if (forceRenderOutputBuffer) {
            long releaseTimeNs = System.nanoTime();
            this.notifyFrameMetadataListener(presentationTimeUs, releaseTimeNs, format);
            if (Util.SDK_INT >= 21) {
                this.renderOutputBufferV21(codec, bufferIndex, presentationTimeUs, releaseTimeNs);
            } else {
                this.renderOutputBuffer(codec, bufferIndex, presentationTimeUs);
            }
            this.updateVideoFrameProcessingOffsetCounters(earlyUs);
            return true;
        }
        if (!isStarted || positionUs == this.initialPositionUs) {
            return false;
        }
        long elapsedSinceStartOfLoopUs = elapsedRealtimeNowUs - elapsedRealtimeUs;
        long systemTimeNs = System.nanoTime();
        long unadjustedFrameReleaseTimeNs = systemTimeNs + (earlyUs -= elapsedSinceStartOfLoopUs) * 1000L;
        long adjustedReleaseTimeNs = this.frameReleaseTimeHelper.adjustReleaseTime(bufferPresentationTimeUs, unadjustedFrameReleaseTimeNs);
        earlyUs = (adjustedReleaseTimeNs - systemTimeNs) / 1000L;
        boolean bl3 = treatDroppedBuffersAsSkipped = this.joiningDeadlineMs != -9223372036854775807L;
        if (this.shouldDropBuffersToKeyframe(earlyUs, elapsedRealtimeUs, isLastBuffer) && this.maybeDropBuffersToKeyframe(codec, bufferIndex, presentationTimeUs, positionUs, treatDroppedBuffersAsSkipped)) {
            return false;
        }
        if (this.shouldDropOutputBuffer(earlyUs, elapsedRealtimeUs, isLastBuffer)) {
            if (treatDroppedBuffersAsSkipped) {
                this.skipOutputBuffer(codec, bufferIndex, presentationTimeUs);
            } else {
                this.dropOutputBuffer(codec, bufferIndex, presentationTimeUs);
            }
            this.updateVideoFrameProcessingOffsetCounters(earlyUs);
            return true;
        }
        if (Util.SDK_INT >= 21) {
            if (earlyUs < 50000L) {
                this.notifyFrameMetadataListener(presentationTimeUs, adjustedReleaseTimeNs, format);
                this.renderOutputBufferV21(codec, bufferIndex, presentationTimeUs, adjustedReleaseTimeNs);
                this.updateVideoFrameProcessingOffsetCounters(earlyUs);
                return true;
            }
        } else if (earlyUs < 30000L) {
            if (earlyUs > 11000L) {
                try {
                    Thread.sleep((earlyUs - 10000L) / 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            this.notifyFrameMetadataListener(presentationTimeUs, adjustedReleaseTimeNs, format);
            this.renderOutputBuffer(codec, bufferIndex, presentationTimeUs);
            this.updateVideoFrameProcessingOffsetCounters(earlyUs);
            return true;
        }
        return false;
    }

    private void notifyFrameMetadataListener(long presentationTimeUs, long releaseTimeNs, Format format) {
        if (this.frameMetadataListener != null) {
            this.frameMetadataListener.onVideoFrameAboutToBeRendered(presentationTimeUs, releaseTimeNs, format, this.getCodecOutputMediaFormat());
        }
    }

    protected void onProcessedTunneledBuffer(long presentationTimeUs) throws ExoPlaybackException {
        this.updateOutputFormatForTime(presentationTimeUs);
        this.maybeNotifyVideoSizeChanged();
        ++this.decoderCounters.renderedOutputBufferCount;
        this.maybeNotifyRenderedFirstFrame();
        this.onProcessedOutputBuffer(presentationTimeUs);
    }

    private void onProcessedTunneledEndOfStream() {
        this.setPendingOutputEndOfStream();
    }

    @Override
    @CallSuper
    protected void onProcessedOutputBuffer(long presentationTimeUs) {
        super.onProcessedOutputBuffer(presentationTimeUs);
        if (!this.tunneling) {
            --this.buffersInCodecCount;
        }
    }

    @Override
    protected void onProcessedStreamChange() {
        super.onProcessedStreamChange();
        this.clearRenderedFirstFrame();
    }

    protected boolean shouldDropOutputBuffer(long earlyUs, long elapsedRealtimeUs, boolean isLastBuffer) {
        return MediaCodecVideoRenderer.isBufferLate(earlyUs) && !isLastBuffer;
    }

    protected boolean shouldDropBuffersToKeyframe(long earlyUs, long elapsedRealtimeUs, boolean isLastBuffer) {
        return MediaCodecVideoRenderer.isBufferVeryLate(earlyUs) && !isLastBuffer;
    }

    protected boolean shouldForceRenderOutputBuffer(long earlyUs, long elapsedSinceLastRenderUs) {
        return MediaCodecVideoRenderer.isBufferLate(earlyUs) && elapsedSinceLastRenderUs > 100000L;
    }

    protected void skipOutputBuffer(MediaCodec codec, int index, long presentationTimeUs) {
        TraceUtil.beginSection("skipVideoBuffer");
        codec.releaseOutputBuffer(index, false);
        TraceUtil.endSection();
        ++this.decoderCounters.skippedOutputBufferCount;
    }

    protected void dropOutputBuffer(MediaCodec codec, int index, long presentationTimeUs) {
        TraceUtil.beginSection("dropVideoBuffer");
        codec.releaseOutputBuffer(index, false);
        TraceUtil.endSection();
        this.updateDroppedBufferCounters(1);
    }

    protected boolean maybeDropBuffersToKeyframe(MediaCodec codec, int index, long presentationTimeUs, long positionUs, boolean treatDroppedBuffersAsSkipped) throws ExoPlaybackException {
        int droppedSourceBufferCount = this.skipSource(positionUs);
        if (droppedSourceBufferCount == 0) {
            return false;
        }
        ++this.decoderCounters.droppedToKeyframeCount;
        int totalDroppedBufferCount = this.buffersInCodecCount + droppedSourceBufferCount;
        if (treatDroppedBuffersAsSkipped) {
            this.decoderCounters.skippedOutputBufferCount += totalDroppedBufferCount;
        } else {
            this.updateDroppedBufferCounters(totalDroppedBufferCount);
        }
        this.flushOrReinitializeCodec();
        return true;
    }

    protected void updateDroppedBufferCounters(int droppedBufferCount) {
        this.decoderCounters.droppedBufferCount += droppedBufferCount;
        this.droppedFrames += droppedBufferCount;
        this.consecutiveDroppedFrameCount += droppedBufferCount;
        this.decoderCounters.maxConsecutiveDroppedBufferCount = Math.max(this.consecutiveDroppedFrameCount, this.decoderCounters.maxConsecutiveDroppedBufferCount);
        if (this.maxDroppedFramesToNotify > 0 && this.droppedFrames >= this.maxDroppedFramesToNotify) {
            this.maybeNotifyDroppedFrames();
        }
    }

    protected void updateVideoFrameProcessingOffsetCounters(long processingOffsetUs) {
        this.decoderCounters.addVideoFrameProcessingOffset(processingOffsetUs);
        this.totalVideoFrameProcessingOffsetUs += processingOffsetUs;
        ++this.videoFrameProcessingOffsetCount;
    }

    protected void renderOutputBuffer(MediaCodec codec, int index, long presentationTimeUs) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBuffer");
        codec.releaseOutputBuffer(index, true);
        TraceUtil.endSection();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        ++this.decoderCounters.renderedOutputBufferCount;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    @RequiresApi(value=21)
    protected void renderOutputBufferV21(MediaCodec codec, int index, long presentationTimeUs, long releaseTimeNs) {
        this.maybeNotifyVideoSizeChanged();
        TraceUtil.beginSection("releaseOutputBuffer");
        codec.releaseOutputBuffer(index, releaseTimeNs);
        TraceUtil.endSection();
        this.lastRenderTimeUs = SystemClock.elapsedRealtime() * 1000L;
        ++this.decoderCounters.renderedOutputBufferCount;
        this.consecutiveDroppedFrameCount = 0;
        this.maybeNotifyRenderedFirstFrame();
    }

    private void updateSurfaceFrameRate(boolean isNewSurface) {
        float surfaceFrameRate;
        if (Util.SDK_INT < 30 || this.surface == null || this.surface == this.dummySurface) {
            return;
        }
        boolean shouldSetFrameRate = this.getState() == 2 && this.currentFrameRate != -1.0f;
        float f = surfaceFrameRate = shouldSetFrameRate ? this.currentFrameRate * this.getOperatingRate() : 0.0f;
        if (this.surfaceFrameRate == surfaceFrameRate && !isNewSurface) {
            return;
        }
        this.surfaceFrameRate = surfaceFrameRate;
        this.setSurfaceFrameRateV30(this.surface, surfaceFrameRate);
    }

    private void clearSurfaceFrameRate() {
        if (Util.SDK_INT < 30 || this.surface == null || this.surface == this.dummySurface || this.surfaceFrameRate == 0.0f) {
            return;
        }
        this.surfaceFrameRate = 0.0f;
        this.setSurfaceFrameRateV30(this.surface, 0.0f);
    }

    @RequiresApi(value=30)
    private void setSurfaceFrameRateV30(Surface surface, float frameRate) {
        if (surfaceSetFrameRateMethod == null) {
            Log.e(TAG, "Failed to call Surface.setFrameRate (method does not exist)");
        }
        int compatibility = frameRate == 0.0f ? 0 : 1;
        try {
            surfaceSetFrameRateMethod.invoke((Object)surface, Float.valueOf(frameRate), compatibility);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to call Surface.setFrameRate", e);
        }
    }

    private boolean shouldUseDummySurface(MediaCodecInfo codecInfo) {
        return Util.SDK_INT >= 23 && !this.tunneling && !this.codecNeedsSetOutputSurfaceWorkaround(codecInfo.name) && (!codecInfo.secure || DummySurface.isSecureSupported(this.context));
    }

    private void setJoiningDeadlineMs() {
        this.joiningDeadlineMs = this.allowedJoiningTimeMs > 0L ? SystemClock.elapsedRealtime() + this.allowedJoiningTimeMs : -9223372036854775807L;
    }

    private void clearRenderedFirstFrame() {
        MediaCodec codec;
        this.renderedFirstFrameAfterReset = false;
        if (Util.SDK_INT >= 23 && this.tunneling && (codec = this.getCodec()) != null) {
            this.tunnelingOnFrameRenderedListener = new OnFrameRenderedListenerV23(codec);
        }
    }

    void maybeNotifyRenderedFirstFrame() {
        this.renderedFirstFrameAfterEnable = true;
        if (!this.renderedFirstFrameAfterReset) {
            this.renderedFirstFrameAfterReset = true;
            this.eventDispatcher.renderedFirstFrame(this.surface);
            this.haveReportedFirstFrameRenderedForCurrentSurface = true;
        }
    }

    private void maybeRenotifyRenderedFirstFrame() {
        if (this.haveReportedFirstFrameRenderedForCurrentSurface) {
            this.eventDispatcher.renderedFirstFrame(this.surface);
        }
    }

    private void clearReportedVideoSize() {
        this.reportedWidth = -1;
        this.reportedHeight = -1;
        this.reportedPixelWidthHeightRatio = -1.0f;
        this.reportedUnappliedRotationDegrees = -1;
    }

    private void maybeNotifyVideoSizeChanged() {
        if (!(this.currentWidth == -1 && this.currentHeight == -1 || this.reportedWidth == this.currentWidth && this.reportedHeight == this.currentHeight && this.reportedUnappliedRotationDegrees == this.currentUnappliedRotationDegrees && this.reportedPixelWidthHeightRatio == this.currentPixelWidthHeightRatio)) {
            this.eventDispatcher.videoSizeChanged(this.currentWidth, this.currentHeight, this.currentUnappliedRotationDegrees, this.currentPixelWidthHeightRatio);
            this.reportedWidth = this.currentWidth;
            this.reportedHeight = this.currentHeight;
            this.reportedUnappliedRotationDegrees = this.currentUnappliedRotationDegrees;
            this.reportedPixelWidthHeightRatio = this.currentPixelWidthHeightRatio;
        }
    }

    private void maybeRenotifyVideoSizeChanged() {
        if (this.reportedWidth != -1 || this.reportedHeight != -1) {
            this.eventDispatcher.videoSizeChanged(this.reportedWidth, this.reportedHeight, this.reportedUnappliedRotationDegrees, this.reportedPixelWidthHeightRatio);
        }
    }

    private void maybeNotifyDroppedFrames() {
        if (this.droppedFrames > 0) {
            long now = SystemClock.elapsedRealtime();
            long elapsedMs = now - this.droppedFrameAccumulationStartTimeMs;
            this.eventDispatcher.droppedFrames(this.droppedFrames, elapsedMs);
            this.droppedFrames = 0;
            this.droppedFrameAccumulationStartTimeMs = now;
        }
    }

    private void maybeNotifyVideoFrameProcessingOffset() {
        if (this.videoFrameProcessingOffsetCount != 0) {
            this.eventDispatcher.reportVideoFrameProcessingOffset(this.totalVideoFrameProcessingOffsetUs, this.videoFrameProcessingOffsetCount);
            this.totalVideoFrameProcessingOffsetUs = 0L;
            this.videoFrameProcessingOffsetCount = 0;
        }
    }

    private static boolean isBufferLate(long earlyUs) {
        return earlyUs < -30000L;
    }

    private static boolean isBufferVeryLate(long earlyUs) {
        return earlyUs < -500000L;
    }

    @RequiresApi(value=29)
    private static void setHdr10PlusInfoV29(MediaCodec codec, byte[] hdr10PlusInfo) {
        Bundle codecParameters = new Bundle();
        codecParameters.putByteArray("hdr10-plus-info", hdr10PlusInfo);
        codec.setParameters(codecParameters);
    }

    @RequiresApi(value=23)
    protected void setOutputSurfaceV23(MediaCodec codec, Surface surface) {
        codec.setOutputSurface(surface);
    }

    @RequiresApi(value=21)
    private static void configureTunnelingV21(MediaFormat mediaFormat, int tunnelingAudioSessionId) {
        mediaFormat.setFeatureEnabled("tunneled-playback", true);
        mediaFormat.setInteger("audio-session-id", tunnelingAudioSessionId);
    }

    @SuppressLint(value={"InlinedApi"})
    @TargetApi(value=21)
    protected MediaFormat getMediaFormat(Format format, String codecMimeType, CodecMaxValues codecMaxValues, float codecOperatingRate, boolean deviceNeedsNoPostProcessWorkaround, int tunnelingAudioSessionId) {
        Pair<Integer, Integer> codecProfileAndLevel;
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", codecMimeType);
        mediaFormat.setInteger("width", format.width);
        mediaFormat.setInteger("height", format.height);
        MediaFormatUtil.setCsdBuffers(mediaFormat, format.initializationData);
        MediaFormatUtil.maybeSetFloat(mediaFormat, "frame-rate", format.frameRate);
        MediaFormatUtil.maybeSetInteger(mediaFormat, "rotation-degrees", format.rotationDegrees);
        MediaFormatUtil.maybeSetColorInfo(mediaFormat, format.colorInfo);
        if ("video/dolby-vision".equals(format.sampleMimeType) && (codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(format)) != null) {
            MediaFormatUtil.maybeSetInteger(mediaFormat, "profile", (Integer)codecProfileAndLevel.first);
        }
        mediaFormat.setInteger("max-width", codecMaxValues.width);
        mediaFormat.setInteger("max-height", codecMaxValues.height);
        MediaFormatUtil.maybeSetInteger(mediaFormat, "max-input-size", codecMaxValues.inputSize);
        if (Util.SDK_INT >= 23) {
            mediaFormat.setInteger("priority", 0);
            if (codecOperatingRate != -1.0f) {
                mediaFormat.setFloat("operating-rate", codecOperatingRate);
            }
        }
        if (deviceNeedsNoPostProcessWorkaround) {
            mediaFormat.setInteger("no-post-process", 1);
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (tunnelingAudioSessionId != 0) {
            MediaCodecVideoRenderer.configureTunnelingV21(mediaFormat, tunnelingAudioSessionId);
        }
        return mediaFormat;
    }

    protected CodecMaxValues getCodecMaxValues(MediaCodecInfo codecInfo, Format format, Format[] streamFormats) {
        int maxWidth = format.width;
        int maxHeight = format.height;
        int maxInputSize = MediaCodecVideoRenderer.getMaxInputSize(codecInfo, format);
        if (streamFormats.length == 1) {
            int codecMaxInputSize;
            if (maxInputSize != -1 && (codecMaxInputSize = MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format.sampleMimeType, format.width, format.height)) != -1) {
                int scaledMaxInputSize = (int)((float)maxInputSize * 1.5f);
                maxInputSize = Math.min(scaledMaxInputSize, codecMaxInputSize);
            }
            return new CodecMaxValues(maxWidth, maxHeight, maxInputSize);
        }
        boolean haveUnknownDimensions = false;
        for (Format streamFormat : streamFormats) {
            if (!codecInfo.isSeamlessAdaptationSupported(format, streamFormat, false)) continue;
            haveUnknownDimensions |= streamFormat.width == -1 || streamFormat.height == -1;
            maxWidth = Math.max(maxWidth, streamFormat.width);
            maxHeight = Math.max(maxHeight, streamFormat.height);
            maxInputSize = Math.max(maxInputSize, MediaCodecVideoRenderer.getMaxInputSize(codecInfo, streamFormat));
        }
        if (haveUnknownDimensions) {
            Log.w(TAG, "Resolutions unknown. Codec max resolution: " + maxWidth + "x" + maxHeight);
            Point codecMaxSize = MediaCodecVideoRenderer.getCodecMaxSize(codecInfo, format);
            if (codecMaxSize != null) {
                maxWidth = Math.max(maxWidth, codecMaxSize.x);
                maxHeight = Math.max(maxHeight, codecMaxSize.y);
                maxInputSize = Math.max(maxInputSize, MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format.sampleMimeType, maxWidth, maxHeight));
                Log.w(TAG, "Codec max resolution adjusted to: " + maxWidth + "x" + maxHeight);
            }
        }
        return new CodecMaxValues(maxWidth, maxHeight, maxInputSize);
    }

    @Override
    protected MediaCodecDecoderException createDecoderException(Throwable cause, @Nullable MediaCodecInfo codecInfo) {
        return new MediaCodecVideoDecoderException(cause, codecInfo, this.surface);
    }

    private static Point getCodecMaxSize(MediaCodecInfo codecInfo, Format format) {
        boolean isVerticalVideo = format.height > format.width;
        int formatLongEdgePx = isVerticalVideo ? format.height : format.width;
        int formatShortEdgePx = isVerticalVideo ? format.width : format.height;
        float aspectRatio = (float)formatShortEdgePx / (float)formatLongEdgePx;
        for (int longEdgePx : STANDARD_LONG_EDGE_VIDEO_PX) {
            int shortEdgePx = (int)((float)longEdgePx * aspectRatio);
            if (longEdgePx <= formatLongEdgePx || shortEdgePx <= formatShortEdgePx) {
                return null;
            }
            if (Util.SDK_INT >= 21) {
                Point alignedSize = codecInfo.alignVideoSizeV21(isVerticalVideo ? shortEdgePx : longEdgePx, isVerticalVideo ? longEdgePx : shortEdgePx);
                float frameRate = format.frameRate;
                if (!codecInfo.isVideoSizeAndRateSupportedV21(alignedSize.x, alignedSize.y, frameRate)) continue;
                return alignedSize;
            }
            try {
                longEdgePx = Util.ceilDivide(longEdgePx, 16) * 16;
                shortEdgePx = Util.ceilDivide(shortEdgePx, 16) * 16;
                if (longEdgePx * shortEdgePx > MediaCodecUtil.maxH264DecodableFrameSize()) continue;
                return new Point(isVerticalVideo ? shortEdgePx : longEdgePx, isVerticalVideo ? longEdgePx : shortEdgePx);
            }
            catch (MediaCodecUtil.DecoderQueryException e) {
                return null;
            }
        }
        return null;
    }

    protected static int getMaxInputSize(MediaCodecInfo codecInfo, Format format) {
        if (format.maxInputSize != -1) {
            int totalInitializationDataSize = 0;
            int initializationDataCount = format.initializationData.size();
            for (int i = 0; i < initializationDataCount; ++i) {
                totalInitializationDataSize += format.initializationData.get(i).length;
            }
            return format.maxInputSize + totalInitializationDataSize;
        }
        return MediaCodecVideoRenderer.getCodecMaxInputSize(codecInfo, format.sampleMimeType, format.width, format.height);
    }

    private static int getCodecMaxInputSize(MediaCodecInfo codecInfo, String sampleMimeType, int width, int height) {
        int minCompressionRatio;
        int maxPixels;
        if (width == -1 || height == -1) {
            return -1;
        }
        switch (sampleMimeType) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                maxPixels = width * height;
                minCompressionRatio = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(Util.MODEL) || "Amazon".equals(Util.MANUFACTURER) && ("KFSOWI".equals(Util.MODEL) || "AFTS".equals(Util.MODEL) && codecInfo.secure)) {
                    return -1;
                }
                maxPixels = Util.ceilDivide(width, 16) * Util.ceilDivide(height, 16) * 16 * 16;
                minCompressionRatio = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                maxPixels = width * height;
                minCompressionRatio = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                maxPixels = width * height;
                minCompressionRatio = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return maxPixels * 3 / (2 * minCompressionRatio);
    }

    private static boolean deviceNeedsNoPostProcessWorkaround() {
        return "NVIDIA".equals(Util.MANUFACTURER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean codecNeedsSetOutputSurfaceWorkaround(String name) {
        if (name.startsWith("OMX.google")) {
            return false;
        }
        Class<MediaCodecVideoRenderer> clazz = MediaCodecVideoRenderer.class;
        synchronized (MediaCodecVideoRenderer.class) {
            if (!evaluatedDeviceNeedsSetOutputSurfaceWorkaround) {
                deviceNeedsSetOutputSurfaceWorkaround = MediaCodecVideoRenderer.evaluateDeviceNeedsSetOutputSurfaceWorkaround();
                evaluatedDeviceNeedsSetOutputSurfaceWorkaround = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return deviceNeedsSetOutputSurfaceWorkaround;
        }
    }

    protected Surface getSurface() {
        return this.surface;
    }

    private static boolean evaluateDeviceNeedsSetOutputSurfaceWorkaround() {
        if (Util.SDK_INT <= 28) {
            switch (Util.DEVICE) {
                case "dangal": 
                case "dangalUHD": 
                case "dangalFHD": 
                case "magnolia": 
                case "machuca": 
                case "oneday": {
                    return true;
                }
            }
        }
        if (Util.SDK_INT <= 27 && "HWEML".equals(Util.DEVICE)) {
            return true;
        }
        if (Util.SDK_INT <= 26) {
            switch (Util.DEVICE) {
                case "1601": 
                case "1713": 
                case "1714": 
                case "601LV": 
                case "602LV": 
                case "A10-70F": 
                case "A10-70L": 
                case "A1601": 
                case "A2016a40": 
                case "A7000-a": 
                case "A7000plus": 
                case "A7010a48": 
                case "A7020a48": 
                case "AquaPowerM": 
                case "ASUS_X00AD_2": 
                case "Aura_Note_2": 
                case "b5": 
                case "BLACK-1X": 
                case "BRAVIA_ATV2": 
                case "BRAVIA_ATV3_4K": 
                case "C1": 
                case "ComioS1": 
                case "CP8676_I02": 
                case "CPH1609": 
                case "CPH1715": 
                case "CPY83_I00": 
                case "cv1": 
                case "cv3": 
                case "deb": 
                case "DM-01K": 
                case "E5643": 
                case "ELUGA_A3_Pro": 
                case "ELUGA_Note": 
                case "ELUGA_Prim": 
                case "ELUGA_Ray_X": 
                case "EverStar_S": 
                case "F01H": 
                case "F01J": 
                case "F02H": 
                case "F03H": 
                case "F04H": 
                case "F04J": 
                case "F3111": 
                case "F3113": 
                case "F3116": 
                case "F3211": 
                case "F3213": 
                case "F3215": 
                case "F3311": 
                case "flo": 
                case "fugu": 
                case "GiONEE_CBL7513": 
                case "GiONEE_GBL7319": 
                case "GIONEE_GBL7360": 
                case "GIONEE_SWW1609": 
                case "GIONEE_SWW1627": 
                case "GIONEE_SWW1631": 
                case "GIONEE_WBL5708": 
                case "GIONEE_WBL7365": 
                case "GIONEE_WBL7519": 
                case "griffin": 
                case "htc_e56ml_dtul": 
                case "hwALE-H": 
                case "HWBLN-H": 
                case "HWCAM-H": 
                case "HWVNS-H": 
                case "HWWAS-H": 
                case "i9031": 
                case "iball8735_9806": 
                case "Infinix-X572": 
                case "iris60": 
                case "itel_S41": 
                case "j2xlteins": 
                case "JGZ": 
                case "K50a40": 
                case "kate": 
                case "l5460": 
                case "le_x6": 
                case "LS-5017": 
                case "M04": 
                case "M5c": 
                case "manning": 
                case "marino_f": 
                case "MEIZU_M5": 
                case "mh": 
                case "mido": 
                case "MX6": 
                case "namath": 
                case "nicklaus_f": 
                case "NX541J": 
                case "NX573J": 
                case "OnePlus5T": 
                case "p212": 
                case "P681": 
                case "P85": 
                case "pacificrim": 
                case "panell_d": 
                case "panell_dl": 
                case "panell_ds": 
                case "panell_dt": 
                case "PB2-670M": 
                case "PGN528": 
                case "PGN610": 
                case "PGN611": 
                case "Phantom6": 
                case "Pixi4-7_3G": 
                case "Pixi5-10_4G": 
                case "PLE": 
                case "PRO7S": 
                case "Q350": 
                case "Q4260": 
                case "Q427": 
                case "Q4310": 
                case "Q5": 
                case "QM16XE_U": 
                case "QX1": 
                case "RAIJIN": 
                case "santoni": 
                case "Slate_Pro": 
                case "SVP-DTV15": 
                case "s905x018": 
                case "taido_row": 
                case "TB3-730F": 
                case "TB3-730X": 
                case "TB3-850F": 
                case "TB3-850M": 
                case "tcl_eu": 
                case "V1": 
                case "V23GB": 
                case "V5": 
                case "vernee_M5": 
                case "watson": 
                case "whyred": 
                case "woods_f": 
                case "woods_fn": 
                case "X3_HK": 
                case "XE2X": 
                case "XT1663": 
                case "Z12_PRO": 
                case "Z80": {
                    return true;
                }
            }
            switch (Util.MODEL) {
                case "AFTA": 
                case "AFTN": 
                case "JSN-L21": {
                    return true;
                }
            }
        }
        return false;
    }

    static {
        Method setFrameRateMethod = null;
        if (Util.SDK_INT >= 30) {
            try {
                setFrameRateMethod = Surface.class.getMethod("setFrameRate", Float.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        surfaceSetFrameRateMethod = setFrameRateMethod;
    }

    @RequiresApi(value=23)
    private final class OnFrameRenderedListenerV23
    implements MediaCodec.OnFrameRenderedListener,
    Handler.Callback {
        private static final int HANDLE_FRAME_RENDERED = 0;
        private final Handler handler = Util.createHandlerForCurrentLooper(this);

        public OnFrameRenderedListenerV23(MediaCodec codec) {
            codec.setOnFrameRenderedListener((MediaCodec.OnFrameRenderedListener)this, this.handler);
        }

        public void onFrameRendered(MediaCodec codec, long presentationTimeUs, long nanoTime) {
            if (Util.SDK_INT < 30) {
                Message message = Message.obtain((Handler)this.handler, (int)0, (int)((int)(presentationTimeUs >> 32)), (int)((int)presentationTimeUs));
                this.handler.sendMessageAtFrontOfQueue(message);
            } else {
                this.handleFrameRendered(presentationTimeUs);
            }
        }

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    this.handleFrameRendered(Util.toLong(message.arg1, message.arg2));
                    return true;
                }
            }
            return false;
        }

        private void handleFrameRendered(long presentationTimeUs) {
            if (this != MediaCodecVideoRenderer.this.tunnelingOnFrameRenderedListener) {
                return;
            }
            if (presentationTimeUs == Long.MAX_VALUE) {
                MediaCodecVideoRenderer.this.onProcessedTunneledEndOfStream();
            } else {
                try {
                    MediaCodecVideoRenderer.this.onProcessedTunneledBuffer(presentationTimeUs);
                }
                catch (ExoPlaybackException e) {
                    MediaCodecVideoRenderer.this.setPendingPlaybackException(e);
                }
            }
        }
    }

    protected static final class CodecMaxValues {
        public final int width;
        public final int height;
        public final int inputSize;

        public CodecMaxValues(int width, int height, int inputSize) {
            this.width = width;
            this.height = height;
            this.inputSize = inputSize;
        }
    }
}

