/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.upstream;

import android.content.Context;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlayerLibraryInfo;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultDataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.akamai.amp.exoplayer2.upstream.TransferListener;

public final class DefaultDataSourceFactory
implements DataSource.Factory {
    private final Context context;
    @Nullable
    private final TransferListener listener;
    private final DataSource.Factory baseDataSourceFactory;

    public DefaultDataSourceFactory(Context context) {
        this(context, ExoPlayerLibraryInfo.DEFAULT_USER_AGENT, null);
    }

    public DefaultDataSourceFactory(Context context, String userAgent) {
        this(context, userAgent, null);
    }

    public DefaultDataSourceFactory(Context context, String userAgent, @Nullable TransferListener listener) {
        this(context, listener, new DefaultHttpDataSourceFactory(userAgent, listener));
    }

    public DefaultDataSourceFactory(Context context, DataSource.Factory baseDataSourceFactory) {
        this(context, null, baseDataSourceFactory);
    }

    public DefaultDataSourceFactory(Context context, @Nullable TransferListener listener, DataSource.Factory baseDataSourceFactory) {
        this.context = context.getApplicationContext();
        this.listener = listener;
        this.baseDataSourceFactory = baseDataSourceFactory;
    }

    @Override
    public DefaultDataSource createDataSource() {
        DefaultDataSource dataSource = new DefaultDataSource(this.context, this.baseDataSourceFactory.createDataSource());
        if (this.listener != null) {
            dataSource.addTransferListener(this.listener);
        }
        return dataSource;
    }
}

