/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.text.CaptionStyleCompat;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class SubtitlePainter {
    private static final String TAG = "SubtitlePainter";
    private static final float INNER_PADDING_RATIO = 0.125f;
    private final float outlineWidth;
    private final float shadowRadius;
    private final float shadowOffset;
    private final float spacingMult;
    private final float spacingAdd;
    private final TextPaint textPaint;
    private final Paint windowPaint;
    private final Paint bitmapPaint;
    @Nullable
    private CharSequence cueText;
    @Nullable
    private Layout.Alignment cueTextAlignment;
    @Nullable
    private Bitmap cueBitmap;
    private float cueLine;
    private int cueLineType;
    private int cueLineAnchor;
    private float cuePosition;
    private int cuePositionAnchor;
    private float cueSize;
    private float cueBitmapHeight;
    private int foregroundColor;
    private int backgroundColor;
    private int windowColor;
    private int edgeColor;
    private int edgeType;
    private float defaultTextSizePx;
    private float cueTextSizePx;
    private float bottomPaddingFraction;
    private int parentLeft;
    private int parentTop;
    private int parentRight;
    private int parentBottom;
    private @MonotonicNonNull StaticLayout textLayout;
    private @MonotonicNonNull StaticLayout edgeLayout;
    private int textLeft;
    private int textTop;
    private int textPaddingX;
    private @MonotonicNonNull Rect bitmapRect;

    public SubtitlePainter(Context context) {
        int[] viewAttr = new int[]{16843287, 16843288};
        TypedArray styledAttributes = context.obtainStyledAttributes(null, viewAttr, 0, 0);
        this.spacingAdd = styledAttributes.getDimensionPixelSize(0, 0);
        this.spacingMult = styledAttributes.getFloat(1, 1.0f);
        styledAttributes.recycle();
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int twoDpInPx = Math.round(2.0f * (float)displayMetrics.densityDpi / 160.0f);
        this.outlineWidth = twoDpInPx;
        this.shadowRadius = twoDpInPx;
        this.shadowOffset = twoDpInPx;
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setSubpixelText(true);
        this.windowPaint = new Paint();
        this.windowPaint.setAntiAlias(true);
        this.windowPaint.setStyle(Paint.Style.FILL);
        this.bitmapPaint = new Paint();
        this.bitmapPaint.setAntiAlias(true);
        this.bitmapPaint.setFilterBitmap(true);
    }

    public void draw(Cue cue, CaptionStyleCompat style2, float defaultTextSizePx, float cueTextSizePx, float bottomPaddingFraction, Canvas canvas, int cueBoxLeft, int cueBoxTop, int cueBoxRight, int cueBoxBottom) {
        boolean isTextCue = cue.bitmap == null;
        int windowColor = -16777216;
        if (isTextCue) {
            if (TextUtils.isEmpty((CharSequence)cue.text)) {
                return;
            }
            int n = windowColor = cue.windowColorSet ? cue.windowColor : style2.windowColor;
        }
        if (SubtitlePainter.areCharSequencesEqual(this.cueText, cue.text) && Util.areEqual(this.cueTextAlignment, cue.textAlignment) && this.cueBitmap == cue.bitmap && this.cueLine == cue.line && this.cueLineType == cue.lineType && Util.areEqual(this.cueLineAnchor, cue.lineAnchor) && this.cuePosition == cue.position && Util.areEqual(this.cuePositionAnchor, cue.positionAnchor) && this.cueSize == cue.size && this.cueBitmapHeight == cue.bitmapHeight && this.foregroundColor == style2.foregroundColor && this.backgroundColor == style2.backgroundColor && this.windowColor == windowColor && this.edgeType == style2.edgeType && this.edgeColor == style2.edgeColor && Util.areEqual(this.textPaint.getTypeface(), style2.typeface) && this.defaultTextSizePx == defaultTextSizePx && this.cueTextSizePx == cueTextSizePx && this.bottomPaddingFraction == bottomPaddingFraction && this.parentLeft == cueBoxLeft && this.parentTop == cueBoxTop && this.parentRight == cueBoxRight && this.parentBottom == cueBoxBottom) {
            this.drawLayout(canvas, isTextCue);
            return;
        }
        this.cueText = cue.text;
        this.cueTextAlignment = cue.textAlignment;
        this.cueBitmap = cue.bitmap;
        this.cueLine = cue.line;
        this.cueLineType = cue.lineType;
        this.cueLineAnchor = cue.lineAnchor;
        this.cuePosition = cue.position;
        this.cuePositionAnchor = cue.positionAnchor;
        this.cueSize = cue.size;
        this.cueBitmapHeight = cue.bitmapHeight;
        this.foregroundColor = style2.foregroundColor;
        this.backgroundColor = style2.backgroundColor;
        this.windowColor = windowColor;
        this.edgeType = style2.edgeType;
        this.edgeColor = style2.edgeColor;
        this.textPaint.setTypeface(style2.typeface);
        this.defaultTextSizePx = defaultTextSizePx;
        this.cueTextSizePx = cueTextSizePx;
        this.bottomPaddingFraction = bottomPaddingFraction;
        this.parentLeft = cueBoxLeft;
        this.parentTop = cueBoxTop;
        this.parentRight = cueBoxRight;
        this.parentBottom = cueBoxBottom;
        if (isTextCue) {
            Assertions.checkNotNull(this.cueText);
            this.setupTextLayout();
        } else {
            Assertions.checkNotNull(this.cueBitmap);
            this.setupBitmapLayout();
        }
        this.drawLayout(canvas, isTextCue);
    }

    @RequiresNonNull(value={"cueText"})
    private void setupTextLayout() {
        int textTop;
        int textRight;
        int textLeft;
        SpannableStringBuilder cueText = this.cueText instanceof SpannableStringBuilder ? (SpannableStringBuilder)this.cueText : new SpannableStringBuilder(this.cueText);
        int parentWidth = this.parentRight - this.parentLeft;
        int parentHeight = this.parentBottom - this.parentTop;
        this.textPaint.setTextSize(this.defaultTextSizePx);
        int textPaddingX = (int)(this.defaultTextSizePx * 0.125f + 0.5f);
        int availableWidth = parentWidth - textPaddingX * 2;
        if (this.cueSize != -3.4028235E38f) {
            availableWidth = (int)((float)availableWidth * this.cueSize);
        }
        if (availableWidth <= 0) {
            Log.w(TAG, "Skipped drawing subtitle cue (insufficient space)");
            return;
        }
        if (this.cueTextSizePx > 0.0f) {
            cueText.setSpan((Object)new AbsoluteSizeSpan((int)this.cueTextSizePx), 0, cueText.length(), 0xFF0000);
        }
        SpannableStringBuilder cueTextEdge = new SpannableStringBuilder((CharSequence)cueText);
        if (this.edgeType == 1) {
            ForegroundColorSpan[] foregroundColorSpans;
            for (ForegroundColorSpan foregroundColorSpan : foregroundColorSpans = (ForegroundColorSpan[])cueTextEdge.getSpans(0, cueTextEdge.length(), ForegroundColorSpan.class)) {
                cueTextEdge.removeSpan((Object)foregroundColorSpan);
            }
        }
        if (Color.alpha((int)this.backgroundColor) > 0) {
            if (this.edgeType == 0 || this.edgeType == 2) {
                cueText.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), 0, cueText.length(), 0xFF0000);
            } else {
                cueTextEdge.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), 0, cueTextEdge.length(), 0xFF0000);
            }
        }
        Layout.Alignment textAlignment = this.cueTextAlignment == null ? Layout.Alignment.ALIGN_CENTER : this.cueTextAlignment;
        this.textLayout = new StaticLayout((CharSequence)cueText, this.textPaint, availableWidth, textAlignment, this.spacingMult, this.spacingAdd, true);
        int textHeight = this.textLayout.getHeight();
        int textWidth = 0;
        int lineCount = this.textLayout.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            textWidth = Math.max((int)Math.ceil(this.textLayout.getLineWidth(i)), textWidth);
        }
        if (this.cueSize != -3.4028235E38f && textWidth < availableWidth) {
            textWidth = availableWidth;
        }
        textWidth += textPaddingX * 2;
        if (this.cuePosition != -3.4028235E38f) {
            int anchorPosition = Math.round((float)parentWidth * this.cuePosition) + this.parentLeft;
            switch (this.cuePositionAnchor) {
                case 2: {
                    textLeft = anchorPosition - textWidth;
                    break;
                }
                case 1: {
                    textLeft = (anchorPosition * 2 - textWidth) / 2;
                    break;
                }
                default: {
                    textLeft = anchorPosition;
                }
            }
            textLeft = Math.max(textLeft, this.parentLeft);
            textRight = Math.min(textLeft + textWidth, this.parentRight);
        } else {
            textLeft = (parentWidth - textWidth) / 2 + this.parentLeft;
            textRight = textLeft + textWidth;
        }
        textWidth = textRight - textLeft;
        if (textWidth <= 0) {
            Log.w(TAG, "Skipped drawing subtitle cue (invalid horizontal positioning)");
            return;
        }
        if (this.cueLine != -3.4028235E38f) {
            if (this.cueLineType == 0) {
                int anchorPosition = Math.round((float)parentHeight * this.cueLine) + this.parentTop;
                textTop = this.cueLineAnchor == 2 ? anchorPosition - textHeight : (this.cueLineAnchor == 1 ? (anchorPosition * 2 - textHeight) / 2 : anchorPosition);
            } else {
                int firstLineHeight = this.textLayout.getLineBottom(0) - this.textLayout.getLineTop(0);
                textTop = this.cueLine >= 0.0f ? Math.round(this.cueLine * (float)firstLineHeight) + this.parentTop : Math.round((this.cueLine + 1.0f) * (float)firstLineHeight) + this.parentBottom - textHeight;
            }
            if (textTop + textHeight > this.parentBottom) {
                textTop = this.parentBottom - textHeight;
            } else if (textTop < this.parentTop) {
                textTop = this.parentTop;
            }
        } else {
            textTop = this.parentBottom - textHeight - (int)((float)parentHeight * this.bottomPaddingFraction);
        }
        this.textLayout = new StaticLayout((CharSequence)cueText, this.textPaint, textWidth, textAlignment, this.spacingMult, this.spacingAdd, true);
        this.edgeLayout = new StaticLayout((CharSequence)cueTextEdge, this.textPaint, textWidth, textAlignment, this.spacingMult, this.spacingAdd, true);
        this.textLeft = textLeft;
        this.textTop = textTop;
        this.textPaddingX = textPaddingX;
    }

    @RequiresNonNull(value={"cueBitmap"})
    private void setupBitmapLayout() {
        int height;
        Bitmap cueBitmap = this.cueBitmap;
        int parentWidth = this.parentRight - this.parentLeft;
        int parentHeight = this.parentBottom - this.parentTop;
        float anchorX = (float)this.parentLeft + (float)parentWidth * this.cuePosition;
        float anchorY = (float)this.parentTop + (float)parentHeight * this.cueLine;
        int width = Math.round((float)parentWidth * this.cueSize);
        int n = height = this.cueBitmapHeight != -3.4028235E38f ? Math.round((float)parentHeight * this.cueBitmapHeight) : Math.round((float)width * ((float)cueBitmap.getHeight() / (float)cueBitmap.getWidth()));
        int x = Math.round(this.cuePositionAnchor == 2 ? anchorX - (float)width : (this.cuePositionAnchor == 1 ? anchorX - (float)(width / 2) : anchorX));
        int y = Math.round(this.cueLineAnchor == 2 ? anchorY - (float)height : (this.cueLineAnchor == 1 ? anchorY - (float)(height / 2) : anchorY));
        this.bitmapRect = new Rect(x, y, x + width, y + height);
    }

    private void drawLayout(Canvas canvas, boolean isTextCue) {
        if (isTextCue) {
            this.drawTextLayout(canvas);
        } else {
            Assertions.checkNotNull(this.bitmapRect);
            Assertions.checkNotNull(this.cueBitmap);
            this.drawBitmapLayout(canvas);
        }
    }

    private void drawTextLayout(Canvas canvas) {
        StaticLayout textLayout = this.textLayout;
        StaticLayout edgeLayout = this.edgeLayout;
        if (textLayout == null || edgeLayout == null) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate((float)this.textLeft, (float)this.textTop);
        if (Color.alpha((int)this.windowColor) > 0) {
            this.windowPaint.setColor(this.windowColor);
            canvas.drawRect((float)(-this.textPaddingX), 0.0f, (float)(textLayout.getWidth() + this.textPaddingX), (float)textLayout.getHeight(), this.windowPaint);
        }
        if (this.edgeType == 1) {
            this.textPaint.setStrokeJoin(Paint.Join.ROUND);
            this.textPaint.setStrokeWidth(this.outlineWidth);
            this.textPaint.setColor(this.edgeColor);
            this.textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            edgeLayout.draw(canvas);
        } else if (this.edgeType == 2) {
            this.textPaint.setShadowLayer(this.shadowRadius, this.shadowOffset, this.shadowOffset, this.edgeColor);
        } else if (this.edgeType == 3 || this.edgeType == 4) {
            boolean raised = this.edgeType == 3;
            int colorUp = raised ? -1 : this.edgeColor;
            int colorDown = raised ? this.edgeColor : -1;
            float offset = this.shadowRadius / 2.0f;
            this.textPaint.setColor(this.foregroundColor);
            this.textPaint.setStyle(Paint.Style.FILL);
            this.textPaint.setShadowLayer(this.shadowRadius, -offset, -offset, colorUp);
            edgeLayout.draw(canvas);
            this.textPaint.setShadowLayer(this.shadowRadius, offset, offset, colorDown);
        }
        this.textPaint.setColor(this.foregroundColor);
        this.textPaint.setStyle(Paint.Style.FILL);
        textLayout.draw(canvas);
        this.textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        canvas.restoreToCount(saveCount);
    }

    @RequiresNonNull(value={"cueBitmap", "bitmapRect"})
    private void drawBitmapLayout(Canvas canvas) {
        canvas.drawBitmap(this.cueBitmap, null, this.bitmapRect, this.bitmapPaint);
    }

    private static boolean areCharSequencesEqual(@Nullable CharSequence first, @Nullable CharSequence second) {
        return first == second || first != null && first.equals(second);
    }
}

