/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.trackselection;

import android.content.Context;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.Locale;

public class TrackSelectionParameters
implements Parcelable {
    public static final TrackSelectionParameters DEFAULT_WITHOUT_CONTEXT;
    @Deprecated
    public static final TrackSelectionParameters DEFAULT;
    @Nullable
    public final String preferredAudioLanguage;
    @Nullable
    public final String preferredTextLanguage;
    public final int preferredTextRoleFlags;
    public final boolean selectUndeterminedTextLanguage;
    public final int disabledTextTrackSelectionFlags;
    public static final Parcelable.Creator<TrackSelectionParameters> CREATOR;

    public static TrackSelectionParameters getDefaults(Context context) {
        return new Builder(context).build();
    }

    TrackSelectionParameters(@Nullable String preferredAudioLanguage, @Nullable String preferredTextLanguage, int preferredTextRoleFlags, boolean selectUndeterminedTextLanguage, int disabledTextTrackSelectionFlags) {
        this.preferredAudioLanguage = Util.normalizeLanguageCode(preferredAudioLanguage);
        this.preferredTextLanguage = Util.normalizeLanguageCode(preferredTextLanguage);
        this.preferredTextRoleFlags = preferredTextRoleFlags;
        this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
        this.disabledTextTrackSelectionFlags = disabledTextTrackSelectionFlags;
    }

    TrackSelectionParameters(Parcel in) {
        this.preferredAudioLanguage = in.readString();
        this.preferredTextLanguage = in.readString();
        this.preferredTextRoleFlags = in.readInt();
        this.selectUndeterminedTextLanguage = Util.readBoolean(in);
        this.disabledTextTrackSelectionFlags = in.readInt();
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionParameters other = (TrackSelectionParameters)obj;
        return TextUtils.equals((CharSequence)this.preferredAudioLanguage, (CharSequence)other.preferredAudioLanguage) && TextUtils.equals((CharSequence)this.preferredTextLanguage, (CharSequence)other.preferredTextLanguage) && this.preferredTextRoleFlags == other.preferredTextRoleFlags && this.selectUndeterminedTextLanguage == other.selectUndeterminedTextLanguage && this.disabledTextTrackSelectionFlags == other.disabledTextTrackSelectionFlags;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.preferredAudioLanguage == null ? 0 : this.preferredAudioLanguage.hashCode());
        result = 31 * result + (this.preferredTextLanguage == null ? 0 : this.preferredTextLanguage.hashCode());
        result = 31 * result + this.preferredTextRoleFlags;
        result = 31 * result + (this.selectUndeterminedTextLanguage ? 1 : 0);
        result = 31 * result + this.disabledTextTrackSelectionFlags;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.preferredAudioLanguage);
        dest.writeString(this.preferredTextLanguage);
        dest.writeInt(this.preferredTextRoleFlags);
        Util.writeBoolean(dest, this.selectUndeterminedTextLanguage);
        dest.writeInt(this.disabledTextTrackSelectionFlags);
    }

    static {
        DEFAULT = DEFAULT_WITHOUT_CONTEXT = new Builder().build();
        CREATOR = new Parcelable.Creator<TrackSelectionParameters>(){

            public TrackSelectionParameters createFromParcel(Parcel in) {
                return new TrackSelectionParameters(in);
            }

            public TrackSelectionParameters[] newArray(int size) {
                return new TrackSelectionParameters[size];
            }
        };
    }

    public static class Builder {
        @Nullable
        String preferredAudioLanguage;
        @Nullable
        String preferredTextLanguage;
        int preferredTextRoleFlags;
        boolean selectUndeterminedTextLanguage;
        int disabledTextTrackSelectionFlags;

        public Builder(Context context) {
            this();
            this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
        }

        @Deprecated
        public Builder() {
            this.preferredAudioLanguage = null;
            this.preferredTextLanguage = null;
            this.preferredTextRoleFlags = 0;
            this.selectUndeterminedTextLanguage = false;
            this.disabledTextTrackSelectionFlags = 0;
        }

        Builder(TrackSelectionParameters initialValues) {
            this.preferredAudioLanguage = initialValues.preferredAudioLanguage;
            this.preferredTextLanguage = initialValues.preferredTextLanguage;
            this.preferredTextRoleFlags = initialValues.preferredTextRoleFlags;
            this.selectUndeterminedTextLanguage = initialValues.selectUndeterminedTextLanguage;
            this.disabledTextTrackSelectionFlags = initialValues.disabledTextTrackSelectionFlags;
        }

        public Builder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            this.preferredAudioLanguage = preferredAudioLanguage;
            return this;
        }

        public Builder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            if (Util.SDK_INT >= 19) {
                this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(context);
            }
            return this;
        }

        public Builder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            this.preferredTextLanguage = preferredTextLanguage;
            return this;
        }

        public Builder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
            this.preferredTextRoleFlags = preferredTextRoleFlags;
            return this;
        }

        public Builder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
            return this;
        }

        public Builder setDisabledTextTrackSelectionFlags(int disabledTextTrackSelectionFlags) {
            this.disabledTextTrackSelectionFlags = disabledTextTrackSelectionFlags;
            return this;
        }

        public TrackSelectionParameters build() {
            return new TrackSelectionParameters(this.preferredAudioLanguage, this.preferredTextLanguage, this.preferredTextRoleFlags, this.selectUndeterminedTextLanguage, this.disabledTextTrackSelectionFlags);
        }

        @RequiresApi(value=19)
        private void setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(Context context) {
            if (Util.SDK_INT < 23 && Looper.myLooper() == null) {
                return;
            }
            CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
            if (captioningManager == null || !captioningManager.isEnabled()) {
                return;
            }
            this.preferredTextRoleFlags = 1088;
            Locale preferredLocale = captioningManager.getLocale();
            if (preferredLocale != null) {
                this.preferredTextLanguage = Util.getLocaleLanguageTag(preferredLocale);
            }
        }
    }
}

