/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.ssa;

import android.graphics.PointF;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SsaStyle {
    private static final String TAG = "SsaStyle";
    public static final int SSA_ALIGNMENT_UNKNOWN = -1;
    public static final int SSA_ALIGNMENT_BOTTOM_LEFT = 1;
    public static final int SSA_ALIGNMENT_BOTTOM_CENTER = 2;
    public static final int SSA_ALIGNMENT_BOTTOM_RIGHT = 3;
    public static final int SSA_ALIGNMENT_MIDDLE_LEFT = 4;
    public static final int SSA_ALIGNMENT_MIDDLE_CENTER = 5;
    public static final int SSA_ALIGNMENT_MIDDLE_RIGHT = 6;
    public static final int SSA_ALIGNMENT_TOP_LEFT = 7;
    public static final int SSA_ALIGNMENT_TOP_CENTER = 8;
    public static final int SSA_ALIGNMENT_TOP_RIGHT = 9;
    public final String name;
    public final int alignment;

    private SsaStyle(String name, int alignment) {
        this.name = name;
        this.alignment = alignment;
    }

    @Nullable
    public static SsaStyle fromStyleLine(String styleLine, Format format) {
        Assertions.checkArgument(styleLine.startsWith("Style:"));
        String[] styleValues = TextUtils.split((String)styleLine.substring("Style:".length()), (String)",");
        if (styleValues.length != format.length) {
            Log.w(TAG, Util.formatInvariant("Skipping malformed 'Style:' line (expected %s values, found %s): '%s'", format.length, styleValues.length, styleLine));
            return null;
        }
        try {
            return new SsaStyle(styleValues[format.nameIndex].trim(), SsaStyle.parseAlignment(styleValues[format.alignmentIndex]));
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Skipping malformed 'Style:' line: '" + styleLine + "'", e);
            return null;
        }
    }

    private static int parseAlignment(String alignmentStr) {
        try {
            int alignment = Integer.parseInt(alignmentStr.trim());
            if (SsaStyle.isValidAlignment(alignment)) {
                return alignment;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Log.w(TAG, "Ignoring unknown alignment: " + alignmentStr);
        return -1;
    }

    private static boolean isValidAlignment(int alignment) {
        switch (alignment) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    static final class Format {
        public final int nameIndex;
        public final int alignmentIndex;
        public final int length;

        private Format(int nameIndex, int alignmentIndex, int length) {
            this.nameIndex = nameIndex;
            this.alignmentIndex = alignmentIndex;
            this.length = length;
        }

        @Nullable
        public static Format fromFormatLine(String styleFormatLine) {
            int nameIndex = -1;
            int alignmentIndex = -1;
            String[] keys = TextUtils.split((String)styleFormatLine.substring("Format:".length()), (String)",");
            block8: for (int i = 0; i < keys.length; ++i) {
                switch (Util.toLowerInvariant(keys[i].trim())) {
                    case "name": {
                        nameIndex = i;
                        continue block8;
                    }
                    case "alignment": {
                        alignmentIndex = i;
                    }
                }
            }
            return nameIndex != -1 ? new Format(nameIndex, alignmentIndex, keys.length) : null;
        }
    }

    static final class Overrides {
        private static final String TAG = "SsaStyle.Overrides";
        private static final Pattern BRACES_PATTERN = Pattern.compile("\\{([^}]*)\\}");
        private static final String PADDED_DECIMAL_PATTERN = "\\s*\\d+(?:\\.\\d+)?\\s*";
        private static final Pattern POSITION_PATTERN = Pattern.compile(Util.formatInvariant("\\\\pos\\((%1$s),(%1$s)\\)", "\\s*\\d+(?:\\.\\d+)?\\s*"));
        private static final Pattern MOVE_PATTERN = Pattern.compile(Util.formatInvariant("\\\\move\\(%1$s,%1$s,(%1$s),(%1$s)(?:,%1$s,%1$s)?\\)", "\\s*\\d+(?:\\.\\d+)?\\s*"));
        private static final Pattern ALIGNMENT_OVERRIDE_PATTERN = Pattern.compile("\\\\an(\\d+)");
        public final int alignment;
        @Nullable
        public final PointF position;

        private Overrides(int alignment, @Nullable PointF position) {
            this.alignment = alignment;
            this.position = position;
        }

        public static Overrides parseFromDialogue(String text) {
            int alignment = -1;
            PointF position = null;
            Matcher matcher = BRACES_PATTERN.matcher(text);
            while (matcher.find()) {
                String braceContents = Assertions.checkNotNull(matcher.group(1));
                try {
                    PointF parsedPosition = Overrides.parsePosition(braceContents);
                    if (parsedPosition != null) {
                        position = parsedPosition;
                    }
                }
                catch (RuntimeException parsedPosition) {
                    // empty catch block
                }
                try {
                    int parsedAlignment = Overrides.parseAlignmentOverride(braceContents);
                    if (parsedAlignment == -1) continue;
                    alignment = parsedAlignment;
                }
                catch (RuntimeException runtimeException) {}
            }
            return new Overrides(alignment, position);
        }

        public static String stripStyleOverrides(String dialogueLine) {
            return BRACES_PATTERN.matcher(dialogueLine).replaceAll("");
        }

        @Nullable
        private static PointF parsePosition(String styleOverride) {
            String y;
            String x;
            Matcher positionMatcher = POSITION_PATTERN.matcher(styleOverride);
            Matcher moveMatcher = MOVE_PATTERN.matcher(styleOverride);
            boolean hasPosition = positionMatcher.find();
            boolean hasMove = moveMatcher.find();
            if (hasPosition) {
                if (hasMove) {
                    Log.i(TAG, "Override has both \\pos(x,y) and \\move(x1,y1,x2,y2); using \\pos values. override='" + styleOverride + "'");
                }
                x = positionMatcher.group(1);
                y = positionMatcher.group(2);
            } else if (hasMove) {
                x = moveMatcher.group(1);
                y = moveMatcher.group(2);
            } else {
                return null;
            }
            return new PointF(Float.parseFloat(Assertions.checkNotNull(x).trim()), Float.parseFloat(Assertions.checkNotNull(y).trim()));
        }

        private static int parseAlignmentOverride(String braceContents) {
            Matcher matcher = ALIGNMENT_OVERRIDE_PATTERN.matcher(braceContents);
            return matcher.find() ? SsaStyle.parseAlignment(Assertions.checkNotNull(matcher.group(1))) : -1;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SsaAlignment {
    }
}

