/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.hls;

import android.net.Uri;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.source.BehindLiveWindowException;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.chunk.BaseMediaChunkIterator;
import com.akamai.amp.exoplayer2.source.chunk.Chunk;
import com.akamai.amp.exoplayer2.source.chunk.DataChunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunkIterator;
import com.akamai.amp.exoplayer2.source.hls.FullSegmentEncryptionKeyCache;
import com.akamai.amp.exoplayer2.source.hls.HlsDataSourceFactory;
import com.akamai.amp.exoplayer2.source.hls.HlsExtractorFactory;
import com.akamai.amp.exoplayer2.source.hls.HlsMediaChunk;
import com.akamai.amp.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.akamai.amp.exoplayer2.trackselection.BaseTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.UriUtil;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class HlsChunkSource {
    private static final int KEY_CACHE_SIZE = 4;
    private final HlsExtractorFactory extractorFactory;
    private final DataSource mediaDataSource;
    private final DataSource encryptionDataSource;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final Uri[] playlistUrls;
    private final Format[] playlistFormats;
    private final HlsPlaylistTracker playlistTracker;
    private final TrackGroup trackGroup;
    @Nullable
    private final List<Format> muxedCaptionFormats;
    private final FullSegmentEncryptionKeyCache keyCache;
    private boolean isTimestampMaster;
    private byte[] scratchSpace;
    @Nullable
    private IOException fatalError;
    @Nullable
    private Uri expectedPlaylistUrl;
    private boolean independentSegments;
    private TrackSelection trackSelection;
    private long liveEdgeInPeriodTimeUs;
    private boolean seenExpectedPlaylistError;

    public HlsChunkSource(HlsExtractorFactory extractorFactory, HlsPlaylistTracker playlistTracker, Uri[] playlistUrls, Format[] playlistFormats, HlsDataSourceFactory dataSourceFactory, @Nullable TransferListener mediaTransferListener, TimestampAdjusterProvider timestampAdjusterProvider, @Nullable List<Format> muxedCaptionFormats) {
        this.extractorFactory = extractorFactory;
        this.playlistTracker = playlistTracker;
        this.playlistUrls = playlistUrls;
        this.playlistFormats = playlistFormats;
        this.timestampAdjusterProvider = timestampAdjusterProvider;
        this.muxedCaptionFormats = muxedCaptionFormats;
        this.keyCache = new FullSegmentEncryptionKeyCache(4);
        this.scratchSpace = Util.EMPTY_BYTE_ARRAY;
        this.liveEdgeInPeriodTimeUs = -9223372036854775807L;
        this.mediaDataSource = dataSourceFactory.createDataSource(1);
        if (mediaTransferListener != null) {
            this.mediaDataSource.addTransferListener(mediaTransferListener);
        }
        this.encryptionDataSource = dataSourceFactory.createDataSource(3);
        this.trackGroup = new TrackGroup(playlistFormats);
        ArrayList<Integer> initialTrackSelection = new ArrayList<Integer>();
        for (int i = 0; i < playlistUrls.length; ++i) {
            if ((playlistFormats[i].roleFlags & 0x4000) != 0) continue;
            initialTrackSelection.add(i);
        }
        this.trackSelection = new InitializationTrackSelection(this.trackGroup, Ints.toArray(initialTrackSelection));
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        if (this.expectedPlaylistUrl != null && this.seenExpectedPlaylistError) {
            this.playlistTracker.maybeThrowPlaylistRefreshError(this.expectedPlaylistUrl);
        }
    }

    public TrackGroup getTrackGroup() {
        return this.trackGroup;
    }

    public void setTrackSelection(TrackSelection trackSelection) {
        this.trackSelection = trackSelection;
    }

    public TrackSelection getTrackSelection() {
        return this.trackSelection;
    }

    public void reset() {
        this.fatalError = null;
    }

    public void setIsTimestampMaster(boolean isTimestampMaster) {
        this.isTimestampMaster = isTimestampMaster;
    }

    public void getNextChunk(long playbackPositionUs, long loadPositionUs, List<HlsMediaChunk> queue, boolean allowEndOfStream, HlsChunkHolder out) {
        HlsMediaChunk previous = queue.isEmpty() ? null : queue.get(queue.size() - 1);
        int oldTrackIndex = previous == null ? -1 : this.trackGroup.indexOf(previous.trackFormat);
        long bufferedDurationUs = loadPositionUs - playbackPositionUs;
        long timeToLiveEdgeUs = this.resolveTimeToLiveEdgeUs(playbackPositionUs);
        if (previous != null && !this.independentSegments) {
            long subtractedDurationUs = previous.getDurationUs();
            bufferedDurationUs = Math.max(0L, bufferedDurationUs - subtractedDurationUs);
            if (timeToLiveEdgeUs != -9223372036854775807L) {
                timeToLiveEdgeUs = Math.max(0L, timeToLiveEdgeUs - subtractedDurationUs);
            }
        }
        MediaChunkIterator[] mediaChunkIterators = this.createMediaChunkIterators(previous, loadPositionUs);
        this.trackSelection.updateSelectedTrack(playbackPositionUs, bufferedDurationUs, timeToLiveEdgeUs, queue, mediaChunkIterators);
        int selectedTrackIndex = this.trackSelection.getSelectedIndexInTrackGroup();
        boolean switchingTrack = oldTrackIndex != selectedTrackIndex;
        Uri selectedPlaylistUrl = this.playlistUrls[selectedTrackIndex];
        if (!this.playlistTracker.isSnapshotValid(selectedPlaylistUrl)) {
            out.playlistUrl = selectedPlaylistUrl;
            this.seenExpectedPlaylistError &= selectedPlaylistUrl.equals((Object)this.expectedPlaylistUrl);
            this.expectedPlaylistUrl = selectedPlaylistUrl;
            return;
        }
        HlsMediaPlaylist mediaPlaylist = this.playlistTracker.getPlaylistSnapshot(selectedPlaylistUrl, true);
        Assertions.checkNotNull(mediaPlaylist);
        this.independentSegments = mediaPlaylist.hasIndependentSegments;
        this.updateLiveEdgeTimeUs(mediaPlaylist);
        long startOfPlaylistInPeriodUs = mediaPlaylist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
        long chunkMediaSequence = this.getChunkMediaSequence(previous, switchingTrack, mediaPlaylist, startOfPlaylistInPeriodUs, loadPositionUs);
        if (chunkMediaSequence < mediaPlaylist.mediaSequence && previous != null && switchingTrack) {
            selectedTrackIndex = oldTrackIndex;
            selectedPlaylistUrl = this.playlistUrls[selectedTrackIndex];
            mediaPlaylist = this.playlistTracker.getPlaylistSnapshot(selectedPlaylistUrl, true);
            Assertions.checkNotNull(mediaPlaylist);
            startOfPlaylistInPeriodUs = mediaPlaylist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            chunkMediaSequence = previous.getNextChunkIndex();
        }
        if (chunkMediaSequence < mediaPlaylist.mediaSequence) {
            this.fatalError = new BehindLiveWindowException();
            return;
        }
        int segmentIndexInPlaylist = (int)(chunkMediaSequence - mediaPlaylist.mediaSequence);
        int availableSegmentCount = mediaPlaylist.segments.size();
        if (segmentIndexInPlaylist >= availableSegmentCount) {
            if (mediaPlaylist.hasEndTag) {
                if (allowEndOfStream || availableSegmentCount == 0) {
                    out.endOfStream = true;
                    return;
                }
                segmentIndexInPlaylist = availableSegmentCount - 1;
            } else {
                out.playlistUrl = selectedPlaylistUrl;
                this.seenExpectedPlaylistError &= selectedPlaylistUrl.equals((Object)this.expectedPlaylistUrl);
                this.expectedPlaylistUrl = selectedPlaylistUrl;
                return;
            }
        }
        this.seenExpectedPlaylistError = false;
        this.expectedPlaylistUrl = null;
        HlsMediaPlaylist.Segment segment = mediaPlaylist.segments.get(segmentIndexInPlaylist);
        Uri initSegmentKeyUri = HlsChunkSource.getFullEncryptionKeyUri(mediaPlaylist, segment.initializationSegment);
        out.chunk = this.maybeCreateEncryptionChunkFor(initSegmentKeyUri, selectedTrackIndex);
        if (out.chunk != null) {
            return;
        }
        Uri mediaSegmentKeyUri = HlsChunkSource.getFullEncryptionKeyUri(mediaPlaylist, segment);
        out.chunk = this.maybeCreateEncryptionChunkFor(mediaSegmentKeyUri, selectedTrackIndex);
        if (out.chunk != null) {
            return;
        }
        out.chunk = HlsMediaChunk.createInstance(this.extractorFactory, this.mediaDataSource, this.playlistFormats[selectedTrackIndex], startOfPlaylistInPeriodUs, mediaPlaylist, segmentIndexInPlaylist, selectedPlaylistUrl, this.muxedCaptionFormats, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), this.isTimestampMaster, this.timestampAdjusterProvider, previous, this.keyCache.get(mediaSegmentKeyUri), this.keyCache.get(initSegmentKeyUri));
    }

    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof EncryptionKeyChunk) {
            EncryptionKeyChunk encryptionKeyChunk = (EncryptionKeyChunk)chunk;
            this.scratchSpace = encryptionKeyChunk.getDataHolder();
            this.keyCache.put(encryptionKeyChunk.dataSpec.uri, Assertions.checkNotNull(encryptionKeyChunk.getResult()));
        }
    }

    public boolean maybeExcludeTrack(Chunk chunk, long exclusionDurationMs) {
        return this.trackSelection.blacklist(this.trackSelection.indexOf(this.trackGroup.indexOf(chunk.trackFormat)), exclusionDurationMs);
    }

    public boolean onPlaylistError(Uri playlistUrl, long exclusionDurationMs) {
        int trackGroupIndex = -1;
        for (int i = 0; i < this.playlistUrls.length; ++i) {
            if (!this.playlistUrls[i].equals((Object)playlistUrl)) continue;
            trackGroupIndex = i;
            break;
        }
        if (trackGroupIndex == -1) {
            return true;
        }
        int trackSelectionIndex = this.trackSelection.indexOf(trackGroupIndex);
        if (trackSelectionIndex == -1) {
            return true;
        }
        this.seenExpectedPlaylistError |= playlistUrl.equals((Object)this.expectedPlaylistUrl);
        return exclusionDurationMs == -9223372036854775807L || this.trackSelection.blacklist(trackSelectionIndex, exclusionDurationMs);
    }

    public MediaChunkIterator[] createMediaChunkIterators(@Nullable HlsMediaChunk previous, long loadPositionUs) {
        int oldTrackIndex = previous == null ? -1 : this.trackGroup.indexOf(previous.trackFormat);
        MediaChunkIterator[] chunkIterators = new MediaChunkIterator[this.trackSelection.length()];
        for (int i = 0; i < chunkIterators.length; ++i) {
            int trackIndex = this.trackSelection.getIndexInTrackGroup(i);
            Uri playlistUrl = this.playlistUrls[trackIndex];
            if (!this.playlistTracker.isSnapshotValid(playlistUrl)) {
                chunkIterators[i] = MediaChunkIterator.EMPTY;
                continue;
            }
            HlsMediaPlaylist playlist = this.playlistTracker.getPlaylistSnapshot(playlistUrl, false);
            Assertions.checkNotNull(playlist);
            long startOfPlaylistInPeriodUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            boolean switchingTrack = trackIndex != oldTrackIndex;
            long chunkMediaSequence = this.getChunkMediaSequence(previous, switchingTrack, playlist, startOfPlaylistInPeriodUs, loadPositionUs);
            if (chunkMediaSequence < playlist.mediaSequence) {
                chunkIterators[i] = MediaChunkIterator.EMPTY;
                continue;
            }
            int chunkIndex = (int)(chunkMediaSequence - playlist.mediaSequence);
            chunkIterators[i] = new HlsMediaPlaylistSegmentIterator(playlist, startOfPlaylistInPeriodUs, chunkIndex);
        }
        return chunkIterators;
    }

    public int getPreferredQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        if (this.fatalError != null || this.trackSelection.length() < 2) {
            return queue.size();
        }
        return this.trackSelection.evaluateQueueSize(playbackPositionUs, queue);
    }

    public boolean shouldCancelLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
        if (this.fatalError != null) {
            return false;
        }
        return this.trackSelection.shouldCancelChunkLoad(playbackPositionUs, loadingChunk, queue);
    }

    private long getChunkMediaSequence(@Nullable HlsMediaChunk previous, boolean switchingTrack, HlsMediaPlaylist mediaPlaylist, long startOfPlaylistInPeriodUs, long loadPositionUs) {
        if (previous == null || switchingTrack) {
            long targetPositionInPeriodUs;
            long endOfPlaylistInPeriodUs = startOfPlaylistInPeriodUs + mediaPlaylist.durationUs;
            long l = targetPositionInPeriodUs = previous == null || this.independentSegments ? loadPositionUs : previous.startTimeUs;
            if (!mediaPlaylist.hasEndTag && targetPositionInPeriodUs >= endOfPlaylistInPeriodUs) {
                return mediaPlaylist.mediaSequence + (long)mediaPlaylist.segments.size();
            }
            long targetPositionInPlaylistUs = targetPositionInPeriodUs - startOfPlaylistInPeriodUs;
            return (long)Util.binarySearchFloor(mediaPlaylist.segments, Long.valueOf(targetPositionInPlaylistUs), true, !this.playlistTracker.isLive() || previous == null) + mediaPlaylist.mediaSequence;
        }
        return previous.isLoadCompleted() ? previous.getNextChunkIndex() : previous.chunkIndex;
    }

    private long resolveTimeToLiveEdgeUs(long playbackPositionUs) {
        boolean resolveTimeToLiveEdgePossible = this.liveEdgeInPeriodTimeUs != -9223372036854775807L;
        return resolveTimeToLiveEdgePossible ? this.liveEdgeInPeriodTimeUs - playbackPositionUs : -9223372036854775807L;
    }

    private void updateLiveEdgeTimeUs(HlsMediaPlaylist mediaPlaylist) {
        this.liveEdgeInPeriodTimeUs = mediaPlaylist.hasEndTag ? -9223372036854775807L : mediaPlaylist.getEndTimeUs() - this.playlistTracker.getInitialStartTimeUs();
    }

    @Nullable
    private Chunk maybeCreateEncryptionChunkFor(@Nullable Uri keyUri, int selectedTrackIndex) {
        if (keyUri == null) {
            return null;
        }
        byte[] encryptionKey = this.keyCache.remove(keyUri);
        if (encryptionKey != null) {
            this.keyCache.put(keyUri, encryptionKey);
            return null;
        }
        DataSpec dataSpec = new DataSpec.Builder().setUri(keyUri).setFlags(1).build();
        return new EncryptionKeyChunk(this.encryptionDataSource, dataSpec, this.playlistFormats[selectedTrackIndex], this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), this.scratchSpace);
    }

    @Nullable
    private static Uri getFullEncryptionKeyUri(HlsMediaPlaylist playlist, @Nullable HlsMediaPlaylist.Segment segment) {
        if (segment == null || segment.fullSegmentEncryptionKeyUri == null) {
            return null;
        }
        return UriUtil.resolveToUri(playlist.baseUri, segment.fullSegmentEncryptionKeyUri);
    }

    private static final class InitializationTrackSelection
    extends BaseTrackSelection {
        private int selectedIndex;

        public InitializationTrackSelection(TrackGroup group, int[] tracks) {
            super(group, tracks);
            this.selectedIndex = this.indexOf(group.getFormat(tracks[0]));
        }

        @Override
        public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
            long nowMs = SystemClock.elapsedRealtime();
            if (!this.isBlacklisted(this.selectedIndex, nowMs)) {
                return;
            }
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.isBlacklisted(i, nowMs)) continue;
                this.selectedIndex = i;
                return;
            }
            throw new IllegalStateException();
        }

        @Override
        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        @Override
        public int getSelectionReason() {
            return 0;
        }

        @Override
        @Nullable
        public Object getSelectionData() {
            return null;
        }
    }

    public static final class HlsChunkHolder {
        @Nullable
        public Chunk chunk;
        public boolean endOfStream;
        @Nullable
        public Uri playlistUrl;

        public HlsChunkHolder() {
            this.clear();
        }

        public void clear() {
            this.chunk = null;
            this.endOfStream = false;
            this.playlistUrl = null;
        }
    }

    private static final class EncryptionKeyChunk
    extends DataChunk {
        private byte @MonotonicNonNull [] result;

        public EncryptionKeyChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, byte[] scratchSpace) {
            super(dataSource, dataSpec, 3, trackFormat, trackSelectionReason, trackSelectionData, scratchSpace);
        }

        @Override
        protected void consume(byte[] data, int limit) {
            this.result = Arrays.copyOf(data, limit);
        }

        @Nullable
        public byte[] getResult() {
            return this.result;
        }
    }

    private static final class HlsMediaPlaylistSegmentIterator
    extends BaseMediaChunkIterator {
        private final HlsMediaPlaylist playlist;
        private final long startOfPlaylistInPeriodUs;

        public HlsMediaPlaylistSegmentIterator(HlsMediaPlaylist playlist, long startOfPlaylistInPeriodUs, int chunkIndex) {
            super(chunkIndex, playlist.segments.size() - 1);
            this.playlist = playlist;
            this.startOfPlaylistInPeriodUs = startOfPlaylistInPeriodUs;
        }

        @Override
        public DataSpec getDataSpec() {
            this.checkInBounds();
            HlsMediaPlaylist.Segment segment = this.playlist.segments.get((int)this.getCurrentIndex());
            Uri chunkUri = UriUtil.resolveToUri(this.playlist.baseUri, segment.url);
            return new DataSpec(chunkUri, segment.byteRangeOffset, segment.byteRangeLength);
        }

        @Override
        public long getChunkStartTimeUs() {
            this.checkInBounds();
            HlsMediaPlaylist.Segment segment = this.playlist.segments.get((int)this.getCurrentIndex());
            return this.startOfPlaylistInPeriodUs + segment.relativeStartTimeUs;
        }

        @Override
        public long getChunkEndTimeUs() {
            this.checkInBounds();
            HlsMediaPlaylist.Segment segment = this.playlist.segments.get((int)this.getCurrentIndex());
            long segmentStartTimeInPeriodUs = this.startOfPlaylistInPeriodUs + segment.relativeStartTimeUs;
            return segmentStartTimeInPeriodUs + segment.durationUs;
        }
    }
}

