/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.hls;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.util.LinkedHashMap;
import java.util.Map;

final class FullSegmentEncryptionKeyCache {
    private final LinkedHashMap<Uri, byte[]> backingMap;

    public FullSegmentEncryptionKeyCache(final int maxSize) {
        this.backingMap = new LinkedHashMap<Uri, byte[]>(maxSize + 1, 1.0f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Uri, byte[]> eldest) {
                return this.size() > maxSize;
            }
        };
    }

    @Nullable
    public byte[] get(@Nullable Uri uri) {
        if (uri == null) {
            return null;
        }
        return this.backingMap.get(uri);
    }

    @Nullable
    public byte[] put(Uri uri, byte[] encryptionKey) {
        return this.backingMap.put(Assertions.checkNotNull(uri), Assertions.checkNotNull(encryptionKey));
    }

    public boolean containsUri(Uri uri) {
        return this.backingMap.containsKey(Assertions.checkNotNull(uri));
    }

    @Nullable
    public byte[] remove(Uri uri) {
        return (byte[])this.backingMap.remove(Assertions.checkNotNull(uri));
    }
}

