/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.ts;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.audio.Ac4Util;
import com.akamai.amp.exoplayer2.extractor.ExtractorOutput;
import com.akamai.amp.exoplayer2.extractor.TrackOutput;
import com.akamai.amp.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.akamai.amp.exoplayer2.extractor.ts.TsPayloadReader;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.ParsableBitArray;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Ac4Reader
implements ElementaryStreamReader {
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private final ParsableBitArray headerScratchBits = new ParsableBitArray(new byte[16]);
    private final ParsableByteArray headerScratchBytes;
    @Nullable
    private final String language;
    private @MonotonicNonNull String formatId;
    private @MonotonicNonNull TrackOutput output;
    private int state;
    private int bytesRead;
    private boolean lastByteWasAC;
    private boolean hasCRC;
    private long sampleDurationUs;
    private @MonotonicNonNull Format format;
    private int sampleSize;
    private long timeUs;

    public Ac4Reader() {
        this(null);
    }

    public Ac4Reader(@Nullable String language) {
        this.headerScratchBytes = new ParsableByteArray(this.headerScratchBits.data);
        this.state = 0;
        this.bytesRead = 0;
        this.lastByteWasAC = false;
        this.hasCRC = false;
        this.language = language;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.lastByteWasAC = false;
        this.hasCRC = false;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator generator) {
        generator.generateNewId();
        this.formatId = generator.getFormatId();
        this.output = extractorOutput.track(generator.getTrackId(), 1);
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        this.timeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) {
        Assertions.checkStateNotNull(this.output);
        block5: while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    if (!this.skipToNextSync(data)) continue block5;
                    this.state = 1;
                    this.headerScratchBytes.getData()[0] = -84;
                    this.headerScratchBytes.getData()[1] = (byte)(this.hasCRC ? 65 : 64);
                    this.bytesRead = 2;
                    continue block5;
                }
                case 1: {
                    if (!this.continueRead(data, this.headerScratchBytes.getData(), 16)) continue block5;
                    this.parseHeader();
                    this.headerScratchBytes.setPosition(0);
                    this.output.sampleData(this.headerScratchBytes, 16);
                    this.state = 2;
                    continue block5;
                }
                case 2: {
                    int bytesToRead = Math.min(data.bytesLeft(), this.sampleSize - this.bytesRead);
                    this.output.sampleData(data, bytesToRead);
                    this.bytesRead += bytesToRead;
                    if (this.bytesRead != this.sampleSize) continue block5;
                    this.output.sampleMetadata(this.timeUs, 1, this.sampleSize, 0, null);
                    this.timeUs += this.sampleDurationUs;
                    this.state = 0;
                    continue block5;
                }
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private boolean continueRead(ParsableByteArray source, byte[] target, int targetLength) {
        int bytesToRead = Math.min(source.bytesLeft(), targetLength - this.bytesRead);
        source.readBytes(target, this.bytesRead, bytesToRead);
        this.bytesRead += bytesToRead;
        return this.bytesRead == targetLength;
    }

    private boolean skipToNextSync(ParsableByteArray pesBuffer) {
        while (pesBuffer.bytesLeft() > 0) {
            if (!this.lastByteWasAC) {
                this.lastByteWasAC = pesBuffer.readUnsignedByte() == 172;
                continue;
            }
            int secondByte = pesBuffer.readUnsignedByte();
            boolean bl = this.lastByteWasAC = secondByte == 172;
            if (secondByte != 64 && secondByte != 65) continue;
            this.hasCRC = secondByte == 65;
            return true;
        }
        return false;
    }

    @RequiresNonNull(value={"output"})
    private void parseHeader() {
        this.headerScratchBits.setPosition(0);
        Ac4Util.SyncFrameInfo frameInfo = Ac4Util.parseAc4SyncframeInfo(this.headerScratchBits);
        if (this.format == null || frameInfo.channelCount != this.format.channelCount || frameInfo.sampleRate != this.format.sampleRate || !"audio/ac4".equals(this.format.sampleMimeType)) {
            this.format = new Format.Builder().setId(this.formatId).setSampleMimeType("audio/ac4").setChannelCount(frameInfo.channelCount).setSampleRate(frameInfo.sampleRate).setLanguage(this.language).build();
            this.output.format(this.format);
        }
        this.sampleSize = frameInfo.frameSize;
        this.sampleDurationUs = 1000000L * (long)frameInfo.sampleCount / (long)this.format.sampleRate;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface State {
    }
}

