/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.analytics;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.analytics.AnalyticsListener;
import com.akamai.amp.exoplayer2.analytics.DefaultPlaybackSessionManager;
import com.akamai.amp.exoplayer2.analytics.PlaybackSessionManager;
import com.akamai.amp.exoplayer2.analytics.PlaybackStats;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PlaybackStatsListener
implements AnalyticsListener,
PlaybackSessionManager.Listener {
    private final PlaybackSessionManager sessionManager;
    private final Map<String, PlaybackStatsTracker> playbackStatsTrackers;
    private final Map<String, AnalyticsListener.EventTime> sessionStartEventTimes;
    @Nullable
    private final Callback callback;
    private final boolean keepHistory;
    private final Timeline.Period period;
    private PlaybackStats finishedPlaybackStats;
    @Nullable
    private String activeContentPlayback;
    @Nullable
    private String activeAdPlayback;
    private boolean playWhenReady;
    private int playbackState;
    private boolean isSuppressed;
    private float playbackSpeed;
    private boolean onSeekStartedCalled;

    public PlaybackStatsListener(boolean keepHistory, @Nullable Callback callback) {
        this.callback = callback;
        this.keepHistory = keepHistory;
        this.sessionManager = new DefaultPlaybackSessionManager();
        this.playbackStatsTrackers = new HashMap<String, PlaybackStatsTracker>();
        this.sessionStartEventTimes = new HashMap<String, AnalyticsListener.EventTime>();
        this.finishedPlaybackStats = PlaybackStats.EMPTY;
        this.playWhenReady = false;
        this.playbackState = 1;
        this.playbackSpeed = 1.0f;
        this.period = new Timeline.Period();
        this.sessionManager.setListener(this);
    }

    public PlaybackStats getCombinedPlaybackStats() {
        PlaybackStats[] allPendingPlaybackStats = new PlaybackStats[this.playbackStatsTrackers.size() + 1];
        allPendingPlaybackStats[0] = this.finishedPlaybackStats;
        int index = 1;
        for (PlaybackStatsTracker tracker : this.playbackStatsTrackers.values()) {
            allPendingPlaybackStats[index++] = tracker.build(false);
        }
        return PlaybackStats.merge(allPendingPlaybackStats);
    }

    @Nullable
    public PlaybackStats getPlaybackStats() {
        PlaybackStatsTracker activeStatsTracker = this.activeAdPlayback != null ? this.playbackStatsTrackers.get(this.activeAdPlayback) : (this.activeContentPlayback != null ? this.playbackStatsTrackers.get(this.activeContentPlayback) : null);
        return activeStatsTracker == null ? null : activeStatsTracker.build(false);
    }

    public void finishAllSessions() {
        this.sessionManager.finishAllSessions(new AnalyticsListener.EventTime(SystemClock.elapsedRealtime(), Timeline.EMPTY, 0, null, 0L, Timeline.EMPTY, 0, null, 0L, 0L));
    }

    @Override
    public void onSessionCreated(AnalyticsListener.EventTime eventTime, String session) {
        PlaybackStatsTracker tracker = new PlaybackStatsTracker(this.keepHistory, eventTime);
        if (this.onSeekStartedCalled) {
            tracker.onSeekStarted(eventTime, true);
        }
        tracker.onPlaybackStateChanged(eventTime, this.playbackState, true);
        tracker.onPlayWhenReadyChanged(eventTime, this.playWhenReady, true);
        tracker.onIsSuppressedChanged(eventTime, this.isSuppressed, true);
        tracker.onPlaybackSpeedChanged(eventTime, this.playbackSpeed);
        this.playbackStatsTrackers.put(session, tracker);
        this.sessionStartEventTimes.put(session, eventTime);
    }

    @Override
    public void onSessionActive(AnalyticsListener.EventTime eventTime, String session) {
        Assertions.checkNotNull(this.playbackStatsTrackers.get(session)).onForeground(eventTime);
        if (eventTime.mediaPeriodId != null && eventTime.mediaPeriodId.isAd()) {
            this.activeAdPlayback = session;
        } else {
            this.activeContentPlayback = session;
        }
    }

    @Override
    public void onAdPlaybackStarted(AnalyticsListener.EventTime eventTime, String contentSession, String adSession) {
        Assertions.checkState(Assertions.checkNotNull(eventTime.mediaPeriodId).isAd());
        long contentPeriodPositionUs = eventTime.timeline.getPeriodByUid(eventTime.mediaPeriodId.periodUid, this.period).getAdGroupTimeUs(eventTime.mediaPeriodId.adGroupIndex);
        long contentWindowPositionUs = contentPeriodPositionUs == Long.MIN_VALUE ? Long.MIN_VALUE : contentPeriodPositionUs + this.period.getPositionInWindowUs();
        AnalyticsListener.EventTime contentEventTime = new AnalyticsListener.EventTime(eventTime.realtimeMs, eventTime.timeline, eventTime.windowIndex, new MediaSource.MediaPeriodId(eventTime.mediaPeriodId.periodUid, eventTime.mediaPeriodId.windowSequenceNumber, eventTime.mediaPeriodId.adGroupIndex), C.usToMs(contentWindowPositionUs), eventTime.timeline, eventTime.currentWindowIndex, eventTime.currentMediaPeriodId, eventTime.currentPlaybackPositionMs, eventTime.totalBufferedDurationMs);
        Assertions.checkNotNull(this.playbackStatsTrackers.get(contentSession)).onInterruptedByAd(contentEventTime);
    }

    @Override
    public void onSessionFinished(AnalyticsListener.EventTime eventTime, String session, boolean automaticTransition) {
        if (session.equals(this.activeAdPlayback)) {
            this.activeAdPlayback = null;
        } else if (session.equals(this.activeContentPlayback)) {
            this.activeContentPlayback = null;
        }
        PlaybackStatsTracker tracker = Assertions.checkNotNull(this.playbackStatsTrackers.remove(session));
        AnalyticsListener.EventTime startEventTime = Assertions.checkNotNull(this.sessionStartEventTimes.remove(session));
        if (automaticTransition) {
            tracker.onPlaybackStateChanged(eventTime, 4, false);
        }
        tracker.onFinished(eventTime);
        PlaybackStats playbackStats = tracker.build(true);
        this.finishedPlaybackStats = PlaybackStats.merge(this.finishedPlaybackStats, playbackStats);
        if (this.callback != null) {
            this.callback.onPlaybackStatsReady(startEventTime, playbackStats);
        }
    }

    @Override
    public void onPlaybackStateChanged(AnalyticsListener.EventTime eventTime, int state) {
        this.playbackState = state;
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            boolean belongsToPlayback = this.sessionManager.belongsToSession(eventTime, session);
            this.playbackStatsTrackers.get(session).onPlaybackStateChanged(eventTime, this.playbackState, belongsToPlayback);
        }
    }

    @Override
    public void onPlayWhenReadyChanged(AnalyticsListener.EventTime eventTime, boolean playWhenReady, int reason) {
        this.playWhenReady = playWhenReady;
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            boolean belongsToPlayback = this.sessionManager.belongsToSession(eventTime, session);
            this.playbackStatsTrackers.get(session).onPlayWhenReadyChanged(eventTime, playWhenReady, belongsToPlayback);
        }
    }

    @Override
    public void onPlaybackSuppressionReasonChanged(AnalyticsListener.EventTime eventTime, int playbackSuppressionReason) {
        this.isSuppressed = playbackSuppressionReason != 0;
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            boolean belongsToPlayback = this.sessionManager.belongsToSession(eventTime, session);
            this.playbackStatsTrackers.get(session).onIsSuppressedChanged(eventTime, this.isSuppressed, belongsToPlayback);
        }
    }

    @Override
    public void onTimelineChanged(AnalyticsListener.EventTime eventTime, int reason) {
        this.sessionManager.updateSessionsWithTimelineChange(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onPositionDiscontinuity(eventTime, false);
        }
    }

    @Override
    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, int reason) {
        boolean isCompletelyIdle;
        boolean bl = isCompletelyIdle = eventTime.timeline.isEmpty() && this.playbackState == 1;
        if (!isCompletelyIdle) {
            this.sessionManager.updateSessionsWithDiscontinuity(eventTime, reason);
        }
        if (reason == 1) {
            this.onSeekStartedCalled = false;
        }
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onPositionDiscontinuity(eventTime, reason == 1);
        }
    }

    @Override
    public void onSeekStarted(AnalyticsListener.EventTime eventTime) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            boolean belongsToPlayback = this.sessionManager.belongsToSession(eventTime, session);
            this.playbackStatsTrackers.get(session).onSeekStarted(eventTime, belongsToPlayback);
        }
        this.onSeekStartedCalled = true;
    }

    @Override
    public void onPlayerError(AnalyticsListener.EventTime eventTime, ExoPlaybackException error) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onFatalError(eventTime, error);
        }
    }

    @Override
    public void onPlaybackParametersChanged(AnalyticsListener.EventTime eventTime, PlaybackParameters playbackParameters) {
        this.playbackSpeed = playbackParameters.speed;
        this.maybeAddSession(eventTime);
        for (PlaybackStatsTracker tracker : this.playbackStatsTrackers.values()) {
            tracker.onPlaybackSpeedChanged(eventTime, this.playbackSpeed);
        }
    }

    @Override
    public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onTracksChanged(eventTime, trackSelections);
        }
    }

    @Override
    public void onLoadStarted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onLoadStarted(eventTime);
        }
    }

    @Override
    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onDownstreamFormatChanged(eventTime, mediaLoadData);
        }
    }

    @Override
    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onVideoSizeChanged(eventTime, width, height);
        }
    }

    @Override
    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onBandwidthData(totalLoadTimeMs, totalBytesLoaded);
        }
    }

    @Override
    public void onAudioUnderrun(AnalyticsListener.EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onAudioUnderrun();
        }
    }

    @Override
    public void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onDroppedVideoFrames(droppedFrames);
        }
    }

    @Override
    public void onLoadError(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onNonFatalError(eventTime, error);
        }
    }

    @Override
    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception error) {
        this.maybeAddSession(eventTime);
        for (String session : this.playbackStatsTrackers.keySet()) {
            if (!this.sessionManager.belongsToSession(eventTime, session)) continue;
            this.playbackStatsTrackers.get(session).onNonFatalError(eventTime, error);
        }
    }

    private void maybeAddSession(AnalyticsListener.EventTime eventTime) {
        boolean isCompletelyIdle;
        boolean bl = isCompletelyIdle = eventTime.timeline.isEmpty() && this.playbackState == 1;
        if (!isCompletelyIdle) {
            this.sessionManager.updateSessions(eventTime);
        }
    }

    public static interface Callback {
        public void onPlaybackStatsReady(AnalyticsListener.EventTime var1, PlaybackStats var2);
    }

    private static final class PlaybackStatsTracker {
        private final boolean keepHistory;
        private final long[] playbackStateDurationsMs;
        private final List<PlaybackStats.EventTimeAndPlaybackState> playbackStateHistory;
        private final List<long[]> mediaTimeHistory;
        private final List<PlaybackStats.EventTimeAndFormat> videoFormatHistory;
        private final List<PlaybackStats.EventTimeAndFormat> audioFormatHistory;
        private final List<PlaybackStats.EventTimeAndException> fatalErrorHistory;
        private final List<PlaybackStats.EventTimeAndException> nonFatalErrorHistory;
        private final boolean isAd;
        private long firstReportedTimeMs;
        private boolean hasBeenReady;
        private boolean hasEnded;
        private boolean isJoinTimeInvalid;
        private int pauseCount;
        private int pauseBufferCount;
        private int seekCount;
        private int rebufferCount;
        private long maxRebufferTimeMs;
        private int initialVideoFormatHeight;
        private long initialVideoFormatBitrate;
        private long initialAudioFormatBitrate;
        private long videoFormatHeightTimeMs;
        private long videoFormatHeightTimeProduct;
        private long videoFormatBitrateTimeMs;
        private long videoFormatBitrateTimeProduct;
        private long audioFormatTimeMs;
        private long audioFormatBitrateTimeProduct;
        private long bandwidthTimeMs;
        private long bandwidthBytes;
        private long droppedFrames;
        private long audioUnderruns;
        private int fatalErrorCount;
        private int nonFatalErrorCount;
        private int currentPlaybackState;
        private long currentPlaybackStateStartTimeMs;
        private boolean isSeeking;
        private boolean isForeground;
        private boolean isInterruptedByAd;
        private boolean isFinished;
        private boolean playWhenReady;
        private int playerPlaybackState;
        private boolean isSuppressed;
        private boolean hasFatalError;
        private boolean startedLoading;
        private long lastRebufferStartTimeMs;
        @Nullable
        private Format currentVideoFormat;
        @Nullable
        private Format currentAudioFormat;
        private long lastVideoFormatStartTimeMs;
        private long lastAudioFormatStartTimeMs;
        private float currentPlaybackSpeed;

        public PlaybackStatsTracker(boolean keepHistory, AnalyticsListener.EventTime startTime) {
            this.keepHistory = keepHistory;
            this.playbackStateDurationsMs = new long[16];
            this.playbackStateHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.mediaTimeHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.videoFormatHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.audioFormatHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.fatalErrorHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.nonFatalErrorHistory = keepHistory ? new ArrayList() : Collections.emptyList();
            this.currentPlaybackState = 0;
            this.currentPlaybackStateStartTimeMs = startTime.realtimeMs;
            this.playerPlaybackState = 1;
            this.firstReportedTimeMs = -9223372036854775807L;
            this.maxRebufferTimeMs = -9223372036854775807L;
            this.isAd = startTime.mediaPeriodId != null && startTime.mediaPeriodId.isAd();
            this.initialAudioFormatBitrate = -1L;
            this.initialVideoFormatBitrate = -1L;
            this.initialVideoFormatHeight = -1;
            this.currentPlaybackSpeed = 1.0f;
        }

        public void onPlaybackStateChanged(AnalyticsListener.EventTime eventTime, int state, boolean belongsToPlayback) {
            this.playerPlaybackState = state;
            if (state != 1) {
                this.hasFatalError = false;
            }
            if (state != 2) {
                this.isSeeking = false;
            }
            if (state == 1 || state == 4) {
                this.isInterruptedByAd = false;
            }
            this.maybeUpdatePlaybackState(eventTime, belongsToPlayback);
        }

        public void onPlayWhenReadyChanged(AnalyticsListener.EventTime eventTime, boolean playWhenReady, boolean belongsToPlayback) {
            this.playWhenReady = playWhenReady;
            this.maybeUpdatePlaybackState(eventTime, belongsToPlayback);
        }

        public void onIsSuppressedChanged(AnalyticsListener.EventTime eventTime, boolean isSuppressed, boolean belongsToPlayback) {
            this.isSuppressed = isSuppressed;
            this.maybeUpdatePlaybackState(eventTime, belongsToPlayback);
        }

        public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, boolean isSeek) {
            if (isSeek && this.playerPlaybackState == 1) {
                this.isSeeking = false;
            }
            this.isInterruptedByAd = false;
            this.maybeUpdatePlaybackState(eventTime, true);
        }

        public void onSeekStarted(AnalyticsListener.EventTime eventTime, boolean belongsToPlayback) {
            this.isSeeking = true;
            this.maybeUpdatePlaybackState(eventTime, belongsToPlayback);
        }

        public void onFatalError(AnalyticsListener.EventTime eventTime, Exception error) {
            ++this.fatalErrorCount;
            if (this.keepHistory) {
                this.fatalErrorHistory.add(new PlaybackStats.EventTimeAndException(eventTime, error));
            }
            this.hasFatalError = true;
            this.isInterruptedByAd = false;
            this.isSeeking = false;
            this.maybeUpdatePlaybackState(eventTime, true);
        }

        public void onLoadStarted(AnalyticsListener.EventTime eventTime) {
            this.startedLoading = true;
            this.maybeUpdatePlaybackState(eventTime, true);
        }

        public void onForeground(AnalyticsListener.EventTime eventTime) {
            this.isForeground = true;
            this.maybeUpdatePlaybackState(eventTime, true);
        }

        public void onInterruptedByAd(AnalyticsListener.EventTime eventTime) {
            this.isInterruptedByAd = true;
            this.isSeeking = false;
            this.maybeUpdatePlaybackState(eventTime, true);
        }

        public void onFinished(AnalyticsListener.EventTime eventTime) {
            this.isFinished = true;
            this.maybeUpdatePlaybackState(eventTime, false);
        }

        public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackSelectionArray trackSelections) {
            boolean videoEnabled = false;
            boolean audioEnabled = false;
            for (TrackSelection trackSelection : trackSelections.getAll()) {
                if (trackSelection == null || trackSelection.length() <= 0) continue;
                int trackType = MimeTypes.getTrackType(trackSelection.getFormat((int)0).sampleMimeType);
                if (trackType == 2) {
                    videoEnabled = true;
                    continue;
                }
                if (trackType != 1) continue;
                audioEnabled = true;
            }
            if (!videoEnabled) {
                this.maybeUpdateVideoFormat(eventTime, null);
            }
            if (!audioEnabled) {
                this.maybeUpdateAudioFormat(eventTime, null);
            }
        }

        public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
            if (mediaLoadData.trackType == 2 || mediaLoadData.trackType == 0) {
                this.maybeUpdateVideoFormat(eventTime, mediaLoadData.trackFormat);
            } else if (mediaLoadData.trackType == 1) {
                this.maybeUpdateAudioFormat(eventTime, mediaLoadData.trackFormat);
            }
        }

        public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height) {
            if (this.currentVideoFormat != null && this.currentVideoFormat.height == -1) {
                Format formatWithHeight = this.currentVideoFormat.buildUpon().setWidth(width).setHeight(height).build();
                this.maybeUpdateVideoFormat(eventTime, formatWithHeight);
            }
        }

        public void onPlaybackSpeedChanged(AnalyticsListener.EventTime eventTime, float playbackSpeed) {
            this.maybeUpdateMediaTimeHistory(eventTime.realtimeMs, eventTime.eventPlaybackPositionMs);
            this.maybeRecordVideoFormatTime(eventTime.realtimeMs);
            this.maybeRecordAudioFormatTime(eventTime.realtimeMs);
            this.currentPlaybackSpeed = playbackSpeed;
        }

        public void onAudioUnderrun() {
            ++this.audioUnderruns;
        }

        public void onDroppedVideoFrames(int droppedFrames) {
            this.droppedFrames += (long)droppedFrames;
        }

        public void onBandwidthData(long timeMs, long bytes) {
            this.bandwidthTimeMs += timeMs;
            this.bandwidthBytes += bytes;
        }

        public void onNonFatalError(AnalyticsListener.EventTime eventTime, Exception error) {
            ++this.nonFatalErrorCount;
            if (this.keepHistory) {
                this.nonFatalErrorHistory.add(new PlaybackStats.EventTimeAndException(eventTime, error));
            }
        }

        public PlaybackStats build(boolean isFinal) {
            long[] playbackStateDurationsMs = this.playbackStateDurationsMs;
            List<long[]> mediaTimeHistory = this.mediaTimeHistory;
            if (!isFinal) {
                long buildTimeMs = SystemClock.elapsedRealtime();
                playbackStateDurationsMs = Arrays.copyOf(this.playbackStateDurationsMs, 16);
                long lastStateDurationMs = Math.max(0L, buildTimeMs - this.currentPlaybackStateStartTimeMs);
                int n = this.currentPlaybackState;
                playbackStateDurationsMs[n] = playbackStateDurationsMs[n] + lastStateDurationMs;
                this.maybeUpdateMaxRebufferTimeMs(buildTimeMs);
                this.maybeRecordVideoFormatTime(buildTimeMs);
                this.maybeRecordAudioFormatTime(buildTimeMs);
                mediaTimeHistory = new ArrayList<long[]>(this.mediaTimeHistory);
                if (this.keepHistory && this.currentPlaybackState == 3) {
                    mediaTimeHistory.add(this.guessMediaTimeBasedOnElapsedRealtime(buildTimeMs));
                }
            }
            boolean isJoinTimeInvalid = this.isJoinTimeInvalid || !this.hasBeenReady;
            long validJoinTimeMs = isJoinTimeInvalid ? -9223372036854775807L : playbackStateDurationsMs[2];
            boolean hasBackgroundJoin = playbackStateDurationsMs[1] > 0L;
            ArrayList<PlaybackStats.EventTimeAndFormat> videoHistory = isFinal ? this.videoFormatHistory : new ArrayList<PlaybackStats.EventTimeAndFormat>(this.videoFormatHistory);
            ArrayList<PlaybackStats.EventTimeAndFormat> audioHistory = isFinal ? this.audioFormatHistory : new ArrayList<PlaybackStats.EventTimeAndFormat>(this.audioFormatHistory);
            return new PlaybackStats(1, playbackStateDurationsMs, isFinal ? this.playbackStateHistory : new ArrayList<PlaybackStats.EventTimeAndPlaybackState>(this.playbackStateHistory), mediaTimeHistory, this.firstReportedTimeMs, this.isForeground ? 1 : 0, this.hasBeenReady ? 0 : 1, this.hasEnded ? 1 : 0, hasBackgroundJoin ? 1 : 0, validJoinTimeMs, isJoinTimeInvalid ? 0 : 1, this.pauseCount, this.pauseBufferCount, this.seekCount, this.rebufferCount, this.maxRebufferTimeMs, this.isAd ? 1 : 0, videoHistory, audioHistory, this.videoFormatHeightTimeMs, this.videoFormatHeightTimeProduct, this.videoFormatBitrateTimeMs, this.videoFormatBitrateTimeProduct, this.audioFormatTimeMs, this.audioFormatBitrateTimeProduct, this.initialVideoFormatHeight == -1 ? 0 : 1, this.initialVideoFormatBitrate == -1L ? 0 : 1, this.initialVideoFormatHeight, this.initialVideoFormatBitrate, this.initialAudioFormatBitrate == -1L ? 0 : 1, this.initialAudioFormatBitrate, this.bandwidthTimeMs, this.bandwidthBytes, this.droppedFrames, this.audioUnderruns, this.fatalErrorCount > 0 ? 1 : 0, this.fatalErrorCount, this.nonFatalErrorCount, this.fatalErrorHistory, this.nonFatalErrorHistory);
        }

        private void maybeUpdatePlaybackState(AnalyticsListener.EventTime eventTime, boolean belongsToPlayback) {
            int newPlaybackState = this.resolveNewPlaybackState();
            if (newPlaybackState == this.currentPlaybackState) {
                return;
            }
            Assertions.checkArgument(eventTime.realtimeMs >= this.currentPlaybackStateStartTimeMs);
            long stateDurationMs = eventTime.realtimeMs - this.currentPlaybackStateStartTimeMs;
            int n = this.currentPlaybackState;
            this.playbackStateDurationsMs[n] = this.playbackStateDurationsMs[n] + stateDurationMs;
            if (this.firstReportedTimeMs == -9223372036854775807L) {
                this.firstReportedTimeMs = eventTime.realtimeMs;
            }
            this.isJoinTimeInvalid |= PlaybackStatsTracker.isInvalidJoinTransition(this.currentPlaybackState, newPlaybackState);
            this.hasBeenReady |= PlaybackStatsTracker.isReadyState(newPlaybackState);
            this.hasEnded |= newPlaybackState == 11;
            if (!PlaybackStatsTracker.isPausedState(this.currentPlaybackState) && PlaybackStatsTracker.isPausedState(newPlaybackState)) {
                ++this.pauseCount;
            }
            if (newPlaybackState == 5) {
                ++this.seekCount;
            }
            if (!PlaybackStatsTracker.isRebufferingState(this.currentPlaybackState) && PlaybackStatsTracker.isRebufferingState(newPlaybackState)) {
                ++this.rebufferCount;
                this.lastRebufferStartTimeMs = eventTime.realtimeMs;
            }
            if (PlaybackStatsTracker.isRebufferingState(this.currentPlaybackState) && this.currentPlaybackState != 7 && newPlaybackState == 7) {
                ++this.pauseBufferCount;
            }
            this.maybeUpdateMediaTimeHistory(eventTime.realtimeMs, belongsToPlayback ? eventTime.eventPlaybackPositionMs : -9223372036854775807L);
            this.maybeUpdateMaxRebufferTimeMs(eventTime.realtimeMs);
            this.maybeRecordVideoFormatTime(eventTime.realtimeMs);
            this.maybeRecordAudioFormatTime(eventTime.realtimeMs);
            this.currentPlaybackState = newPlaybackState;
            this.currentPlaybackStateStartTimeMs = eventTime.realtimeMs;
            if (this.keepHistory) {
                this.playbackStateHistory.add(new PlaybackStats.EventTimeAndPlaybackState(eventTime, this.currentPlaybackState));
            }
        }

        private int resolveNewPlaybackState() {
            if (this.isFinished) {
                return this.currentPlaybackState == 11 ? 11 : 15;
            }
            if (this.isSeeking && this.isForeground) {
                return 5;
            }
            if (this.hasFatalError) {
                return 13;
            }
            if (!this.isForeground) {
                return this.startedLoading ? 1 : 0;
            }
            if (this.isInterruptedByAd) {
                return 14;
            }
            if (this.playerPlaybackState == 4) {
                return 11;
            }
            if (this.playerPlaybackState == 2) {
                if (this.currentPlaybackState == 0 || this.currentPlaybackState == 1 || this.currentPlaybackState == 2 || this.currentPlaybackState == 14) {
                    return 2;
                }
                if (!this.playWhenReady) {
                    return 7;
                }
                return this.isSuppressed ? 10 : 6;
            }
            if (this.playerPlaybackState == 3) {
                if (!this.playWhenReady) {
                    return 4;
                }
                return this.isSuppressed ? 9 : 3;
            }
            if (this.playerPlaybackState == 1 && this.currentPlaybackState != 0) {
                return 12;
            }
            return this.currentPlaybackState;
        }

        private void maybeUpdateMaxRebufferTimeMs(long nowMs) {
            if (PlaybackStatsTracker.isRebufferingState(this.currentPlaybackState)) {
                long rebufferDurationMs = nowMs - this.lastRebufferStartTimeMs;
                if (this.maxRebufferTimeMs == -9223372036854775807L || rebufferDurationMs > this.maxRebufferTimeMs) {
                    this.maxRebufferTimeMs = rebufferDurationMs;
                }
            }
        }

        private void maybeUpdateMediaTimeHistory(long realtimeMs, long mediaTimeMs) {
            long[] lArray;
            if (!this.keepHistory) {
                return;
            }
            if (this.currentPlaybackState != 3) {
                long previousMediaTimeMs;
                if (mediaTimeMs == -9223372036854775807L) {
                    return;
                }
                if (!this.mediaTimeHistory.isEmpty() && (previousMediaTimeMs = this.mediaTimeHistory.get(this.mediaTimeHistory.size() - 1)[1]) != mediaTimeMs) {
                    this.mediaTimeHistory.add(new long[]{realtimeMs, previousMediaTimeMs});
                }
            }
            if (mediaTimeMs == -9223372036854775807L) {
                lArray = this.guessMediaTimeBasedOnElapsedRealtime(realtimeMs);
            } else {
                long[] lArray2 = new long[2];
                lArray2[0] = realtimeMs;
                lArray = lArray2;
                lArray2[1] = mediaTimeMs;
            }
            this.mediaTimeHistory.add(lArray);
        }

        private long[] guessMediaTimeBasedOnElapsedRealtime(long realtimeMs) {
            long[] previousKnownMediaTimeHistory = this.mediaTimeHistory.get(this.mediaTimeHistory.size() - 1);
            long previousRealtimeMs = previousKnownMediaTimeHistory[0];
            long previousMediaTimeMs = previousKnownMediaTimeHistory[1];
            long elapsedMediaTimeEstimateMs = (long)((float)(realtimeMs - previousRealtimeMs) * this.currentPlaybackSpeed);
            long mediaTimeEstimateMs = previousMediaTimeMs + elapsedMediaTimeEstimateMs;
            return new long[]{realtimeMs, mediaTimeEstimateMs};
        }

        private void maybeUpdateVideoFormat(AnalyticsListener.EventTime eventTime, @Nullable Format newFormat) {
            if (Util.areEqual(this.currentVideoFormat, newFormat)) {
                return;
            }
            this.maybeRecordVideoFormatTime(eventTime.realtimeMs);
            if (newFormat != null) {
                if (this.initialVideoFormatHeight == -1 && newFormat.height != -1) {
                    this.initialVideoFormatHeight = newFormat.height;
                }
                if (this.initialVideoFormatBitrate == -1L && newFormat.bitrate != -1) {
                    this.initialVideoFormatBitrate = newFormat.bitrate;
                }
            }
            this.currentVideoFormat = newFormat;
            if (this.keepHistory) {
                this.videoFormatHistory.add(new PlaybackStats.EventTimeAndFormat(eventTime, this.currentVideoFormat));
            }
        }

        private void maybeUpdateAudioFormat(AnalyticsListener.EventTime eventTime, @Nullable Format newFormat) {
            if (Util.areEqual(this.currentAudioFormat, newFormat)) {
                return;
            }
            this.maybeRecordAudioFormatTime(eventTime.realtimeMs);
            if (newFormat != null && this.initialAudioFormatBitrate == -1L && newFormat.bitrate != -1) {
                this.initialAudioFormatBitrate = newFormat.bitrate;
            }
            this.currentAudioFormat = newFormat;
            if (this.keepHistory) {
                this.audioFormatHistory.add(new PlaybackStats.EventTimeAndFormat(eventTime, this.currentAudioFormat));
            }
        }

        private void maybeRecordVideoFormatTime(long nowMs) {
            if (this.currentPlaybackState == 3 && this.currentVideoFormat != null) {
                long mediaDurationMs = (long)((float)(nowMs - this.lastVideoFormatStartTimeMs) * this.currentPlaybackSpeed);
                if (this.currentVideoFormat.height != -1) {
                    this.videoFormatHeightTimeMs += mediaDurationMs;
                    this.videoFormatHeightTimeProduct += mediaDurationMs * (long)this.currentVideoFormat.height;
                }
                if (this.currentVideoFormat.bitrate != -1) {
                    this.videoFormatBitrateTimeMs += mediaDurationMs;
                    this.videoFormatBitrateTimeProduct += mediaDurationMs * (long)this.currentVideoFormat.bitrate;
                }
            }
            this.lastVideoFormatStartTimeMs = nowMs;
        }

        private void maybeRecordAudioFormatTime(long nowMs) {
            if (this.currentPlaybackState == 3 && this.currentAudioFormat != null && this.currentAudioFormat.bitrate != -1) {
                long mediaDurationMs = (long)((float)(nowMs - this.lastAudioFormatStartTimeMs) * this.currentPlaybackSpeed);
                this.audioFormatTimeMs += mediaDurationMs;
                this.audioFormatBitrateTimeProduct += mediaDurationMs * (long)this.currentAudioFormat.bitrate;
            }
            this.lastAudioFormatStartTimeMs = nowMs;
        }

        private static boolean isReadyState(int state) {
            return state == 3 || state == 4 || state == 9;
        }

        private static boolean isPausedState(int state) {
            return state == 4 || state == 7;
        }

        private static boolean isRebufferingState(int state) {
            return state == 6 || state == 7 || state == 10;
        }

        private static boolean isInvalidJoinTransition(int oldState, int newState) {
            if (oldState != 1 && oldState != 2 && oldState != 14) {
                return false;
            }
            return newState != 1 && newState != 2 && newState != 14 && newState != 3 && newState != 4 && newState != 9 && newState != 11;
        }
    }
}

