/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Renderer;
import com.akamai.amp.exoplayer2.RenderersFactory;
import com.akamai.amp.exoplayer2.audio.AudioCapabilities;
import com.akamai.amp.exoplayer2.audio.AudioProcessor;
import com.akamai.amp.exoplayer2.audio.AudioRendererEventListener;
import com.akamai.amp.exoplayer2.audio.AudioSink;
import com.akamai.amp.exoplayer2.audio.DefaultAudioSink;
import com.akamai.amp.exoplayer2.audio.MediaCodecAudioRenderer;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecSelector;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.metadata.MetadataRenderer;
import com.akamai.amp.exoplayer2.text.TextOutput;
import com.akamai.amp.exoplayer2.text.TextRenderer;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.video.MediaCodecVideoRenderer;
import com.akamai.amp.exoplayer2.video.VideoRendererEventListener;
import com.akamai.amp.exoplayer2.video.spherical.CameraMotionRenderer;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class DefaultRenderersFactory
implements RenderersFactory {
    public static final long DEFAULT_ALLOWED_VIDEO_JOINING_TIME_MS = 5000L;
    public static final int EXTENSION_RENDERER_MODE_OFF = 0;
    public static final int EXTENSION_RENDERER_MODE_ON = 1;
    public static final int EXTENSION_RENDERER_MODE_PREFER = 2;
    private static final String TAG = "DefaultRenderersFactory";
    protected static final int MAX_DROPPED_VIDEO_FRAME_COUNT_TO_NOTIFY = 50;
    private final Context context;
    private int extensionRendererMode;
    private long allowedVideoJoiningTimeMs;
    private boolean enableDecoderFallback;
    private MediaCodecSelector mediaCodecSelector;
    private int audioMediaCodecOperationMode;
    private int videoMediaCodecOperationMode;
    private boolean enableFloatOutput;
    private boolean enableAudioTrackPlaybackParams;
    private boolean enableOffload;

    public DefaultRenderersFactory(Context context) {
        this.context = context;
        this.extensionRendererMode = 0;
        this.allowedVideoJoiningTimeMs = 5000L;
        this.mediaCodecSelector = MediaCodecSelector.DEFAULT;
        this.audioMediaCodecOperationMode = 0;
        this.videoMediaCodecOperationMode = 0;
    }

    @Deprecated
    public DefaultRenderersFactory(Context context, int extensionRendererMode) {
        this(context, extensionRendererMode, 5000L);
    }

    @Deprecated
    public DefaultRenderersFactory(Context context, int extensionRendererMode, long allowedVideoJoiningTimeMs) {
        this.context = context;
        this.extensionRendererMode = extensionRendererMode;
        this.allowedVideoJoiningTimeMs = allowedVideoJoiningTimeMs;
        this.mediaCodecSelector = MediaCodecSelector.DEFAULT;
    }

    public DefaultRenderersFactory setExtensionRendererMode(int extensionRendererMode) {
        this.extensionRendererMode = extensionRendererMode;
        return this;
    }

    public DefaultRenderersFactory experimentalSetAudioMediaCodecOperationMode(int mode) {
        this.audioMediaCodecOperationMode = mode;
        return this;
    }

    public DefaultRenderersFactory experimentalSetVideoMediaCodecOperationMode(int mode) {
        this.videoMediaCodecOperationMode = mode;
        return this;
    }

    public DefaultRenderersFactory experimentalSetMediaCodecOperationMode(int mode) {
        this.experimentalSetAudioMediaCodecOperationMode(mode);
        this.experimentalSetVideoMediaCodecOperationMode(mode);
        return this;
    }

    public DefaultRenderersFactory setEnableDecoderFallback(boolean enableDecoderFallback) {
        this.enableDecoderFallback = enableDecoderFallback;
        return this;
    }

    public DefaultRenderersFactory setMediaCodecSelector(MediaCodecSelector mediaCodecSelector) {
        this.mediaCodecSelector = mediaCodecSelector;
        return this;
    }

    public DefaultRenderersFactory setEnableAudioFloatOutput(boolean enableFloatOutput) {
        this.enableFloatOutput = enableFloatOutput;
        return this;
    }

    public DefaultRenderersFactory setEnableAudioOffload(boolean enableOffload) {
        this.enableOffload = enableOffload;
        return this;
    }

    public DefaultRenderersFactory setEnableAudioTrackPlaybackParams(boolean enableAudioTrackPlaybackParams) {
        this.enableAudioTrackPlaybackParams = enableAudioTrackPlaybackParams;
        return this;
    }

    public DefaultRenderersFactory setAllowedVideoJoiningTimeMs(long allowedVideoJoiningTimeMs) {
        this.allowedVideoJoiningTimeMs = allowedVideoJoiningTimeMs;
        return this;
    }

    @Override
    public Renderer[] createRenderers(Handler eventHandler, VideoRendererEventListener videoRendererEventListener, AudioRendererEventListener audioRendererEventListener, TextOutput textRendererOutput, MetadataOutput metadataRendererOutput) {
        ArrayList<Renderer> renderersList = new ArrayList<Renderer>();
        this.buildVideoRenderers(this.context, this.extensionRendererMode, this.mediaCodecSelector, this.enableDecoderFallback, eventHandler, videoRendererEventListener, this.allowedVideoJoiningTimeMs, renderersList);
        AudioSink audioSink = this.buildAudioSink(this.context, this.enableFloatOutput, this.enableAudioTrackPlaybackParams, this.enableOffload);
        if (audioSink != null) {
            this.buildAudioRenderers(this.context, this.extensionRendererMode, this.mediaCodecSelector, this.enableDecoderFallback, audioSink, eventHandler, audioRendererEventListener, renderersList);
        }
        this.buildTextRenderers(this.context, textRendererOutput, eventHandler.getLooper(), this.extensionRendererMode, renderersList);
        this.buildMetadataRenderers(this.context, metadataRendererOutput, eventHandler.getLooper(), this.extensionRendererMode, renderersList);
        this.buildCameraMotionRenderers(this.context, this.extensionRendererMode, renderersList);
        this.buildMiscellaneousRenderers(this.context, eventHandler, this.extensionRendererMode, renderersList);
        return renderersList.toArray(new Renderer[0]);
    }

    protected void buildVideoRenderers(Context context, int extensionRendererMode, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, Handler eventHandler, VideoRendererEventListener eventListener, long allowedVideoJoiningTimeMs, ArrayList<Renderer> out) {
        Renderer renderer;
        Constructor<?> constructor;
        Class<?> clazz2;
        MediaCodecVideoRenderer videoRenderer = new MediaCodecVideoRenderer(context, mediaCodecSelector, allowedVideoJoiningTimeMs, enableDecoderFallback, eventHandler, eventListener, 50);
        videoRenderer.experimentalSetMediaCodecOperationMode(this.videoMediaCodecOperationMode);
        out.add(videoRenderer);
        if (extensionRendererMode == 0) {
            return;
        }
        int extensionRendererIndex = out.size();
        if (extensionRendererMode == 2) {
            --extensionRendererIndex;
        }
        try {
            clazz2 = Class.forName("com.akamai.amp.exoplayer2.ext.vp9.LibvpxVideoRenderer");
            constructor = clazz2.getConstructor(Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE);
            renderer = (Renderer)constructor.newInstance(allowedVideoJoiningTimeMs, eventHandler, eventListener, 50);
            out.add(extensionRendererIndex++, renderer);
            Log.i(TAG, "Loaded LibvpxVideoRenderer.");
        }
        catch (ClassNotFoundException clazz2) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating VP9 extension", e);
        }
        try {
            clazz2 = Class.forName("com.akamai.amp.exoplayer2.ext.av1.Libgav1VideoRenderer");
            constructor = clazz2.getConstructor(Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE);
            renderer = (Renderer)constructor.newInstance(allowedVideoJoiningTimeMs, eventHandler, eventListener, 50);
            out.add(extensionRendererIndex++, renderer);
            Log.i(TAG, "Loaded Libgav1VideoRenderer.");
        }
        catch (ClassNotFoundException clazz3) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating AV1 extension", e);
        }
    }

    protected void buildAudioRenderers(Context context, int extensionRendererMode, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, AudioSink audioSink, Handler eventHandler, AudioRendererEventListener eventListener, ArrayList<Renderer> out) {
        Renderer renderer;
        Constructor<?> constructor;
        Class<?> clazz2;
        MediaCodecAudioRenderer audioRenderer = new MediaCodecAudioRenderer(context, mediaCodecSelector, enableDecoderFallback, eventHandler, eventListener, audioSink);
        audioRenderer.experimentalSetMediaCodecOperationMode(this.audioMediaCodecOperationMode);
        out.add(audioRenderer);
        if (extensionRendererMode == 0) {
            return;
        }
        int extensionRendererIndex = out.size();
        if (extensionRendererMode == 2) {
            --extensionRendererIndex;
        }
        try {
            clazz2 = Class.forName("com.akamai.amp.exoplayer2.ext.opus.LibopusAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class);
            renderer = (Renderer)constructor.newInstance(eventHandler, eventListener, audioSink);
            out.add(extensionRendererIndex++, renderer);
            Log.i(TAG, "Loaded LibopusAudioRenderer.");
        }
        catch (ClassNotFoundException clazz2) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating Opus extension", e);
        }
        try {
            clazz2 = Class.forName("com.akamai.amp.exoplayer2.ext.flac.LibflacAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class);
            renderer = (Renderer)constructor.newInstance(eventHandler, eventListener, audioSink);
            out.add(extensionRendererIndex++, renderer);
            Log.i(TAG, "Loaded LibflacAudioRenderer.");
        }
        catch (ClassNotFoundException clazz3) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating FLAC extension", e);
        }
        try {
            clazz2 = Class.forName("com.akamai.amp.exoplayer2.ext.ffmpeg.FfmpegAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class);
            renderer = (Renderer)constructor.newInstance(eventHandler, eventListener, audioSink);
            out.add(extensionRendererIndex++, renderer);
            Log.i(TAG, "Loaded FfmpegAudioRenderer.");
        }
        catch (ClassNotFoundException clazz4) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating FFmpeg extension", e);
        }
    }

    protected void buildTextRenderers(Context context, TextOutput output, Looper outputLooper, int extensionRendererMode, ArrayList<Renderer> out) {
        out.add(new TextRenderer(output, outputLooper));
    }

    protected void buildMetadataRenderers(Context context, MetadataOutput output, Looper outputLooper, int extensionRendererMode, ArrayList<Renderer> out) {
        out.add(new MetadataRenderer(output, outputLooper));
    }

    protected void buildCameraMotionRenderers(Context context, int extensionRendererMode, ArrayList<Renderer> out) {
        out.add(new CameraMotionRenderer());
    }

    protected void buildMiscellaneousRenderers(Context context, Handler eventHandler, int extensionRendererMode, ArrayList<Renderer> out) {
    }

    @Nullable
    protected AudioSink buildAudioSink(Context context, boolean enableFloatOutput, boolean enableAudioTrackPlaybackParams, boolean enableOffload) {
        return new DefaultAudioSink(AudioCapabilities.getCapabilities(context), new DefaultAudioSink.DefaultAudioProcessorChain(new AudioProcessor[0]), enableFloatOutput, enableAudioTrackPlaybackParams, enableOffload);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExtensionRendererMode {
    }
}

