/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.offline;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.database.DatabaseIOException;
import com.akamai.amp.exoplayer2.database.DatabaseProvider;
import com.akamai.amp.exoplayer2.database.VersionTable;
import com.akamai.amp.exoplayer2.offline.Download;
import com.akamai.amp.exoplayer2.offline.DownloadCursor;
import com.akamai.amp.exoplayer2.offline.DownloadProgress;
import com.akamai.amp.exoplayer2.offline.DownloadRequest;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.offline.WritableDownloadIndex;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class DefaultDownloadIndex
implements WritableDownloadIndex {
    private static final String TABLE_PREFIX = "ExoPlayerDownloads";
    @VisibleForTesting
    static final int TABLE_VERSION = 3;
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_MIME_TYPE = "mime_type";
    private static final String COLUMN_URI = "uri";
    private static final String COLUMN_STREAM_KEYS = "stream_keys";
    private static final String COLUMN_CUSTOM_CACHE_KEY = "custom_cache_key";
    private static final String COLUMN_DATA = "data";
    private static final String COLUMN_STATE = "state";
    private static final String COLUMN_START_TIME_MS = "start_time_ms";
    private static final String COLUMN_UPDATE_TIME_MS = "update_time_ms";
    private static final String COLUMN_CONTENT_LENGTH = "content_length";
    private static final String COLUMN_STOP_REASON = "stop_reason";
    private static final String COLUMN_FAILURE_REASON = "failure_reason";
    private static final String COLUMN_PERCENT_DOWNLOADED = "percent_downloaded";
    private static final String COLUMN_BYTES_DOWNLOADED = "bytes_downloaded";
    private static final String COLUMN_KEY_SET_ID = "key_set_id";
    private static final int COLUMN_INDEX_ID = 0;
    private static final int COLUMN_INDEX_MIME_TYPE = 1;
    private static final int COLUMN_INDEX_URI = 2;
    private static final int COLUMN_INDEX_STREAM_KEYS = 3;
    private static final int COLUMN_INDEX_CUSTOM_CACHE_KEY = 4;
    private static final int COLUMN_INDEX_DATA = 5;
    private static final int COLUMN_INDEX_STATE = 6;
    private static final int COLUMN_INDEX_START_TIME_MS = 7;
    private static final int COLUMN_INDEX_UPDATE_TIME_MS = 8;
    private static final int COLUMN_INDEX_CONTENT_LENGTH = 9;
    private static final int COLUMN_INDEX_STOP_REASON = 10;
    private static final int COLUMN_INDEX_FAILURE_REASON = 11;
    private static final int COLUMN_INDEX_PERCENT_DOWNLOADED = 12;
    private static final int COLUMN_INDEX_BYTES_DOWNLOADED = 13;
    private static final int COLUMN_INDEX_KEY_SET_ID = 14;
    private static final String WHERE_ID_EQUALS = "id = ?";
    private static final String WHERE_STATE_IS_DOWNLOADING = "state = 2";
    private static final String WHERE_STATE_IS_TERMINAL = DefaultDownloadIndex.getStateQuery(3, 4);
    private static final String[] COLUMNS = new String[]{"id", "mime_type", "uri", "stream_keys", "custom_cache_key", "data", "state", "start_time_ms", "update_time_ms", "content_length", "stop_reason", "failure_reason", "percent_downloaded", "bytes_downloaded", "key_set_id"};
    private static final String TABLE_SCHEMA = "(id TEXT PRIMARY KEY NOT NULL,mime_type TEXT,uri TEXT NOT NULL,stream_keys TEXT NOT NULL,custom_cache_key TEXT,data BLOB NOT NULL,state INTEGER NOT NULL,start_time_ms INTEGER NOT NULL,update_time_ms INTEGER NOT NULL,content_length INTEGER NOT NULL,stop_reason INTEGER NOT NULL,failure_reason INTEGER NOT NULL,percent_downloaded REAL NOT NULL,bytes_downloaded INTEGER NOT NULL,key_set_id BLOB NOT NULL)";
    private static final String TRUE = "1";
    private final String name;
    private final String tableName;
    private final DatabaseProvider databaseProvider;
    private final Object initializationLock;
    @GuardedBy(value="initializationLock")
    private boolean initialized;

    public DefaultDownloadIndex(DatabaseProvider databaseProvider) {
        this(databaseProvider, "");
    }

    public DefaultDownloadIndex(DatabaseProvider databaseProvider, String name) {
        this.name = name;
        this.databaseProvider = databaseProvider;
        this.tableName = TABLE_PREFIX + name;
        this.initializationLock = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Download getDownload(String id) throws DatabaseIOException {
        this.ensureInitialized();
        try (Cursor cursor = this.getCursor(WHERE_ID_EQUALS, new String[]{id});){
            if (cursor.getCount() == 0) {
                Download download2 = null;
                return download2;
            }
            cursor.moveToNext();
            Download download = DefaultDownloadIndex.getDownloadForCurrentRow(cursor);
            return download;
        }
        catch (SQLiteException e) {
            throw new DatabaseIOException((SQLException)((Object)e));
        }
    }

    @Override
    public DownloadCursor getDownloads(int ... states) throws DatabaseIOException {
        this.ensureInitialized();
        Cursor cursor = this.getCursor(DefaultDownloadIndex.getStateQuery(states), null);
        return new DownloadCursorImpl(cursor);
    }

    @Override
    public void putDownload(Download download) throws DatabaseIOException {
        this.ensureInitialized();
        try {
            SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
            this.putDownloadInternal(download, writableDatabase);
        }
        catch (SQLiteException e) {
            throw new DatabaseIOException((SQLException)((Object)e));
        }
    }

    @Override
    public void removeDownload(String id) throws DatabaseIOException {
        this.ensureInitialized();
        try {
            this.databaseProvider.getWritableDatabase().delete(this.tableName, WHERE_ID_EQUALS, new String[]{id});
        }
        catch (SQLiteException e) {
            throw new DatabaseIOException((SQLException)((Object)e));
        }
    }

    @Override
    public void setDownloadingStatesToQueued() throws DatabaseIOException {
        this.ensureInitialized();
        try {
            ContentValues values = new ContentValues();
            values.put(COLUMN_STATE, Integer.valueOf(0));
            SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
            writableDatabase.update(this.tableName, values, WHERE_STATE_IS_DOWNLOADING, null);
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    @Override
    public void setStatesToRemoving() throws DatabaseIOException {
        this.ensureInitialized();
        try {
            ContentValues values = new ContentValues();
            values.put(COLUMN_STATE, Integer.valueOf(5));
            values.put(COLUMN_FAILURE_REASON, Integer.valueOf(0));
            SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
            writableDatabase.update(this.tableName, values, null, null);
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    @Override
    public void setStopReason(int stopReason) throws DatabaseIOException {
        this.ensureInitialized();
        try {
            ContentValues values = new ContentValues();
            values.put(COLUMN_STOP_REASON, Integer.valueOf(stopReason));
            SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
            writableDatabase.update(this.tableName, values, WHERE_STATE_IS_TERMINAL, null);
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    @Override
    public void setStopReason(String id, int stopReason) throws DatabaseIOException {
        this.ensureInitialized();
        try {
            ContentValues values = new ContentValues();
            values.put(COLUMN_STOP_REASON, Integer.valueOf(stopReason));
            SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
            writableDatabase.update(this.tableName, values, WHERE_STATE_IS_TERMINAL + " AND " + WHERE_ID_EQUALS, new String[]{id});
        }
        catch (SQLException e) {
            throw new DatabaseIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() throws DatabaseIOException {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            try {
                SQLiteDatabase readableDatabase = this.databaseProvider.getReadableDatabase();
                int version = VersionTable.getVersion(readableDatabase, 0, this.name);
                if (version != 3) {
                    SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
                    writableDatabase.beginTransactionNonExclusive();
                    try {
                        VersionTable.setVersion(writableDatabase, 0, this.name, 3);
                        List<Object> upgradedDownloads = version == 2 ? this.loadDownloadsFromVersion2(writableDatabase) : new ArrayList();
                        writableDatabase.execSQL("DROP TABLE IF EXISTS " + this.tableName);
                        writableDatabase.execSQL("CREATE TABLE " + this.tableName + " " + TABLE_SCHEMA);
                        for (Download download : upgradedDownloads) {
                            this.putDownloadInternal(download, writableDatabase);
                        }
                        writableDatabase.setTransactionSuccessful();
                    }
                    finally {
                        writableDatabase.endTransaction();
                    }
                }
                this.initialized = true;
            }
            catch (SQLException e) {
                throw new DatabaseIOException(e);
            }
        }
    }

    private void putDownloadInternal(Download download, SQLiteDatabase database) {
        byte[] keySetId = download.request.keySetId == null ? Util.EMPTY_BYTE_ARRAY : download.request.keySetId;
        ContentValues values = new ContentValues();
        values.put(COLUMN_ID, download.request.id);
        values.put(COLUMN_MIME_TYPE, download.request.mimeType);
        values.put(COLUMN_URI, download.request.uri.toString());
        values.put(COLUMN_STREAM_KEYS, DefaultDownloadIndex.encodeStreamKeys(download.request.streamKeys));
        values.put(COLUMN_CUSTOM_CACHE_KEY, download.request.customCacheKey);
        values.put(COLUMN_DATA, download.request.data);
        values.put(COLUMN_STATE, Integer.valueOf(download.state));
        values.put(COLUMN_START_TIME_MS, Long.valueOf(download.startTimeMs));
        values.put(COLUMN_UPDATE_TIME_MS, Long.valueOf(download.updateTimeMs));
        values.put(COLUMN_CONTENT_LENGTH, Long.valueOf(download.contentLength));
        values.put(COLUMN_STOP_REASON, Integer.valueOf(download.stopReason));
        values.put(COLUMN_FAILURE_REASON, Integer.valueOf(download.failureReason));
        values.put(COLUMN_PERCENT_DOWNLOADED, Float.valueOf(download.getPercentDownloaded()));
        values.put(COLUMN_BYTES_DOWNLOADED, Long.valueOf(download.getBytesDownloaded()));
        values.put(COLUMN_KEY_SET_ID, keySetId);
        database.replaceOrThrow(this.tableName, null, values);
    }

    private List<Download> loadDownloadsFromVersion2(SQLiteDatabase database) {
        ArrayList<Download> downloads = new ArrayList<Download>();
        if (!Util.tableExists(database, this.tableName)) {
            return downloads;
        }
        String[] columnsV2 = new String[]{COLUMN_ID, "title", COLUMN_URI, COLUMN_STREAM_KEYS, COLUMN_CUSTOM_CACHE_KEY, COLUMN_DATA, COLUMN_STATE, COLUMN_START_TIME_MS, COLUMN_UPDATE_TIME_MS, COLUMN_CONTENT_LENGTH, COLUMN_STOP_REASON, COLUMN_FAILURE_REASON, COLUMN_PERCENT_DOWNLOADED, COLUMN_BYTES_DOWNLOADED};
        try (Cursor cursor = database.query(this.tableName, columnsV2, null, null, null, null, null);){
            while (cursor.moveToNext()) {
                downloads.add(DefaultDownloadIndex.getDownloadForCurrentRowV2(cursor));
            }
            ArrayList<Download> arrayList = downloads;
            return arrayList;
        }
    }

    private static String inferMimeType(String downloadType) {
        if ("dash".equals(downloadType)) {
            return "application/dash+xml";
        }
        if ("hls".equals(downloadType)) {
            return "application/x-mpegURL";
        }
        if ("ss".equals(downloadType)) {
            return "application/vnd.ms-sstr+xml";
        }
        return "video/x-unknown";
    }

    private Cursor getCursor(String selection, @Nullable String[] selectionArgs) throws DatabaseIOException {
        try {
            String sortOrder = "start_time_ms ASC";
            return this.databaseProvider.getReadableDatabase().query(this.tableName, COLUMNS, selection, selectionArgs, null, null, sortOrder);
        }
        catch (SQLiteException e) {
            throw new DatabaseIOException((SQLException)((Object)e));
        }
    }

    @VisibleForTesting
    static String encodeStreamKeys(List<StreamKey> streamKeys) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < streamKeys.size(); ++i) {
            StreamKey streamKey = streamKeys.get(i);
            stringBuilder.append(streamKey.periodIndex).append('.').append(streamKey.groupIndex).append('.').append(streamKey.trackIndex).append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static String getStateQuery(int ... states) {
        if (states.length == 0) {
            return TRUE;
        }
        StringBuilder selectionBuilder = new StringBuilder();
        selectionBuilder.append(COLUMN_STATE).append(" IN (");
        for (int i = 0; i < states.length; ++i) {
            if (i > 0) {
                selectionBuilder.append(',');
            }
            selectionBuilder.append(states[i]);
        }
        selectionBuilder.append(')');
        return selectionBuilder.toString();
    }

    private static Download getDownloadForCurrentRow(Cursor cursor) {
        byte[] keySetId = cursor.getBlob(14);
        DownloadRequest request = new DownloadRequest.Builder(cursor.getString(0), Uri.parse((String)cursor.getString(2))).setMimeType(cursor.getString(1)).setStreamKeys(DefaultDownloadIndex.decodeStreamKeys(cursor.getString(3))).setKeySetId((byte[])(keySetId.length > 0 ? keySetId : null)).setCustomCacheKey(cursor.getString(4)).setData(cursor.getBlob(5)).build();
        DownloadProgress downloadProgress = new DownloadProgress();
        downloadProgress.bytesDownloaded = cursor.getLong(13);
        downloadProgress.percentDownloaded = cursor.getFloat(12);
        int state = cursor.getInt(6);
        int failureReason = state == 4 ? cursor.getInt(11) : 0;
        return new Download(request, state, cursor.getLong(7), cursor.getLong(8), cursor.getLong(9), cursor.getInt(10), failureReason, downloadProgress);
    }

    private static Download getDownloadForCurrentRowV2(Cursor cursor) {
        DownloadRequest request = new DownloadRequest.Builder(cursor.getString(0), Uri.parse((String)cursor.getString(2))).setMimeType(DefaultDownloadIndex.inferMimeType(cursor.getString(1))).setStreamKeys(DefaultDownloadIndex.decodeStreamKeys(cursor.getString(3))).setCustomCacheKey(cursor.getString(4)).setData(cursor.getBlob(5)).build();
        DownloadProgress downloadProgress = new DownloadProgress();
        downloadProgress.bytesDownloaded = cursor.getLong(13);
        downloadProgress.percentDownloaded = cursor.getFloat(12);
        int state = cursor.getInt(6);
        int failureReason = state == 4 ? cursor.getInt(11) : 0;
        return new Download(request, state, cursor.getLong(7), cursor.getLong(8), cursor.getLong(9), cursor.getInt(10), failureReason, downloadProgress);
    }

    private static List<StreamKey> decodeStreamKeys(String encodedStreamKeys) {
        String[] streamKeysStrings;
        ArrayList<StreamKey> streamKeys = new ArrayList<StreamKey>();
        if (encodedStreamKeys.isEmpty()) {
            return streamKeys;
        }
        for (String streamKeysString : streamKeysStrings = Util.split(encodedStreamKeys, ",")) {
            String[] indices = Util.split(streamKeysString, "\\.");
            Assertions.checkState(indices.length == 3);
            streamKeys.add(new StreamKey(Integer.parseInt(indices[0]), Integer.parseInt(indices[1]), Integer.parseInt(indices[2])));
        }
        return streamKeys;
    }

    private static final class DownloadCursorImpl
    implements DownloadCursor {
        private final Cursor cursor;

        private DownloadCursorImpl(Cursor cursor) {
            this.cursor = cursor;
        }

        @Override
        public Download getDownload() {
            return DefaultDownloadIndex.getDownloadForCurrentRow(this.cursor);
        }

        @Override
        public int getCount() {
            return this.cursor.getCount();
        }

        @Override
        public int getPosition() {
            return this.cursor.getPosition();
        }

        @Override
        public boolean moveToPosition(int position) {
            return this.cursor.moveToPosition(position);
        }

        @Override
        public void close() {
            this.cursor.close();
        }

        @Override
        public boolean isClosed() {
            return this.cursor.isClosed();
        }
    }
}

