/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.mediacodec;

import android.annotation.SuppressLint;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecInfo;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.exoplayer2.video.ColorInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

@SuppressLint(value={"InlinedApi"})
public final class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    private static final Pattern PROFILE_PATTERN = Pattern.compile("^\\D?(\\d+)$");
    private static final HashMap<CodecKey, List<MediaCodecInfo>> decoderInfosCache = new HashMap();
    private static final String CODEC_ID_AVC1 = "avc1";
    private static final String CODEC_ID_AVC2 = "avc2";
    private static final String CODEC_ID_VP09 = "vp09";
    private static final String CODEC_ID_HEV1 = "hev1";
    private static final String CODEC_ID_HVC1 = "hvc1";
    private static final String CODEC_ID_AV01 = "av01";
    private static final String CODEC_ID_MP4A = "mp4a";
    private static int maxH264DecodableFrameSize = -1;

    private MediaCodecUtil() {
    }

    public static void warmDecoderInfoCache(String mimeType, boolean secure, boolean tunneling) {
        try {
            MediaCodecUtil.getDecoderInfos(mimeType, secure, tunneling);
        }
        catch (DecoderQueryException e) {
            Log.e(TAG, "Codec warming failed", e);
        }
    }

    @Nullable
    public static MediaCodecInfo getDecryptOnlyDecoderInfo() throws DecoderQueryException {
        return MediaCodecUtil.getDecoderInfo("audio/raw", false, false);
    }

    @Nullable
    public static MediaCodecInfo getDecoderInfo(String mimeType, boolean secure, boolean tunneling) throws DecoderQueryException {
        List<MediaCodecInfo> decoderInfos = MediaCodecUtil.getDecoderInfos(mimeType, secure, tunneling);
        return decoderInfos.isEmpty() ? null : decoderInfos.get(0);
    }

    public static synchronized List<MediaCodecInfo> getDecoderInfos(String mimeType, boolean secure, boolean tunneling) throws DecoderQueryException {
        CodecKey key = new CodecKey(mimeType, secure, tunneling);
        List<MediaCodecInfo> cachedDecoderInfos = decoderInfosCache.get(key);
        if (cachedDecoderInfos != null) {
            return cachedDecoderInfos;
        }
        MediaCodecListCompat mediaCodecList = Util.SDK_INT >= 21 ? new MediaCodecListCompatV21(secure, tunneling) : new MediaCodecListCompatV16();
        ArrayList<MediaCodecInfo> decoderInfos = MediaCodecUtil.getDecoderInfosInternal(key, mediaCodecList);
        if (secure && decoderInfos.isEmpty() && 21 <= Util.SDK_INT && Util.SDK_INT <= 23 && !(decoderInfos = MediaCodecUtil.getDecoderInfosInternal(key, mediaCodecList = new MediaCodecListCompatV16())).isEmpty()) {
            Log.w(TAG, "MediaCodecList API didn't list secure decoder for: " + mimeType + ". Assuming: " + decoderInfos.get((int)0).name);
        }
        MediaCodecUtil.applyWorkarounds(mimeType, decoderInfos);
        List<MediaCodecInfo> unmodifiableDecoderInfos = Collections.unmodifiableList(decoderInfos);
        decoderInfosCache.put(key, unmodifiableDecoderInfos);
        return unmodifiableDecoderInfos;
    }

    @CheckResult
    public static List<MediaCodecInfo> getDecoderInfosSortedByFormatSupport(List<MediaCodecInfo> decoderInfos, Format format) {
        decoderInfos = new ArrayList<MediaCodecInfo>(decoderInfos);
        MediaCodecUtil.sortByScore(decoderInfos, decoderInfo -> {
            try {
                return decoderInfo.isFormatSupported(format) ? 1 : 0;
            }
            catch (DecoderQueryException e) {
                return -1;
            }
        });
        return decoderInfos;
    }

    public static int maxH264DecodableFrameSize() throws DecoderQueryException {
        if (maxH264DecodableFrameSize == -1) {
            int result = 0;
            MediaCodecInfo decoderInfo = MediaCodecUtil.getDecoderInfo("video/avc", false, false);
            if (decoderInfo != null) {
                for (MediaCodecInfo.CodecProfileLevel profileLevel : decoderInfo.getProfileLevels()) {
                    result = Math.max(MediaCodecUtil.avcLevelToMaxFrameSize(profileLevel.level), result);
                }
                result = Math.max(result, Util.SDK_INT >= 21 ? 345600 : 172800);
            }
            maxH264DecodableFrameSize = result;
        }
        return maxH264DecodableFrameSize;
    }

    @Nullable
    public static Pair<Integer, Integer> getCodecProfileAndLevel(Format format) {
        if (format.codecs == null) {
            return null;
        }
        String[] parts = format.codecs.split("\\.");
        if ("video/dolby-vision".equals(format.sampleMimeType)) {
            return MediaCodecUtil.getDolbyVisionProfileAndLevel(format.codecs, parts);
        }
        switch (parts[0]) {
            case "avc1": 
            case "avc2": {
                return MediaCodecUtil.getAvcProfileAndLevel(format.codecs, parts);
            }
            case "vp09": {
                return MediaCodecUtil.getVp9ProfileAndLevel(format.codecs, parts);
            }
            case "hev1": 
            case "hvc1": {
                return MediaCodecUtil.getHevcProfileAndLevel(format.codecs, parts);
            }
            case "av01": {
                return MediaCodecUtil.getAv1ProfileAndLevel(format.codecs, parts, format.colorInfo);
            }
            case "mp4a": {
                return MediaCodecUtil.getAacCodecProfileAndLevel(format.codecs, parts);
            }
        }
        return null;
    }

    private static ArrayList<MediaCodecInfo> getDecoderInfosInternal(CodecKey key, MediaCodecListCompat mediaCodecList) throws DecoderQueryException {
        try {
            ArrayList<MediaCodecInfo> decoderInfos = new ArrayList<MediaCodecInfo>();
            String mimeType = key.mimeType;
            int numberOfCodecs = mediaCodecList.getCodecCount();
            boolean secureDecodersExplicit = mediaCodecList.secureDecodersExplicit();
            for (int i = 0; i < numberOfCodecs; ++i) {
                String codecMimeType;
                String name;
                android.media.MediaCodecInfo codecInfo = mediaCodecList.getCodecInfoAt(i);
                if (MediaCodecUtil.isAlias(codecInfo) || !MediaCodecUtil.isCodecUsableDecoder(codecInfo, name = codecInfo.getName(), secureDecodersExplicit, mimeType) || (codecMimeType = MediaCodecUtil.getCodecMimeType(codecInfo, name, mimeType)) == null) continue;
                try {
                    MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(codecMimeType);
                    boolean tunnelingSupported = mediaCodecList.isFeatureSupported("tunneled-playback", codecMimeType, capabilities);
                    boolean tunnelingRequired = mediaCodecList.isFeatureRequired("tunneled-playback", codecMimeType, capabilities);
                    if (!key.tunneling && tunnelingRequired || key.tunneling && !tunnelingSupported) continue;
                    boolean secureSupported = mediaCodecList.isFeatureSupported("secure-playback", codecMimeType, capabilities);
                    boolean secureRequired = mediaCodecList.isFeatureRequired("secure-playback", codecMimeType, capabilities);
                    if (!key.secure && secureRequired || key.secure && !secureSupported) continue;
                    boolean hardwareAccelerated = MediaCodecUtil.isHardwareAccelerated(codecInfo);
                    boolean softwareOnly = MediaCodecUtil.isSoftwareOnly(codecInfo);
                    boolean vendor = MediaCodecUtil.isVendor(codecInfo);
                    boolean forceDisableAdaptive = MediaCodecUtil.codecNeedsDisableAdaptationWorkaround(name);
                    if (secureDecodersExplicit && key.secure == secureSupported || !secureDecodersExplicit && !key.secure) {
                        decoderInfos.add(MediaCodecInfo.newInstance(name, mimeType, codecMimeType, capabilities, hardwareAccelerated, softwareOnly, vendor, forceDisableAdaptive, false));
                        continue;
                    }
                    if (secureDecodersExplicit || !secureSupported) continue;
                    decoderInfos.add(MediaCodecInfo.newInstance(name + ".secure", mimeType, codecMimeType, capabilities, hardwareAccelerated, softwareOnly, vendor, forceDisableAdaptive, true));
                    return decoderInfos;
                }
                catch (Exception e) {
                    if (Util.SDK_INT <= 23 && !decoderInfos.isEmpty()) {
                        Log.e(TAG, "Skipping codec " + name + " (failed to query capabilities)");
                        continue;
                    }
                    Log.e(TAG, "Failed to query codec " + name + " (" + codecMimeType + ")");
                    throw e;
                }
            }
            return decoderInfos;
        }
        catch (Exception e) {
            throw new DecoderQueryException(e);
        }
    }

    @Nullable
    private static String getCodecMimeType(android.media.MediaCodecInfo info, String name, String mimeType) {
        String[] supportedTypes;
        for (String supportedType : supportedTypes = info.getSupportedTypes()) {
            if (!supportedType.equalsIgnoreCase(mimeType)) continue;
            return supportedType;
        }
        if (mimeType.equals("video/dolby-vision")) {
            if ("OMX.MS.HEVCDV.Decoder".equals(name)) {
                return "video/hevcdv";
            }
            if ("OMX.RTK.video.decoder".equals(name) || "OMX.realtek.video.decoder.tunneled".equals(name)) {
                return "video/dv_hevc";
            }
        } else {
            if (mimeType.equals("audio/alac") && "OMX.lge.alac.decoder".equals(name)) {
                return "audio/x-lg-alac";
            }
            if (mimeType.equals("audio/flac") && "OMX.lge.flac.decoder".equals(name)) {
                return "audio/x-lg-flac";
            }
        }
        return null;
    }

    private static boolean isCodecUsableDecoder(android.media.MediaCodecInfo info, String name, boolean secureDecodersExplicit, String mimeType) {
        if (info.isEncoder() || !secureDecodersExplicit && name.endsWith(".secure")) {
            return false;
        }
        if (Util.SDK_INT < 21 && ("CIPAACDecoder".equals(name) || "CIPMP3Decoder".equals(name) || "CIPVorbisDecoder".equals(name) || "CIPAMRNBDecoder".equals(name) || "AACDecoder".equals(name) || "MP3Decoder".equals(name))) {
            return false;
        }
        if (Util.SDK_INT < 18 && "OMX.MTK.AUDIO.DECODER.AAC".equals(name) && ("a70".equals(Util.DEVICE) || "Xiaomi".equals(Util.MANUFACTURER) && Util.DEVICE.startsWith("HM"))) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.mp3".equals(name) && ("dlxu".equals(Util.DEVICE) || "protou".equals(Util.DEVICE) || "ville".equals(Util.DEVICE) || "villeplus".equals(Util.DEVICE) || "villec2".equals(Util.DEVICE) || Util.DEVICE.startsWith("gee") || "C6602".equals(Util.DEVICE) || "C6603".equals(Util.DEVICE) || "C6606".equals(Util.DEVICE) || "C6616".equals(Util.DEVICE) || "L36h".equals(Util.DEVICE) || "SO-02E".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.aac".equals(name) && ("C1504".equals(Util.DEVICE) || "C1505".equals(Util.DEVICE) || "C1604".equals(Util.DEVICE) || "C1605".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT < 24 && ("OMX.SEC.aac.dec".equals(name) || "OMX.Exynos.AAC.Decoder".equals(name)) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("zeroflte") || Util.DEVICE.startsWith("zerolte") || Util.DEVICE.startsWith("zenlte") || "SC-05G".equals(Util.DEVICE) || "marinelteatt".equals(Util.DEVICE) || "404SC".equals(Util.DEVICE) || "SC-04G".equals(Util.DEVICE) || "SCV31".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT <= 19 && "OMX.SEC.vp8.dec".equals(name) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("d2") || Util.DEVICE.startsWith("serrano") || Util.DEVICE.startsWith("jflte") || Util.DEVICE.startsWith("santos") || Util.DEVICE.startsWith("t0"))) {
            return false;
        }
        if (Util.SDK_INT <= 19 && Util.DEVICE.startsWith("jflte") && "OMX.qcom.video.decoder.vp8".equals(name)) {
            return false;
        }
        return !"audio/eac3-joc".equals(mimeType) || !"OMX.MTK.AUDIO.DECODER.DSPAC3".equals(name);
    }

    private static void applyWorkarounds(String mimeType, List<MediaCodecInfo> decoderInfos) {
        String firstCodecName;
        if ("audio/raw".equals(mimeType)) {
            if (Util.SDK_INT < 26 && Util.DEVICE.equals("R9") && decoderInfos.size() == 1 && decoderInfos.get((int)0).name.equals("OMX.MTK.AUDIO.DECODER.RAW")) {
                decoderInfos.add(MediaCodecInfo.newInstance("OMX.google.raw.decoder", "audio/raw", "audio/raw", null, false, true, false, false, false));
            }
            MediaCodecUtil.sortByScore(decoderInfos, decoderInfo -> {
                String name = decoderInfo.name;
                if (name.startsWith("OMX.google") || name.startsWith("c2.android")) {
                    return 1;
                }
                if (Util.SDK_INT < 26 && name.equals("OMX.MTK.AUDIO.DECODER.RAW")) {
                    return -1;
                }
                return 0;
            });
        }
        if (Util.SDK_INT < 21 && decoderInfos.size() > 1 && ("OMX.SEC.mp3.dec".equals(firstCodecName = decoderInfos.get((int)0).name) || "OMX.SEC.MP3.Decoder".equals(firstCodecName) || "OMX.brcm.audio.mp3.decoder".equals(firstCodecName))) {
            MediaCodecUtil.sortByScore(decoderInfos, decoderInfo -> decoderInfo.name.startsWith("OMX.google") ? 1 : 0);
        }
        if (Util.SDK_INT < 30 && decoderInfos.size() > 1 && "OMX.qti.audio.decoder.flac".equals(firstCodecName = decoderInfos.get((int)0).name)) {
            decoderInfos.add(decoderInfos.remove(0));
        }
    }

    private static boolean isAlias(android.media.MediaCodecInfo info) {
        return Util.SDK_INT >= 29 && MediaCodecUtil.isAliasV29(info);
    }

    @RequiresApi(value=29)
    private static boolean isAliasV29(android.media.MediaCodecInfo info) {
        return info.isAlias();
    }

    private static boolean isHardwareAccelerated(android.media.MediaCodecInfo codecInfo) {
        if (Util.SDK_INT >= 29) {
            return MediaCodecUtil.isHardwareAcceleratedV29(codecInfo);
        }
        return !MediaCodecUtil.isSoftwareOnly(codecInfo);
    }

    @RequiresApi(value=29)
    private static boolean isHardwareAcceleratedV29(android.media.MediaCodecInfo codecInfo) {
        return codecInfo.isHardwareAccelerated();
    }

    private static boolean isSoftwareOnly(android.media.MediaCodecInfo codecInfo) {
        if (Util.SDK_INT >= 29) {
            return MediaCodecUtil.isSoftwareOnlyV29(codecInfo);
        }
        String codecName = Util.toLowerInvariant(codecInfo.getName());
        if (codecName.startsWith("arc.")) {
            return false;
        }
        return codecName.startsWith("omx.google.") || codecName.startsWith("omx.ffmpeg.") || codecName.startsWith("omx.sec.") && codecName.contains(".sw.") || codecName.equals("omx.qcom.video.decoder.hevcswvdec") || codecName.startsWith("c2.android.") || codecName.startsWith("c2.google.") || !codecName.startsWith("omx.") && !codecName.startsWith("c2.");
    }

    @RequiresApi(value=29)
    private static boolean isSoftwareOnlyV29(android.media.MediaCodecInfo codecInfo) {
        return codecInfo.isSoftwareOnly();
    }

    private static boolean isVendor(android.media.MediaCodecInfo codecInfo) {
        if (Util.SDK_INT >= 29) {
            return MediaCodecUtil.isVendorV29(codecInfo);
        }
        String codecName = Util.toLowerInvariant(codecInfo.getName());
        return !codecName.startsWith("omx.google.") && !codecName.startsWith("c2.android.") && !codecName.startsWith("c2.google.");
    }

    @RequiresApi(value=29)
    private static boolean isVendorV29(android.media.MediaCodecInfo codecInfo) {
        return codecInfo.isVendor();
    }

    private static boolean codecNeedsDisableAdaptationWorkaround(String name) {
        return !(Util.SDK_INT > 22 || !"ODROID-XU3".equals(Util.MODEL) && !"Nexus 10".equals(Util.MODEL) || !"OMX.Exynos.AVC.Decoder".equals(name) && !"OMX.Exynos.AVC.Decoder.secure".equals(name));
    }

    @Nullable
    private static Pair<Integer, Integer> getDolbyVisionProfileAndLevel(String codec, String[] parts) {
        if (parts.length < 3) {
            Log.w(TAG, "Ignoring malformed Dolby Vision codec string: " + codec);
            return null;
        }
        Matcher matcher = PROFILE_PATTERN.matcher(parts[1]);
        if (!matcher.matches()) {
            Log.w(TAG, "Ignoring malformed Dolby Vision codec string: " + codec);
            return null;
        }
        String profileString = matcher.group(1);
        Integer profile = MediaCodecUtil.dolbyVisionStringToProfile(profileString);
        if (profile == null) {
            Log.w(TAG, "Unknown Dolby Vision profile string: " + profileString);
            return null;
        }
        String levelString = parts[2];
        Integer level = MediaCodecUtil.dolbyVisionStringToLevel(levelString);
        if (level == null) {
            Log.w(TAG, "Unknown Dolby Vision level string: " + levelString);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    @Nullable
    private static Pair<Integer, Integer> getHevcProfileAndLevel(String codec, String[] parts) {
        int profile;
        if (parts.length < 4) {
            Log.w(TAG, "Ignoring malformed HEVC codec string: " + codec);
            return null;
        }
        Matcher matcher = PROFILE_PATTERN.matcher(parts[1]);
        if (!matcher.matches()) {
            Log.w(TAG, "Ignoring malformed HEVC codec string: " + codec);
            return null;
        }
        String profileString = matcher.group(1);
        if ("1".equals(profileString)) {
            profile = 1;
        } else if ("2".equals(profileString)) {
            profile = 2;
        } else {
            Log.w(TAG, "Unknown HEVC profile string: " + profileString);
            return null;
        }
        String levelString = parts[3];
        Integer level = MediaCodecUtil.hevcCodecStringToProfileLevel(levelString);
        if (level == null) {
            Log.w(TAG, "Unknown HEVC level string: " + levelString);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    @Nullable
    private static Pair<Integer, Integer> getAvcProfileAndLevel(String codec, String[] parts) {
        int levelInteger;
        int profileInteger;
        block7: {
            if (parts.length < 2) {
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
            try {
                if (parts[1].length() == 6) {
                    profileInteger = Integer.parseInt(parts[1].substring(0, 2), 16);
                    levelInteger = Integer.parseInt(parts[1].substring(4), 16);
                    break block7;
                }
                if (parts.length >= 3) {
                    profileInteger = Integer.parseInt(parts[1]);
                    levelInteger = Integer.parseInt(parts[2]);
                    break block7;
                }
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
            catch (NumberFormatException e) {
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
        }
        int profile = MediaCodecUtil.avcProfileNumberToConst(profileInteger);
        if (profile == -1) {
            Log.w(TAG, "Unknown AVC profile: " + profileInteger);
            return null;
        }
        int level = MediaCodecUtil.avcLevelNumberToConst(levelInteger);
        if (level == -1) {
            Log.w(TAG, "Unknown AVC level: " + levelInteger);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    @Nullable
    private static Pair<Integer, Integer> getVp9ProfileAndLevel(String codec, String[] parts) {
        int levelInteger;
        int profileInteger;
        if (parts.length < 3) {
            Log.w(TAG, "Ignoring malformed VP9 codec string: " + codec);
            return null;
        }
        try {
            profileInteger = Integer.parseInt(parts[1]);
            levelInteger = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Ignoring malformed VP9 codec string: " + codec);
            return null;
        }
        int profile = MediaCodecUtil.vp9ProfileNumberToConst(profileInteger);
        if (profile == -1) {
            Log.w(TAG, "Unknown VP9 profile: " + profileInteger);
            return null;
        }
        int level = MediaCodecUtil.vp9LevelNumberToConst(levelInteger);
        if (level == -1) {
            Log.w(TAG, "Unknown VP9 level: " + levelInteger);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    @Nullable
    private static Pair<Integer, Integer> getAv1ProfileAndLevel(String codec, String[] parts, @Nullable ColorInfo colorInfo) {
        int bitDepthInteger;
        int levelInteger;
        int profileInteger;
        if (parts.length < 4) {
            Log.w(TAG, "Ignoring malformed AV1 codec string: " + codec);
            return null;
        }
        try {
            profileInteger = Integer.parseInt(parts[1]);
            levelInteger = Integer.parseInt(parts[2].substring(0, 2));
            bitDepthInteger = Integer.parseInt(parts[3]);
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Ignoring malformed AV1 codec string: " + codec);
            return null;
        }
        if (profileInteger != 0) {
            Log.w(TAG, "Unknown AV1 profile: " + profileInteger);
            return null;
        }
        if (bitDepthInteger != 8 && bitDepthInteger != 10) {
            Log.w(TAG, "Unknown AV1 bit depth: " + bitDepthInteger);
            return null;
        }
        int profile = bitDepthInteger == 8 ? 1 : (colorInfo != null && (colorInfo.hdrStaticInfo != null || colorInfo.colorTransfer == 7 || colorInfo.colorTransfer == 6) ? 4096 : 2);
        int level = MediaCodecUtil.av1LevelNumberToConst(levelInteger);
        if (level == -1) {
            Log.w(TAG, "Unknown AV1 level: " + levelInteger);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    private static int avcLevelToMaxFrameSize(int avcLevel) {
        switch (avcLevel) {
            case 1: 
            case 2: {
                return 25344;
            }
            case 8: 
            case 16: 
            case 32: {
                return 101376;
            }
            case 64: {
                return 202752;
            }
            case 128: 
            case 256: {
                return 414720;
            }
            case 512: {
                return 921600;
            }
            case 1024: {
                return 0x140000;
            }
            case 2048: 
            case 4096: {
                return 0x200000;
            }
            case 8192: {
                return 0x220000;
            }
            case 16384: {
                return 5652480;
            }
            case 32768: 
            case 65536: {
                return 0x900000;
            }
        }
        return -1;
    }

    @Nullable
    private static Pair<Integer, Integer> getAacCodecProfileAndLevel(String codec, String[] parts) {
        if (parts.length != 3) {
            Log.w(TAG, "Ignoring malformed MP4A codec string: " + codec);
            return null;
        }
        try {
            int audioObjectTypeIndication;
            int profile;
            int objectTypeIndication = Integer.parseInt(parts[1], 16);
            String mimeType = MimeTypes.getMimeTypeFromMp4ObjectType(objectTypeIndication);
            if ("audio/mp4a-latm".equals(mimeType) && (profile = MediaCodecUtil.mp4aAudioObjectTypeToProfile(audioObjectTypeIndication = Integer.parseInt(parts[2]))) != -1) {
                return new Pair((Object)profile, (Object)0);
            }
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Ignoring malformed MP4A codec string: " + codec);
        }
        return null;
    }

    private static <T> void sortByScore(List<T> list, ScoreProvider<T> scoreProvider) {
        Collections.sort(list, (a, b) -> scoreProvider.getScore(b) - scoreProvider.getScore(a));
    }

    private static int avcProfileNumberToConst(int profileNumber) {
        switch (profileNumber) {
            case 66: {
                return 1;
            }
            case 77: {
                return 2;
            }
            case 88: {
                return 4;
            }
            case 100: {
                return 8;
            }
            case 110: {
                return 16;
            }
            case 122: {
                return 32;
            }
            case 244: {
                return 64;
            }
        }
        return -1;
    }

    private static int avcLevelNumberToConst(int levelNumber) {
        switch (levelNumber) {
            case 10: {
                return 1;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 8;
            }
            case 13: {
                return 16;
            }
            case 20: {
                return 32;
            }
            case 21: {
                return 64;
            }
            case 22: {
                return 128;
            }
            case 30: {
                return 256;
            }
            case 31: {
                return 512;
            }
            case 32: {
                return 1024;
            }
            case 40: {
                return 2048;
            }
            case 41: {
                return 4096;
            }
            case 42: {
                return 8192;
            }
            case 50: {
                return 16384;
            }
            case 51: {
                return 32768;
            }
            case 52: {
                return 65536;
            }
        }
        return -1;
    }

    private static int vp9ProfileNumberToConst(int profileNumber) {
        switch (profileNumber) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        return -1;
    }

    private static int vp9LevelNumberToConst(int levelNumber) {
        switch (levelNumber) {
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 8;
            }
            case 30: {
                return 16;
            }
            case 31: {
                return 32;
            }
            case 40: {
                return 64;
            }
            case 41: {
                return 128;
            }
            case 50: {
                return 256;
            }
            case 51: {
                return 512;
            }
            case 60: {
                return 2048;
            }
            case 61: {
                return 4096;
            }
            case 62: {
                return 8192;
            }
        }
        return -1;
    }

    @Nullable
    private static Integer hevcCodecStringToProfileLevel(@Nullable String codecString) {
        if (codecString == null) {
            return null;
        }
        switch (codecString) {
            case "L30": {
                return 1;
            }
            case "L60": {
                return 4;
            }
            case "L63": {
                return 16;
            }
            case "L90": {
                return 64;
            }
            case "L93": {
                return 256;
            }
            case "L120": {
                return 1024;
            }
            case "L123": {
                return 4096;
            }
            case "L150": {
                return 16384;
            }
            case "L153": {
                return 65536;
            }
            case "L156": {
                return 262144;
            }
            case "L180": {
                return 0x100000;
            }
            case "L183": {
                return 0x400000;
            }
            case "L186": {
                return 0x1000000;
            }
            case "H30": {
                return 2;
            }
            case "H60": {
                return 8;
            }
            case "H63": {
                return 32;
            }
            case "H90": {
                return 128;
            }
            case "H93": {
                return 512;
            }
            case "H120": {
                return 2048;
            }
            case "H123": {
                return 8192;
            }
            case "H150": {
                return 32768;
            }
            case "H153": {
                return 131072;
            }
            case "H156": {
                return 524288;
            }
            case "H180": {
                return 0x200000;
            }
            case "H183": {
                return 0x800000;
            }
            case "H186": {
                return 0x2000000;
            }
        }
        return null;
    }

    @Nullable
    private static Integer dolbyVisionStringToProfile(@Nullable String profileString) {
        if (profileString == null) {
            return null;
        }
        switch (profileString) {
            case "00": {
                return 1;
            }
            case "01": {
                return 2;
            }
            case "02": {
                return 4;
            }
            case "03": {
                return 8;
            }
            case "04": {
                return 16;
            }
            case "05": {
                return 32;
            }
            case "06": {
                return 64;
            }
            case "07": {
                return 128;
            }
            case "08": {
                return 256;
            }
            case "09": {
                return 512;
            }
        }
        return null;
    }

    @Nullable
    private static Integer dolbyVisionStringToLevel(@Nullable String levelString) {
        if (levelString == null) {
            return null;
        }
        switch (levelString) {
            case "01": {
                return 1;
            }
            case "02": {
                return 2;
            }
            case "03": {
                return 4;
            }
            case "04": {
                return 8;
            }
            case "05": {
                return 16;
            }
            case "06": {
                return 32;
            }
            case "07": {
                return 64;
            }
            case "08": {
                return 128;
            }
            case "09": {
                return 256;
            }
        }
        return null;
    }

    private static int av1LevelNumberToConst(int levelNumber) {
        switch (levelNumber) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 7: {
                return 128;
            }
            case 8: {
                return 256;
            }
            case 9: {
                return 512;
            }
            case 10: {
                return 1024;
            }
            case 11: {
                return 2048;
            }
            case 12: {
                return 4096;
            }
            case 13: {
                return 8192;
            }
            case 14: {
                return 16384;
            }
            case 15: {
                return 32768;
            }
            case 16: {
                return 65536;
            }
            case 17: {
                return 131072;
            }
            case 18: {
                return 262144;
            }
            case 19: {
                return 524288;
            }
            case 20: {
                return 0x100000;
            }
            case 21: {
                return 0x200000;
            }
            case 22: {
                return 0x400000;
            }
            case 23: {
                return 0x800000;
            }
        }
        return -1;
    }

    private static int mp4aAudioObjectTypeToProfile(int profileNumber) {
        switch (profileNumber) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 17: {
                return 17;
            }
            case 20: {
                return 20;
            }
            case 23: {
                return 23;
            }
            case 29: {
                return 29;
            }
            case 39: {
                return 39;
            }
            case 42: {
                return 42;
            }
        }
        return -1;
    }

    public static class DecoderQueryException
    extends Exception {
        private DecoderQueryException(Throwable cause) {
            super("Failed to query underlying media codecs", cause);
        }
    }

    private static final class CodecKey {
        public final String mimeType;
        public final boolean secure;
        public final boolean tunneling;

        public CodecKey(String mimeType, boolean secure, boolean tunneling) {
            this.mimeType = mimeType;
            this.secure = secure;
            this.tunneling = tunneling;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mimeType.hashCode();
            result = 31 * result + (this.secure ? 1231 : 1237);
            result = 31 * result + (this.tunneling ? 1231 : 1237);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != CodecKey.class) {
                return false;
            }
            CodecKey other = (CodecKey)obj;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)other.mimeType) && this.secure == other.secure && this.tunneling == other.tunneling;
        }
    }

    @RequiresApi(value=21)
    private static final class MediaCodecListCompatV21
    implements MediaCodecListCompat {
        private final int codecKind;
        @Nullable
        private android.media.MediaCodecInfo[] mediaCodecInfos;

        public MediaCodecListCompatV21(boolean includeSecure, boolean includeTunneling) {
            this.codecKind = includeSecure || includeTunneling ? 1 : 0;
        }

        @Override
        public int getCodecCount() {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos.length;
        }

        @Override
        public android.media.MediaCodecInfo getCodecInfoAt(int index) {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos[index];
        }

        @Override
        public boolean secureDecodersExplicit() {
            return true;
        }

        @Override
        public boolean isFeatureSupported(String feature, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return capabilities.isFeatureSupported(feature);
        }

        @Override
        public boolean isFeatureRequired(String feature, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return capabilities.isFeatureRequired(feature);
        }

        @EnsuresNonNull(value={"mediaCodecInfos"})
        private void ensureMediaCodecInfosInitialized() {
            if (this.mediaCodecInfos == null) {
                this.mediaCodecInfos = new MediaCodecList(this.codecKind).getCodecInfos();
            }
        }
    }

    private static final class MediaCodecListCompatV16
    implements MediaCodecListCompat {
        private MediaCodecListCompatV16() {
        }

        @Override
        public int getCodecCount() {
            return MediaCodecList.getCodecCount();
        }

        @Override
        public android.media.MediaCodecInfo getCodecInfoAt(int index) {
            return MediaCodecList.getCodecInfoAt((int)index);
        }

        @Override
        public boolean secureDecodersExplicit() {
            return false;
        }

        @Override
        public boolean isFeatureSupported(String feature, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return "secure-playback".equals(feature) && "video/avc".equals(mimeType);
        }

        @Override
        public boolean isFeatureRequired(String feature, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return false;
        }
    }

    private static interface MediaCodecListCompat {
        public int getCodecCount();

        public android.media.MediaCodecInfo getCodecInfoAt(int var1);

        public boolean secureDecodersExplicit();

        public boolean isFeatureSupported(String var1, String var2, MediaCodecInfo.CodecCapabilities var3);

        public boolean isFeatureRequired(String var1, String var2, MediaCodecInfo.CodecCapabilities var3);
    }

    private static interface ScoreProvider<T> {
        public int getScore(T var1);
    }
}

