/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.cast.queue;

import android.content.Context;
import com.akamai.amp.cast.queue.AmpQueueManager;
import com.akamai.amp.cast.queue.OnQueueDataChangedListener;
import com.akamai.amp.cast.queue.RemoteLoadListener;
import com.akamai.amp.cast.utils.AmpCastUtils;
import com.akamai.amp.cast.utils.CastSettings;
import com.akamai.amp.utils.LogManager;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class QueueProvider
implements AmpQueueManager {
    private final String TAG = this.getClass().getSimpleName();
    public static final int INVALID = -1;
    private final Context mAppContext;
    private final List<MediaQueueItem> mQueue = new CopyOnWriteArrayList<MediaQueueItem>();
    private static QueueProvider mInstance;
    private final Object mLock = new Object();
    private final SessionManagerListener<CastSession> mSessionManagerListener = new QueueSessionManagerListener();
    private final RemoteMediaClient.Callback mRemoteMediaClientCallback = new QueueRemoteMediaClientCallback();
    private int mRepeatMode;
    private MediaQueueItem mCurrentIem;
    private MediaQueueItem mUpcomingItem;
    private OnQueueDataChangedListener mListener;
    private boolean mDetachedQueue = true;

    public static synchronized AmpQueueManager getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new QueueProvider(context);
        }
        return mInstance;
    }

    private QueueProvider(Context context) {
        LogManager.log((String)this.TAG, (String)"Queue Manager initialized");
        this.mAppContext = context.getApplicationContext();
        this.mRepeatMode = 0;
        this.mCurrentIem = null;
        CastSettings.get().getCastContext(this.mAppContext).getSessionManager().addSessionManagerListener(this.mSessionManagerListener, CastSession.class);
        this.syncWithRemoteQueue();
    }

    @Override
    public void truncateFromQueueItem(MediaQueueItem upcomingItem) {
        LogManager.log((String)this.TAG, (String)("Truncating queue from -> " + upcomingItem.toString()));
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, truncate can't be completed");
            return;
        }
        int position = this.getPositionByItemId(upcomingItem.getItemId());
        int[] itemIds = new int[this.getCount() - position];
        for (int i = 0; i < itemIds.length; ++i) {
            itemIds[i] = this.mQueue.get(i + position).getItemId();
        }
        remoteMediaClient.queueRemoveItems(itemIds, null);
    }

    @Override
    public void jumpToQueueItem(MediaQueueItem upcomingItem) {
        LogManager.log((String)this.TAG, (String)("jumping to item -> " + upcomingItem.toString()));
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't jump to specified item");
            return;
        }
        remoteMediaClient.queueJumpToItem(upcomingItem.getItemId(), null);
    }

    @Override
    public void toggleRemotePlay() {
        LogManager.log((String)this.TAG, (String)"Starting casting current item");
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't cast the current item");
            return;
        }
        remoteMediaClient.togglePlayback();
    }

    @Override
    public void appendAndRefreshQueue(MediaQueueItem mediaQueueItem) {
        LogManager.log((String)this.TAG, (String)("Appending to queue -> " + mediaQueueItem.toString()));
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't append the item");
            return;
        }
        MediaQueueItem[] items = this.rebuildQueueAndAppend(mediaQueueItem);
        remoteMediaClient.queueLoad(items, this.getCount(), 0, null);
    }

    @Override
    public void loadRemoteMedia(MediaInfo selectedMedia, int position, boolean autoPlay, final RemoteLoadListener loadListener, MediaMetadata extraData) {
        LogManager.log((String)this.TAG, (String)("Start casting for selected item -> " + selectedMedia.toString()));
        final RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't start casting the selected item");
            return;
        }
        remoteMediaClient.registerCallback(new RemoteMediaClient.Callback(){

            public void onStatusUpdated() {
                loadListener.onRemoteReady();
                remoteMediaClient.unregisterCallback((RemoteMediaClient.Callback)this);
                LogManager.log((String)QueueProvider.this.TAG, (String)"Remote client is ready to cast");
            }
        });
        remoteMediaClient.load(AmpCastUtils.updateMediaInfo(selectedMedia, extraData), new MediaLoadOptions.Builder().setAutoplay(autoPlay).setPlayPosition((long)position).build());
    }

    @Override
    public void loadRemoteMedia(MediaInfo selectedMedia, int position, boolean autoPlay, final RemoteLoadListener loadListener) {
        LogManager.log((String)this.TAG, (String)("Start casting for selected item -> " + selectedMedia.toString()));
        final RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't start casting the selected item");
            return;
        }
        remoteMediaClient.registerCallback(new RemoteMediaClient.Callback(){

            public void onStatusUpdated() {
                loadListener.onRemoteReady();
                remoteMediaClient.unregisterCallback((RemoteMediaClient.Callback)this);
                LogManager.log((String)QueueProvider.this.TAG, (String)"Remote client is ready to cast");
            }
        });
        remoteMediaClient.load(selectedMedia, new MediaLoadOptions.Builder().setAutoplay(autoPlay).setPlayPosition((long)position).build());
    }

    @Override
    public void appendItemToEnd(MediaQueueItem mediaQueueItem) {
        LogManager.log((String)this.TAG, (String)("Appending item to end of the queue -> " + mediaQueueItem.toString()));
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't append the item");
            return;
        }
        if (this.getCount() == 0) {
            LogManager.log((String)this.TAG, (String)(mediaQueueItem.toString() + " is the first in the queue"));
            remoteMediaClient.queueLoad(new MediaQueueItem[]{mediaQueueItem}, 0, 0, null);
        } else {
            remoteMediaClient.queueAppendItem(mediaQueueItem, null);
        }
    }

    @Override
    public void appendItemToEndAndPlay(MediaQueueItem mediaQueueItem) {
        LogManager.log((String)this.TAG, (String)("Appending item to and playing immediately -> " + mediaQueueItem.toString()));
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't append the item");
            return;
        }
        if (this.getCount() == 0) {
            LogManager.log((String)this.TAG, (String)(mediaQueueItem.toString() + " is the first in the queue"));
            remoteMediaClient.queueLoad(new MediaQueueItem[]{mediaQueueItem}, 0, 0, null);
        } else {
            remoteMediaClient.queueInsertAndPlayItem(mediaQueueItem, this.getCurrentItemId(), null);
        }
    }

    @Override
    public void appendItemToNext(MediaQueueItem mediaQueueItem) {
        LogManager.log((String)this.TAG, (String)("Appending item to and playing it next -> " + mediaQueueItem.toString()));
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't append the item");
            return;
        }
        int currentPosition = this.getPositionByItemId(this.getCurrentItemId());
        if (this.getCount() == 0 || currentPosition == this.getCount() - 1) {
            LogManager.log((String)this.TAG, (String)(mediaQueueItem.toString() + " is the first in the queue"));
            this.appendItemToEnd(mediaQueueItem);
        } else {
            int nextItemId = this.getItem(currentPosition + 1).getItemId();
            remoteMediaClient.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, nextItemId, null);
        }
    }

    @Override
    public void refreshQueueOnCurrentPosition(MediaQueueItem mediaQueueItem) {
        LogManager.log((String)this.TAG, (String)("Refreshing the queue to make sure the item is appended -> " + mediaQueueItem.toString()));
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't refresh the queue");
            return;
        }
        int currentPosition = this.getPositionByItemId(mediaQueueItem.getItemId());
        MediaQueueItem[] items = this.rebuildQueue();
        remoteMediaClient.queueLoad(items, currentPosition, 0, null);
    }

    @Override
    public boolean isQueueDetached() {
        return this.mDetachedQueue;
    }

    @Override
    public int getPositionByItemId(int itemId) {
        if (this.mQueue.isEmpty()) {
            LogManager.error((String)this.TAG, (String)"The queue is empty");
            return -1;
        }
        for (int i = 0; i < this.mQueue.size(); ++i) {
            if (this.mQueue.get(i).getItemId() != itemId) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromQueue(int position) {
        Object object = this.mLock;
        synchronized (object) {
            RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
            if (remoteMediaClient == null) {
                LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't remove the item selected");
                return;
            }
            remoteMediaClient.queueRemoveItem(this.mQueue.get(position).getItemId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mQueue.isEmpty()) {
                LogManager.error((String)this.TAG, (String)"Queue is already empty");
                return;
            }
            RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
            if (remoteMediaClient == null) {
                LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't empty the queue");
                return;
            }
            int[] itemIds = new int[this.mQueue.size()];
            for (int i = 0; i < this.mQueue.size(); ++i) {
                itemIds[i] = this.mQueue.get(i).getItemId();
            }
            remoteMediaClient.queueRemoveItems(itemIds, null);
            this.mQueue.clear();
        }
    }

    @Override
    public void moveItem(int fromPosition, int toPosition) {
        if (fromPosition == toPosition) {
            LogManager.error((String)this.TAG, (String)"The item is already at the target position");
            return;
        }
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient == null) {
            LogManager.error((String)this.TAG, (String)"RemoteMediaClient is null, can't move the item");
            return;
        }
        int itemId = this.mQueue.get(fromPosition).getItemId();
        remoteMediaClient.queueMoveItemToNewIndex(itemId, toPosition, null);
        MediaQueueItem item = this.mQueue.remove(fromPosition);
        this.mQueue.add(toPosition, item);
    }

    @Override
    public int getCount() {
        return this.mQueue.size();
    }

    @Override
    public MediaQueueItem getItem(int position) {
        return this.mQueue.get(position);
    }

    @Override
    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    @Override
    public MediaQueueItem getCurrentItem() {
        return this.mCurrentIem;
    }

    @Override
    public int getCurrentItemId() {
        return this.mCurrentIem.getItemId();
    }

    @Override
    public MediaQueueItem getUpcomingItem() {
        return this.mUpcomingItem;
    }

    @Override
    public void setOnQueueDataChangedListener(OnQueueDataChangedListener listener) {
        this.mListener = listener;
    }

    @Override
    public List<MediaQueueItem> getItems() {
        return this.mQueue;
    }

    @Override
    public List<MediaQueueItem> getRemoteQueuedItems() {
        MediaStatus mediaStatus = CastSettings.get().getRemoteMediaClient(this.mAppContext).getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItems();
    }

    private MediaQueueItem[] rebuildQueue() {
        List<MediaQueueItem> items = this.getItems();
        if (items == null || items.isEmpty()) {
            LogManager.error((String)this.TAG, (String)"Queue is empty, it can't be rebuilt");
            return null;
        }
        MediaQueueItem[] rebuiltQueue = new MediaQueueItem[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            rebuiltQueue[i] = this.rebuildQueueItem(items.get(i));
        }
        return rebuiltQueue;
    }

    private MediaQueueItem[] rebuildQueueAndAppend(MediaQueueItem currentItem) {
        List<MediaQueueItem> items = this.getItems();
        if (items == null || items.isEmpty()) {
            return new MediaQueueItem[]{currentItem};
        }
        MediaQueueItem[] rebuiltQueue = new MediaQueueItem[items.size() + 1];
        for (int i = 0; i < items.size(); ++i) {
            rebuiltQueue[i] = this.rebuildQueueItem(items.get(i));
        }
        rebuiltQueue[items.size()] = currentItem;
        return rebuiltQueue;
    }

    private void clearQueue() {
        this.mQueue.clear();
        this.mDetachedQueue = true;
        this.mCurrentIem = null;
    }

    private MediaQueueItem rebuildQueueItem(MediaQueueItem item) {
        return new MediaQueueItem.Builder(item).clearItemId().build();
    }

    private void syncWithRemoteQueue() {
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        if (remoteMediaClient != null) {
            List items;
            remoteMediaClient.registerCallback(this.mRemoteMediaClientCallback);
            MediaStatus mediaStatus = remoteMediaClient.getMediaStatus();
            if (mediaStatus != null && (items = mediaStatus.getQueueItems()) != null && !items.isEmpty()) {
                this.mQueue.clear();
                this.mQueue.addAll(items);
                this.mRepeatMode = mediaStatus.getQueueRepeatMode();
                this.mCurrentIem = mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
                this.mDetachedQueue = false;
                this.mUpcomingItem = mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
            }
        }
    }

    private void updateMediaQueue() {
        MediaStatus mediaStatus;
        RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(this.mAppContext);
        List queueItems = null;
        if (remoteMediaClient != null && (mediaStatus = remoteMediaClient.getMediaStatus()) != null) {
            queueItems = mediaStatus.getQueueItems();
            this.mRepeatMode = mediaStatus.getQueueRepeatMode();
            this.mCurrentIem = mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
        }
        this.mQueue.clear();
        if (queueItems == null) {
            LogManager.log((String)this.TAG, (String)"Queue is cleared");
        } else {
            LogManager.log((String)this.TAG, (String)("Queue is updated with a list of size: " + queueItems.size()));
            if (queueItems.size() > 0) {
                this.mQueue.addAll(queueItems);
                this.mDetachedQueue = false;
            } else {
                this.mDetachedQueue = true;
            }
        }
    }

    private class QueueSessionManagerListener
    implements SessionManagerListener<CastSession> {
        private QueueSessionManagerListener() {
        }

        public void onSessionResumed(CastSession session, boolean wasSuspended) {
            QueueProvider.this.syncWithRemoteQueue();
        }

        public void onSessionStarted(CastSession session, String sessionId) {
            QueueProvider.this.syncWithRemoteQueue();
        }

        public void onSessionEnded(CastSession session, int error) {
            QueueProvider.this.clearQueue();
            if (QueueProvider.this.mListener != null) {
                QueueProvider.this.mListener.onQueueDataChanged();
            }
        }

        public void onSessionStarting(CastSession session) {
        }

        public void onSessionStartFailed(CastSession session, int error) {
        }

        public void onSessionEnding(CastSession session) {
        }

        public void onSessionResuming(CastSession session, String sessionId) {
        }

        public void onSessionResumeFailed(CastSession session, int error) {
        }

        public void onSessionSuspended(CastSession session, int reason) {
        }
    }

    private class QueueRemoteMediaClientCallback
    extends RemoteMediaClient.Callback {
        private QueueRemoteMediaClientCallback() {
        }

        public void onPreloadStatusUpdated() {
            RemoteMediaClient remoteMediaClient = CastSettings.get().getRemoteMediaClient(QueueProvider.this.mAppContext);
            if (remoteMediaClient == null) {
                return;
            }
            MediaStatus mediaStatus = remoteMediaClient.getMediaStatus();
            if (mediaStatus == null) {
                return;
            }
            QueueProvider.this.mUpcomingItem = mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
            LogManager.log((String)QueueProvider.this.TAG, (String)("onRemoteMediaPreloadStatusUpdated() with item=" + QueueProvider.this.mUpcomingItem));
            if (QueueProvider.this.mListener != null) {
                QueueProvider.this.mListener.onQueueDataChanged();
            }
        }

        public void onQueueStatusUpdated() {
            QueueProvider.this.updateMediaQueue();
            if (QueueProvider.this.mListener != null) {
                QueueProvider.this.mListener.onQueueDataChanged();
            }
            LogManager.log((String)QueueProvider.this.TAG, (String)"Queue was updated");
        }

        public void onStatusUpdated() {
            QueueProvider.this.updateMediaQueue();
            if (QueueProvider.this.mListener != null) {
                QueueProvider.this.mListener.onQueueDataChanged();
            }
        }
    }
}

