/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.config;

import android.util.Log;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.FreewheelData;
import com.akamai.amp.config.data.GoogleAnalyticsData;
import com.akamai.amp.config.data.IMAData;
import com.akamai.amp.config.data.MediaAnalyticsData;
import com.akamai.amp.config.data.NielsenData;
import com.akamai.amp.config.data.heartbeat.HeartbeatConfigurationData;
import com.akamai.amp.config.data.streamsense.StreamsenseData;
import com.akamai.amp.parser.config.FreewheelParser;
import com.akamai.amp.parser.config.GoogleAnalyticsParser;
import com.akamai.amp.parser.config.HeartbeatParser;
import com.akamai.amp.parser.config.IMAParser;
import com.akamai.amp.parser.config.MediaAnalyticsParser;
import com.akamai.amp.parser.config.NielsenParser;
import com.akamai.amp.parser.config.ParamsParser;
import com.akamai.amp.parser.config.StreamsenseParser;
import com.akamai.amp.parser.feed.MediaParser;
import com.akamai.amp.parser.utils.UtilsParser;
import com.akamai.amp.utils.LogManager;
import org.json.JSONObject;

public class RootConfigParser {
    public static final String TAG = "RootConfigParser";
    public final String MEDIA_TAG = "media";
    public final String FEED_TAG = "feed";
    public final String URL_TAG = "url";
    public final String DATA_TAG = "data";
    public final String AUTOPLAY_TAG = "autoplay";
    public final String FULLSCREEN_TAG = "fullscreen";
    public final String ENABLED_TAG = "enabled";
    public final String CONTROLS_TAG = "controls";
    public final String CAPTIONING_TAG = "captioning";
    public final String ADMODE_TAG = "admode";
    public final String MODE_TAG = "mode";
    private JSONObject root;
    private IMAParser imaParser = new IMAParser();
    private NielsenParser nielsenParser = new NielsenParser();
    private HeartbeatParser heartbeatParser = new HeartbeatParser();
    private StreamsenseParser streamsenseParser = new StreamsenseParser();
    private FreewheelParser freewheelParser = new FreewheelParser();
    private MediaAnalyticsParser mediaAnalyticsParser = new MediaAnalyticsParser();
    private GoogleAnalyticsParser googleAnalyticsParser = new GoogleAnalyticsParser();
    private ParamsParser paramsParser;
    private boolean isMediaObjectAvailable;
    private boolean isFeedDataAvailable;
    private boolean isFeedURLAvailable;

    public boolean isMediaObjectAvailable() {
        return this.isMediaObjectAvailable;
    }

    public boolean isFeedDataAvailable() {
        return this.isFeedDataAvailable;
    }

    public boolean isFeedURLAvailable() {
        return this.isFeedURLAvailable;
    }

    public void parseJson(String content) {
        try {
            this.root = new JSONObject(content);
            if (this.root != null) {
                this.parseParams();
                this.parseRootValues();
                this.validateModules();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(e == null ? "NULL ERROR" : e.toString()));
        }
    }

    private void setMediaFromConfig() {
        this.isMediaObjectAvailable = UtilsParser.existObj("media", this.root);
        if (this.isMediaObjectAvailable) {
            Config.getConfig().media = MediaParser.buildMedia(UtilsParser.getObj("media", this.root));
        }
    }

    private void setFeedFromConfig() {
        if (UtilsParser.existObj("feed", this.root)) {
            JSONObject feedObject = UtilsParser.getObj("feed", this.root);
            this.isFeedURLAvailable = UtilsParser.existObj("url", feedObject);
            if (this.isFeedURLAvailable) {
                Config.getConfig().feedURL = UtilsParser.getValue("url", feedObject);
            }
            this.isFeedDataAvailable = UtilsParser.existObj("data", feedObject);
            if (this.isFeedDataAvailable) {
                Config.getConfig().feedData = UtilsParser.getValue("data", feedObject);
            }
        }
    }

    private void parseParams() {
        Config.getConfig().jsEvaluator.createParamsJS(ParamsParser.buildParams(this.root));
    }

    private void parseRootValues() {
        JSONObject captioningObject;
        JSONObject controlsObject;
        Config.getConfig().autoplay = Boolean.valueOf(UtilsParser.getValue("autoplay", this.root));
        JSONObject fullScreenObject = UtilsParser.getObj("fullscreen", this.root);
        if (fullScreenObject != null) {
            Config.getConfig().fullScreen = Boolean.valueOf(UtilsParser.getValue("enabled", fullScreenObject));
        }
        if ((controlsObject = UtilsParser.getObj("controls", this.root)) != null) {
            Config.getConfig().controlsMode = UtilsParser.getValue("mode", controlsObject);
            Config.getConfig().controlsAdMode = UtilsParser.getValue("admode", controlsObject);
        }
        if ((captioningObject = UtilsParser.getObj("captioning", this.root)) != null) {
            Config.getConfig().captionsEnabled = Boolean.valueOf(UtilsParser.getValue("enabled", captioningObject));
        }
        this.setMediaFromConfig();
        this.setFeedFromConfig();
    }

    private void validateModules() {
        if (this.jsonContains("ima")) {
            Config.getConfig().setIMAData();
        }
        if (this.jsonContains("nielsendcr")) {
            Config.getConfig().setNielsenData();
        }
        if (this.jsonContains("omniture")) {
            Config.getConfig().setHeartbeatData();
        }
        if (this.jsonContains("comscorestreamsense")) {
            Config.getConfig().setStreamsenseData();
        }
        if (this.jsonContains("freewheel")) {
            Config.getConfig().setFreeWheelData();
        }
        if (this.jsonContains("mediaanalytics")) {
            Config.getConfig().setMediaAnalyticsData();
        }
        if (this.jsonContains("googleanalytics")) {
            Config.getConfig().setGoogleAnalyticsData();
        }
    }

    private boolean jsonContains(String tag) {
        boolean found = UtilsParser.existObj(tag, this.root);
        if (found) {
            LogManager.log(TAG, "<" + tag + "> found in the config file");
        }
        return found;
    }

    public IMAData buildIMAData() {
        return this.imaParser.buildIMAData(this.root);
    }

    public NielsenData buildNielsenData() {
        return this.nielsenParser.buildNielsenData(this.root);
    }

    public HeartbeatConfigurationData buildHeartbeatData() {
        return this.heartbeatParser.buildHeartbeatData(this.root);
    }

    public StreamsenseData buildStreamsenseData() {
        return this.streamsenseParser.buildStreamsenseData(this.root);
    }

    public FreewheelData buildFreeWheelData() {
        return this.freewheelParser.buildFreeWheelData(this.root);
    }

    public MediaAnalyticsData buildMediaAnalyticsData() {
        return this.mediaAnalyticsParser.buildMediaAnalyticsData(this.root);
    }

    public String getAdsId(boolean isFreewheel) {
        if (isFreewheel) {
            return this.freewheelParser.getAdId(this.root);
        }
        return this.imaParser.getAdsId(this.root);
    }

    public GoogleAnalyticsData buildGoogleAnalyticsData() {
        return this.googleAnalyticsParser.buildGoogleAnalyticsData(this.root);
    }
}

